/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.smartmetergateway.ui;

import java.awt.Color;
import java.awt.Dialog.ModalityType;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

/**
 * The graphical user interface of the minimal SMGW implementation. This class
 * represents the main window. The GUI was built using the Eclipse-Plugin
 * WindowBuilder.
 * 
 * @author Daniel Fuchs
 * @author Michael Hoefling
 */
public class MainWindow {

    /**
     * Main frame of the GUI.
     */
    private JFrame mainFrame;

    /**
     * One tab for each client-server connection.
     */
    private JTabbedPane tabbedPane;

    /**
     * Menu item to create new tab.
     */
    private JMenuItem menuItemCreateClient;

    /**
     * Counts the clients.
     */
    private int clientCounter = 1;

    /**
     * Starts the GUI.
     */
    public void startGUI() {
        EventQueue.invokeLater(new Runnable() {
            public void run() {
                try {
                    MainWindow window = new MainWindow();
                    window.mainFrame.setVisible(true);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /**
     * Constructor.
     */
    public MainWindow() {
        initialize();
    }

    /**
     * Initialize the contents of the frame.
     */
    private void initialize() {
        try { // set the look and feel
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }

        mainFrame = new JFrame();
        mainFrame.setForeground(Color.LIGHT_GRAY);
        mainFrame.setTitle("Minimal Smart Meter Gateway");
        mainFrame.setBounds(100, 100, 900, 600);
        mainFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        JMenuBar menuBar = new JMenuBar();
        mainFrame.setJMenuBar(menuBar);

        JMenu mainMenu = new JMenu("Main Menu");
        menuBar.add(mainMenu);

        menuItemCreateClient = new JMenuItem("Create New Client");
        mainMenu.add(menuItemCreateClient);
        menuItemCreateClient.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                ClientTab panel = new ClientTab();
                tabbedPane.addTab("Client" + clientCounter, null, panel, null);
                clientCounter++;
            }
        });

        JMenuItem menuItemAbout = new JMenuItem("About");
        menuItemAbout.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                openAbout();
            }
        });
        mainMenu.add(menuItemAbout);

        JMenuItem menuItemExit = new JMenuItem("Exit");
        menuItemExit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        mainMenu.add(menuItemExit);
        mainFrame.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));

        tabbedPane = new JTabbedPane(JTabbedPane.TOP);
        mainFrame.getContentPane().add(tabbedPane);

    }

    /**
     * About dialog.
     */
    public void openAbout() {
        JDialog about = new JDialog();
        about.setTitle("About");
        about.setSize(550, 150);
        about.setResizable(false);
        about.setLocationRelativeTo(null);
        about.setModalityType(ModalityType.APPLICATION_MODAL);

        JTextArea text = new JTextArea();
        text.setVisible(true);
        text.setEditable(false);
        text.append("jOSEF: Minimal Smart Meter Gateway\n");
        text.append("========================================\n");
        text.append(
                "(c) 2015 Daniel Fuchs, Michael Hoefling, Florian Heimgaertner\n");
        text.append("         Chair of Communication Networks\n");
        text.append("         University of Tuebingen");

        JPanel p = new JPanel();
        p.add(text);

        about.getContentPane().add(text);
        about.setVisible(true);
    }

}
