/**
 * Additional Functions (Header+Implementation)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of RNNPBlib.
 * 
 * RNNPBlib is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * RNNPBlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with RNNPBlib. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

#define _USE_MATH_DEFINES
#include <math.h>
#include <cmath>
#include <stdlib.h>



//Macro stuff for exp approximation
/*
 * See Schraudolph, Nicol N. "A fast, compact approximation of the exponential function." Neural Computation 11.4 (1999): 853-862.
 * */
#ifdef ENABLE_FAST_EXP
static union
{
	double d;
	struct
	{
		#ifdef LITTLE_ENDIAN	//must be defined on little endian systems
			int j, i;
		#else
			int i, j;
		#endif
	} n;
} _eco;
#define EXP_A (1048576/M_LN2) /* use 1512775 for integer version */
#define EXP_C 60801 /* see text for choice of c values */

#define EXP(y) (_eco.n.i = EXP_A*(y) + (1072693248 - EXP_C), _eco.d)
#endif


struct RNNPB_Helper
{
	static inline double signum(double x)
	{
		return (x>=0) ? 1 : -1;
	}

	static double gaussianNoise(double sigma)
	{
		double x1 = ((double)rand() / (double)(RAND_MAX));
		double x2 = ((double)rand() / (double)(RAND_MAX));

		double y1 = sqrt( - 2.0f * log(x1) ) * cos( 2.0f * M_PI * x2 );
        //double y2 = sqrt( - 2 * log(x1) ) * sin( 2 * M_PI * x2 );

		return y1 * sigma;
	}

	static double uniformNoise(double max)
	{
		return max * (((double)rand() / (double)(RAND_MAX)) * 2.0 - 1.0);
	}
};


