/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Main;
import genomic.AbstractSequenceFeature;
import genomic.Gene;
import genomic.NCRNA;
import java.util.LinkedList;
import java.util.List;
import seq.Sequence;
import sidd.SIDDSite;
import term.Terminator;

public class NCRNATranscript
extends AbstractSequenceFeature {
    private SIDDSite siddSite;
    private Terminator terminator;
    private List<Terminator> suboptimalTerms;
    private NCRNA ncrna;
    private List<Gene> genes;
    private double rnazScore;

    public NCRNATranscript() {
    }

    public NCRNATranscript(String ID, int start, int end, char strand, SIDDSite siddSite, Terminator terminator, NCRNA ncrna) {
        super(ID, start, end, strand);
        if (siddSite == null) {
            throw new IllegalArgumentException("Cannot create predicted transcript without SIDDSite!");
        }
        this.siddSite = siddSite;
        this.terminator = terminator;
        this.ncrna = ncrna;
        this.suboptimalTerms = new LinkedList<Terminator>();
        this.genes = new LinkedList<Gene>();
        this.rnazScore = -1.0;
    }

    @Override
    public boolean isSequenceConsitentWithFeatureType(Sequence seq) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean shortenEachOther(NCRNATranscript otherTU) {
        if (this.numOverlappingBases(otherTU) == 0) {
            return true;
        }
        if (this.getStrand() == otherTU.getStrand()) {
            System.err.println("WARNING: otherTU should not be located on the same strand!");
            Thread.dumpStack();
            return true;
        }
        if (this.getTerminator() == null || otherTU.getTerminator() == null) {
            return false;
        }
        thisShortest = this.terminator;
        otherTUShortest = otherTU.getTerminator();
        if (this.suboptimalTerms.size() > 0) {
            thisShortest = this.suboptimalTerms.get(0);
        }
        if (otherTU.suboptimalTerms.size() > 0) {
            otherTUShortest = otherTU.suboptimalTerms.get(0);
        }
        if (!(this.getStrand() == '+' ? thisShortest.getEnd() >= otherTUShortest.getStart() : thisShortest.getStart() <= otherTUShortest.getEnd())) ** GOTO lbl19
        return false;
lbl-1000:
        // 1 sources

        {
            if (!(this.getTerminator().getConfidence() <= otherTU.getTerminator().getConfidence() ? this.shorten() == false && otherTU.shorten() == false : otherTU.shorten() == false && this.shorten() == false)) continue;
            return false;
lbl19:
            // 2 sources

            ** while (this.numOverlappingBases((AbstractSequenceFeature)otherTU) > 0)
        }
lbl20:
        // 1 sources

        return true;
    }

    private boolean shorten() {
        if (this.suboptimalTerms.size() == 0) {
            return false;
        }
        this.terminator = this.suboptimalTerms.get(0);
        for (Terminator t : this.suboptimalTerms) {
            if (t.getConfidence() <= this.terminator.getConfidence()) continue;
            this.terminator = t;
        }
        if (this.getStrand() == '+') {
            this.setEnd_WARNING(this.terminator.getEnd());
        } else {
            this.setStart_WARNING(this.terminator.getStart());
        }
        return true;
    }

    public NCRNA getNcrna() {
        return this.ncrna;
    }

    public SIDDSite getSiddSite() {
        return this.siddSite;
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    public void addGene(Gene gene) {
        this.genes.add(gene);
    }

    public void clearGenes() {
        this.genes = new LinkedList<Gene>();
    }

    public List<Gene> getGenes() {
        return this.genes;
    }

    public List<Gene> getASGenes() {
        LinkedList<Gene> res = new LinkedList<Gene>();
        for (Gene g : this.genes) {
            if (g.getStrand() == this.getStrand()) continue;
            res.add(g);
        }
        return res;
    }

    public int numGenes() {
        return this.genes.size();
    }

    public int numASGenes() {
        int res = 0;
        for (Gene g : this.genes) {
            if (g.getStrand() == this.getStrand()) continue;
            ++res;
        }
        return res;
    }

    @Override
    protected void setStart_WARNING(int newStart) {
        super.setStart_WARNING(newStart);
        this.removeInappropriateTerminators();
    }

    @Override
    protected void setEnd_WARNING(int newEnd) {
        super.setEnd_WARNING(newEnd);
        this.removeInappropriateTerminators();
    }

    public void setSuboptimalTerminators(List<Terminator> terms) {
        this.suboptimalTerms = terms;
        this.removeInappropriateTerminators();
    }

    private void removeInappropriateTerminators() {
        LinkedList<Terminator> toBeRemoved = new LinkedList<Terminator>();
        for (Terminator t : this.suboptimalTerms) {
            if (t.numOverlappingBases(this) >= t.getLength() && t.getStrand() == this.getStrand()) continue;
            toBeRemoved.add(t);
        }
        this.suboptimalTerms.removeAll(toBeRemoved);
        this.suboptimalTerms.remove(this.terminator);
    }

    @Override
    public String toGFFString() {
        double siddValue = this.getSiddSite().getMinIncEnergy();
        int termConf = this.getTerminator() == null ? 0 : this.getTerminator().getConfidence();
        String mandatory = String.valueOf(Main.genome.getID()) + "\t" + "nocoRNAc" + "\t" + "ncRNA_transcript" + "\t" + this.getStart() + "\t" + this.getEnd() + "\t" + "." + "\t" + this.getStrand() + "\t" + ".";
        String attributes = "\tID=" + this.getID() + "; ncRNA_Region=" + this.getNcrna().getID() + "; SIDD_value=" + siddValue + "; Term_Confidence=" + termConf;
        if (this.numGenes() > 0) {
            int i;
            List<Object> genes;
            if (this.numGenes() > this.numASGenes()) {
                genes = new LinkedList();
                for (Gene g : this.getGenes()) {
                    if (this.getStrand() != g.getStrand()) continue;
                    genes.add(g);
                }
                attributes = String.valueOf(attributes) + "; sense-overlapping_genes=";
                attributes = String.valueOf(attributes) + ((Gene)genes.get(0)).getID();
                i = 1;
                while (i < genes.size()) {
                    attributes = String.valueOf(attributes) + "," + ((Gene)genes.get(i)).getID();
                    ++i;
                }
            }
            if (this.numASGenes() > 0) {
                genes = this.getASGenes();
                attributes = String.valueOf(attributes) + "; antisense_genes=";
                attributes = String.valueOf(attributes) + ((Gene)genes.get(0)).getID();
                i = 1;
                while (i < genes.size()) {
                    attributes = String.valueOf(attributes) + "," + ((Gene)genes.get(i)).getID();
                    ++i;
                }
            }
        }
        if (this.rnazScore != -1.0) {
            attributes = String.valueOf(attributes) + "; RNAz_P-Value=" + this.getRnazScore();
        }
        return String.valueOf(mandatory) + attributes;
    }

    @Override
    public String toString() {
        String siddID = this.getSiddSite().getID();
        String termID = this.getTerminator() == null ? "NA" : this.getTerminator().getID();
        StringBuffer geneString = new StringBuffer();
        if (this.numGenes() == 0) {
            geneString.append("NA");
        } else {
            geneString.append(this.genes.get(0).getID());
            if (this.numGenes() > 1) {
                int i = 1;
                while (i < this.genes.size()) {
                    geneString.append("," + this.genes.get(i).getID());
                    ++i;
                }
            }
        }
        String as = "F";
        if (this.numASGenes() > 0) {
            as = "T";
        }
        return String.valueOf(this.getID()) + "\t" + this.getNcrna().getID() + "\t" + this.getStart() + "\t" + this.getEnd() + "\t" + this.getStrand() + "\t" + siddID + "\t" + termID + "\t" + geneString + "\t" + as;
    }

    public double getRnazScore() {
        return this.rnazScore;
    }

    public void setRnazScore(double rnazScore) {
        this.rnazScore = rnazScore;
    }
}

