/*
 * Decompiled with CFR 0.152.
 */
package promoter;

import efault.Config;
import genomic.Genome;
import genomic.NCRNA;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import promoter.PCMatch;
import promoter.PCPattern;
import seq.SequenceTools;

public class PCFinder {
    private Genome genome;
    private List<PCPattern> consensusPatterns;
    private List<NCRNA> ncRNAs;
    private List<PCMatch> proms;
    private int upDownStreamRegSize = Config.getInt("pcUpstreamRegionSize");

    public PCFinder(Genome genome, List<NCRNA> ncRNAs, List<PCPattern> consensusPatterns) {
        this.genome = genome;
        this.ncRNAs = ncRNAs;
        this.consensusPatterns = consensusPatterns;
    }

    public void findConsensusMatches() {
        this.proms = new LinkedList<PCMatch>();
        int matchCount = 1;
        int start = 1;
        int end = 1;
        LinkedList<PCMatch> localProms = new LinkedList<PCMatch>();
        for (NCRNA currNCRNA : this.ncRNAs) {
            Matcher matcher;
            localProms.clear();
            start = currNCRNA.getStart() - this.upDownStreamRegSize;
            if (start < 1) {
                start = 1;
            }
            if ((end = currNCRNA.getEnd() + this.upDownStreamRegSize) > this.genome.getEnd()) {
                end = this.genome.getEnd();
            }
            String currNCRNASeq = this.genome.getSequence().getSubsequence(start, end).getSequenceString();
            for (PCPattern currPattern : this.consensusPatterns) {
                matcher = currPattern.getPattern().matcher(currNCRNASeq);
                while (matcher.find()) {
                    localProms.add(new PCMatch("PROMCONS" + matchCount++, start + matcher.start(), start + matcher.end(), '+', currPattern.getName()));
                }
            }
            currNCRNASeq = SequenceTools.reverseComplementDNA(this.genome.getSequence().getSubsequence(start, end)).getSequenceString();
            for (PCPattern currPattern : this.consensusPatterns) {
                matcher = currPattern.getPattern().matcher(currNCRNASeq);
                while (matcher.find()) {
                    localProms.add(new PCMatch("PROMCONS" + matchCount++, end - matcher.end(), end - matcher.start(), '-', currPattern.getName()));
                }
            }
            Collections.sort(localProms);
            this.proms.addAll(localProms);
        }
    }

    public List<PCMatch> getProms() {
        return this.proms;
    }
}

