/*
 * Decompiled with CFR 0.152.
 */
package seq;

import seq.Sequence;

public class RNASequence
extends Sequence {
    public RNASequence() {
        this("");
    }

    public RNASequence(String sequence) {
        this.setSequenceString(sequence);
    }

    @Override
    public boolean isStringConsistentWithSequenceType(String s) {
        int i = 0;
        while (i < s.length()) {
            char tmpChar = s.charAt(i);
            switch (tmpChar) {
                case '-': 
                case '.': 
                case 'A': 
                case 'C': 
                case 'G': 
                case 'N': 
                case 'T': 
                case 'U': 
                case 'a': 
                case 'c': 
                case 'g': 
                case 'n': 
                case 't': 
                case 'u': {
                    break;
                }
                default: {
                    return true;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public RNASequence getSubsequence(int start, int end) {
        return new RNASequence(this.getSequenceString().substring(start - 1, end));
    }
}

