/*
 * Decompiled with CFR 0.152.
 */
package term;

import efault.Config;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import term.Terminator;

public class TransTermParser {
    private static final char COMMENT_CHAR = Config.getChar("commentChar");
    private String filename;
    private LinkedList<Terminator> terminators;

    public TransTermParser(String filename) throws Exception {
        this.filename = filename;
        this.terminators = new LinkedList();
    }

    public void parse() throws Exception {
        boolean parseTerms = true;
        String source = "";
        int lineNo = 0;
        try {
            String[] lineFields;
            BufferedReader br = new BufferedReader(new FileReader(this.filename));
            String line = br.readLine();
            while (line != null) {
                ++lineNo;
                if ((line = line.trim()).length() != 0 && line.charAt(0) != '#' && (lineFields = line.split("[\\s]+"))[0].equals("SEQUENCE")) {
                    source = lineFields[1];
                    break;
                }
                line = br.readLine();
            }
            line = br.readLine();
            while (line != null) {
                ++lineNo;
                if ((line = line.trim()).length() != 0 && line.charAt(0) != COMMENT_CHAR) {
                    lineFields = line.split("[\\s]+");
                    if (lineFields[0].equalsIgnoreCase("SEQUENCE")) break;
                    if (lineFields[0].equalsIgnoreCase("TERM") && parseTerms) {
                        if (lineFields.length < 8) {
                            System.err.println("missing Fields in TERM line!");
                        }
                        String ID = "TERM" + lineFields[1];
                        int start = Integer.parseInt(lineFields[2]);
                        int end = Integer.parseInt(lineFields[4]);
                        char strand = lineFields[5].charAt(0);
                        int conf = Integer.parseInt(lineFields[7]);
                        Terminator term = new Terminator(ID, start, end, strand, conf);
                        this.terminators.add(term);
                    }
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            System.err.println("TransTerm file cannot be read:\n" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            System.err.println("TransTerm file cannot be read:\n" + this.filename + "\nLine " + lineNo + " not in proper format:\n" + e.getMessage());
            throw e;
        }
    }

    public LinkedList<Terminator> getTerminators() {
        return this.terminators;
    }
}

