Attribute VB_Name = "UPDOWNComparions"
'UPDOWN is also for comparing lists of genes, but it gives a Set-Value of
'for the overlap back for making graphs to compare SU SD RU RD / (shoot up, shoot down
'root up/root down) for SAMPLE1 / SAMPLE2 / etc...
'The UP and DOWN are combined, the overlap set is extracted and remember as SHARED
'and the inital group (automatically found from a set of text files in a root(and nested) folders
'to all other files found.
'    Script:
'    UPDOWNComparions, Copyright (C) 2007 Berendzen, Uni-Tbingen
'    see: http://www.zmbp.uni-tuebingen.de/PlantPhysiology/ResearchGroups/harter/berendzen/index.html	
'    UPDOWNComparionscomes with ABSOLUTELY NO WARRANTY;
'    This is free software, and you are welcome to redistribute it
'    under certain conditions.
'
'    This program is free software; you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation; either version 2 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program; if not, write to the Free Software
'    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

Option Explicit

Type UP_DOWN_List
 UP As String
 up_Number As Integer
 DOWN As String
 down_Number As Integer
 SHARED As String
 shared_Number As Integer
End Type
Dim UP_DOWN_Array() As UP_DOWN_List

Type TargetFoundUDDU
  UP_UP As Integer   'found UP of reference list in UP of comparison
  DWN_DWN As Integer
  SHA_SHA As Integer
End Type
Dim TargetFoundUDDU_Array() As TargetFoundUDDU

Dim MM As New MotifMapperBasicClass
Dim ExperimentalFileAGI_listPaths() As String
Dim ExperimentalFileAGI_delimit_lists() As String
Dim outFileMainTextFile
Dim outFileSeqListsUP
Dim outFileSeqListsDOWN

Dim RootFolderName As String
Dim RootFolderForExpFiles As String
Dim FolderRootStem As String

Dim fsO                     '-for File System Object - initilized in main
'- major output will be
'- upOS-up OSdwn-dwn         source comparison -> next
'- OSdwn-up    OSup-dwn

Function FolderPathStem(ByVal FullPath As String) As String
 '* this returns the path part before the last folder
 '- this REQUIRES that at least one folder is given...no drive possible

If InStr(Len(FullPath) - 1, FullPath, "\") Then FullPath = Mid(FullPath, 1, Len(FullPath) - 1)
FolderPathStem = Mid(FullPath, 1, InStrRev(FullPath, "\", , vbBinaryCompare) - 1)
FolderPathStem = FolderPathStem + "\"

End Function


Function RetrieveAllTextFilePaths(LocalRootFolder, ByVal NewPath As String, FoundFiles As Integer, PathsArray)
 '* will return all text files found under a given folder
 '* including subfolders, all folders with -.txt files will be
 '* created under the root folder
Dim QueriedObj, oTextFiles, obj
Dim TempArr() As String
Dim datei
Dim dummy

If FoundFiles = 0 Then
    ReDim PathsArray(0)
End If

 Set QueriedObj = fsO.GetFolder(LocalRootFolder)  '* the current folder/subfolder
 
 'Set oTextFiles = QueriedObj.Files   '* get only the .txt files
 
 'For Each obj In QueriedObj.Files
 ' If InList(fsO3.GetExtensionName(obj), fileFORMAT) Then
 
 '- if we find that there are text files there we set the destination folders

    'prepare another folder
   ' NewPath = NewPath + "\" + QueriedObj.Name
   ' If Not (fsO.Folderexists(NewPath)) Then
   '  Set datei = fsO.Createfolder(NewPath)
   ' End If

 
 For Each obj In QueriedObj.Files
  If UCase(fsO.GetExtensionName(obj)) = "TXT" Then
   ReDim Preserve PathsArray(UBound(PathsArray) + 1)
   PathsArray(UBound(PathsArray)) = fsO.GetAbsolutePathName(obj)
  End If
 Next obj
  
 For Each obj In QueriedObj.subFolders
 'MsgBox obj
  dummy = RetrieveAllTextFilePaths(obj, NewPath, UBound(PathsArray), PathsArray)
 Next

End Function


Function getUPnDOWNlistTimeDelimitedIrrevelant_b(ByVal FullPath As String, CurrentIndex As Integer)
Dim fsOpen
Dim Flagg As Integer
    Flagg = 0
Dim lineSPLITED, atLINE As String
Dim i As Long
Dim UParrayTEMP() As String     'needed for removing redundancy
'Dim DOWNarrayTEMP() As String   'needed for removing redundancy
    ReDim UParrayTEMP(0)        'will go into 1-INDEX
'    ReDim DOWNarrayTEMP(0)      'will go into 1-INDEX
Dim tempFUSEstring As String

'Set outFileSeqListsUP = fsO.CreateTextFile(RootFolderName + MM.SpliceOutFileName(ExperimentalFileAGI_listPaths(CurrentIndex)) + " up " + DateTime.Date$ + ".txt", True)
'Set outFileSeqListsDOWN = fsO.CreateTextFile(RootFolderName + MM.SpliceOutFileName(ExperimentalFileAGI_listPaths(CurrentIndex)) + " down " + DateTime.Date$ + ".txt", True)
  '* format is (and is not controlled!):
  '  bla bla bla
  '  - - -  treatment as file - - -
  ' TIME TIME TIME TIME   TIME2  TIME2 etc....
  ' SU   SD   RU   RD     = shoot/up     shoot/down    root/up    root/down
  ' ..              (for indicating begin samples)
  '* the point for this one is that all UP is compressed to UP and DOWN TO DOWN *'
  '* and all time points are put together too - for now! -

     UP_DOWN_Array(CurrentIndex).UP = "%"        '*1 INDEX
     UP_DOWN_Array(CurrentIndex).DOWN = "%"
    
    '*open the file and get the AGI
    Set fsOpen = fsO.OpenTextFile(FullPath)
    
    '- save as a % delimited string
   Do Until fsOpen.atEndofStream
    
    atLINE = fsOpen.readLine
    atLINE = UCase(atLINE)
    lineSPLITED = Split(atLINE, vbTab, , vbBinaryCompare)

    If Flagg = 1 And atLINE <> "" Then
    'MsgBox "halt"
    For i = 0 To UBound(lineSPLITED)
    If i Mod 2 = 0 And lineSPLITED(i) <> "" Then
    
        If InStr(1, UP_DOWN_Array(CurrentIndex).UP, "%" + lineSPLITED(i) + "%") > 0 Then
         UP_DOWN_Array(CurrentIndex).UP = Replace(UP_DOWN_Array(CurrentIndex).UP, ("%" + lineSPLITED(i)) + "%", "%", , , vbBinaryCompare)
        End If
        UP_DOWN_Array(CurrentIndex).UP = UP_DOWN_Array(CurrentIndex).UP + lineSPLITED(i) + "%"

'outFileSeqListsUP.write lineSPLITED(i) & vbNewLine
    
     ElseIf i Mod 2 = 1 And lineSPLITED(i) <> "" Then
      
       If InStr(1, UP_DOWN_Array(CurrentIndex).DOWN, "%" + lineSPLITED(i) + "%") > 0 Then
        UP_DOWN_Array(CurrentIndex).DOWN = Replace(UP_DOWN_Array(CurrentIndex).DOWN, "%" + lineSPLITED(i) + "%", "%", , , vbBinaryCompare)
       End If
       UP_DOWN_Array(CurrentIndex).DOWN = UP_DOWN_Array(CurrentIndex).DOWN + lineSPLITED(i) + "%"
       
'outFileSeqListsDOWN.write lineSPLITED(i) & vbNewLine
       
       'UP_DOWN_Array(CurrentIndex).down_Number = UP_DOWN_Array(CurrentIndex).down_Number + 1
        
    
     End If

    Next i
    
    End If
    
    If atLINE <> "" Then
     If (UCase(lineSPLITED(0)) = "..") Then Flagg = 1
    End If
   Loop


 '*remove redundancy was done inline, now we fuse the two and make the shared list
'MsgBox UP_DOWN_Array(CurrentIndex).down_Number & " " & GenesPresent(UP_DOWN_Array(CurrentIndex).DOWN)

 tempFUSEstring = Mid(UP_DOWN_Array(CurrentIndex).UP, 2, Len(UP_DOWN_Array(CurrentIndex).UP) - 2)
 UParrayTEMP = Split(tempFUSEstring, "%", , vbBinaryCompare)

 tempFUSEstring = ""
 UP_DOWN_Array(CurrentIndex).UP = "%"
 UP_DOWN_Array(CurrentIndex).SHARED = "%"
  
 For i = 0 To UBound(UParrayTEMP)
 If InStr(1, UP_DOWN_Array(CurrentIndex).DOWN, "%" + UParrayTEMP(i) + "%") > 0 Then
 'MsgBox "oh"
  UP_DOWN_Array(CurrentIndex).SHARED = UP_DOWN_Array(CurrentIndex).SHARED + UParrayTEMP(i) + "%"
  
  UP_DOWN_Array(CurrentIndex).DOWN = Replace(UP_DOWN_Array(CurrentIndex).DOWN, "%" + UParrayTEMP(i) + "%", "%", , , vbBinaryCompare)
  
 Else
  UP_DOWN_Array(CurrentIndex).UP = UP_DOWN_Array(CurrentIndex).UP + UParrayTEMP(i) + "%"
  
 End If
 Next i
 

 
getUPnDOWNlistTimeDelimitedIrrevelant_b = 0
End Function

Sub Main_UPDOWN()
   '*-LOCAL VARIABLES
   Dim i As Integer, ii As Integer, iii As Integer
   Dim datei
   Dim DummyVariable
    ReDim ExperimentalFileAGI_listPaths(0)
    ReDim ExperimentalFileAGI_delimit_lists(0)
   Dim notRepresented As Integer
   Dim TDDU_Start_position


     
   '*-GLOBAL VARIABLES
   Set fsO = CreateObject("Scripting.FileSystemObject")
   
   RootFolderName = MM.setROOT("\ListDistance\")
   'prepare teh folder
   If Not (fsO.folderExists(RootFolderName)) Then
    'create a new folder for convience
    Set datei = fsO.Createfolder(RootFolderName)
   End If
    
   '* input the RootFolder with experimental promoter sets
   RootFolderForExpFiles = InputBox("Enter the Root Folder Path with all " & vbCr & "UP DOWN Gene Lists.", "Root Folder for Experimental Data", "")
   If RootFolderForExpFiles <> "" Then DummyVariable = RetrieveAllTextFilePaths(RootFolderForExpFiles, RootFolderName, 0, ExperimentalFileAGI_listPaths)
    '*
    ReDim ExperimentalFileAGI_delimit_lists(UBound(ExperimentalFileAGI_listPaths))
    FolderRootStem = FolderPathStem(RootFolderForExpFiles)

    Set datei = fsO.GetFolder(RootFolderForExpFiles)
    RootFolderName = RootFolderName + datei.Name
    If Not (fsO.folderExists(RootFolderName)) Then
     Set datei = fsO.Createfolder(RootFolderName)
    End If
    'datei.Close
    

  
  Set outFileMainTextFile = fsO.CreateTextFile(RootFolderName + "\UPDOWNanalysis _" + DateTime.Date$ + ".txt", True)
  
  
  '* get lists
  If RootFolderForExpFiles <> "" Then   'Something to Compare?
  ReDim UP_DOWN_Array(UBound(ExperimentalFileAGI_listPaths))
  
   For i = 1 To UBound(ExperimentalFileAGI_listPaths) '1 index
   'MsgBox ExperimentalFileAGI_listPaths(i)
    DummyVariable = getUPnDOWNlistTimeDelimitedIrrevelant_b(ExperimentalFileAGI_listPaths(i), i)
   'outFileSeqLists.write vbNewLine
   Next i
   
  End If
  '* files are there!!!!!!!
  
  


   '* write out the total numbers of genes in each set first
   '* TO DO!
    outFileMainTextFile.write vbNewLine
    outFileMainTextFile.write "Experiment Title" & vbTab
    For ii = 1 To UBound(ExperimentalFileAGI_listPaths) '1 index
     outFileMainTextFile.write MM.SpliceOutFileName(ExperimentalFileAGI_listPaths(ii)) & vbTab
    Next ii
    outFileMainTextFile.write vbNewLine
    outFileMainTextFile.write "UP" & vbTab
    For ii = 1 To UBound(ExperimentalFileAGI_listPaths) '1 index
     UP_DOWN_Array(ii).up_Number = GenesPresent(UP_DOWN_Array(ii).UP)
     outFileMainTextFile.write UP_DOWN_Array(ii).up_Number & vbTab
    Next ii
    outFileMainTextFile.write vbNewLine
    outFileMainTextFile.write "SHARED" & vbTab
    For ii = 1 To UBound(ExperimentalFileAGI_listPaths) '1 index
     UP_DOWN_Array(ii).shared_Number = GenesPresent(UP_DOWN_Array(ii).SHARED)
     outFileMainTextFile.write UP_DOWN_Array(ii).shared_Number & vbTab
    Next ii
    outFileMainTextFile.write vbNewLine
    outFileMainTextFile.write "DOWN" & vbTab
    For ii = 1 To UBound(ExperimentalFileAGI_listPaths) '1 index
     UP_DOWN_Array(ii).down_Number = GenesPresent(UP_DOWN_Array(ii).DOWN)
     outFileMainTextFile.write UP_DOWN_Array(ii).down_Number & vbTab
    Next ii
    outFileMainTextFile.write vbNewLine
  '*HEADER FORMATTING and TOTAL VALUE DATA


  '* process
  For i = 1 To UBound(ExperimentalFileAGI_listPaths) '1 index
   ReDim TargetFoundUDDU_Array(UBound(ExperimentalFileAGI_listPaths) * 3)
   '*- for UP; SHARED; DOWN
   
   'MsgBox ExperimentalFileAGI_listPaths(i)
   
   
   For ii = 1 To UBound(ExperimentalFileAGI_listPaths) '1 index
   If i <> ii Then
   
   
        '* find who is where!!!
        DummyVariable = calcLISTmembers(ii, i)
  

   End If 'NOT THE SAME SET, same set already handeled
   Next ii 'INNER LOOP

    '* WRITE OUT RESULTS for REFERENCE PASS

 'MsgBox "output"
 
    outFileMainTextFile.write vbNewLine
    outFileMainTextFile.write vbNewLine

    
    
     outFileMainTextFile.write vbNewLine
     outFileMainTextFile.write vbNewLine
     outFileMainTextFile.write vbTab & "up" & vbTab & "shared" & vbTab & "down" & vbTab & "not present" & vbNewLine
     outFileMainTextFile.write MM.SpliceOutFileName(ExperimentalFileAGI_listPaths(i)) & vbTab
     outFileMainTextFile.write GenesPresent(UP_DOWN_Array(i).UP) & vbTab
     outFileMainTextFile.write GenesPresent(UP_DOWN_Array(i).SHARED) & vbTab
     outFileMainTextFile.write GenesPresent(UP_DOWN_Array(i).DOWN) & vbTab
     outFileMainTextFile.write 0 & vbTab
     outFileMainTextFile.write vbNewLine
     outFileMainTextFile.write vbNewLine
    
    For iii = 1 To UBound(ExperimentalFileAGI_listPaths) '1 index
    If iii <> i Then
    TDDU_Start_position = (iii - 1) * 3
    
      outFileMainTextFile.write MM.SpliceOutFileName(ExperimentalFileAGI_listPaths(iii)) + " up" & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position).UP_UP & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position + 1).UP_UP & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position + 2).UP_UP & vbTab
      notRepresented = UP_DOWN_Array(iii).up_Number - (TargetFoundUDDU_Array(TDDU_Start_position).UP_UP + TargetFoundUDDU_Array(TDDU_Start_position + 1).UP_UP + TargetFoundUDDU_Array(TDDU_Start_position + 2).UP_UP)
      outFileMainTextFile.write notRepresented & vbNewLine

      outFileMainTextFile.write MM.SpliceOutFileName(ExperimentalFileAGI_listPaths(iii)) + " shared" & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position).SHA_SHA & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position + 1).SHA_SHA & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position + 2).SHA_SHA & vbTab
      notRepresented = UP_DOWN_Array(iii).shared_Number - (TargetFoundUDDU_Array(TDDU_Start_position).SHA_SHA + TargetFoundUDDU_Array(TDDU_Start_position + 1).SHA_SHA + TargetFoundUDDU_Array(TDDU_Start_position + 2).SHA_SHA)
      outFileMainTextFile.write notRepresented & vbNewLine

      outFileMainTextFile.write MM.SpliceOutFileName(ExperimentalFileAGI_listPaths(iii)) + " down" & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position).DWN_DWN & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position + 1).DWN_DWN & vbTab
      outFileMainTextFile.write TargetFoundUDDU_Array(TDDU_Start_position + 2).DWN_DWN & vbTab
      notRepresented = UP_DOWN_Array(iii).down_Number - (TargetFoundUDDU_Array(TDDU_Start_position).DWN_DWN + TargetFoundUDDU_Array(TDDU_Start_position + 1).DWN_DWN + TargetFoundUDDU_Array(TDDU_Start_position + 2).DWN_DWN)
      outFileMainTextFile.write notRepresented & vbNewLine
    
      outFileMainTextFile.write vbNewLine
    End If
    Next iii
  
    outFileMainTextFile.write vbNewLine
    '* END OUTPUT PASS
   
   
    
   Next i 'END OF MAJOR LOOP


'*OUTPUT lists FOR DIERK*
outFileMainTextFile.Close
End Sub

Function GenesPresent(percentList As String)
  Dim reGGExp
      Set reGGExp = New RegExp
  Dim r1Matches   ', r1Match
    
 reGGExp.Pattern = "%"
 reGGExp.Global = True
 reGGExp.IgnoreCase = True
 Set r1Matches = reGGExp.Execute(percentList)
 GenesPresent = r1Matches.Count - 1

End Function

Function calcLISTmembers(ByVal UnknownPosition As Integer, ByVal ReferencePosition As Integer)
Dim tempUNKNOWNSarrayUP
Dim tempUNKNOWNSarrayDOWN
Dim tempUNKNOWNSarraySHARED
Dim tempUKNOWNSTRING
Dim i As Integer
Dim TDDU_Start_position


TDDU_Start_position = (UnknownPosition - 1) * 3
'MsgBox TDDU_Start_position
'- UPPER CASE IS DONE ON READ IN - see getList
If UP_DOWN_Array(ReferencePosition).up_Number > 0 Then
tempUKNOWNSTRING = UP_DOWN_Array(ReferencePosition).UP
tempUKNOWNSTRING = Mid(tempUKNOWNSTRING, 2, Len(tempUKNOWNSTRING) - 2)
tempUNKNOWNSarrayUP = Split(tempUKNOWNSTRING, "%", , vbBinaryCompare)
tempUKNOWNSTRING = ""
For i = 0 To UBound(tempUNKNOWNSarrayUP)
 If InStr(1, UP_DOWN_Array(UnknownPosition).UP, "%" + tempUNKNOWNSarrayUP(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position).UP_UP = TargetFoundUDDU_Array(TDDU_Start_position).UP_UP + 1
 If InStr(1, UP_DOWN_Array(UnknownPosition).SHARED, "%" + tempUNKNOWNSarrayUP(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position).SHA_SHA = TargetFoundUDDU_Array(TDDU_Start_position).SHA_SHA + 1
 If InStr(1, UP_DOWN_Array(UnknownPosition).DOWN, "%" + tempUNKNOWNSarrayUP(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position).DWN_DWN = TargetFoundUDDU_Array(TDDU_Start_position).DWN_DWN + 1
Next i
End If
ReDim tempUNKNOWNSarrayUP(0)


'MsgBox UBound(TargetFoundUDDU_Array)
If UP_DOWN_Array(ReferencePosition).shared_Number > 0 Then
tempUKNOWNSTRING = UP_DOWN_Array(ReferencePosition).SHARED
tempUKNOWNSTRING = Mid(tempUKNOWNSTRING, 2, Len(tempUKNOWNSTRING) - 2)
tempUNKNOWNSarraySHARED = Split(tempUKNOWNSTRING, "%", , vbBinaryCompare)
tempUKNOWNSTRING = ""
For i = 0 To UBound(tempUNKNOWNSarraySHARED)
 If InStr(1, UP_DOWN_Array(UnknownPosition).UP, "%" + tempUNKNOWNSarraySHARED(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position + 1).UP_UP = TargetFoundUDDU_Array(TDDU_Start_position + 1).UP_UP + 1
  If InStr(1, UP_DOWN_Array(UnknownPosition).SHARED, "%" + tempUNKNOWNSarraySHARED(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position + 1).SHA_SHA = TargetFoundUDDU_Array(TDDU_Start_position + 1).SHA_SHA + 1
 If InStr(1, UP_DOWN_Array(UnknownPosition).DOWN, "%" + tempUNKNOWNSarraySHARED(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position + 1).DWN_DWN = TargetFoundUDDU_Array(TDDU_Start_position + 1).DWN_DWN + 1
Next i
End If
ReDim tempUNKNOWNSarraySHARED(0)


'MsgBox "halt"
If UP_DOWN_Array(ReferencePosition).down_Number > 0 Then
tempUKNOWNSTRING = UP_DOWN_Array(ReferencePosition).DOWN
tempUKNOWNSTRING = Mid(tempUKNOWNSTRING, 2, Len(tempUKNOWNSTRING) - 2)
tempUNKNOWNSarrayDOWN = Split(tempUKNOWNSTRING, "%", , vbBinaryCompare)
tempUKNOWNSTRING = ""
For i = 0 To UBound(tempUNKNOWNSarrayDOWN)
 If InStr(1, UP_DOWN_Array(UnknownPosition).UP, "%" + tempUNKNOWNSarrayDOWN(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position + 2).UP_UP = TargetFoundUDDU_Array(TDDU_Start_position + 2).UP_UP + 1
 If InStr(1, UP_DOWN_Array(UnknownPosition).SHARED, "%" + tempUNKNOWNSarrayDOWN(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position + 2).SHA_SHA = TargetFoundUDDU_Array(TDDU_Start_position + 2).SHA_SHA + 1
 If InStr(1, UP_DOWN_Array(UnknownPosition).DOWN, "%" + tempUNKNOWNSarrayDOWN(i) + "%") > 0 Then TargetFoundUDDU_Array(TDDU_Start_position + 2).DWN_DWN = TargetFoundUDDU_Array(TDDU_Start_position + 2).DWN_DWN + 1
Next i
End If
ReDim tempUNKNOWNSarrayDOWN(0)



calcLISTmembers = 0

End Function
