/*
 * Decompiled with CFR 0.152.
 */
package chip;

import chip.RumSamplerSaver;
import genomic.ArrayProbe;
import genomic.Genome;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import seq.SequenceTools;

public class RumSampler {
    private Genome genome;
    private char[] genomeCh;
    private ArrayProbe[] probes;
    private int[] startPos;
    private int probeLength;
    private Random rand;
    private volatile String[] rownames;
    private volatile int[][] result;

    public RumSampler(Genome genome, List<ArrayProbe> probes, String resFile, long saveInterval) {
        this.genome = genome;
        this.probeLength = probes.get(0).getLength();
        this.probes = new ArrayProbe[probes.size()];
        this.probes = probes.toArray(this.probes);
        this.result = new int[this.probes.length][this.probeLength + 1];
        this.genomeCh = (String.valueOf(genome.getSequence().getSequenceString()) + SequenceTools.reverseComplementDNA(genome.getSequence())).toCharArray();
        this.rand = new Random();
        int genomeLength = genome.getLength();
        this.startPos = new int[probes.size()];
        int i = 0;
        while (i < this.probes.length) {
            int tmp = this.probes[i].getStrand() == '+' ? this.probes[i].getStart() - 1 : genomeLength - (this.probes[i].getEnd() - 1) + genomeLength - 1;
            this.startPos[i] = tmp;
            ++i;
        }
        LinkedList<String> names = new LinkedList<String>();
        int i2 = 0;
        while (i2 < this.probes.length) {
            names.add(this.probes[i2].getID());
            ++i2;
        }
        this.rownames = names.toArray(new String[1]);
        if (saveInterval != 0L) {
            new RumSamplerSaver(resFile, saveInterval, this.result, names.toArray(new String[1])).start();
        }
    }

    public void sampleRum() {
        int start1 = 0;
        int start2 = 0;
        int diff = 0;
        int pos = 0;
        while (pos < this.genomeCh.length - 1 - this.probeLength) {
            start2 = pos;
            int i = 0;
            while (i < this.startPos.length) {
                start1 = this.startPos[i];
                diff = 0;
                int diff_iterator = 0;
                while (diff_iterator != this.probeLength) {
                    if (this.genomeCh[start1 + diff_iterator] != this.genomeCh[start2 + diff_iterator]) {
                        ++diff;
                    }
                    ++diff_iterator;
                }
                int[] nArray = this.result[i];
                int n = diff;
                nArray[n] = nArray[n] + 1;
                ++i;
            }
            ++pos;
        }
    }

    public void sampleRum2() {
        int start1 = 0;
        int start2 = 0;
        int diff = 0;
        int pos = 0;
        while (pos < this.genomeCh.length - 1 - this.probeLength) {
            start2 = pos;
            int i = 0;
            while (i < this.startPos.length) {
                start1 = this.startPos[i];
                diff = 0;
                int diff_iterator = 0;
                while (diff_iterator != this.probeLength) {
                    if (this.genomeCh[start1 + diff_iterator] != this.genomeCh[start2 + diff_iterator]) {
                        ++diff;
                    }
                    ++diff_iterator;
                }
                if (diff < 6) {
                    System.out.println(String.valueOf(this.rownames[i]) + "\t" + pos + "\t" + diff);
                }
                ++i;
            }
            ++pos;
        }
    }

    public void save(String filename) throws Exception {
        System.out.println("Saving: " + filename);
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        int row = 0;
        while (row != this.rownames.length) {
            bw.write(this.rownames[row]);
            int col = 0;
            while (col != this.result[row].length) {
                bw.write("\t" + this.result[row][col]);
                ++col;
            }
            bw.write("\n");
            ++row;
        }
        bw.flush();
        bw.close();
    }
}

