/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Config;
import genomic.MASequenceFeature;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;
import seq.Sequence;

public class ArrayProbe
extends MASequenceFeature {
    private String probeSetID;

    public ArrayProbe() {
    }

    public ArrayProbe(String ID, int start, int end, char strand, String probeSetID) {
        super(ID, start, end, strand);
        this.probeSetID = probeSetID;
    }

    @Override
    public boolean isSequenceConsitentWithFeatureType(Sequence seq) {
        return false;
    }

    @Override
    public String toGFFString() {
        return null;
    }

    public String getProbeSetID() {
        return this.probeSetID;
    }

    public static List<ArrayProbe> parseTilingMap(String filename) throws Exception {
        char COMMENT_CHAR = Config.getChar("commentChar");
        LinkedList<ArrayProbe> res = new LinkedList<ArrayProbe>();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() != 0 && line.charAt(0) != COMMENT_CHAR) {
                String[] lineFields = line.split("\\s");
                String name = lineFields[5];
                int start = Integer.parseInt(lineFields[3]);
                int end = Integer.parseInt(lineFields[4]);
                String preStrand = lineFields[2];
                char strand = preStrand.equals("TRUE") ? (char)'+' : '-';
                String probesetID = lineFields[1];
                res.add(new ArrayProbe(name, start, end, strand, probesetID));
            }
            line = br.readLine();
        }
        br.close();
        return res;
    }
}

