/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Config;
import genomic.TSS;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;

public class TSSGFFParser {
    private static final char COMMENT_CHAR = Config.getChar("commentChar");

    public static List<TSS> parseGFF(String filename) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        LinkedList<TSS> tssList = new LinkedList<TSS>();
        String line = br.readLine();
        while (line != null) {
            if (line.charAt(0) == COMMENT_CHAR) {
                line = br.readLine();
                continue;
            }
            String[] lineFields = line.split("\\s");
            String sourceSeqID = lineFields[0];
            String id = lineFields[9];
            int start = Integer.parseInt(lineFields[3]);
            int end = Integer.parseInt(lineFields[4]);
            char strand = lineFields[6].charAt(0);
            tssList.add(new TSS(id, start, end, strand));
            line = br.readLine();
        }
        br.close();
        return tssList;
    }
}

