/*
 * Decompiled with CFR 0.152.
 */
package interact;

import genomic.AbstractSequenceFeature;
import interact.TranskriptInteraction;
import java.util.HashSet;
import java.util.List;
import sidd.SIDDSettings;

public class InteractionProfiler {
    public static void profileInteractions(List<TranskriptInteraction> interactions) {
        HashSet<AbstractSequenceFeature> interactionPartners = new HashSet<AbstractSequenceFeature>();
        for (TranskriptInteraction ti : interactions) {
            interactionPartners.add(ti.getHunter());
            interactionPartners.add(ti.getTarget());
        }
        double Znet = 0.0;
        for (TranskriptInteraction ti : interactions) {
            Znet += Math.exp(-(ti.getEnergy() / (SIDDSettings.GAS_CONSTANT * SIDDSettings.DEFAULT_TEMPERATURE)));
        }
        for (AbstractSequenceFeature sf : interactionPartners) {
            if (sf.numInteractions() == 0) continue;
            double[] profileG = new double[sf.getLength()];
            double[] profileZ = new double[sf.getLength()];
            int[] profileN = new int[sf.getLength()];
            double Z = 0.0;
            for (TranskriptInteraction ti : sf.getInteractions()) {
                int tmpend;
                int tmpstart;
                if (sf.getID().equals(ti.getHunter().getID())) {
                    tmpstart = ti.getHunterStart();
                    tmpend = ti.getHunterEnd();
                } else if (sf.getID().equals(ti.getTarget().getID())) {
                    tmpstart = ti.getTargetStart();
                    tmpend = ti.getTargetEnd();
                } else {
                    throw new Error("This error shouldn't occur!");
                }
                Z += Math.exp(-(ti.getEnergy() / (SIDDSettings.GAS_CONSTANT * SIDDSettings.DEFAULT_TEMPERATURE)));
                int i = tmpstart;
                while (i <= tmpend) {
                    int n = i - 1;
                    profileN[n] = profileN[n] + 1;
                    int n2 = i - 1;
                    profileZ[n2] = profileZ[n2] + Math.exp(-(ti.getEnergy() / (SIDDSettings.GAS_CONSTANT * SIDDSettings.DEFAULT_TEMPERATURE)));
                    int n3 = i - 1;
                    profileG[n3] = profileG[n3] + ti.getEnergy() * Math.exp(-(ti.getEnergy() / (SIDDSettings.GAS_CONSTANT * SIDDSettings.DEFAULT_TEMPERATURE)));
                    ++i;
                }
            }
            int i = 0;
            while (i < profileZ.length) {
                if (profileG[i] != 0.0) {
                    int n = i;
                    profileG[n] = profileG[n] / profileZ[i];
                }
                ++i;
            }
            if (sf.getStrand() == '-') {
                InteractionProfiler.revertProfile(profileN);
                InteractionProfiler.revertProfile(profileG);
                InteractionProfiler.revertProfile(profileZ);
            }
            sf.setInteractionProfiles(profileN, profileZ, profileG, Z, Znet);
        }
    }

    private static void revertProfile(double[] profile) {
        int i = 0;
        int j = profile.length - 1;
        while (i < j) {
            double swap = profile[i];
            profile[i] = profile[j];
            profile[j] = swap;
            ++i;
            --j;
        }
    }

    private static void revertProfile(int[] profile) {
        int i = 0;
        int j = profile.length - 1;
        while (i < j) {
            int swap = profile[i];
            profile[i] = profile[j];
            profile[j] = swap;
            ++i;
            --j;
        }
    }
}

