/*
 * Decompiled with CFR 0.152.
 */
package interact;

import efault.Config;
import genomic.AbstractSequenceFeature;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TranskriptInteraction
implements Comparable<TranskriptInteraction> {
    private static final char COMMENT_CHAR = Config.getChar("commentChar");
    private AbstractSequenceFeature hunter;
    private AbstractSequenceFeature target;
    private int hunterStart;
    private int hunterEnd;
    private char hunterStrand;
    private int targetStart;
    private int targetEnd;
    private char targetStrand;
    private double hunterED;
    private double targetED;
    private double hybridE;
    private double energy;

    public static void writeTranscriptInteractions(List<? extends TranskriptInteraction> interactions, String filename) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        Iterator<? extends TranskriptInteraction> transIt = interactions.iterator();
        while (transIt.hasNext()) {
            bw.append(String.valueOf(transIt.next().toString()) + "\n");
        }
        bw.close();
    }

    public static List<TranskriptInteraction> readTranscriptInteractions_oldAndSlow(List<AbstractSequenceFeature> potentialHuntersAndTargets, File file) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(file));
        LinkedList<TranskriptInteraction> interactions = new LinkedList<TranskriptInteraction>();
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                line = br.readLine();
                continue;
            }
            if (line.charAt(0) == COMMENT_CHAR) {
                line = br.readLine();
                continue;
            }
            String[] lineFields = line.split("[\\s]+");
            String hunterID = lineFields[0];
            String targetID = lineFields[1];
            int hunterStart = Integer.parseInt(lineFields[2]);
            int hunterEnd = Integer.parseInt(lineFields[3]);
            char hunterStrand = lineFields[4].charAt(0);
            int targetStart = Integer.parseInt(lineFields[5]);
            int targetEnd = Integer.parseInt(lineFields[6]);
            char targetStrand = lineFields[7].charAt(0);
            double hunterED = Double.parseDouble(lineFields[8]);
            double targetED = Double.parseDouble(lineFields[9]);
            double hybridE = Double.parseDouble(lineFields[10]);
            double energy = Double.parseDouble(lineFields[11]);
            AbstractSequenceFeature hunter = null;
            AbstractSequenceFeature target = null;
            for (AbstractSequenceFeature sf : potentialHuntersAndTargets) {
                if (sf.getID().equalsIgnoreCase(hunterID)) {
                    hunter = sf;
                    continue;
                }
                if (!sf.getID().equalsIgnoreCase(targetID)) continue;
                target = sf;
            }
            if (hunter == null) {
                System.err.println("Warning while reading " + file.getName() + "! " + hunterID + " does not match any sequence feature! Entry will be ignored.");
                line = br.readLine();
                continue;
            }
            if (target == null) {
                System.err.println("Warning while reading " + file.getName() + "! " + targetID + " does not match any sequence feature! Entry will be ignored.");
                line = br.readLine();
                continue;
            }
            TranskriptInteraction inter = new TranskriptInteraction(hunter, target, hunterStart, hunterEnd, hunterStrand, targetStart, targetEnd, targetStrand, hunterED, targetED, hybridE, energy);
            interactions.add(inter);
            hunter.addInteraction(inter);
            target.addInteraction(inter);
            line = br.readLine();
        }
        return interactions;
    }

    public static List<TranskriptInteraction> readTranscriptInteractions(List<AbstractSequenceFeature> potentialHuntersAndTargets, File file) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(file));
        LinkedList<TranskriptInteraction> interactions = new LinkedList<TranskriptInteraction>();
        HashMap<String, AbstractSequenceFeature> sfMap = new HashMap<String, AbstractSequenceFeature>();
        for (AbstractSequenceFeature sf : potentialHuntersAndTargets) {
            sfMap.put(sf.getID(), sf);
        }
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                line = br.readLine();
                continue;
            }
            if (line.charAt(0) == COMMENT_CHAR) {
                line = br.readLine();
                continue;
            }
            String[] lineFields = line.split("[\\s]+");
            String hunterID = lineFields[0];
            String targetID = lineFields[1];
            int hunterStart = Integer.parseInt(lineFields[2]);
            int hunterEnd = Integer.parseInt(lineFields[3]);
            char hunterStrand = lineFields[4].charAt(0);
            int targetStart = Integer.parseInt(lineFields[5]);
            int targetEnd = Integer.parseInt(lineFields[6]);
            char targetStrand = lineFields[7].charAt(0);
            double hunterED = Double.parseDouble(lineFields[8]);
            double targetED = Double.parseDouble(lineFields[9]);
            double hybridE = Double.parseDouble(lineFields[10]);
            double energy = Double.parseDouble(lineFields[11]);
            AbstractSequenceFeature hunter = (AbstractSequenceFeature)sfMap.get(hunterID);
            AbstractSequenceFeature target = (AbstractSequenceFeature)sfMap.get(targetID);
            if (hunter == null) {
                System.err.println("Warning while reading " + file.getName() + "! " + hunterID + " does not match any sequence feature! Entry will be ignored.");
                line = br.readLine();
                continue;
            }
            if (target == null) {
                System.err.println("Warning while reading " + file.getName() + "! " + targetID + " does not match any sequence feature! Entry will be ignored.");
                line = br.readLine();
                continue;
            }
            TranskriptInteraction inter = new TranskriptInteraction(hunter, target, hunterStart, hunterEnd, hunterStrand, targetStart, targetEnd, targetStrand, hunterED, targetED, hybridE, energy);
            interactions.add(inter);
            hunter.addInteraction(inter);
            target.addInteraction(inter);
            line = br.readLine();
        }
        return interactions;
    }

    public TranskriptInteraction(AbstractSequenceFeature hunter, AbstractSequenceFeature target, int hunterStart, int hunterEnd, char hunterStrand, int targetStart, int targetEnd, char targetStrand, double hunterED, double targetED, double hybridE, double energy) {
        this.hunter = hunter;
        this.target = target;
        this.hunterStart = hunterStart;
        this.hunterEnd = hunterEnd;
        this.hunterStrand = hunterStrand;
        this.targetStart = targetStart;
        this.targetEnd = targetEnd;
        this.targetStrand = targetStrand;
        this.hunterED = hunterED;
        this.targetED = targetED;
        this.hybridE = hybridE;
        this.energy = energy;
        this.checkForStrandInconsistencies();
    }

    private void checkForStrandInconsistencies() {
        char strand = this.hunter.getStrand();
        if (strand != '.' && this.hunterStrand != '.' && strand != this.hunterStrand) {
            System.err.println("WARNING: An interaction between " + this.hunter.getID() + " and " + this.target.getID() + " does not use the original strand of " + this.hunter.getID() + "!");
        }
        if (strand == '.' && this.hunterStrand == '.') {
            System.err.println("WARNING: An interaction between " + this.hunter.getID() + " and " + this.target.getID() + " does not specify the strand of " + this.hunter.getID() + "!");
        }
        if ((strand = this.target.getStrand()) != '.' && this.targetStrand != '.' && strand != this.targetStrand) {
            System.err.println("WARNING: An interaction between " + this.hunter.getID() + " and " + this.target.getID() + " does not use the original strand of " + this.target.getID() + "!");
        }
        if (strand == '.' && this.targetStrand == '.') {
            System.err.println("WARNING: An interaction between " + this.hunter.getID() + " and " + this.target.getID() + " does not specify the strand of " + this.target.getID() + "!");
        }
    }

    public boolean isSenseAntisensePair() {
        if (this.hunter.numOverlappingBases(this.target) > 0) {
            if (this.hunterStrand == '+' || this.hunter.getStrand() == '+' && this.targetStrand == '-' || this.target.getStrand() == '-') {
                return true;
            }
            if (this.hunterStrand == '-' || this.hunter.getStrand() == '-' && this.targetStrand == '+' || this.target.getStrand() == '+') {
                return true;
            }
        }
        return false;
    }

    public double getEnergy() {
        return this.energy;
    }

    public AbstractSequenceFeature getHunter() {
        return this.hunter;
    }

    public double getHunterED() {
        return this.hunterED;
    }

    public int getHunterEnd() {
        return this.hunterEnd;
    }

    public int getHunterStart() {
        return this.hunterStart;
    }

    public double getHybridE() {
        return this.hybridE;
    }

    public AbstractSequenceFeature getTarget() {
        return this.target;
    }

    public double getTargetED() {
        return this.targetED;
    }

    public int getTargetEnd() {
        return this.targetEnd;
    }

    public int getTargetStart() {
        return this.targetStart;
    }

    public int getInteractionLength() {
        return this.targetEnd - this.targetStart + 1;
    }

    public double getNormEnergy() {
        return this.energy / (double)this.getInteractionLength();
    }

    @Override
    public int compareTo(TranskriptInteraction o) {
        if (this.energy > o.energy) {
            return 1;
        }
        if (this.energy < o.energy) {
            return -1;
        }
        return 0;
    }

    public char getHunterStrand() {
        return this.hunterStrand;
    }

    public char getTargetStrand() {
        return this.targetStrand;
    }

    public String toString() {
        return String.valueOf(this.hunter.getID()) + "\t" + this.target.getID() + "\t" + this.hunterStart + "\t" + this.hunterEnd + "\t" + this.hunterStrand + "\t" + this.targetStart + "\t" + this.targetEnd + "\t" + this.targetStrand + "\t" + this.hunterED + "\t" + this.targetED + "\t" + this.hybridE + "\t" + this.energy;
    }
}

