/*
 * Decompiled with CFR 0.152.
 */
package rfam;

import efault.Config;
import efault.Main;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import rfam.CMSearchScannerThread;
import rfam.RfamHit;
import rfam.RfamSeed;

public class CMSearchScanner {
    public static double E_VALUE_CUTOFF = Config.getDouble("cmsearchEValueCutoff");
    public static boolean cmsearchProkaryoticOnly = Config.getBoolean("cmsearchProkaryoticOnly");
    private List<String> nonProkEntries;
    private List<RfamSeed> allSeeds;
    private Queue<RfamSeed> seedQueue;
    private List<RfamHit> hits;
    private File genomeFasta;
    private int numCPUs;

    public CMSearchScanner(List<RfamSeed> rfamSeeds, File genomeFasta) throws Exception {
        this.genomeFasta = genomeFasta;
        this.allSeeds = rfamSeeds;
        this.nonProkEntries = cmsearchProkaryoticOnly ? new LinkedList<String>(Arrays.asList(Config.getString("nonProkaryoticRfam").split(","))) : new LinkedList<String>();
        this.numCPUs = Main.numCPUs;
        if (this.allSeeds.size() < this.numCPUs) {
            this.numCPUs = 1;
        }
    }

    public void scan(String[] queries) throws Exception {
        this.hits = new LinkedList<RfamHit>();
        this.seedQueue = new LinkedList<RfamSeed>();
        boolean scanAll = false;
        if (queries.length == 0) {
            scanAll = true;
        }
        for (RfamSeed currSeed : this.allSeeds) {
            boolean scanSeed = scanAll;
            int i = 0;
            while (i < queries.length) {
                if (currSeed.getAC().toLowerCase().contains(queries[i].toLowerCase())) {
                    scanSeed = true;
                    break;
                }
                if (currSeed.getTP().toLowerCase().contains(queries[i].toLowerCase())) {
                    scanSeed = true;
                    break;
                }
                ++i;
            }
            for (String e : this.nonProkEntries) {
                if (!currSeed.getAC().toLowerCase().contains(e.toLowerCase()) && !currSeed.getTP().toLowerCase().contains(e.toLowerCase())) continue;
                scanSeed = false;
                break;
            }
            if (!scanSeed) continue;
            this.seedQueue.add(currSeed);
        }
        CMSearchScannerThread[] searchers = new CMSearchScannerThread[this.numCPUs];
        int i = 0;
        while (i < searchers.length) {
            searchers[i] = new CMSearchScannerThread(this, this.genomeFasta, i);
            ++i;
        }
        CMSearchScannerThread[] cMSearchScannerThreadArray = searchers;
        int n = searchers.length;
        int n2 = 0;
        while (n2 < n) {
            CMSearchScannerThread s = cMSearchScannerThreadArray[n2];
            s.start();
            ++n2;
        }
        cMSearchScannerThreadArray = searchers;
        n = searchers.length;
        n2 = 0;
        while (n2 < n) {
            CMSearchScannerThread s = cMSearchScannerThreadArray[n2];
            s.join();
            ++n2;
        }
        cMSearchScannerThreadArray = searchers;
        n = searchers.length;
        n2 = 0;
        while (n2 < n) {
            CMSearchScannerThread s = cMSearchScannerThreadArray[n2];
            this.hits.addAll(s.getHits());
            ++n2;
        }
        Collections.sort(this.hits);
    }

    protected synchronized RfamSeed getNextSeed() {
        return this.seedQueue.poll();
    }

    public List<RfamHit> getHits() {
        return this.hits;
    }
}

