/*
 * Decompiled with CFR 0.152.
 */
package rfam;

import efault.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rfam.RfamHit;

public class RfamHitIO {
    public static int NUM_RFAM_HIT_FIELDS = 11;
    public static char COMMENT_CHAR = Config.getChar("commentChar");

    public static List<RfamHit> readRfamHits(File infile) throws Exception {
        LinkedList<RfamHit> res = new LinkedList<RfamHit>();
        int lineCount = 0;
        BufferedReader reader = new BufferedReader(new FileReader(infile));
        String line = reader.readLine();
        while (line != null) {
            ++lineCount;
            if ((line = line.trim()).length() != 0 && line.charAt(0) != COMMENT_CHAR) {
                String[] currLine = line.split("[\\t]+");
                if (currLine.length != NUM_RFAM_HIT_FIELDS) {
                    System.err.println("Line " + lineCount + " of file " + infile.getAbsolutePath() + " contains improper number of fields.");
                } else {
                    res.add(new RfamHit(currLine[0], Integer.parseInt(currLine[1]), Integer.parseInt(currLine[2]), currLine[3].charAt(0), currLine[4], currLine[5], currLine[6], currLine[7], currLine[8], Double.parseDouble(currLine[9]), Double.parseDouble(currLine[10])));
                }
            }
            line = reader.readLine();
        }
        return res;
    }

    public static void writeRfamHits(List<RfamHit> rFamHits, File outfile) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outfile));
        Iterator<RfamHit> hitIt = rFamHits.iterator();
        while (hitIt.hasNext()) {
            writer.write(hitIt.next().toString());
            writer.newLine();
        }
        writer.close();
    }
}

