/*
 * Decompiled with CFR 0.152.
 */
package seq;

import genomic.Gene;
import genomic.Genome;
import genomic.NCRNA;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.List;

public class DNAStabTools {
    public static double calcUpstreamGibbsMean(Genome genome, List<Gene> genes, int upstreamRegSize) {
        Iterator<Gene> genesIt = genes.iterator();
        double sum = 0.0;
        int numNucs = 0;
        while (genesIt.hasNext()) {
            int end;
            int start;
            Gene tmpGene = genesIt.next();
            if (tmpGene.getStrand() == '+') {
                start = tmpGene.getStart() - 1 - (upstreamRegSize - 1);
                end = tmpGene.getStart() - 1;
            } else {
                start = tmpGene.getEnd() + 1;
                end = tmpGene.getEnd() + 1 + (upstreamRegSize - 1);
            }
            if (start < 1 || end > genome.getEnd()) continue;
            int i = start;
            while (i <= end) {
                sum += genome.getGibbsEnergyAt(i);
                ++numNucs;
                ++i;
            }
        }
        return sum / (double)numNucs;
    }

    public static double calcUpstreamGibbsSd(Genome genome, List<Gene> genes, int upstreamRegSize, double mean) {
        Iterator<Gene> genesIt = genes.iterator();
        double sum = 0.0;
        int numNucs = 0;
        while (genesIt.hasNext()) {
            int end;
            int start;
            Gene tmpGene = genesIt.next();
            if (tmpGene.getStrand() == '+') {
                start = tmpGene.getStart() - 1 - (upstreamRegSize - 1);
                end = tmpGene.getStart() - 1;
            } else {
                start = tmpGene.getEnd() + 1;
                end = tmpGene.getEnd() + 1 + (upstreamRegSize - 1);
            }
            if (start < 1 || end > genome.getEnd()) continue;
            int i = start;
            while (i <= end) {
                sum += Math.pow(genome.getGibbsEnergyAt(i) - mean, 2.0);
                ++numNucs;
                ++i;
            }
        }
        return Math.sqrt(sum / (double)numNucs);
    }

    public static void writeUpstreamGibbsProfiles(Genome genome, List<Gene> genes, int upstreamRegSize, String outfile) throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter(outfile));
        for (Gene tmpGene : genes) {
            int end;
            int start;
            if (tmpGene.getStrand() == '+') {
                start = tmpGene.getStart() - 1 - (upstreamRegSize - 1);
                end = tmpGene.getStart() - 1;
            } else {
                start = tmpGene.getEnd() + 1;
                end = tmpGene.getEnd() + 1 + (upstreamRegSize - 1);
            }
            if (start < 1 || end > genome.getEnd()) continue;
            int i = start;
            while (i <= end) {
                w.write(String.valueOf(genome.getGibbsEnergyAt(i)) + "\t");
                ++i;
            }
            w.newLine();
        }
        w.flush();
    }

    public static void writeUpstreamGibbsRegionProfiles(Genome genome, List<Gene> genes, int upstreamRegSize, int regionSize, String outfile) throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter(outfile));
        for (Gene tmpGene : genes) {
            int end;
            int start;
            if (tmpGene.getStrand() == '+') {
                start = tmpGene.getStart() - 1 - (upstreamRegSize - 1);
                end = tmpGene.getStart() - 1;
            } else {
                start = tmpGene.getEnd() + 1;
                end = tmpGene.getEnd() + 1 + (upstreamRegSize - 1);
            }
            if (start < 1 || end + regionSize - 1 > genome.getEnd()) continue;
            int i = start;
            while (i <= end) {
                w.write(String.valueOf(DNAStabTools.calcAverageGibbsEnergyInRegion(genome, i, i + regionSize - 1)) + "\t");
                ++i;
            }
            w.newLine();
        }
        w.flush();
    }

    public static void writeNCRNAGibbsRegionProfiles(Genome genome, List<NCRNA> ncRNAs, int upDownRegionSize, int regionSize, String outfile) throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter(outfile));
        for (NCRNA tmpNCRNA : ncRNAs) {
            int start = tmpNCRNA.getStart() - 1 - (upDownRegionSize - 1);
            int end = tmpNCRNA.getEnd() + 1 + (upDownRegionSize - 1);
            if (start < 1 || end + regionSize - 1 > genome.getEnd()) continue;
            int i = start;
            while (i <= end) {
                w.write(String.valueOf(DNAStabTools.calcAverageGibbsEnergyInRegion(genome, i, i + regionSize - 1)) + "\t");
                ++i;
            }
            w.newLine();
        }
        w.flush();
    }

    public static void writeUpstreamGibbsOverallProfile(Genome genome, List<Gene> genes, int upstreamRegSize, String outfile) throws Exception {
        int i;
        BufferedWriter w = new BufferedWriter(new FileWriter(outfile));
        int numProfs = 0;
        double[] profile = new double[upstreamRegSize];
        for (Gene tmpGene : genes) {
            int end;
            int start;
            if (tmpGene.getStrand() == '+') {
                start = tmpGene.getStart() - 1 - (upstreamRegSize - 1);
                end = tmpGene.getStart() - 1;
                if (start < 1 || end > genome.getEnd()) continue;
                i = 0;
                while (i < upstreamRegSize) {
                    int n = i;
                    profile[n] = profile[n] + genome.getGibbsEnergyAt(start + i);
                    ++i;
                }
                ++numProfs;
                continue;
            }
            start = tmpGene.getEnd() + 1;
            end = tmpGene.getEnd() + 1 + (upstreamRegSize - 1);
            if (start < 1 || end > genome.getEnd()) continue;
            i = 0;
            while (i < upstreamRegSize) {
                int n = i;
                profile[n] = profile[n] + genome.getGibbsEnergyAt(end - i);
                ++i;
            }
            ++numProfs;
        }
        i = 0;
        while (i < profile.length) {
            int n = i++;
            profile[n] = profile[n] / (double)numProfs;
        }
        i = 0;
        while (i < profile.length) {
            w.write(String.valueOf(profile[i]) + "\t");
            ++i;
        }
        w.flush();
    }

    public static double calcAverageGibbsEnergyInRegion(Genome genome, int start, int end) {
        if (start < 1 || end > genome.getEnd()) {
            throw new IndexOutOfBoundsException("Region not within genome bounds!");
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start! Has to be greater or equal!");
        }
        double res = 0.0;
        int i = start;
        while (i <= end) {
            res += genome.getGibbsEnergyAt(i);
            ++i;
        }
        return res /= (double)(end - start + 1);
    }
}

