/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.mycosem;

import java.util.ArrayList;

import org.openmuc.jsml.structures.OctetString;

import de.ekut.informatik.kn.josef.mycosem.InterfaceClass;

/**
 * Class that represents a logical device (LD) in the COSEM server model.
 * 
 * @author Daniel Fuchs
 */
public class LogicalDevice {

    /**
     * Service Access Point (SAP) of this LD.
     */
    private final OctetString sap;

    /**
     * Holds all COSEM objects in this LD.
     */
    private ArrayList<InterfaceClass> objList;

    /**
     * Name of the LD.
     */
    private OctetString name;

    /**
     * Constructor.
     * 
     * @param sap
     *            service access point
     */
    public LogicalDevice(OctetString sap, OctetString name) {
        this.sap = sap;
        this.objList = new ArrayList<InterfaceClass>();
        this.name = name;
    }

    /**
     * Constructor with empty name. Caution: must be set later.
     * 
     * @param sap
     */
    public LogicalDevice(OctetString sap) {
        this.sap = sap;
        this.objList = new ArrayList<InterfaceClass>();
        this.name = new OctetString("NameEmpty");
    }

    /**
     * Gets the SAP.
     * 
     * @return
     */
    public OctetString getSap() {
        return this.sap;
    }

    /**
     * Gets the name.
     * 
     * @return
     */
    public OctetString getName() {
        return this.name;
    }

    /**
     * Sets the name.
     * 
     * @param name
     */
    public void setName(OctetString name) {
        this.name = name;
    }

    /**
     * Gets the object list. For thread-safety, only access via this getter.
     * 
     * @return
     */
    public synchronized ArrayList<InterfaceClass> getObjectList() {
        return this.objList;
    }

}
