/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation
Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.mycosem;

import java.util.ArrayList;
import java.util.Iterator;

import org.openmuc.jsml.structures.OctetString;

/**
 * This class represents an abstract COSEM server model.
 * 
 * @author Daniel Fuchs
 * @author Michael Hoefling
 */
public class ServerModel {

    /**
     * Holds all logical devices in the server model.
     */
    protected ArrayList<LogicalDevice> ldevs;

    /**
     * Constructor. Default server model.
     */
    public ServerModel() {
        ldevs = new ArrayList<LogicalDevice>();
    }

    /**
     * Gets the logical device list. For thread-safety, only access via this
     * getter
     * 
     * @return
     */
    public synchronized ArrayList<LogicalDevice> getLdevs() {
        return ldevs;
    }

    /**
     * Gets a logical device by its SAP. Returns null, if no matching. For
     * thread-safety, only access via this getter
     * 
     * @return
     */
    public synchronized LogicalDevice getLdev(OctetString sap) {
        for (LogicalDevice ldev : ldevs) {
            if (ldev.getSap().equals(sap))
                return ldev;
        }
        return null;
    }

    /**
     * Gets all electricity objects in the given logical device.
     * 
     * @param sap SAP of the logical device
     * @return
     */
    public synchronized ArrayList<InterfaceClass> getElectricityObjects(OctetString sap) {
        ArrayList<InterfaceClass> eList = new ArrayList<InterfaceClass>();
        ArrayList<InterfaceClass> list = getLdev(sap).getObjectList();
        Iterator<InterfaceClass> it = list.iterator();
        InterfaceClass c;
        while (it.hasNext()) {
            c = it.next();
            if (c.getLogicalName().toString().contains(".")) {
                String s = c.getLogicalName().toString().split("\\.")[0]; // first
                                                                          // "byte"
                if (s.equals("1")) { // electricity
                    eList.add(c);
                }
            }
        }
        return eList;
    }
}
