/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import java.io.DataInputStream;
import java.io.IOException;

import org.openmuc.jsml.structures.Choice;
import org.openmuc.jsml.structures.Unsigned8;

/**
 * Representation of a SML_CosemAttributeConent, as specified in SML v1.04.
 * 
 * @author Daniel Fuchs
 */
public class SML_CosemAttributeContent extends Choice {

    public static final int DATA = 1, DATAACCESSRESULT = 2;

    public SML_CosemAttributeContent(int tag, SML_CosemValue choice) {
        if (!(tag == DATA || tag == DATAACCESSRESULT)) {
            throw new IllegalArgumentException(
                    "SML_CosemAttributeContent: Wrong value for tag! " + tag
                            + " is not allowed.");
        }

        this.tag = new Unsigned8(tag);
        this.choice = choice;
        isSelected = true;
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte tlField = is.readByte();
        if (isOptional && (tlField == 0x01)) {
            isSelected = false;
            return true;
        }
        if ((tlField & 0xff) != 0x72 || !tag.decode(is)) {
            return false;
        }

        switch (tag.getVal()) { // tag.val
        case DATA:
            choice = new SML_CosemValue();
            break;
        case DATAACCESSRESULT:
            choice = new Unsigned8();
            break;
        }

        if (!choice.decode(is)) {
            return false;
        }

        isSelected = true;

        return true;
    }

    public SML_CosemAttributeContent() {
    }

}
