/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.Sequence;

/**
 * Representation of a SML_CosemAttributeDesc, as specified in SML v1.04.
 * 
 * @author Daniel Fuchs
 */
public class SML_CosemAttributeDesc extends Sequence {

    protected Integer16 attributeIndex;
    /**
     * OPTIONAL
     */
    protected SML_CosemSelAccessDesc selectiveAccessDescriptor;

    public Integer16 getAttributeIndex() {
        return attributeIndex;
    }

    public SML_CosemSelAccessDesc getSelectiveAccessDescriptor() {
        return selectiveAccessDescriptor;
    }

    public SML_CosemAttributeDesc(Integer16 attributeIndex,
            SML_CosemSelAccessDesc selectiveAccessDescriptor) {

        if (attributeIndex == null) {
            throw new IllegalArgumentException(
                    "SML_CosemAttributeDesc: attributeIndex is not optional and must not be null!");
        }

        this.attributeIndex = attributeIndex;
        this.selectiveAccessDescriptor = selectiveAccessDescriptor;

        if (this.selectiveAccessDescriptor == null) {
            this.selectiveAccessDescriptor = new SML_CosemSelAccessDesc();
        }
        setOptionalAndSeq();
        isSelected = true;
    }

    public SML_CosemAttributeDesc() {
    }

    public void setOptionalAndSeq() {
        selectiveAccessDescriptor.setOptional();

        seqArray = new ASNObject[] { attributeIndex,
                selectiveAccessDescriptor };
    }

    @Override
    protected void createElements() {
        attributeIndex = new Integer16();
        selectiveAccessDescriptor = new SML_CosemSelAccessDesc();
        setOptionalAndSeq();
    }

    @Override
    public void print() {
        if (!isOptional || isSelected) {
            System.out.println("SML_CosemAttributeDesc: ");
            super.print();
        }
    }

}
