/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.Integer32;
import org.openmuc.jsml.structures.Integer64;
import org.openmuc.jsml.structures.Integer8;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SML_Boolean;
import org.openmuc.jsml.structures.Unsigned16;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.Unsigned64;
import org.openmuc.jsml.structures.Unsigned8;

/**
 * Representation of a SML_CosemValue, as specified in SML v1.04.
 * 
 * @author Daniel Fuchs
 * @author Michael Hoefling
 */
public class SML_CosemValue extends ExtendedImplicitChoice {

    // copy from SML_Value (simplification)
    public static final int BOOLEAN = 1, OCTETSTRING = 2, INTEGER8 = 3,
            INTEGER16 = 4, INTEGER32 = 5;
    public static final int INTEGER64 = 6, UNSIGNED8 = 7, UNSIGNED16 = 8,
            UNSIGNED32 = 9, UNSIGNED64 = 10;
    public static final int SMLCOSEMVALUELIST = 11; // -> what's the point of
                                                    // the values? added by df

    /**
     * 
     * @param choice
     *            possible values: Boolean, OctetString, Integer{8,16,32,64},
     *            Unsigned{8-64}, SML_CosemValueList (array of SML_CosemValue)
     */
    public SML_CosemValue(ASNObject choice) {
        setValue(choice);
    }

    public SML_CosemValue() {
    }

    /**
     * Sets the value
     * 
     * @param choice
     */
    public void setValue(ASNObject choice) {
        if (!(choice instanceof SML_Boolean || choice instanceof OctetString
                || choice instanceof Integer8 || choice instanceof Integer16
                || choice instanceof Integer32 || choice instanceof Integer64
                || choice instanceof Unsigned8 || choice instanceof Unsigned16
                || choice instanceof Unsigned32 || choice instanceof Unsigned64
                || choice instanceof SML_CosemValueList)) {
            throw new IllegalArgumentException(
                    "SML_CosemValue: Wrong ASNObject! "
                            + choice.getClass().getName() + " is not allowed.");
        }

        this.choice = choice;
        isSelected = true;
    }

    public String toString() {
        if (choice instanceof SML_Boolean)
            return ((SML_Boolean) choice).getVal() + "";
        if (choice instanceof OctetString)
            return ((OctetString) choice).toString();

        if (choice instanceof Integer8)
            return ((Integer8) choice).getVal() + "";
        if (choice instanceof Integer16)
            return ((Integer16) choice).getVal() + "";
        if (choice instanceof Integer32)
            return ((Integer32) choice).getVal() + "";
        if (choice instanceof Integer64)
            return ((Integer64) choice).getVal() + "";

        if (choice instanceof Unsigned8)
            return ((Unsigned8) choice).getVal() + "";
        if (choice instanceof Unsigned16)
            return ((Unsigned16) choice).getVal() + "";
        if (choice instanceof Unsigned32)
            return ((Unsigned32) choice).getVal() + "";
        if (choice instanceof Unsigned64)
            return ((Unsigned64) choice).getVal() + "";

        return "";
    }

}
