/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.myjsml;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;

/**
 * Representation of a SML_SetCosemReq, as specified in SML v1.04.
 * 
 * @author Daniel Fuchs
 */
public class SML_SetCosemReq extends Sequence {

    protected OctetString clientId;
    protected OctetString serverId; // OPTIONAL
    protected OctetString username; // OPTIONAL
    protected OctetString password; // OPTIONAL
    protected OctetString objName; // COSEM object name
    protected Integer16 classID; // COSEM class_id
    protected Integer16 classVersion; // COSEM class_version
    protected SML_CosemAttrList attributeList;

    public OctetString getClientId() {
        return clientId;
    }

    public OctetString getServerId() {
        return serverId;
    }

    public OctetString getUsername() {
        return username;
    }

    public OctetString getPassword() {
        return password;
    }

    public OctetString getObjName() {
        return objName;
    }

    public Integer16 getClassID() {
        return classID;
    }

    public Integer16 getClassVersion() {
        return classVersion;
    }

    public SML_CosemAttrList getAttributeList() {
        return attributeList;
    }

    /**
     * Constructor
     * 
     * @param clientId
     * @param serverId
     *            OPTIONAL
     * @param username
     *            OPTIONAL
     * @param password
     *            OPTIONAL
     * @param objName
     * @param classID
     * @param classVersion
     * @param attributeList
     */
    public SML_SetCosemReq(OctetString clientId, OctetString serverId,
            OctetString username, OctetString password, OctetString objName,
            Integer16 classID, Integer16 classVersion,
            SML_CosemAttrList attributeList) {

        if (clientId == null) {
            throw new IllegalArgumentException(
                    "SML_SetCosemtReq: clientId is not optional and must not be null!");
        }
        if (objName == null) {
            throw new IllegalArgumentException(
                    "SML_SetCosemtReq: objName is not optional and must not be null!");
        }
        if (classID == null) {
            throw new IllegalArgumentException(
                    "SML_SetCosemtReq: classID is not optional and must not be null!");
        }
        if (classVersion == null) {
            throw new IllegalArgumentException(
                    "SML_SetCosemtReq: classVersion is not optional and must not be null!");
        }
        if (attributeList == null) {
            throw new IllegalArgumentException(
                    "SML_SetCosemtReq: attributeList is not optional and must not be null!");
        }

        this.clientId = clientId;
        this.serverId = serverId;
        this.username = username;
        this.password = password;
        this.objName = objName;
        this.classID = classID;
        this.classVersion = classVersion;
        this.attributeList = attributeList;

        if (this.serverId == null) {
            this.serverId = new OctetString();
        }
        if (this.username == null) {
            this.username = new OctetString();
        }
        if (this.password == null) {
            this.password = new OctetString();
        }

        setOptionalAndSeq();
        isSelected = true;
    }

    public SML_SetCosemReq() {
    }

    public void setOptionalAndSeq() {
        serverId.setOptional();
        username.setOptional();
        password.setOptional();

        seqArray = new ASNObject[] { clientId, serverId, username, password,
                objName, classID, classVersion, attributeList };
    }

    @Override
    protected void createElements() {

        clientId = new OctetString();
        serverId = new OctetString();
        username = new OctetString();
        password = new OctetString();
        objName = new OctetString();
        classID = new Integer16();
        classVersion = new Integer16();
        attributeList = new SML_CosemAttrList();

        setOptionalAndSeq();
    }

    @Override
    public void print() {
        if (!isOptional || isSelected) {
            System.out.println("SML_SetCosemReq: ");
            super.print();
        }
    }

}
