/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.restserver.resources;

import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import de.ekut.informatik.kn.josef.restserver.model.RestModel;
import de.ekut.informatik.kn.josef.restserver.schema.CosemType;

/**
 * Class that represents a RESTful server resource.
 * 
 * @author Daniel Fuchs
 */
@Path("cosem")
public class CosemResource {

    @Context
    UriInfo uriInfo;

    /**
     * Gets the COSEM resource model.
     * 
     * @return
     */
    @GET
    @Produces(MediaType.APPLICATION_XML)
    public CosemType getCosem() {
        return RestModel.getCosem();
    }

    /**
     * Allowed methods on this resource: GET, OPTIONS, HEAD.
     * 
     * @return
     */
    @OPTIONS
    public Response options() {
        return Response.ok()
                .header("Allow-Control-Allow-Methods", "GET,OPTIONS,HEAD")
                .header("Access-Control-Allow-Origin", "*").build();
    }

}
