/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.smartmetergateway.cosem;

import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SML_Message;
import org.openmuc.jsml.structures.Unsigned8;

import de.ekut.informatik.kn.josef.helper.SMLMessageCreator;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemValue;

/**
 * Class that represents an action request. Internal use only.
 * 
 * @author Daniel Fuchs
 */
public class ActionRequest extends CosemRequest {

    protected short serviceIndex;
    protected SML_CosemValue serviceParameter; // optional

    /**
     * Constructor.
     * 
     * @param objName
     * @param classID
     * @param classVersion
     * @param serviceIndex
     * @param serviceParameter
     */
    public ActionRequest(String objName, short classID, short classVersion,
            short serviceIndex, SML_CosemValue serviceParameter) {
        super(objName, classID, classVersion);
        this.type = TYPE_ACTION;
        this.serviceIndex = serviceIndex;
        this.serviceParameter = serviceParameter;
    }

    public short getServiceIndex() {
        return serviceIndex;
    }

    public SML_CosemValue getServiceParameter() {
        return serviceParameter;
    }

    @Override
    public boolean isComplete() {
        return (this.serviceIndex != 0);
    }

    @Override
    public SML_Message createRequestMessage(OctetString transactionID,
            OctetString clientID, OctetString serverID, OctetString username,
            OctetString password) {
        if (!isComplete())
            return null;

        return SMLMessageCreator.createActionCosemRequestMessage(transactionID,
                clientID, serverID, new OctetString(this.objName),
                new Integer16(this.classID), new Integer16(this.classVersion),
                new Unsigned8(this.serviceIndex), this.serviceParameter,
                username, password);
    }

}
