/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.smartmetergateway.cosem;

import org.openmuc.jsml.structures.Integer16;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.SML_Message;

import de.ekut.informatik.kn.josef.helper.SMLMessageCreator;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemAttrIndexList;
import de.ekut.informatik.kn.josef.myjsml.SML_CosemAttributeDesc;

/**
 * Class that represents a get request. Internal use only.
 * 
 * @author Daniel Fuchs
 */
public class GetRequest extends CosemRequest {

    protected short[] attributeIndexList; // optional

    /**
     * Constructor. Get the whole object.
     * 
     * @param objName
     * @param classID
     * @param classVersion
     */
    public GetRequest(String objName, short classID, short classVersion) {
        super(objName, classID, classVersion);
        this.type = TYPE_GET;
        this.attributeIndexList = new short[0];
    }

    /**
     * Constructor. Get selective attributes.
     * 
     * @param objName
     * @param classID
     * @param classVersion
     * @param attributeList
     */
    public GetRequest(String objName, short classID, short classVersion,
            short[] attributeList) {
        super(objName, classID, classVersion);
        this.type = TYPE_GET;
        this.attributeIndexList = attributeList;
    }

    public short[] getAttributeIndexList() {
        return attributeIndexList;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public SML_Message createRequestMessage(OctetString transactionID,
            OctetString clientID, OctetString serverID, OctetString username,
            OctetString password) {
        int len = this.attributeIndexList.length;
        SML_CosemAttributeDesc[] attrDescList = new SML_CosemAttributeDesc[len];
        for (int i = 0; i < len; i++) { // OPTIONAL
            SML_CosemAttributeDesc attrDesc = new SML_CosemAttributeDesc(
                    new Integer16(this.attributeIndexList[i]), null);
            attrDescList[i] = attrDesc;
        }
        SML_CosemAttrIndexList attrIndexList;
        if (attrDescList.length > 0) {
            attrIndexList = new SML_CosemAttrIndexList(attrDescList);
        } else {
            attrIndexList = null;
        }
        return SMLMessageCreator.createGetCosemRequestMessage(transactionID,
                clientID, serverID, new OctetString(this.objName),
                new Integer16(this.classID), new Integer16(this.classVersion),
                attrIndexList, username, password);
    }

}
