/*
 * jOSEF: A Java-Based Open-Source Smart Meter Gateway Experimentation Framework
 *
 * Copyright (C) 2015 Daniel Fuchs
 * Copyright (C) 2015 Michael Hoefling
 *
 * jOSEF is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * jOSEF is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package de.ekut.informatik.kn.josef.smartmetergateway.ui;

import javax.swing.DefaultListModel;

import de.ekut.informatik.kn.josef.mycosem.InterfaceClass;

/**
 * Class representing the list model for attributes.
 * 
 * @author Daniel Fuchs
 * @author Michael Hoefling
 */
public class AttributeListModel extends DefaultListModel<String> {

    /**
     * Serial.
     */
    private static final long serialVersionUID = 1L;

    /**
     * Updates the list model.
     * 
     * @param ic
     */
    public void updateList(InterfaceClass ic) {
        clear();
        if (ic != null) {
            String[] atts = ic.getAttributesAsString();
            for (int i = 0; i < atts.length; i++) {
                this.addElement((i + 1) + "-" + atts[i]); // start at index 1
            }
        }
    }

}
