// these are the pwm pins; they provide the input to the motor circuits
int motor1 = 5;
int motor2 = 6;
int motor3 = 9;
int motor4 = 10;
int motor5 = 3;
// this is the initialization, the setup function is called once on start-up
void setup() {
 // we specify the data rate in bits per second (baud) that is how fast a single symbol is transmitted
 Serial.begin(9600);
 // we tell the controller to use the PWM pins as output
 pinMode(motor1, OUTPUT);
 pinMode(motor2, OUTPUT);
 pinMode(motor3, OUTPUT);
 pinMode(motor4, OUTPUT);
 pinMode(motor5, OUTPUT);
}
// the loop function runs continuously, we can use it to check whether control commands have been send
void loop() {
 // is there some input available?
 while(Serial.available() > 0) {
  // if so, we try to obtain the control values in terms of integers between 0 and 255,
  // parseInt returns 0 if no valid input is available
  int inInt1 = Serial.parseInt();
  int inInt2 = Serial.parseInt();
  int inInt3 = Serial.parseInt();
  int inInt4 = Serial.parseInt();
  int inInt5 = Serial.parseInt();
  // the line break is our control sequence, if it was send along with some numbers, we apply them here
  if(Serial.read() == '\n') {
   // just to make sure the value is within the range
   inInt1 = constrain(inInt1,0,255);
   inInt2 = constrain(inInt2,0,255);
   inInt3 = constrain(inInt3,0,255);
   inInt4 = constrain(inInt4,0,255);
   inInt5 = constrain(inInt5,0,255);
   // now we send the vibration strength via the PWM pins to the motors
   analogWrite(motor1, inInt1);
   analogWrite(motor2, inInt2);
   analogWrite(motor3, inInt3);
   analogWrite(motor4, inInt4);
   analogWrite(motor5, inInt5);
  }
 }
}
