/*
 * Decompiled with CFR 0.152.
 */
package testgui1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import testgui1.Gpl;
import testgui1.ParseLabels;

public class NewJFrame
extends JFrame {
    private JTextField FlashIntBox;
    private JFileChooser JFileChooser;
    private JTextField LabelBox;
    private JTextField MeasureBox;
    private JTextField OutpathBox;
    private JTextField TimeBetweenBox;
    private JTextField TreatIntBox;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JCheckBox ckTreatment;
    private JTextField flashBox;
    private JButton jButton_doit;
    private JLabel jLabel_destination;
    private JLabel jLabel_flash;
    private JLabel jLabel_flsInt;
    private JLabel jLabel_labels;
    private JLabel jLabel_measure;
    private JLabel jLabel_plateReader;
    private JLabel jLabel_timebtw;
    private JLabel jLabel_trtInt;
    private JOptionPane jOptionPane;
    private JProgressBar jProgressBar;
    private JLabel lblAbout;
    private JRadioButton rbt_AscentFL;
    private JRadioButton rbt_TECAN;
    private JRadioButton rbt_WinSkan;

    public NewJFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.JFileChooser = new JFileChooser();
        this.jOptionPane = new JOptionPane();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jButton_doit = new JButton();
        this.flashBox = new JTextField();
        this.MeasureBox = new JTextField();
        this.jProgressBar = new JProgressBar();
        this.LabelBox = new JTextField();
        this.jLabel_flash = new JLabel();
        this.jLabel_measure = new JLabel();
        this.jLabel_labels = new JLabel();
        this.jLabel_destination = new JLabel();
        this.FlashIntBox = new JTextField();
        this.jLabel_flsInt = new JLabel();
        this.TimeBetweenBox = new JTextField();
        this.jLabel_timebtw = new JLabel();
        this.TreatIntBox = new JTextField();
        this.jLabel_trtInt = new JLabel();
        this.OutpathBox = new JTextField();
        this.ckTreatment = new JCheckBox();
        this.lblAbout = new JLabel();
        this.rbt_AscentFL = new JRadioButton();
        this.rbt_WinSkan = new JRadioButton();
        this.rbt_TECAN = new JRadioButton();
        this.jLabel_plateReader = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Plate Reader Organizer 3.5 (Kezmonk)");
        this.setResizable(false);
        this.jButton_doit.setText("Make JMP");
        this.jButton_doit.setToolTipText("");
        this.jButton_doit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewJFrame.this.jButton_doitActionPerformed(evt);
            }
        });
        this.flashBox.setText("click to enter file or drag and drop");
        this.flashBox.setDragEnabled(true);
        this.flashBox.setDropMode(DropMode.INSERT);
        this.flashBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewJFrame.this.flashBoxMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewJFrame.this.flashBoxMouseEntered(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewJFrame.this.flashBoxMouseReleased(evt);
            }
        });
        this.MeasureBox.setText("click to enter file or drag and drop");
        this.MeasureBox.setDragEnabled(true);
        this.MeasureBox.setDropMode(DropMode.INSERT);
        this.MeasureBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewJFrame.this.MeasureBoxMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewJFrame.this.MeasureBoxMouseEntered(evt);
            }
        });
        this.LabelBox.setText("click to enter file or drag and drop");
        this.LabelBox.setDragEnabled(true);
        this.LabelBox.setDropMode(DropMode.INSERT);
        this.LabelBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewJFrame.this.LabelBoxMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewJFrame.this.LabelBoxMouseEntered(evt);
            }
        });
        this.jLabel_flash.setText("Single File (Flash)");
        this.jLabel_flash.setToolTipText("<html>\nDrag-Drop file with flash values. Flash values are initial measurments <br>\nthat do not follow a treatment of some sort - variable promoter kinetic. <br>\nGUS/NAN/LUC extracts are 'flash' measurments only.  <br>\nJust delete the Flash column when you are done.\n</html>");
        this.jLabel_measure.setText("2nd File (Treatment)");
        this.jLabel_measure.setToolTipText("<html> Drag-Drop file with measurment values, or <br> 2nd file to be appended to the first file. <br> </html>");
        this.jLabel_labels.setText("Labels");
        this.jLabel_labels.setToolTipText("Drag-Drop file with labels");
        this.jLabel_destination.setText("Folder destination");
        this.jLabel_destination.setToolTipText("Drag-drop folder where output file should go");
        this.FlashIntBox.setHorizontalAlignment(0);
        this.FlashIntBox.setText("5");
        this.jLabel_flsInt.setText("1st Interval");
        this.jLabel_flsInt.setToolTipText("Enter time between measruments in the first file");
        this.TimeBetweenBox.setHorizontalAlignment(0);
        this.TimeBetweenBox.setText("0");
        this.jLabel_timebtw.setText("Time between");
        this.jLabel_timebtw.setToolTipText("<html>\nEnter time between 1st measurments ended and 2nd began.<br>\nIgnored  if no treatment file is present.\n</html>");
        this.TreatIntBox.setHorizontalAlignment(0);
        this.TreatIntBox.setText("5");
        this.jLabel_trtInt.setText("2nd. Interval");
        this.jLabel_trtInt.setToolTipText("Enter time between measurments in the second file");
        this.OutpathBox.setText("click to enter file or drag and drop");
        this.OutpathBox.setToolTipText("");
        this.OutpathBox.setDragEnabled(true);
        this.OutpathBox.setDropMode(DropMode.INSERT);
        this.OutpathBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewJFrame.this.OutpathBoxMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewJFrame.this.OutpathBoxMouseEntered(evt);
            }
        });
        this.ckTreatment.setSelected(true);
        this.ckTreatment.setText("Treatment");
        this.ckTreatment.setToolTipText("<html>\nIf you only have a single kinetic file, then you <br>\nonly need to enter that in the \"Flash\" field.  <br>\nThe \"Treatment\" is for a second, continuing kinetic  <br>\nmeasurment, for example after a hormone treatment. <br>\n</html>");
        this.lblAbout.setForeground(new Color(102, 102, 102));
        this.lblAbout.setText("About");
        this.lblAbout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewJFrame.this.lblAboutMouseClicked(evt);
            }
        });
        this.buttonGroup1.add(this.rbt_AscentFL);
        this.rbt_AscentFL.setSelected(true);
        this.rbt_AscentFL.setText("FluroskanAscentFL");
        this.rbt_AscentFL.setToolTipText("This accepts the raw format output from Ascent Fluoroskan FL");
        this.rbt_AscentFL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewJFrame.this.rbt_AscentFLActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbt_WinSkan);
        this.rbt_WinSkan.setText("WinSkan");
        this.rbt_WinSkan.setToolTipText("This accepts the raw output from the WinMikro plate reader");
        this.rbt_WinSkan.setMaximumSize(new Dimension(70, 23));
        this.buttonGroup1.add(this.rbt_TECAN);
        this.rbt_TECAN.setText("TECAN Saffaire");
        this.rbt_TECAN.setToolTipText("This accepts the raw output from the TECAN Saffaire plate reader");
        this.rbt_TECAN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewJFrame.this.rbt_TECANActionPerformed(evt);
            }
        });
        this.jLabel_plateReader.setText("Plate Reader");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_labels).addComponent(this.jLabel_destination).addComponent(this.jLabel_measure).addComponent(this.jLabel_flash)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MeasureBox, GroupLayout.Alignment.TRAILING, -2, 229, -2).addComponent(this.flashBox, GroupLayout.Alignment.TRAILING, -2, 229, -2).addComponent(this.LabelBox, GroupLayout.Alignment.TRAILING, -2, 229, -2).addComponent(this.OutpathBox, GroupLayout.Alignment.TRAILING, -2, 216, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblAbout).addGap(9, 9, 9)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_timebtw).addComponent(this.jLabel_trtInt).addComponent(this.jLabel_flsInt)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.TimeBetweenBox, -2, 28, -2).addComponent(this.FlashIntBox, -2, 28, -2).addComponent(this.TreatIntBox, -2, 28, -2)).addGap(18, 18, 18).addComponent(this.ckTreatment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbt_TECAN).addComponent(this.rbt_AscentFL).addComponent(this.rbt_WinSkan, -2, -1, -2).addComponent(this.jLabel_plateReader))).addGroup(layout.createSequentialGroup().addComponent(this.jProgressBar, -1, -1, Short.MAX_VALUE).addGap(26, 26, 26).addComponent(this.jButton_doit))).addGap(25, 25, 25)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.flashBox, -2, -1, -2).addComponent(this.jLabel_flash))).addComponent(this.lblAbout)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MeasureBox, -2, -1, -2).addComponent(this.jLabel_measure)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LabelBox, -2, -1, -2).addComponent(this.jLabel_labels)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.OutpathBox, -2, -1, -2).addComponent(this.jLabel_destination)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.FlashIntBox, -2, -1, -2).addComponent(this.jLabel_flsInt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.TreatIntBox, -2, -1, -2).addComponent(this.jLabel_trtInt)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel_timebtw).addComponent(this.TimeBetweenBox, -2, -1, -2).addComponent(this.ckTreatment)).addGap(9, 9, 9)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.jLabel_plateReader).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbt_AscentFL).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbt_WinSkan, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbt_TECAN).addGap(18, 18, 18))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton_doit).addComponent(this.jProgressBar, -2, -1, -2)).addContainerGap()));
        this.jLabel_flash.getAccessibleContext().setAccessibleDescription("Drag-Drop file with flash values. Flash values are initial measurments that do not follow a treatment of some sort - variable promoter kinetic. GUS/NAN/LUC extracts are 'flash' measurments only. \nJust delete the Flash column when you are done.\n");
        this.jLabel_measure.getAccessibleContext().setAccessibleDescription("Drag-Drop file with measurment values, second file appened to first.");
        this.rbt_AscentFL.getAccessibleContext().setAccessibleDescription("");
        this.pack();
    }

    private boolean checkFile(String _string) throws SecurityException {
        File file = null;
        file = new File(_string);
        try {
            return file.isFile();
        }
        catch (SecurityException x) {
            JOptionPane.showMessageDialog(this.jOptionPane, "Error reading file: " + _string + "\n" + x.toString());
            return false;
        }
    }

    private boolean checkDirectory(String _string) throws SecurityException {
        File file = null;
        file = new File(_string);
        try {
            return file.isDirectory();
        }
        catch (SecurityException x) {
            JOptionPane.showMessageDialog(this.jOptionPane, "Output Directory wrong?: " + x.toString());
            return false;
        }
    }

    private void jButton_doitActionPerformed(ActionEvent evt) {
        if (this.rbt_AscentFL.isSelected()) {
            Task_AscentFL task = new Task_AscentFL();
            task.execute();
        } else if (this.rbt_WinSkan.isSelected()) {
            Task_WinMikro task = new Task_WinMikro();
            task.execute();
        } else if (this.rbt_TECAN.isSelected()) {
            Task_TecanSaffaire task = new Task_TecanSaffaire();
            task.execute();
        }
        System.gc();
    }

    private void flashBoxMouseClicked(MouseEvent evt) {
        int returnVal = this.JFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.JFileChooser.getSelectedFile();
            this.flashBox.setText(file.getAbsolutePath());
        }
    }

    private void MeasureBoxMouseClicked(MouseEvent evt) {
        int returnVal = this.JFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.JFileChooser.getSelectedFile();
            this.MeasureBox.setText(file.getAbsolutePath());
        }
    }

    private void LabelBoxMouseClicked(MouseEvent evt) {
        int returnVal = this.JFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.JFileChooser.getSelectedFile();
            this.LabelBox.setText(file.getAbsolutePath());
        }
    }

    private void OutpathBoxMouseClicked(MouseEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            this.OutpathBox.setText(file.getAbsolutePath());
        }
    }

    private void flashBoxMouseReleased(MouseEvent evt) {
    }

    private void flashBoxMouseEntered(MouseEvent evt) {
        this.flashBox.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = droppedFiles.iterator();
                    if (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        NewJFrame.this.flashBox.setText(file.toString());
                    }
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error writing output file:" + x.toString());
                }
            }
        });
    }

    private void MeasureBoxMouseEntered(MouseEvent evt) {
        this.MeasureBox.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = droppedFiles.iterator();
                    if (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        NewJFrame.this.MeasureBox.setText(file.toString());
                    }
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error writing output file:" + x.toString());
                }
            }
        });
    }

    private void LabelBoxMouseEntered(MouseEvent evt) {
        this.LabelBox.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = droppedFiles.iterator();
                    if (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        NewJFrame.this.LabelBox.setText(file.toString());
                    }
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error writing output file:" + x.toString());
                }
            }
        });
    }

    private void OutpathBoxMouseEntered(MouseEvent evt) {
        this.OutpathBox.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = droppedFiles.iterator();
                    if (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        NewJFrame.this.OutpathBox.setText(file.toString());
                    }
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error writing output file:" + x.toString());
                }
            }
        });
    }

    private void lblAboutMouseClicked(MouseEvent evt) {
        Gpl license = new Gpl();
        JTextArea textArea = new JTextArea(license.Text);
        JScrollPane scrollPane = new JScrollPane(textArea);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        scrollPane.setPreferredSize(new Dimension(500, 500));
        JOptionPane.showMessageDialog(null, scrollPane);
    }

    private void rbt_AscentFLActionPerformed(ActionEvent evt) {
    }

    private void rbt_TECANActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(NewJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(NewJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NewJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(NewJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new NewJFrame().setVisible(true);
            }
        });
    }

    class Task_TecanSaffaire
    extends SwingWorker<Void, Void> {
        Task_TecanSaffaire() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void MakeJMPfileTask() {
            if (!NewJFrame.this.checkFile(NewJFrame.this.flashBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Flash file not entered");
                return;
            }
            if (!NewJFrame.this.checkFile(NewJFrame.this.LabelBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Label file not entered");
                return;
            }
            if (!NewJFrame.this.checkDirectory(NewJFrame.this.OutpathBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Output directory is bullshit");
                return;
            }
            if (NewJFrame.this.ckTreatment.isSelected() && !NewJFrame.this.checkFile(NewJFrame.this.MeasureBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Measurement file not entered");
                return;
            }
            int FlashInt = 5;
            int TreatInt = 5;
            int TimeBetween = 5;
            int LastTimeCount = 60;
            try {
                FlashInt = Integer.parseInt(NewJFrame.this.FlashIntBox.getText());
            }
            catch (NumberFormatException x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Flash Interval is not a number");
                return;
            }
            if (NewJFrame.this.ckTreatment.isSelected()) {
                try {
                    TreatInt = Integer.parseInt(NewJFrame.this.TreatIntBox.getText());
                }
                catch (NumberFormatException x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Treatment Interval is not a number");
                    return;
                }
                try {
                    TimeBetween = Integer.parseInt(NewJFrame.this.TimeBetweenBox.getText());
                }
                catch (NumberFormatException x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Time Between Interval is not a number");
                    return;
                }
            }
            HashMap<Object, Object> prop_hash = new HashMap();
            ArrayList<Object> SubProperties = new ArrayList();
            ParseLabels pL = new ParseLabels(NewJFrame.this.LabelBox.getText());
            try {
                pL.makeHashs();
                prop_hash = pL.hash_labels;
                SubProperties = pL.properties;
            }
            catch (IOException x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error reading labels: " + x.toString());
                return;
            }
            try {
                String tx;
                int y;
                int i;
                Matcher m;
                String[] mblock;
                ArrayList<List<String>> mes_blocks;
                Pattern pattern;
                Path path = Paths.get(NewJFrame.this.flashBox.getText(), new String[0]).getFileName();
                String name = path.getFileName().toString();
                int pos = name.lastIndexOf(".");
                if (pos > 0) {
                    name = name.substring(0, pos);
                }
                FileWriter writer = null;
                boolean _fileNameOK = false;
                int _fileCtr = 0;
                String _filename = "";
                while (!_fileNameOK) {
                    _filename = NewJFrame.this.OutpathBox.getText() + File.separator + name + "_JMPinput" + _fileCtr + ".txt";
                    if (!NewJFrame.this.checkFile(_filename)) {
                        _fileNameOK = true;
                        continue;
                    }
                    ++_fileCtr;
                }
                writer = new FileWriter(_filename);
                writer.write("Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t");
                Set<Object> _keys = prop_hash.keySet();
                Iterator<Object> iterator = _keys.iterator();
                if (iterator.hasNext()) {
                    String _key = (String)iterator.next();
                    Set _subkeys = ((HashMap)prop_hash.get(_key)).keySet();
                    for (Object _skey : _subkeys) {
                        writer.write((String)_skey + "\t");
                    }
                }
                writer.write("\n");
                writer.flush();
                int TimeCount = 0;
                Scanner s = null;
                path = Paths.get(NewJFrame.this.flashBox.getText(), new String[0]);
                ArrayList<String> MeasureBreak = new ArrayList<String>();
                try {
                    s = new Scanner(path);
                    pattern = Pattern.compile("Cycle ");
                    s.useDelimiter(pattern);
                    while (s.hasNext()) {
                        MeasureBreak.add(s.next().toString());
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
                pattern = Pattern.compile("Number:[^0-9]([0-9]+)[^0-9]");
                try {
                    for (String _s : MeasureBreak) {
                        mes_blocks = new ArrayList<List<String>>();
                        mblock = _s.split("\n");
                        m = pattern.matcher(mblock[0]);
                        if (m.find()) {
                            TimeCount = Integer.parseInt(m.group(1));
                        }
                        mes_blocks.clear();
                        for (i = 2; i < mblock.length; ++i) {
                            List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));
                            if (_list.size() <= 0) continue;
                            mes_blocks.add(_list);
                        }
                        for (y = 1; y < mes_blocks.size(); ++y) {
                            for (int x = 1; x < ((List)mes_blocks.get(0)).size(); ++x) {
                                tx = (String)((List)mes_blocks.get(y)).get(0) + (String)((List)mes_blocks.get(0)).get(x);
                                if (!prop_hash.containsKey(tx)) continue;
                                writer.write(Integer.toString(TimeCount * FlashInt));
                                writer.write("\t" + tx + "\t" + (String)((List)mes_blocks.get(y)).get(0) + "\t" + (String)((List)mes_blocks.get(0)).get(x));
                                writer.write("\t" + (String)((List)mes_blocks.get(y)).get(x));
                                writer.write("\ty\t");
                                for (String string : SubProperties) {
                                    writer.write((String)((HashMap)prop_hash.get(tx)).get(string) + "\t");
                                }
                                writer.write("\n");
                                writer.flush();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    writer.close();
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Unknown error: " + e.toString());
                }
                if (NewJFrame.this.ckTreatment.isSelected()) {
                    LastTimeCount = TimeCount * FlashInt;
                    s = null;
                    path = Paths.get(NewJFrame.this.MeasureBox.getText(), new String[0]);
                    MeasureBreak.clear();
                    try {
                        s = new Scanner(path);
                        pattern = Pattern.compile("Cycle ");
                        s.useDelimiter(pattern);
                        while (s.hasNext()) {
                            MeasureBreak.add(s.next().toString());
                        }
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                    pattern = Pattern.compile("Number:[^0-9]([0-9]+)[^0-9]");
                    try {
                        for (String _s : MeasureBreak) {
                            mes_blocks = new ArrayList();
                            mblock = _s.split("\n");
                            m = pattern.matcher(mblock[0]);
                            if (m.find()) {
                                TimeCount = Integer.parseInt(m.group(1));
                            }
                            mes_blocks.clear();
                            for (i = 2; i < mblock.length; ++i) {
                                List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));
                                if (_list.size() <= 0) continue;
                                mes_blocks.add(_list);
                            }
                            for (y = 1; y < mes_blocks.size(); ++y) {
                                for (int x = 1; x < ((List)mes_blocks.get(0)).size(); ++x) {
                                    tx = (String)((List)mes_blocks.get(y)).get(0) + (String)((List)mes_blocks.get(0)).get(x);
                                    if (!prop_hash.containsKey(tx)) continue;
                                    writer.write(Integer.toString(TimeCount * TreatInt + LastTimeCount + TimeBetween));
                                    writer.write("\t" + tx + "\t" + (String)((List)mes_blocks.get(y)).get(0) + "\t" + (String)((List)mes_blocks.get(0)).get(x));
                                    writer.write("\t" + (String)((List)mes_blocks.get(y)).get(x));
                                    writer.write("\tn\t");
                                    for (String string : SubProperties) {
                                        writer.write((String)((HashMap)prop_hash.get(tx)).get(string) + "\t");
                                    }
                                    writer.write("\n");
                                    writer.flush();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        writer.close();
                        JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Unknown error: " + e.toString());
                    }
                }
                writer.close();
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Done: " + _filename);
            }
            catch (Exception x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error :" + x.toString());
            }
        }

        @Override
        public Void doInBackground() {
            NewJFrame.this.jButton_doit.setEnabled(false);
            NewJFrame.this.jProgressBar.setIndeterminate(true);
            this.MakeJMPfileTask();
            NewJFrame.this.jProgressBar.setIndeterminate(false);
            NewJFrame.this.jButton_doit.setEnabled(true);
            return null;
        }
    }

    class Task_AscentFL
    extends SwingWorker<Void, Void> {
        Task_AscentFL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void MakeJMPfileTask() {
            if (!NewJFrame.this.checkFile(NewJFrame.this.flashBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Flash file not entered");
                return;
            }
            if (!NewJFrame.this.checkFile(NewJFrame.this.LabelBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Label file not entered");
                return;
            }
            if (!NewJFrame.this.checkDirectory(NewJFrame.this.OutpathBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Output directory is bullshit");
                return;
            }
            if (NewJFrame.this.ckTreatment.isSelected() && !NewJFrame.this.checkFile(NewJFrame.this.MeasureBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Measurement file not entered");
                return;
            }
            int FlashInt = 5;
            int TreatInt = 5;
            int TimeBetween = 5;
            int LastTimeCount = 60;
            try {
                FlashInt = Integer.parseInt(NewJFrame.this.FlashIntBox.getText());
            }
            catch (NumberFormatException x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Flash Interval is not a number");
                return;
            }
            if (NewJFrame.this.ckTreatment.isSelected()) {
                try {
                    TreatInt = Integer.parseInt(NewJFrame.this.TreatIntBox.getText());
                }
                catch (NumberFormatException x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Treatment Interval is not a number");
                    return;
                }
                try {
                    TimeBetween = Integer.parseInt(NewJFrame.this.TimeBetweenBox.getText());
                }
                catch (NumberFormatException x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Time Between Interval is not a number");
                    return;
                }
            }
            HashMap<Object, Object> prop_hash = new HashMap();
            ArrayList<Object> SubProperties = new ArrayList();
            ParseLabels pL = new ParseLabels(NewJFrame.this.LabelBox.getText());
            try {
                pL.makeHashs();
                prop_hash = pL.hash_labels;
                SubProperties = pL.properties;
            }
            catch (IOException x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error reading labels: " + x.toString());
                return;
            }
            try {
                String tx;
                int y;
                int i;
                Matcher m;
                String[] mblock;
                ArrayList<List<String>> mes_blocks;
                Pattern pattern;
                Path path = Paths.get(NewJFrame.this.flashBox.getText(), new String[0]).getFileName();
                String name = path.getFileName().toString();
                int pos = name.lastIndexOf(".");
                if (pos > 0) {
                    name = name.substring(0, pos);
                }
                FileWriter writer = null;
                boolean _fileNameOK = false;
                int _fileCtr = 0;
                String _filename = "";
                while (!_fileNameOK) {
                    _filename = NewJFrame.this.OutpathBox.getText() + File.separator + name + "_JMPinput" + _fileCtr + ".txt";
                    if (!NewJFrame.this.checkFile(_filename)) {
                        _fileNameOK = true;
                        continue;
                    }
                    ++_fileCtr;
                }
                writer = new FileWriter(_filename);
                writer.write("Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t");
                Set<Object> _keys = prop_hash.keySet();
                Iterator<Object> iterator = _keys.iterator();
                if (iterator.hasNext()) {
                    String _key = (String)iterator.next();
                    Set _subkeys = ((HashMap)prop_hash.get(_key)).keySet();
                    for (Object _skey : _subkeys) {
                        writer.write((String)_skey + "\t");
                    }
                }
                writer.write("\n");
                writer.flush();
                int TimeCount = 0;
                Scanner s = null;
                path = Paths.get(NewJFrame.this.flashBox.getText(), new String[0]);
                ArrayList<String> MeasureBreak = new ArrayList<String>();
                try {
                    s = new Scanner(path);
                    pattern = Pattern.compile("Measurement");
                    s.useDelimiter(pattern);
                    while (s.hasNext()) {
                        MeasureBreak.add(s.next().toString());
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
                pattern = Pattern.compile("count:[^0-9]([0-9]+)[^0-9]");
                try {
                    for (String _s : MeasureBreak) {
                        mes_blocks = new ArrayList<List<String>>();
                        mblock = _s.split("\n");
                        m = pattern.matcher(mblock[0]);
                        if (m.find()) {
                            TimeCount = Integer.parseInt(m.group(1));
                        }
                        mes_blocks.clear();
                        for (i = 1; i < mblock.length; ++i) {
                            List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));
                            mes_blocks.add(_list);
                        }
                        for (y = 1; y < mes_blocks.size(); ++y) {
                            for (int x = 1; x < ((List)mes_blocks.get(0)).size(); ++x) {
                                tx = (String)((List)mes_blocks.get(y)).get(0) + (String)((List)mes_blocks.get(0)).get(x);
                                if (!prop_hash.containsKey(tx)) continue;
                                writer.write(Integer.toString(TimeCount * FlashInt));
                                writer.write("\t" + tx + "\t" + (String)((List)mes_blocks.get(y)).get(0) + "\t" + (String)((List)mes_blocks.get(0)).get(x));
                                writer.write("\t" + (String)((List)mes_blocks.get(y)).get(x));
                                writer.write("\ty\t");
                                for (String string : SubProperties) {
                                    writer.write((String)((HashMap)prop_hash.get(tx)).get(string) + "\t");
                                }
                                writer.write("\n");
                                writer.flush();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    writer.close();
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Unknown error: " + e.toString());
                }
                if (NewJFrame.this.ckTreatment.isSelected()) {
                    LastTimeCount = TimeCount * FlashInt;
                    s = null;
                    path = Paths.get(NewJFrame.this.MeasureBox.getText(), new String[0]);
                    MeasureBreak.clear();
                    try {
                        s = new Scanner(path);
                        pattern = Pattern.compile("Measurement");
                        s.useDelimiter(pattern);
                        while (s.hasNext()) {
                            MeasureBreak.add(s.next().toString());
                        }
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                    pattern = Pattern.compile("count:[^0-9]([0-9]+)[^0-9]");
                    try {
                        for (String _s : MeasureBreak) {
                            mes_blocks = new ArrayList();
                            mblock = _s.split("\n");
                            m = pattern.matcher(mblock[0]);
                            if (m.find()) {
                                TimeCount = Integer.parseInt(m.group(1));
                            }
                            mes_blocks.clear();
                            for (i = 1; i < mblock.length; ++i) {
                                List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));
                                mes_blocks.add(_list);
                            }
                            for (y = 1; y < mes_blocks.size(); ++y) {
                                for (int x = 1; x < ((List)mes_blocks.get(0)).size(); ++x) {
                                    tx = (String)((List)mes_blocks.get(y)).get(0) + (String)((List)mes_blocks.get(0)).get(x);
                                    if (!prop_hash.containsKey(tx)) continue;
                                    writer.write(Integer.toString(TimeCount * TreatInt + LastTimeCount + TimeBetween));
                                    writer.write("\t" + tx + "\t" + (String)((List)mes_blocks.get(y)).get(0) + "\t" + (String)((List)mes_blocks.get(0)).get(x));
                                    writer.write("\t" + (String)((List)mes_blocks.get(y)).get(x));
                                    writer.write("\tn\t");
                                    for (String string : SubProperties) {
                                        writer.write((String)((HashMap)prop_hash.get(tx)).get(string) + "\t");
                                    }
                                    writer.write("\n");
                                    writer.flush();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        writer.close();
                        JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Unknown error: " + e.toString());
                    }
                }
                writer.close();
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Done: " + _filename);
            }
            catch (Exception x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error :" + x.toString());
            }
        }

        @Override
        public Void doInBackground() {
            NewJFrame.this.jButton_doit.setEnabled(false);
            NewJFrame.this.jProgressBar.setIndeterminate(true);
            this.MakeJMPfileTask();
            NewJFrame.this.jProgressBar.setIndeterminate(false);
            NewJFrame.this.jButton_doit.setEnabled(true);
            return null;
        }
    }

    class Task_WinMikro
    extends SwingWorker<Void, Void> {
        Task_WinMikro() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void MakeJMPfileTask() {
            if (!NewJFrame.this.checkFile(NewJFrame.this.flashBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Flash file not entered");
                return;
            }
            if (!NewJFrame.this.checkFile(NewJFrame.this.LabelBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Label file not entered");
                return;
            }
            if (!NewJFrame.this.checkDirectory(NewJFrame.this.OutpathBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Output directory is bullshit");
                return;
            }
            if (NewJFrame.this.ckTreatment.isSelected() && !NewJFrame.this.checkFile(NewJFrame.this.MeasureBox.getText())) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Measurement file not entered");
                return;
            }
            int FlashInt = 5;
            int TreatInt = 5;
            int TimeBetween = 5;
            int LastTimeCount = 60;
            try {
                FlashInt = Integer.parseInt(NewJFrame.this.FlashIntBox.getText());
            }
            catch (NumberFormatException x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Flash Interval is not a number");
                return;
            }
            if (NewJFrame.this.ckTreatment.isSelected()) {
                try {
                    TreatInt = Integer.parseInt(NewJFrame.this.TreatIntBox.getText());
                }
                catch (NumberFormatException x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Treatment Interval is not a number");
                    return;
                }
                try {
                    TimeBetween = Integer.parseInt(NewJFrame.this.TimeBetweenBox.getText());
                }
                catch (NumberFormatException x) {
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Time Between Interval is not a number");
                    return;
                }
            }
            HashMap<Object, Object> prop_hash = new HashMap();
            ArrayList<Object> SubProperties = new ArrayList();
            ParseLabels pL = new ParseLabels(NewJFrame.this.LabelBox.getText());
            try {
                pL.makeHashs();
                prop_hash = pL.hash_labels;
                SubProperties = pL.properties;
            }
            catch (IOException x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error reading labels: " + x.toString());
                return;
            }
            try {
                int y;
                Matcher m0;
                String[] mblock;
                String _col;
                String _row;
                String tx;
                Pattern pattern;
                Path path = Paths.get(NewJFrame.this.flashBox.getText(), new String[0]).getFileName();
                String name = path.getFileName().toString();
                int pos = name.lastIndexOf(".");
                if (pos > 0) {
                    name = name.substring(0, pos);
                }
                FileWriter writer = null;
                boolean _fileNameOK = false;
                int _fileCtr = 0;
                String _filename = "";
                while (!_fileNameOK) {
                    _filename = NewJFrame.this.OutpathBox.getText() + File.separator + name + "_JMPinput" + _fileCtr + ".txt";
                    if (!NewJFrame.this.checkFile(_filename)) {
                        _fileNameOK = true;
                        continue;
                    }
                    ++_fileCtr;
                }
                writer = new FileWriter(_filename);
                writer.write("Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t");
                Set<Object> _keys = prop_hash.keySet();
                Iterator<Object> iterator = _keys.iterator();
                if (iterator.hasNext()) {
                    String _key = (String)iterator.next();
                    Set _subkeys = ((HashMap)prop_hash.get(_key)).keySet();
                    for (Object _skey : _subkeys) {
                        writer.write((String)_skey + "\t");
                    }
                }
                writer.write("\n");
                writer.flush();
                int TimeCount = 0;
                Scanner s = null;
                path = Paths.get(NewJFrame.this.flashBox.getText(), new String[0]);
                ArrayList<String> MeasureBreak = new ArrayList<String>();
                try {
                    s = new Scanner(path);
                    pattern = Pattern.compile("\n");
                    s.useDelimiter(pattern);
                    while (s.hasNext()) {
                        MeasureBreak.add(s.next().toString().replaceAll("(\\r|\\n)", ""));
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
                pattern = Pattern.compile("(\\D)(\\d+)");
                try {
                    for (String _s : MeasureBreak) {
                        TimeCount = 0;
                        tx = "";
                        _row = "";
                        _col = "";
                        mblock = _s.split("\t");
                        m0 = pattern.matcher(mblock[0]);
                        while (m0.find()) {
                            _row = m0.group(1);
                            _col = m0.group(2);
                            _col = _col.replaceFirst("^0+(?!$)", "");
                        }
                        tx = _row + _col;
                        for (y = 1; y < mblock.length; ++y) {
                            writer.write(Integer.toString(++TimeCount * FlashInt));
                            writer.write("\t" + tx + "\t" + _row + "\t" + _col);
                            writer.write("\t" + mblock[y]);
                            writer.write("\ty\t");
                            for (String string : SubProperties) {
                                writer.write((String)((HashMap)prop_hash.get(tx)).get(string) + "\t");
                            }
                            writer.write("\n");
                            writer.flush();
                        }
                    }
                }
                catch (Exception e) {
                    writer.close();
                    JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Unknown error: " + e.toString());
                }
                if (NewJFrame.this.ckTreatment.isSelected()) {
                    LastTimeCount = TimeCount * FlashInt;
                    s = null;
                    path = Paths.get(NewJFrame.this.MeasureBox.getText(), new String[0]);
                    MeasureBreak.clear();
                    try {
                        s = new Scanner(path);
                        pattern = Pattern.compile("\n");
                        s.useDelimiter(pattern);
                        while (s.hasNext()) {
                            MeasureBreak.add(s.next().toString().replaceAll("(\\r|\\n)", ""));
                        }
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                    pattern = Pattern.compile("(\\D)(\\d+)");
                    try {
                        for (String _s : MeasureBreak) {
                            TimeCount = 0;
                            tx = "";
                            _row = "";
                            _col = "";
                            mblock = _s.split("\t");
                            m0 = pattern.matcher(mblock[0]);
                            while (m0.find()) {
                                _row = m0.group(1);
                                _col = m0.group(2);
                                _col = _col.replaceFirst("^0+(?!$)", "");
                            }
                            tx = _row + _col;
                            for (y = 1; y < mblock.length; ++y) {
                                writer.write(Integer.toString(++TimeCount * TreatInt + LastTimeCount + TimeBetween));
                                writer.write("\t" + tx + "\t" + _row + "\t" + _col);
                                writer.write("\t" + mblock[y]);
                                writer.write("\tn\t");
                                for (String string : SubProperties) {
                                    writer.write((String)((HashMap)prop_hash.get(tx)).get(string) + "\t");
                                }
                                writer.write("\n");
                                writer.flush();
                            }
                        }
                    }
                    catch (Exception e) {
                        writer.close();
                        JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Unknown error: " + e.toString());
                    }
                }
                writer.close();
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Done: " + _filename);
            }
            catch (Exception x) {
                JOptionPane.showMessageDialog(NewJFrame.this.jOptionPane, "Error :" + x.toString());
            }
        }

        @Override
        public Void doInBackground() {
            NewJFrame.this.jButton_doit.setEnabled(false);
            NewJFrame.this.jProgressBar.setIndeterminate(true);
            this.MakeJMPfileTask();
            NewJFrame.this.jProgressBar.setIndeterminate(false);
            NewJFrame.this.jButton_doit.setEnabled(true);
            return null;
        }
    }
}

