/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package testgui1;

//* IMPORTS
import java.util.*;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.*;
import java.awt.Dimension;
//import javax.swing.DropMode;
import javax.swing.JOptionPane;
import java.io.IOException;
//import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.FileReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
//import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.io.File;
import java.util.List;
import java.lang.Object;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import java.awt.datatransfer.*;
/**
 *
 * @author kezmonk
 * Copyright 2013-2018 Kenenth W Berendzen (Kezmonk)
 * 
 * This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    * 
    * Purpose of Program
    * This program is designed to take raw data output from plate readers like the Fluorskan Ascent FL
    * and and prepare it for input into JMP (SAS). The program requires two
    * input files: "FLASH" is a measurement file and "LABELS" which is a prepared text
    * file for adding properties to each well. Please consult me or read the documentation
    * to know how to prepare input. You made an one additional measurement file after
    * the additional file if a second consecutive measurement is made.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
public class NewJFrame extends javax.swing.JFrame {

    /**
     * Creates new form NewJFrame
     */
    public NewJFrame() {
        initComponents();        
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        JFileChooser = new javax.swing.JFileChooser();
        jOptionPane = new javax.swing.JOptionPane();
        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        buttonGroup3 = new javax.swing.ButtonGroup();
        jButton_doit = new javax.swing.JButton();
        flashBox = new javax.swing.JTextField();
        MeasureBox = new javax.swing.JTextField();
        jProgressBar = new javax.swing.JProgressBar();
        LabelBox = new javax.swing.JTextField();
        jLabel_flash = new javax.swing.JLabel();
        jLabel_measure = new javax.swing.JLabel();
        jLabel_labels = new javax.swing.JLabel();
        jLabel_destination = new javax.swing.JLabel();
        FlashIntBox = new javax.swing.JTextField();
        jLabel_flsInt = new javax.swing.JLabel();
        TimeBetweenBox = new javax.swing.JTextField();
        jLabel_timebtw = new javax.swing.JLabel();
        TreatIntBox = new javax.swing.JTextField();
        jLabel_trtInt = new javax.swing.JLabel();
        OutpathBox = new javax.swing.JTextField();
        ckTreatment = new javax.swing.JCheckBox();
        lblAbout = new javax.swing.JLabel();
        rbt_AscentFL = new javax.swing.JRadioButton();
        rbt_WinSkan = new javax.swing.JRadioButton();
        rbt_TECAN = new javax.swing.JRadioButton();
        jLabel_plateReader = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Plate Reader Organizer 3.5 (Kezmonk)");
        setResizable(false);

        jButton_doit.setText("Make JMP");
        jButton_doit.setToolTipText("");
        jButton_doit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_doitActionPerformed(evt);
            }
        });

        flashBox.setText("click to enter file or drag and drop");
        flashBox.setDragEnabled(true);
        flashBox.setDropMode(javax.swing.DropMode.INSERT);
        flashBox.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                flashBoxMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                flashBoxMouseEntered(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                flashBoxMouseReleased(evt);
            }
        });

        MeasureBox.setText("click to enter file or drag and drop");
        MeasureBox.setDragEnabled(true);
        MeasureBox.setDropMode(javax.swing.DropMode.INSERT);
        MeasureBox.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                MeasureBoxMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                MeasureBoxMouseEntered(evt);
            }
        });

        LabelBox.setText("click to enter file or drag and drop");
        LabelBox.setDragEnabled(true);
        LabelBox.setDropMode(javax.swing.DropMode.INSERT);
        LabelBox.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                LabelBoxMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                LabelBoxMouseEntered(evt);
            }
        });

        jLabel_flash.setText("Single File (Flash)");
        jLabel_flash.setToolTipText("<html>\nDrag-Drop file with flash values. Flash values are initial measurments <br>\nthat do not follow a treatment of some sort - variable promoter kinetic. <br>\nGUS/NAN/LUC extracts are 'flash' measurments only.  <br>\nJust delete the Flash column when you are done.\n</html>");

        jLabel_measure.setText("2nd File (Treatment)");
        jLabel_measure.setToolTipText("<html> Drag-Drop file with measurment values, or <br> 2nd file to be appended to the first file. <br> </html>");

        jLabel_labels.setText("Labels");
        jLabel_labels.setToolTipText("Drag-Drop file with labels");

        jLabel_destination.setText("Folder destination");
        jLabel_destination.setToolTipText("Drag-drop folder where output file should go");

        FlashIntBox.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        FlashIntBox.setText("5");

        jLabel_flsInt.setText("1st Interval");
        jLabel_flsInt.setToolTipText("Enter time between measruments in the first file");

        TimeBetweenBox.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        TimeBetweenBox.setText("0");

        jLabel_timebtw.setText("Time between");
        jLabel_timebtw.setToolTipText("<html>\nEnter time between 1st measurments ended and 2nd began.<br>\nIgnored  if no treatment file is present.\n</html>");

        TreatIntBox.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        TreatIntBox.setText("5");

        jLabel_trtInt.setText("2nd. Interval");
        jLabel_trtInt.setToolTipText("Enter time between measurments in the second file");

        OutpathBox.setText("click to enter file or drag and drop");
        OutpathBox.setToolTipText("");
        OutpathBox.setDragEnabled(true);
        OutpathBox.setDropMode(javax.swing.DropMode.INSERT);
        OutpathBox.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                OutpathBoxMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                OutpathBoxMouseEntered(evt);
            }
        });

        ckTreatment.setSelected(true);
        ckTreatment.setText("Treatment");
        ckTreatment.setToolTipText("<html>\nIf you only have a single kinetic file, then you <br>\nonly need to enter that in the \"Flash\" field.  <br>\nThe \"Treatment\" is for a second, continuing kinetic  <br>\nmeasurment, for example after a hormone treatment. <br>\n</html>");

        lblAbout.setForeground(new java.awt.Color(102, 102, 102));
        lblAbout.setText("About");
        lblAbout.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblAboutMouseClicked(evt);
            }
        });

        buttonGroup1.add(rbt_AscentFL);
        rbt_AscentFL.setSelected(true);
        rbt_AscentFL.setText("FluroskanAscentFL");
        rbt_AscentFL.setToolTipText("This accepts the raw format output from Ascent Fluoroskan FL");
        rbt_AscentFL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbt_AscentFLActionPerformed(evt);
            }
        });

        buttonGroup1.add(rbt_WinSkan);
        rbt_WinSkan.setText("WinSkan");
        rbt_WinSkan.setToolTipText("This accepts the raw output from the WinMikro plate reader");
        rbt_WinSkan.setMaximumSize(new java.awt.Dimension(70, 23));

        buttonGroup1.add(rbt_TECAN);
        rbt_TECAN.setText("TECAN Saffaire");
        rbt_TECAN.setToolTipText("This accepts the raw output from the TECAN Saffaire plate reader");
        rbt_TECAN.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rbt_TECANActionPerformed(evt);
            }
        });

        jLabel_plateReader.setText("Plate Reader");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(19, 19, 19)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(8, 8, 8)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel_labels)
                            .addComponent(jLabel_destination)
                            .addComponent(jLabel_measure)
                            .addComponent(jLabel_flash))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(MeasureBox, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 229, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(flashBox, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 229, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(LabelBox, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 229, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(OutpathBox, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 216, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(lblAbout)
                        .addGap(9, 9, 9))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel_timebtw)
                                    .addComponent(jLabel_trtInt)
                                    .addComponent(jLabel_flsInt))
                                .addGap(18, 18, 18)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                                    .addComponent(TimeBetweenBox, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(FlashIntBox, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(TreatIntBox, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(18, 18, 18)
                                .addComponent(ckTreatment)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(rbt_TECAN)
                                    .addComponent(rbt_AscentFL)
                                    .addComponent(rbt_WinSkan, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel_plateReader)))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jProgressBar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGap(26, 26, 26)
                                .addComponent(jButton_doit)))
                        .addGap(25, 25, 25))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(flashBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel_flash)))
                    .addComponent(lblAbout))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(MeasureBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel_measure))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(LabelBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel_labels))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(OutpathBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel_destination))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(FlashIntBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel_flsInt))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(TreatIntBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel_trtInt))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(jLabel_timebtw)
                            .addComponent(TimeBetweenBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(ckTreatment))
                        .addGap(9, 9, 9))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE)
                        .addComponent(jLabel_plateReader)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(rbt_AscentFL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(rbt_WinSkan, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(rbt_TECAN)
                        .addGap(18, 18, 18)))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jButton_doit)
                    .addComponent(jProgressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        jLabel_flash.getAccessibleContext().setAccessibleDescription("Drag-Drop file with flash values. Flash values are initial measurments that do not follow a treatment of some sort - variable promoter kinetic. GUS/NAN/LUC extracts are 'flash' measurments only. \nJust delete the Flash column when you are done.\n");
        jLabel_measure.getAccessibleContext().setAccessibleDescription("Drag-Drop file with measurment values, second file appened to first.");
        rbt_AscentFL.getAccessibleContext().setAccessibleDescription("");

        pack();
    }// </editor-fold>//GEN-END:initComponents


    /*
     * this is not used below....but it worked. retained for my notes. TransferHandler solution
     */
    
// private TransferHandler fb_handler = new TransferHandler() {
//        public boolean canImport(TransferHandler.TransferSupport support) {
//            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
//                return false;
//            }
//
////            if (copyItem.isSelected()) {
////                boolean copySupported = (COPY & support.getSourceDropActions()) == COPY;
////
////                if (!copySupported) {
////                    return false;
////                }
////
////                support.setDropAction(COPY);
////            }
//
//            return true;
//        }
//
//        public boolean importData(TransferHandler.TransferSupport support) {
//            if (!canImport(support)) {   //this calls the one above
//                return false;
//             }
//            
//            if (!support.isDrop()) {
//                    return false;
//             }
//             
//            Transferable t = support.getTransferable();
////            String data;
////                try {
////                    data = (String)t.getTransferData(DataFlavor.stringFlavor);
////                } 
////                catch (Exception e) { return false; }
//            
//            try {
//                java.util.List<File> l =
//                    (java.util.List<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
//
//                for (File f : l) {
//                    flashBox.setText(f.toString());
//                    break;
//                   // new Doc(f); //do somethint with the text, but this is in the handler
//                }
//            } catch (Exception e) {
//                return false;
//            } 
//            return true;
//        } //end importData
//    }; //end object
   
    /*
     * below is the Thread version for running the progress bar, I think it works, and I left it since it too me so long to figure 
     * it out. Thread Solution.
     */
//    public class HelloThread extends Thread {
//
//        private void MakeJMPfileHelloThread(){
//       
//    //check to see if all the text fields are file paths, exception thrown from method        
//         if (checkFile(flashBox.getText()) == false) { 
//             JOptionPane.showMessageDialog(jOptionPane,"Flash file not entered");
//             return; //exit 
//         }      
//         if (checkFile(LabelBox.getText()) == false) { 
//             JOptionPane.showMessageDialog(jOptionPane,"Label file not entered");
//             return; //exit 
//         }
//         if (checkDirectory(OutpathBox.getText()) == false) { 
//             JOptionPane.showMessageDialog(jOptionPane,"Output directory is bullshit");
//             return; //exit 
//         }
//         if (ckTreatment.isSelected() == true) {  //measurment file is an option
//            if (checkFile(MeasureBox.getText()) == false) { 
//             JOptionPane.showMessageDialog(jOptionPane,"Measurement file not entered");
//             return; //exit 
//            }  
//         }
//         
//     //check to make sure the intervals are integers,I save them so they dont need to be converted each time
//        int FlashInt = 5;
//        int TreatInt = 5;
//        int TimeBetween = 5;
//        int LastTimeCount = 60;
//        //flash interval is mandatory
//        try { FlashInt = Integer.parseInt(FlashIntBox.getText()); }
//        catch (NumberFormatException x) { 
//            JOptionPane.showMessageDialog(jOptionPane,"Flash Interval is not a number");
//            return; }
//        //if treatment file exists
//        if (ckTreatment.isSelected() == true) {
//          try { TreatInt = Integer.parseInt(TreatIntBox.getText()); }
//        catch (NumberFormatException x) { 
//            JOptionPane.showMessageDialog(jOptionPane,"Treatment Interval is not a number");
//            return; }
//          try { TimeBetween = Integer.parseInt(TimeBetweenBox.getText()); }
//        catch (NumberFormatException x) { 
//            JOptionPane.showMessageDialog(jOptionPane,"Time Between Interval is not a number");
//            return; }
//        }
//        
//        
//        
//     //read in the labels
//        HashMap<String, HashMap<String,String>> prop_hash = new HashMap<String, HashMap<String,String>>();
//        ArrayList<String> SubProperties = new ArrayList<String>();
//        //final Charset ENCODING = StandardCharsets.UTF_8;
//        //get labels from file        
//        testgui1.ParseLabels pL = new testgui1.ParseLabels(LabelBox.getText());
//        try {
//             pL.makeHashs();
//             prop_hash = pL.hash_labels;
//             SubProperties = pL.properties;
//            }
//        catch (IOException x) {
//            JOptionPane.showMessageDialog(jOptionPane,"Error reading labels: " + x.toString());
//            //jump out of rest of the code 
//            return;
//            }        
//        
//        
//      //** BEGIN WITH FLSH FILE make outputfile **//
//      try  { //try catch for all things not caught?
//        Path path = Paths.get(flashBox.getText()).getFileName();        
//        String name = path.getFileName().toString();
//        int pos = name.lastIndexOf(".");
//        if (pos > 0) { name = name.substring(0, pos); }
//        //Path path = Paths.get(OutpathBox.getText() + File.separator + name + "_JMPinput.txt");
//        //open the file
//        
//            FileWriter writer = null;
//            String _filename = OutpathBox.getText() + File.separator + name + "_JMPinput.txt";
//            writer = new FileWriter(_filename);
//            
//        /*write out header to file
//                        """
//                        Set up OUTPUT
//                        Time; well, Row, Col,*PROPERTIES*,FLASH, Luc Activity 
//                        """
//                        outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t')
//        */
//            writer.write("Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t");
//            Set<String> _keys = prop_hash.keySet();
//            for(String _key : _keys){
//             Set<String> _subkeys = prop_hash.get(_key).keySet();
//               for (String _skey : _subkeys) {
//                  writer.write(_skey + "\t");
//               }
//               break; //once is enough
//             }
//           writer.write("\n");
//           writer.flush();
//            
//            
//       //do conversion of:
//        //Flash file first
//            path = null;
//            int TimeCount = 0;
//            Scanner s = null;
//            FileReader inputStream = null;
//            path = Paths.get(flashBox.getText());
//            ArrayList<String> MeasureBreak = new ArrayList<String>();
//           
//           //datafile is broken at Measurments 
//            try {
//            s = new Scanner(path);            
//            Pattern pattern = Pattern.compile("Measurement");
//            s.useDelimiter(pattern);
//            while (s.hasNext()) { MeasureBreak.add(s.next().toString());  }
//            } finally {
//             if (s != null) { s.close(); }
//            }   
//            
//            
//           
//          Pattern pattern = Pattern.compile("count:[^0-9]([0-9]+)[^0-9]");  //fuck double escape shit
//          try {
//             //now flash file, process each line, first catching the time 
//             for (String _s : MeasureBreak) {
//              String[] mblock;
//              List<List<String>> mes_blocks = new ArrayList<List<String>>();
//              
//                 mblock = _s.split("\n"); 
//                 Matcher m = pattern.matcher(mblock[0]);
//                 while (m.find()) {
//                     TimeCount = Integer.parseInt(m.group(1));
//                     break; //there should only be one, but....
//                 }
//                 
//                 
//                 mes_blocks.clear();                 
//                 for (int i=1;i<mblock.length;i++) {
//                     List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));                     
//                     mes_blocks.add(_list);
//                 }  
//                 
//                 
//                    //match and output
//               for (int y=1; y <mes_blocks.size(); y++){ //header is only col numbers
//                   for (int x=1; x < mes_blocks.get(0).size(); x++) { //data starts on 1
//                       String tx;
//                       tx = mes_blocks.get(y).get(0)+ mes_blocks.get(0).get(x);
//                        //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
//                        writer.write(Integer.toString(TimeCount * FlashInt));
//                        writer.write("\t" + tx + "\t" + mes_blocks.get(y).get(0) + "\t" + mes_blocks.get(0).get(x));
//                        writer.write("\t" + mes_blocks.get(y).get(x));
//                        writer.write("\ty\t"); //flash is YES
//                            //Set<String> _subkeys = prop_hash.get(tx).keySet();
//                            for (String _skey : SubProperties) {
//                                     writer.write(prop_hash.get(tx).get(_skey) + "\t");
//                            }
//                       writer.write("\n");
//                       writer.flush();
//                   }  
//               }  //output mes_blocks flash
//             }  //for each flash measurment
//          } //try block close for flash file
//          catch (Exception e) {  //this should catch whatever shit happens
//              writer.close();
//               JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
//          }
//         //*** END FLASH FILE ***//
//         //****************************//
//         //** now treatment file if present/chosen **/
//         if (ckTreatment.isSelected() == true) {   
//             LastTimeCount = TimeCount * FlashInt;
//             
//           //do conversion of:
//            //Measruement file , reset variables
//                path = null;
//                //int TimeCount = 0;
//                s = null;
//                inputStream = null;
//                path = Paths.get(MeasureBox.getText());
//                MeasureBreak.clear();
//
//               //datafile is broken at Measurments 
//                try {
//                s = new Scanner(path);            
//                pattern = Pattern.compile("Measurement");
//                s.useDelimiter(pattern);
//                while (s.hasNext()) { MeasureBreak.add(s.next().toString());  }
//                } finally {
//                 if (s != null) { s.close(); }
//                }   
//                
//              pattern = Pattern.compile("count:[^0-9]([0-9]+)[^0-9]");  //fuck double escape shit
//              try {
//                 //now flash file, process each line, first catching the time 
//                 for (String _s : MeasureBreak) {
//                  String[] mblock;
//                  List<List<String>> mes_blocks = new ArrayList<List<String>>();
//
//                     mblock = _s.split("\n"); 
//                     Matcher m = pattern.matcher(mblock[0]);
//                     while (m.find()) {
//                         TimeCount = Integer.parseInt(m.group(1));
//                         break; //there should only be one, but....
//                     }
//
//
//                     mes_blocks.clear();                 
//                     for (int i=1;i<mblock.length;i++) {
//                         List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));                     
//                         mes_blocks.add(_list);
//                     }  
//
//
//                        //match and output
//                   for (int y=1; y <mes_blocks.size(); y++){ //header is only col numbers
//                       for (int x=1; x < mes_blocks.get(0).size(); x++) { //data starts on 1
//                           String tx;
//                           tx = mes_blocks.get(y).get(0)+ mes_blocks.get(0).get(x);
//                            //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
//                            writer.write(Integer.toString((TimeCount * TreatInt)+LastTimeCount+TimeBetween));
//                            writer.write("\t" + tx + "\t" + mes_blocks.get(y).get(0) + "\t" + mes_blocks.get(0).get(x));
//                            writer.write("\t" + mes_blocks.get(y).get(x));
//                            writer.write("\tn\t"); //flash is NO
//                                //Set<String> _subkeys = prop_hash.get(tx).keySet();
//                                for (String _skey : SubProperties) {
//                                         writer.write(prop_hash.get(tx).get(_skey) + "\t");
//                                }
//                           writer.write("\n");
//                           writer.flush();
//                       }  
//                   }  //output mes_blocks flash
//                 }  //for each flash measurment
//              } //try block close for measeurment file
//              catch (Exception e) {  //this should catch whatever shit happens
//                  writer.close();
//                   JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
//              } 
//                    
//                
//            } //if then: measurment file 
//            
//  
//        //tell user you are done and what the file is    
//          writer.close();
//          JOptionPane.showMessageDialog(jOptionPane,"Done: "+ _filename);
//            
//        //gloabl try catch    
//        } catch (Exception x) {
//            JOptionPane.showMessageDialog(jOptionPane,"Error :" + x.toString());
//        }
//} //end make file
//    
//    
//        
//    public void run() {
//        try{
//           HelloThread.sleep(100); 
//         //  Thread.currentThread().join();   //causes it to lock
//        }catch (Exception x) { 
//            JOptionPane.showMessageDialog(jOptionPane,x.toString());
//        }
//            
//        MakeJMPfileHelloThread();
//    }
//
//    public  void main(String args[]) {
//        (new HelloThread()).start();
//    }
//
//} //end nested class HelloThread /* I think this also worked, but is not used. I decided to use the Task and SwingWorker instead */
    
    
    
    class Task_WinMikro extends SwingWorker<Void, Void> {
        /*
         * Main task. Executed in background thread.
         */
        private void MakeJMPfileTask(){
   
         //check to see if all the text fields are file paths, exception thrown from method        
         if (checkFile(flashBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Flash file not entered");
             return; //exit 
         }      
         if (checkFile(LabelBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Label file not entered");
             return; //exit 
         }
         if (checkDirectory(OutpathBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Output directory is bullshit");
             return; //exit 
         }
         if (ckTreatment.isSelected() == true) {  //measurment file is an option
            if (checkFile(MeasureBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Measurement file not entered");
             return; //exit 
            }  
         }
         
     //check to make sure the intervals are integers,I save them so they dont need to be converted each time
        int FlashInt = 5;
        int TreatInt = 5;
        int TimeBetween = 5;
        int LastTimeCount = 60;
        //flash interval is mandatory
        try { FlashInt = Integer.parseInt(FlashIntBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Flash Interval is not a number");
            return; }
        //if treatment file exists
        if (ckTreatment.isSelected() == true) {
          try { TreatInt = Integer.parseInt(TreatIntBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Treatment Interval is not a number");
            return; }
          try { TimeBetween = Integer.parseInt(TimeBetweenBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Time Between Interval is not a number");
            return; }
        }
        
        
        
     //read in the labels
        HashMap<String, HashMap<String,String>> prop_hash = new HashMap<String, HashMap<String,String>>();
        ArrayList<String> SubProperties = new ArrayList<String>();
        //final Charset ENCODING = StandardCharsets.UTF_8;
        //get labels from file        
        testgui1.ParseLabels pL = new testgui1.ParseLabels(LabelBox.getText());
        try {
             pL.makeHashs();
             prop_hash = pL.hash_labels;
             SubProperties = pL.properties;
            }
        catch (IOException x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error reading labels: " + x.toString());
            //jump out of rest of the code 
            return;
            }        
        
        
      //** BEGIN WITH FLASH WinMikro FILE make outputfile **//
      try  { //try catch for all things not caught?
        Path path = Paths.get(flashBox.getText()).getFileName();        
        String name = path.getFileName().toString();
        int pos = name.lastIndexOf(".");
        if (pos > 0) { name = name.substring(0, pos); }
        //Path path = Paths.get(OutpathBox.getText() + File.separator + name + "_JMPinput.txt");
        //open the file
        
            FileWriter writer = null;
            int _fileNameOK = 0;
            int _fileCtr = 0;
            String _filename = "";
            while (_fileNameOK == 0){
              _filename = OutpathBox.getText() + File.separator + name + "_JMPinput" + _fileCtr + ".txt";  
              if (checkFile(_filename)==false){
                  _fileNameOK = 1;}
              else{ _fileCtr++;}
              } //end while 
            writer = new FileWriter(_filename);
            
        /*write out header to file
                        """
                        Set up OUTPUT
                        Time; well, Row, Col,*PROPERTIES*,FLASH, Luc Activity 
                        """
                        outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t')
        */
            writer.write("Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t");
            Set<String> _keys = prop_hash.keySet();
            for(String _key : _keys){
             Set<String> _subkeys = prop_hash.get(_key).keySet();
               for (String _skey : _subkeys) {
                  writer.write(_skey + "\t");
               }
               break; //once is enough
             }
           writer.write("\n");
           writer.flush();
            
        /*
         * header files done now get the data out
         * need to take each line, parse the first column into letter and then number
         */    
       //do conversion of:
        //Flash file first WinMikro
           Pattern pattern;
            //path = null;
            int TimeCount = 0;
            Scanner s = null;
            //FileReader inputStream = null;
            path = Paths.get(flashBox.getText());
            ArrayList<String> MeasureBreak = new ArrayList<String>(); 
           /*
             * Go line by line, Time by Time, that is the simple approach
             * The time is the column order. The WinMikro actually spits out real time, but we only need interger units
             */
           //datafile is broken by line , read in line to array string
            try {
            s = new Scanner(path);            
            pattern = Pattern.compile("\n");
            s.useDelimiter(pattern);
            while (s.hasNext()) { MeasureBreak.add(s.next().toString().replaceAll("(\\r|\\n)", "")); }
            } finally {
             if (s != null) { s.close(); }
            }   
                  
      
         // pattern used here becomes a global-local variable   
         // Pattern pattern = Pattern.compile("([^0-9])(0-9]+)[\\t\\n\\x0b\\r\\f]+");  //need to get Row and Column
          pattern = Pattern.compile("(\\D)(\\d+)");   //need to get Row and Column (\\D\\d+)\\1
          try {
             //now flash file, process each line, first catching the time 
             /*
              * loop each line
              */
             for (String _s : MeasureBreak) {
              TimeCount = 0;  
              String[] mblock;
              String tx = "";
              String _row = "";
              String _col = "";
              
              mblock = _s.split("\t");  //was already broken by \n
              Matcher m0 = pattern.matcher(mblock[0]); //until calling find, not found!
              while(m0.find()) { //if find is not called, no action, beware of locality
                      
                      _row = m0.group(1);
                      _col = m0.group(2);
                      _col = _col.replaceFirst("^0+(?!$)", "");
                      //long _long = Long.parseLong(_col);
                       }
               tx = _row + _col;
     
                    //match and output
               for (int y=1; y < mblock.length; y++){ //header is well identifier, which was just parsed
                        TimeCount += 1;
                        //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
                        writer.write(Integer.toString(TimeCount * FlashInt));
                        writer.write("\t" + tx + "\t" + _row + "\t" + _col);
                        writer.write("\t" + mblock[y]);
                        writer.write("\ty\t"); //flash is YES
                            //Set<String> _subkeys = prop_hash.get(tx).keySet();
                            for (String _skey : SubProperties) {
                                     writer.write(prop_hash.get(tx).get(_skey) + "\t");
                            }
                       writer.write("\n");
                       writer.flush();
                     
               }  //output mes_blocks flash
             }  //for each flash measurment
          } //try block close for flash file
          catch (Exception e) {  //this should catch whatever shit happens
              writer.close();
               JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
          }
         //*** END FLASH FILE ***//
         //****************************//
         //** now treatment file if present/chosen **/
         if (ckTreatment.isSelected() == true) {   
             LastTimeCount = TimeCount * FlashInt;
             
           //do conversion of:
            //Measruement file , reset variables
                //path = null;
                //int TimeCount = 0;
                s = null;
                //inputStream = null;
                path = Paths.get(MeasureBox.getText());
                MeasureBreak.clear();

               //datafile is broken at Measurments 
                try {
                s = new Scanner(path);            
                pattern = Pattern.compile("\n");
                s.useDelimiter(pattern);
                while (s.hasNext()) { MeasureBreak.add(s.next().toString().replaceAll("(\\r|\\n)", "")); }
                } finally {
                 if (s != null) { s.close(); }
                }   
                
          pattern = Pattern.compile("(\\D)(\\d+)");   //need to get Row and Column (\\D\\d+)\\1
          try {
             
            
             //now flash file, process each line, first catching the time 
             /*
              * loop each line
              */
             for (String _s : MeasureBreak) {
              TimeCount = 0;   
              String[] mblock;
              String tx = "";
              String _row = "";
              String _col = "";
              
              mblock = _s.split("\t");  //was already broken by \n
              Matcher m0 = pattern.matcher(mblock[0]); //until calling find, not found!
              while(m0.find()) { //if find is not called, no action, beware of locality
                      
                      _row = m0.group(1);
                      _col = m0.group(2);
                      _col = _col.replaceFirst("^0+(?!$)", "");
                      //long _long = Long.parseLong(_col);
                       }
               tx = _row + _col;
             
   
                    //match and output
               for (int y=1; y < mblock.length; y++){ //header is well identifier, which was just parsed
                        //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
                        TimeCount += 1;
                        writer.write(Integer.toString((TimeCount * TreatInt)+LastTimeCount+TimeBetween));
                        writer.write("\t" + tx + "\t" + _row + "\t" + _col);
                        writer.write("\t" + mblock[y]);
                        writer.write("\tn\t"); //flash was YES, this makes n the correct property
                            //Set<String> _subkeys = prop_hash.get(tx).keySet();
                            for (String _skey : SubProperties) {
                                     writer.write(prop_hash.get(tx).get(_skey) + "\t");
                            }
                       writer.write("\n");
                       writer.flush();
                     
               }  //output mes_blocks flash
             }  //for each flash measurment
          } //try block close for treatment file
              catch (Exception e) {  //this should catch whatever shit happens
                  writer.close();
                   JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
              } 
                    
                
            } //if then: measurment file 
            
  
        //tell user you are done and what the file is    
          writer.close();
          JOptionPane.showMessageDialog(jOptionPane,"Done: "+ _filename);
            
        //gloabl try catch    
        } catch (Exception x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error :" + x.toString());
        }
} //end make file    
        @Override
        public Void doInBackground() {
             jButton_doit.setEnabled(false);
             jProgressBar.setIndeterminate(true);
           MakeJMPfileTask();
             jProgressBar.setIndeterminate(false);
             jButton_doit.setEnabled(true); 
            return null;
        }
    } //end Swing worker task class
    
    
    
    class Task_AscentFL extends SwingWorker<Void, Void> {
        /*
         * Main task. Executed in background thread.
         */
        private void MakeJMPfileTask(){
       
    //check to see if all the text fields are file paths, exception thrown from method        
         if (checkFile(flashBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Flash file not entered");
             return; //exit 
         }      
         if (checkFile(LabelBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Label file not entered");
             return; //exit 
         }
         if (checkDirectory(OutpathBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Output directory is bullshit");
             return; //exit 
         }
         if (ckTreatment.isSelected() == true) {  //measurment file is an option
            if (checkFile(MeasureBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Measurement file not entered");
             return; //exit 
            }  
         }
         
     //check to make sure the intervals are integers,I save them so they dont need to be converted each time
        int FlashInt = 5;
        int TreatInt = 5;
        int TimeBetween = 5;
        int LastTimeCount = 60;
        //flash interval is mandatory
        try { FlashInt = Integer.parseInt(FlashIntBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Flash Interval is not a number");
            return; }
        //if treatment file exists
        if (ckTreatment.isSelected() == true) {
          try { TreatInt = Integer.parseInt(TreatIntBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Treatment Interval is not a number");
            return; }
          try { TimeBetween = Integer.parseInt(TimeBetweenBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Time Between Interval is not a number");
            return; }
        }
        
        
        
     //read in the labels
        HashMap<String, HashMap<String,String>> prop_hash = new HashMap<String, HashMap<String,String>>();
        ArrayList<String> SubProperties = new ArrayList<String>();
        //final Charset ENCODING = StandardCharsets.UTF_8;
        //get labels from file                
        testgui1.ParseLabels pL = new testgui1.ParseLabels(LabelBox.getText()); 
        try {
             pL.makeHashs();
             prop_hash = pL.hash_labels;
             SubProperties = pL.properties;
            }
        catch (IOException x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error reading labels: " + x.toString());
            //jump out of rest of the code 
            return;
            }        
        
        
      //** BEGIN WITH FLASH FILE make outputfile **//
      try  { //try catch for all things not caught?
        //there is a bug somwhere (June2017, when a bad file is read, then it does not replace it, rather load it, which is in the Scanner variable 's', but it is called new
        Path path = Paths.get(flashBox.getText()).getFileName();        
        String name = path.getFileName().toString();
        int pos = name.lastIndexOf(".");
        if (pos > 0) { name = name.substring(0, pos); }
        //Path path = Paths.get(OutpathBox.getText() + File.separator + name + "_JMPinput.txt");
        //open the file
        
            FileWriter writer = null;
            int _fileNameOK = 0;
            int _fileCtr = 0;
            String _filename = "";
            while (_fileNameOK == 0){
              _filename = OutpathBox.getText() + File.separator + name + "_JMPinput" + _fileCtr + ".txt";  
              if (checkFile(_filename)==false){
                  _fileNameOK = 1;}
              else{ _fileCtr++;}
              } //end while 
            writer = new FileWriter(_filename);
            
        /*write out header to file
                        """
                        Set up OUTPUT
                        Time; well, Row, Col,*PROPERTIES*,FLASH, Luc Activity 
                        """
                        outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t')
        */
            writer.write("Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t");
            Set<String> _keys = prop_hash.keySet();
            for(String _key : _keys){
             Set<String> _subkeys = prop_hash.get(_key).keySet();
               for (String _skey : _subkeys) {
                  writer.write(_skey + "\t");
               }
               break; //once is enough
             }
           writer.write("\n");
           writer.flush();
            
            
       //do conversion of:
        //Flash file first AscentFL format
            //path = null;
            int TimeCount = 0;
            Scanner s = null;
            //FileReader inputStream = null;
            path = Paths.get(flashBox.getText());
            ArrayList<String> MeasureBreak = new ArrayList<String>();
           
           //datafile is broken at Measurments 
            try {
            s = new Scanner(path);            
            Pattern pattern = Pattern.compile("Measurement");
            s.useDelimiter(pattern);
            while (s.hasNext()) { MeasureBreak.add(s.next().toString());  }
            } finally {
             if (s != null) { s.close(); }
            }   
            
            
           
          Pattern pattern = Pattern.compile("count:[^0-9]([0-9]+)[^0-9]");  //fuck double escape shit

          try {
             //now flash file, process each line, first catching the time 
             for (String _s : MeasureBreak) {
              String[] mblock;
              List<List<String>> mes_blocks = new ArrayList<List<String>>();
              
                 mblock = _s.split("\n"); 
                 Matcher m = pattern.matcher(mblock[0]);
                 while (m.find()) {
                     TimeCount = Integer.parseInt(m.group(1));
                     break; //there should only be one, but....
                 }
                 
                 
                 mes_blocks.clear();                 
                 for (int i=1;i<mblock.length;i++) {
                     List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));                     
                     mes_blocks.add(_list);
                 }  
                 
                 
                    //match and output
               for (int y=1; y <mes_blocks.size(); y++){ //header is only col numbers
                   for (int x=1; x < mes_blocks.get(0).size(); x++) { //data starts on 1
                       String tx;
                       tx = mes_blocks.get(y).get(0)+ mes_blocks.get(0).get(x);
                       
                       if(prop_hash.containsKey(tx)){
                         // in range
                      
                        //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
                        writer.write(Integer.toString(TimeCount * FlashInt));
                        writer.write("\t" + tx + "\t" + mes_blocks.get(y).get(0) + "\t" + mes_blocks.get(0).get(x));
                        writer.write("\t" + mes_blocks.get(y).get(x));
                        writer.write("\ty\t"); //flash is YES
                            //Set<String> _subkeys = prop_hash.get(tx).keySet();
                            for (String _skey : SubProperties) {
                                     writer.write(prop_hash.get(tx).get(_skey) + "\t");
                            }
                       writer.write("\n");
                       writer.flush();
                       }
                   }  
               }  //output mes_blocks flash
             }  //for each flash measurment
          } //try block close for flash file
          catch (Exception e) {  //this should catch whatever shit happens
              writer.close();
               JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
          }

         //*** END FLASH FILE ***//
         //****************************//
         //** now treatment file if present/chosen **/
         if (ckTreatment.isSelected() == true) {   
             LastTimeCount = TimeCount * FlashInt;
             
           //do conversion of:
            //Measruement file , reset variables
                //path = null;
                //int TimeCount = 0;
                s = null;
                //inputStream = null;
                path = Paths.get(MeasureBox.getText());
                MeasureBreak.clear();

               //datafile is broken at Measurments 
                try {
                s = new Scanner(path);            
                pattern = Pattern.compile("Measurement");
                s.useDelimiter(pattern);
                while (s.hasNext()) { MeasureBreak.add(s.next().toString());  }
                } finally {
                 if (s != null) { s.close(); }
                }   
                
              pattern = Pattern.compile("count:[^0-9]([0-9]+)[^0-9]");  //fuck double escape shit
              try {
                 //now flash file, process each line, first catching the time 
                 for (String _s : MeasureBreak) {
                  String[] mblock;
                  List<List<String>> mes_blocks = new ArrayList<List<String>>();

                     mblock = _s.split("\n"); 
                     Matcher m = pattern.matcher(mblock[0]);
                     while (m.find()) {
                         TimeCount = Integer.parseInt(m.group(1));
                         break; //there should only be one, but....
                     }


                     mes_blocks.clear();                 
                     for (int i=1;i<mblock.length;i++) {
                         List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));                     
                         mes_blocks.add(_list);
                     }  


                        //match and output
                   for (int y=1; y <mes_blocks.size(); y++){ //header is only col numbers
                       for (int x=1; x < mes_blocks.get(0).size(); x++) { //data starts on 1
                           String tx;
                           tx = mes_blocks.get(y).get(0)+ mes_blocks.get(0).get(x);
                           
                           if(prop_hash.containsKey(tx)){
                            //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
                            writer.write(Integer.toString((TimeCount * TreatInt)+LastTimeCount+TimeBetween));
                            writer.write("\t" + tx + "\t" + mes_blocks.get(y).get(0) + "\t" + mes_blocks.get(0).get(x));
                            writer.write("\t" + mes_blocks.get(y).get(x));
                            writer.write("\tn\t"); //flash is NO
                                //Set<String> _subkeys = prop_hash.get(tx).keySet();
                                for (String _skey : SubProperties) {
                                         writer.write(prop_hash.get(tx).get(_skey) + "\t");
                                }
                           writer.write("\n");
                           writer.flush();
                           }
                       }  
                   }  //output mes_blocks flash
                 }  //for each flash measurment
              } //try block close for measeurment file
              catch (Exception e) {  //this should catch whatever shit happens
                  writer.close();
                   JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
              } 
                    
                
            } //if then: measurment file 
            
  
        //tell user you are done and what the file is    
          writer.close();
          JOptionPane.showMessageDialog(jOptionPane,"Done: "+ _filename);
            
        //gloabl try catch    
        } catch (Exception x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error :" + x.toString());
        }
} //end make file
  
        
        @Override
        public Void doInBackground() {
//            Random random = new Random();
//            int progress = 0;
//            //Initialize progress property.
//            setProgress(0);
//            while (progress < 100) {
//                //Sleep for up to one second.
//                try {
//                    Thread.sleep(random.nextInt(1000));
//                } catch (InterruptedException ignore) {}
//                //Make random progress.
//                progress += random.nextInt(10);
//                setProgress(Math.min(progress, 100));
//            }
             jButton_doit.setEnabled(false);
             jProgressBar.setIndeterminate(true);
           MakeJMPfileTask();
             jProgressBar.setIndeterminate(false);
             jButton_doit.setEnabled(true);
             
            return null;
        }
 
        /*
         * Executed in event dispatching thread
         */
//        @Override
//        public void done() {
//            Toolkit.getDefaultToolkit().beep();
//            startButton.setEnabled(true);
//            setCursor(null); //turn off the wait cursor
//            taskOutput.append("Done!\n");
//        }
    } //end swingworker task class
    
 
    class Task_TecanSaffaire extends SwingWorker<Void, Void> {
        /*
         * Main task. Executed in background thread.
         */
        private void MakeJMPfileTask(){
       
    //check to see if all the text fields are file paths, exception thrown from method        
         if (checkFile(flashBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Flash file not entered");
             return; //exit 
         }      
         if (checkFile(LabelBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Label file not entered");
             return; //exit 
         }
         if (checkDirectory(OutpathBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Output directory is bullshit");
             return; //exit 
         }
         if (ckTreatment.isSelected() == true) {  //measurment file is an option
            if (checkFile(MeasureBox.getText()) == false) { 
             JOptionPane.showMessageDialog(jOptionPane,"Measurement file not entered");
             return; //exit 
            }  
         }
         
     //check to make sure the intervals are integers,I save them so they dont need to be converted each time
        int FlashInt = 5;
        int TreatInt = 5;
        int TimeBetween = 5;
        int LastTimeCount = 60;
        //flash interval is mandatory
        try { FlashInt = Integer.parseInt(FlashIntBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Flash Interval is not a number");
            return; }
        //if treatment file exists
        if (ckTreatment.isSelected() == true) {
          try { TreatInt = Integer.parseInt(TreatIntBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Treatment Interval is not a number");
            return; }
          try { TimeBetween = Integer.parseInt(TimeBetweenBox.getText()); }
        catch (NumberFormatException x) { 
            JOptionPane.showMessageDialog(jOptionPane,"Time Between Interval is not a number");
            return; }
        }
        
        
        
     //read in the labels
        HashMap<String, HashMap<String,String>> prop_hash = new HashMap<String, HashMap<String,String>>();
        ArrayList<String> SubProperties = new ArrayList<String>();
        //final Charset ENCODING = StandardCharsets.UTF_8;
        //get labels from file                
        testgui1.ParseLabels pL = new testgui1.ParseLabels(LabelBox.getText()); 
        try {
             pL.makeHashs();
             prop_hash = pL.hash_labels;
             SubProperties = pL.properties;
            }
        catch (IOException x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error reading labels: " + x.toString());
            //jump out of rest of the code 
            return;
            }        
        
        
      //** BEGIN WITH FLASH FILE make outputfile **//
      try  { //try catch for all things not caught?
        //there is a bug somwhere (June2017, when a bad file is read, then it does not replace it, rather load it, which is in the Scanner variable 's', but it is called new
        Path path = Paths.get(flashBox.getText()).getFileName();        
        String name = path.getFileName().toString();
        int pos = name.lastIndexOf(".");
        if (pos > 0) { name = name.substring(0, pos); }
        //Path path = Paths.get(OutpathBox.getText() + File.separator + name + "_JMPinput.txt");
        //open the file
        
            FileWriter writer = null;
            int _fileNameOK = 0;
            int _fileCtr = 0;
            String _filename = "";
            while (_fileNameOK == 0){
              _filename = OutpathBox.getText() + File.separator + name + "_JMPinput" + _fileCtr + ".txt";  
              if (checkFile(_filename)==false){
                  _fileNameOK = 1;}
              else{ _fileCtr++;}
              } //end while 
            writer = new FileWriter(_filename);
            
        /*write out header to file
                        """
                        Set up OUTPUT
                        Time; well, Row, Col,*PROPERTIES*,FLASH, Luc Activity 
                        """
                        outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t')
        */
            writer.write("Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t");
            Set<String> _keys = prop_hash.keySet();
            for(String _key : _keys){
             Set<String> _subkeys = prop_hash.get(_key).keySet();
               for (String _skey : _subkeys) {
                  writer.write(_skey + "\t");
               }
               break; //once is enough
             }
           writer.write("\n");
           writer.flush();
            
            
       //do conversion of:
        //Flash file first AscentFL format
            //path = null;
            int TimeCount = 0;
            Scanner s = null;
            //FileReader inputStream = null;
            path = Paths.get(flashBox.getText());
            ArrayList<String> MeasureBreak = new ArrayList<String>();
           
           //datafile is broken at Measurments 
            try {
            s = new Scanner(path);            
            Pattern pattern = Pattern.compile("Cycle ");
            s.useDelimiter(pattern);
            while (s.hasNext()) { MeasureBreak.add(s.next().toString());  }
            } finally {
             if (s != null) { s.close(); }
            }   
            
            
           
          Pattern pattern = Pattern.compile("Number:[^0-9]([0-9]+)[^0-9]");  //fuck double escape shit

          try {
             //now flash file, process each line, first catching the time 
             for (String _s : MeasureBreak) {
              String[] mblock;
              List<List<String>> mes_blocks = new ArrayList<List<String>>();
              
                 mblock = _s.split("\n"); 
                 Matcher m = pattern.matcher(mblock[0]);
                 while (m.find()) {
                     TimeCount = Integer.parseInt(m.group(1));
                     break; //there should only be one, but....
                 }
                 
                 
                 mes_blocks.clear();           //line , blank line after it    
                 for (int i=2;i<mblock.length;i++) {
                     List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));                     
                     if (_list.size()>0)  {  mes_blocks.add(_list); }
                 }  
                 
                 
                    //match and output
               for (int y=1; y <mes_blocks.size(); y++){ //header is only col numbers
                   for (int x=1; x < mes_blocks.get(0).size(); x++) { //data starts on 1
                       String tx;
                       tx = mes_blocks.get(y).get(0)+ mes_blocks.get(0).get(x);
                       
                       if(prop_hash.containsKey(tx)){
                         // in range
                      
                        //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
                        writer.write(Integer.toString(TimeCount * FlashInt));
                        writer.write("\t" + tx + "\t" + mes_blocks.get(y).get(0) + "\t" + mes_blocks.get(0).get(x));
                        writer.write("\t" + mes_blocks.get(y).get(x));
                        writer.write("\ty\t"); //flash is YES
                            //Set<String> _subkeys = prop_hash.get(tx).keySet();
                            for (String _skey : SubProperties) {
                                     writer.write(prop_hash.get(tx).get(_skey) + "\t");
                            }
                       writer.write("\n");
                       writer.flush();
                       }
                   }  
               }  //output mes_blocks flash
             }  //for each flash measurment
          } //try block close for flash file
          catch (Exception e) {  //this should catch whatever shit happens
              writer.close();
               JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
          }

         //*** END FLASH FILE ***//
         //****************************//
         //** now treatment file if present/chosen **/
         if (ckTreatment.isSelected() == true) {   
             LastTimeCount = TimeCount * FlashInt;
             
           //do conversion of:
            //Measruement file , reset variables
                //path = null;
                //int TimeCount = 0;
                s = null;
                //inputStream = null;
                path = Paths.get(MeasureBox.getText());
                MeasureBreak.clear();

               //datafile is broken at Measurments 
                try {
                s = new Scanner(path);            
                pattern = Pattern.compile("Cycle ");
                s.useDelimiter(pattern);
                while (s.hasNext()) { MeasureBreak.add(s.next().toString());  }
                } finally {
                 if (s != null) { s.close(); }
                }   
                
              pattern = Pattern.compile("Number:[^0-9]([0-9]+)[^0-9]");  //fuck double escape shit
              try {
                 //now flash file, process each line, first catching the time 
                 for (String _s : MeasureBreak) {
                  String[] mblock;
                  List<List<String>> mes_blocks = new ArrayList<List<String>>();

                     mblock = _s.split("\n"); 
                     Matcher m = pattern.matcher(mblock[0]);
                     while (m.find()) {
                         TimeCount = Integer.parseInt(m.group(1));
                         break; //there should only be one, but....
                     }


                     mes_blocks.clear();                 
                    for (int i=2;i<mblock.length;i++) {
                        List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));                     
                        if (_list.size()>0)  {  mes_blocks.add(_list); }
                    }  


                        //match and output
                   for (int y=1; y <mes_blocks.size(); y++){ //header is only col numbers
                       for (int x=1; x < mes_blocks.get(0).size(); x++) { //data starts on 1
                           String tx;
                           tx = mes_blocks.get(y).get(0)+ mes_blocks.get(0).get(x);
                           
                           if(prop_hash.containsKey(tx)){
                            //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
                            writer.write(Integer.toString((TimeCount * TreatInt)+LastTimeCount+TimeBetween));
                            writer.write("\t" + tx + "\t" + mes_blocks.get(y).get(0) + "\t" + mes_blocks.get(0).get(x));
                            writer.write("\t" + mes_blocks.get(y).get(x));
                            writer.write("\tn\t"); //flash is NO
                                //Set<String> _subkeys = prop_hash.get(tx).keySet();
                                for (String _skey : SubProperties) {
                                         writer.write(prop_hash.get(tx).get(_skey) + "\t");
                                }
                           writer.write("\n");
                           writer.flush();
                           }
                       }  
                   }  //output mes_blocks flash
                 }  //for each flash measurment
              } //try block close for measeurment file
              catch (Exception e) {  //this should catch whatever shit happens
                  writer.close();
                   JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
              } 
                    
                
            } //if then: measurment file 
            
  
        //tell user you are done and what the file is    
          writer.close();
          JOptionPane.showMessageDialog(jOptionPane,"Done: "+ _filename);
            
        //gloabl try catch    
        } catch (Exception x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error :" + x.toString());
        }
} //end make file
  
        
        @Override
        public Void doInBackground() {
//            Random random = new Random();
//            int progress = 0;
//            //Initialize progress property.
//            setProgress(0);
//            while (progress < 100) {
//                //Sleep for up to one second.
//                try {
//                    Thread.sleep(random.nextInt(1000));
//                } catch (InterruptedException ignore) {}
//                //Make random progress.
//                progress += random.nextInt(10);
//                setProgress(Math.min(progress, 100));
//            }
             jButton_doit.setEnabled(false);
             jProgressBar.setIndeterminate(true);
           MakeJMPfileTask();
             jProgressBar.setIndeterminate(false);
             jButton_doit.setEnabled(true);
             
            return null;
        }
 
        /*
         * Executed in event dispatching thread
         */
//        @Override
//        public void done() {
//            Toolkit.getDefaultToolkit().beep();
//            startButton.setEnabled(true);
//            setCursor(null); //turn off the wait cursor
//            taskOutput.append("Done!\n");
//        }
    } //end swingworker task class
    
   

    
//private void MakeJMPfile(){
//       
//    //check to see if all the text fields are file paths, exception thrown from method        
//         if (checkFile(flashBox.getText()) == false) { 
//             JOptionPane.showMessageDialog(jOptionPane,"Flash file not entered");
//             return; //exit 
//         }      
//         if (checkFile(LabelBox.getText()) == false) { 
//             JOptionPane.showMessageDialog(jOptionPane,"Label file not entered");
//             return; //exit 
//         }
//         if (checkDirectory(OutpathBox.getText()) == false) { 
//             JOptionPane.showMessageDialog(jOptionPane,"Output directory is bullshit");
//             return; //exit 
//         }
//         if (ckTreatment.isSelected() == true) {  //measurment file is an option
//            if (checkFile(MeasureBox.getText()) == false) { 
//             JOptionPane.showMessageDialog(jOptionPane,"Measurement file not entered");
//             return; //exit 
//            }  
//         }
//         
//     //check to make sure the intervals are integers,I save them so they dont need to be converted each time
//        int FlashInt = 5;
//        int TreatInt = 5;
//        int TimeBetween = 5;
//        int LastTimeCount = 60;
//        //flash interval is mandatory
//        try { FlashInt = Integer.parseInt(FlashIntBox.getText()); }
//        catch (NumberFormatException x) { 
//            JOptionPane.showMessageDialog(jOptionPane,"Flash Interval is not a number");
//            return; }
//        //if treatment file exists
//        if (ckTreatment.isSelected() == true) {
//          try { TreatInt = Integer.parseInt(TreatIntBox.getText()); }
//        catch (NumberFormatException x) { 
//            JOptionPane.showMessageDialog(jOptionPane,"Treatment Interval is not a number");
//            return; }
//          try { TimeBetween = Integer.parseInt(TimeBetweenBox.getText()); }
//        catch (NumberFormatException x) { 
//            JOptionPane.showMessageDialog(jOptionPane,"Time Between Interval is not a number");
//            return; }
//        }
//        
//        
//        
//     //read in the labels
//        HashMap<String, HashMap<String,String>> prop_hash = new HashMap<String, HashMap<String,String>>();
//        ArrayList<String> SubProperties = new ArrayList<String>();
//        //final Charset ENCODING = StandardCharsets.UTF_8;
//        //get labels from file        
//        testgui1.ParseLabels pL = new testgui1.ParseLabels(LabelBox.getText());
//        try {
//             pL.makeHashs();
//             prop_hash = pL.hash_labels;
//             SubProperties = pL.properties;
//            }
//        catch (IOException x) {
//            JOptionPane.showMessageDialog(jOptionPane,"Error reading labels: " + x.toString());
//            //jump out of rest of the code 
//            return;
//            }        
//        
//        
//      //** BEGIN WITH FLSH FILE make outputfile **//
//      try  { //try catch for all things not caught?
//        Path path = Paths.get(flashBox.getText()).getFileName();        
//        String name = path.getFileName().toString();
//        int pos = name.lastIndexOf(".");
//        if (pos > 0) { name = name.substring(0, pos); }
//        //Path path = Paths.get(OutpathBox.getText() + File.separator + name + "_JMPinput.txt");
//        //open the file
//        
//            FileWriter writer = null;
//            String _filename = OutpathBox.getText() + File.separator + name + "_JMPinput.txt";
//            writer = new FileWriter(_filename);
//            
//        /*write out header to file
//                        """
//                        Set up OUTPUT
//                        Time; well, Row, Col,*PROPERTIES*,FLASH, Luc Activity 
//                        """
//                        outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t')
//        */
//            writer.write("Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t");
//            Set<String> _keys = prop_hash.keySet();
//            for(String _key : _keys){
//             Set<String> _subkeys = prop_hash.get(_key).keySet();
//               for (String _skey : _subkeys) {
//                  writer.write(_skey + "\t");
//               }
//               break; //once is enough
//             }
//           writer.write("\n");
//           writer.flush();
//            
//            
//       //do conversion of:
//        //Flash file first
//            path = null;
//            int TimeCount = 0;
//            Scanner s = null;
//            FileReader inputStream = null;
//            path = Paths.get(flashBox.getText());
//            ArrayList<String> MeasureBreak = new ArrayList<String>();
//           
//           //datafile is broken at Measurments 
//            try {
//            s = new Scanner(path);            
//            Pattern pattern = Pattern.compile("Measurement");
//            s.useDelimiter(pattern);
//            while (s.hasNext()) { MeasureBreak.add(s.next().toString());  }
//            } finally {
//             if (s != null) { s.close(); }
//            }   
//            
//            
//           
//          Pattern pattern = Pattern.compile("count:[^0-9]([0-9]+)[^0-9]");  //fuck double escape shit
//          try {
//             //now flash file, process each line, first catching the time 
//             for (String _s : MeasureBreak) {
//              String[] mblock;
//              List<List<String>> mes_blocks = new ArrayList<List<String>>();
//              
//                 mblock = _s.split("\n"); 
//                 Matcher m = pattern.matcher(mblock[0]);
//                 while (m.find()) {
//                     TimeCount = Integer.parseInt(m.group(1));
//                     break; //there should only be one, but....
//                 }
//                 
//                 
//                 mes_blocks.clear();                 
//                 for (int i=1;i<mblock.length;i++) {
//                     List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));                     
//                     mes_blocks.add(_list);
//                 }  
//                 
//                 
//                    //match and output
//               for (int y=1; y <mes_blocks.size(); y++){ //header is only col numbers
//                   for (int x=1; x < mes_blocks.get(0).size(); x++) { //data starts on 1
//                       String tx;
//                       tx = mes_blocks.get(y).get(0)+ mes_blocks.get(0).get(x);
//                        //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
//                        writer.write(Integer.toString(TimeCount * FlashInt));
//                        writer.write("\t" + tx + "\t" + mes_blocks.get(y).get(0) + "\t" + mes_blocks.get(0).get(x));
//                        writer.write("\t" + mes_blocks.get(y).get(x));
//                        writer.write("\ty\t"); //flash is YES
//                            //Set<String> _subkeys = prop_hash.get(tx).keySet();
//                            for (String _skey : SubProperties) {
//                                     writer.write(prop_hash.get(tx).get(_skey) + "\t");
//                            }
//                       writer.write("\n");
//                       writer.flush();
//                   }  
//               }  //output mes_blocks flash
//             }  //for each flash measurment
//          } //try block close for flash file
//          catch (Exception e) {  //this should catch whatever shit happens
//              writer.close();
//               JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
//          }
//         //*** END FLASH FILE ***//
//         //****************************//
//         //** now treatment file if present/chosen **/
//         if (ckTreatment.isSelected() == true) {   
//             LastTimeCount = TimeCount * FlashInt;
//             
//           //do conversion of:
//            //Measruement file , reset variables
//                path = null;
//                //int TimeCount = 0;
//                s = null;
//                inputStream = null;
//                path = Paths.get(MeasureBox.getText());
//                MeasureBreak.clear();
//
//               //datafile is broken at Measurments 
//                try {
//                s = new Scanner(path);            
//                pattern = Pattern.compile("Measurement");
//                s.useDelimiter(pattern);
//                while (s.hasNext()) { MeasureBreak.add(s.next().toString());  }
//                } finally {
//                 if (s != null) { s.close(); }
//                }   
//                
//              pattern = Pattern.compile("count:[^0-9]([0-9]+)[^0-9]");  //fuck double escape shit
//              try {
//                 //now flash file, process each line, first catching the time 
//                 for (String _s : MeasureBreak) {
//                  String[] mblock;
//                  List<List<String>> mes_blocks = new ArrayList<List<String>>();
//
//                     mblock = _s.split("\n"); 
//                     Matcher m = pattern.matcher(mblock[0]);
//                     while (m.find()) {
//                         TimeCount = Integer.parseInt(m.group(1));
//                         break; //there should only be one, but....
//                     }
//
//
//                     mes_blocks.clear();                 
//                     for (int i=1;i<mblock.length;i++) {
//                         List<String> _list = Arrays.asList(mblock[i].split("[ \\t\\n\\x0B\\f\\r]"));                     
//                         mes_blocks.add(_list);
//                     }  
//
//
//                        //match and output
//                   for (int y=1; y <mes_blocks.size(); y++){ //header is only col numbers
//                       for (int x=1; x < mes_blocks.get(0).size(); x++) { //data starts on 1
//                           String tx;
//                           tx = mes_blocks.get(y).get(0)+ mes_blocks.get(0).get(x);
//                            //outputf.write('Time[min]\tWell\tRow\tCol\tLuc.Act.\tFLASH\t') + properties!!
//                            writer.write(Integer.toString((TimeCount * TreatInt)+LastTimeCount+TimeBetween));
//                            writer.write("\t" + tx + "\t" + mes_blocks.get(y).get(0) + "\t" + mes_blocks.get(0).get(x));
//                            writer.write("\t" + mes_blocks.get(y).get(x));
//                            writer.write("\tn\t"); //flash is NO
//                                //Set<String> _subkeys = prop_hash.get(tx).keySet();
//                                for (String _skey : SubProperties) {
//                                         writer.write(prop_hash.get(tx).get(_skey) + "\t");
//                                }
//                           writer.write("\n");
//                           writer.flush();
//                       }  
//                   }  //output mes_blocks flash
//                 }  //for each flash measurment
//              } //try block close for measeurment file
//              catch (Exception e) {  //this should catch whatever shit happens
//                  writer.close();
//                   JOptionPane.showMessageDialog(jOptionPane,"Unknown error: " + e.toString());
//              } 
//                    
//                
//            } //if then: measurment file 
//            
//  
//        //tell user you are done and what the file is    
//          writer.close();
//          JOptionPane.showMessageDialog(jOptionPane,"Done: "+ _filename);
//            
//        //gloabl try catch    
//        } catch (Exception x) {
//            JOptionPane.showMessageDialog(jOptionPane,"Error :" + x.toString());
//        }
//} //end make file, orginal version (i think) before moving into the Threaded versions
    
    
    private boolean checkFile(String _string) throws SecurityException {
        File file =null;
        file = new File(_string);
        try  {
            if (file.isFile() == true) { return true; } else { return false; }
        } catch (SecurityException x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error reading file: " + _string + "\n" + x.toString());
            return false;
        }
    }
    
        private boolean checkDirectory(String _string) throws SecurityException {
        File file =null;
        file = new File(_string);
        try  {
            if (file.isDirectory() == true) { return true; } else { return false; }
        } catch (SecurityException x) {
            JOptionPane.showMessageDialog(jOptionPane,"Output Directory wrong?: " + x.toString());
            return false;
        }
    }
    
        

        
        
    // this will run the code: make a JMP ready file from LUC measurments
    private void jButton_doitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_doitActionPerformed
       
        /*
         * cosmetic stuff for user, progress bar and disable button and make curor change
         */
       
        //startButton.setEnabled(false);
        //setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    
//        SwingUtilities.invokeLater(new Runnable() {
//       public void run() {
//          jProgressBar.setIndeterminate(true);
//          }
//       });
        
      // MakeJMPfile();
       
//       SwingUtilities.invokeLater(new Runnable() {
//       public void run() {
//      MakeJMPfile();
//      }
//       }); 
          
       //  jProgressBar.setIndeterminate(true);

         
        /*
         * with subclass inheriting Thread, worked as well, I think. Sub commented out.
         */
//         HelloThread _makejmpfile = new HelloThread();
//         //_makejmpfile.setPriority(6);
//        _makejmpfile.run();
        
        
        /*
       //MakeJMPfile(); //runs without calling new thread, is now commented out to reduce confusion
       */
        
        
        //SwingWorker solution seemed to be the optimal choice
        if (rbt_AscentFL.isSelected() == true) {
               Task_AscentFL task = new Task_AscentFL(); //the progress bar has to be set there, in a new thread, in order not to block the API/GUI
               task.execute();
        }    
         else if (rbt_WinSkan.isSelected() == true) {
               Task_WinMikro task = new Task_WinMikro(); //the progress bar has to be set there, in a new thread, in order not to block the API/GUI
               task.execute();
        }
        else if (rbt_TECAN.isSelected() == true) {
               Task_TecanSaffaire task = new Task_TecanSaffaire(); //the progress bar has to be set there, in a new thread, in order not to block the API/GUI
               task.execute();
        }

        // jProgressBar.setIndeterminate(false); //this did not work, the API was blocked during computation and runs after the block is finished. therfore you need a new thread
        
       //June2017 just in case, lets call the garbage collection, I am not sure why, but when I change a file on the PC, it is not reloaded as it should be
       //somehow it keeps taking a copy from memory.
        System.gc();
    }//GEN-LAST:event_jButton_doitActionPerformed

    private void flashBoxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_flashBoxMouseClicked
        // TODO add your handling code here:
      int returnVal = JFileChooser.showOpenDialog(this);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
        
        File file = JFileChooser.getSelectedFile();
         flashBox.setText(file.getAbsolutePath());
    }//GEN-LAST:event_flashBoxMouseClicked
    }
    
    private void MeasureBoxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_MeasureBoxMouseClicked
        // TODO add your handling code here:
        
   int returnVal = JFileChooser.showOpenDialog(this);
    if (returnVal == JFileChooser.APPROVE_OPTION) 
    {
        File file = JFileChooser.getSelectedFile();
        MeasureBox.setText(file.getAbsolutePath());
    }//GEN-LAST:event_MeasureBoxMouseClicked
    }
        
    private void LabelBoxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_LabelBoxMouseClicked
        // TODO add your handling code here:
           int returnVal = JFileChooser.showOpenDialog(this);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
        File file = JFileChooser.getSelectedFile();
         LabelBox.setText(file.getAbsolutePath());
    }
    }//GEN-LAST:event_LabelBoxMouseClicked

    private void OutpathBoxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_OutpathBoxMouseClicked
        // TODO add your handling code here:
        JFileChooser fileChooser = new JFileChooser();                
        fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        
    int returnVal = fileChooser.showOpenDialog(this);
    if (returnVal == fileChooser.APPROVE_OPTION) {
        File file = fileChooser.getSelectedFile();
         OutpathBox.setText(file.getAbsolutePath());
    } 
    }//GEN-LAST:event_OutpathBoxMouseClicked

      
    private void flashBoxMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_flashBoxMouseReleased
        /*
         * both solutions worked here, one, pass to handler object and othet to DropTarget
         * DropTarget is better as you can not pass an object with the Handler  - as far as I undetrstand it.
         */
//    flashBox.setTransferHandler(fb_handler);
//    
//    flashBox.setDropTarget(new DropTarget() {
//    public synchronized void drop(DropTargetDropEvent evt) {
//        try {
//            evt.acceptDrop(DnDConstants.ACTION_COPY);
//            List<File> droppedFiles = (List<File>)
//                evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
//            for (File file : droppedFiles) {
//                // process files
//                flashBox.setText(file.toString());
//                break;
//            }
//        } catch (Exception ex) {
//            ex.printStackTrace();
//        }
//    }
//});
    }//GEN-LAST:event_flashBoxMouseReleased

    private void flashBoxMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_flashBoxMouseEntered
        // TODO add your handling code here:
       //  flashBox.setTransferHandler(fb_handler);
    flashBox.setDropTarget(new DropTarget() {
    public synchronized void drop(DropTargetDropEvent evt) {
        try {
            evt.acceptDrop(DnDConstants.ACTION_COPY);
            List<File> droppedFiles = (List<File>)
                evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            for (File file : droppedFiles) {
                // process files
                flashBox.setText(file.toString());
                break;
            }
        } catch (Exception x) {
           JOptionPane.showMessageDialog(jOptionPane,"Error writing output file:" + x.toString());
        }
    }
});
    }//GEN-LAST:event_flashBoxMouseEntered

    private void MeasureBoxMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_MeasureBoxMouseEntered
        // TODO add your handling code here:
         MeasureBox.setDropTarget(new DropTarget() {
    public synchronized void drop(DropTargetDropEvent evt) {
        try {
            evt.acceptDrop(DnDConstants.ACTION_COPY);
            List<File> droppedFiles = (List<File>)
                evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            for (File file : droppedFiles) {
                // process files
                MeasureBox.setText(file.toString());
                break;
            }
        } catch (Exception x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error writing output file:" + x.toString());
        }
    }
});
    }//GEN-LAST:event_MeasureBoxMouseEntered

    private void LabelBoxMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_LabelBoxMouseEntered
     LabelBox.setDropTarget(new DropTarget() {
    public synchronized void drop(DropTargetDropEvent evt) {
        try {
            evt.acceptDrop(DnDConstants.ACTION_COPY);
            List<File> droppedFiles = (List<File>)
                evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            for (File file : droppedFiles) {
                // process files
                LabelBox.setText(file.toString());
                break;
            }
        } catch (Exception x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error writing output file:" + x.toString());
        }
    }
});
    }//GEN-LAST:event_LabelBoxMouseEntered

    private void OutpathBoxMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_OutpathBoxMouseEntered
      OutpathBox.setDropTarget(new DropTarget() {
    public synchronized void drop(DropTargetDropEvent evt) {
        try {
            evt.acceptDrop(DnDConstants.ACTION_COPY);
            List<File> droppedFiles = (List<File>)
                evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            for (File file : droppedFiles) {
                // process files
                OutpathBox.setText(file.toString());
                break;
            }
        } catch (Exception x) {
            JOptionPane.showMessageDialog(jOptionPane,"Error writing output file:" + x.toString());
        }
    }
});
    }//GEN-LAST:event_OutpathBoxMouseEntered

    private void lblAboutMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblAboutMouseClicked
        Gpl license = new Gpl();
        //JOptionPane.showMessageDialog(jOptionPane,license.Text);
        
        JTextArea textArea = new JTextArea(license.Text);
        JScrollPane scrollPane = new JScrollPane(textArea);  
        textArea.setLineWrap(true);  
        textArea.setWrapStyleWord(true); 
        scrollPane.setPreferredSize( new Dimension( 500, 500 ) );
        JOptionPane.showMessageDialog(null, scrollPane);
    }//GEN-LAST:event_lblAboutMouseClicked

    
    
    private void rbt_AscentFLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbt_AscentFLActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_rbt_AscentFLActionPerformed

    private void rbt_TECANActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rbt_TECANActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_rbt_TECANActionPerformed
    
    
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(NewJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(NewJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(NewJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(NewJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>       

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new NewJFrame().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField FlashIntBox;
    private javax.swing.JFileChooser JFileChooser;
    private javax.swing.JTextField LabelBox;
    private javax.swing.JTextField MeasureBox;
    private javax.swing.JTextField OutpathBox;
    private javax.swing.JTextField TimeBetweenBox;
    private javax.swing.JTextField TreatIntBox;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.ButtonGroup buttonGroup3;
    private javax.swing.JCheckBox ckTreatment;
    private javax.swing.JTextField flashBox;
    private javax.swing.JButton jButton_doit;
    private javax.swing.JLabel jLabel_destination;
    private javax.swing.JLabel jLabel_flash;
    private javax.swing.JLabel jLabel_flsInt;
    private javax.swing.JLabel jLabel_labels;
    private javax.swing.JLabel jLabel_measure;
    private javax.swing.JLabel jLabel_plateReader;
    private javax.swing.JLabel jLabel_timebtw;
    private javax.swing.JLabel jLabel_trtInt;
    private javax.swing.JOptionPane jOptionPane;
    private javax.swing.JProgressBar jProgressBar;
    private javax.swing.JLabel lblAbout;
    private javax.swing.JRadioButton rbt_AscentFL;
    private javax.swing.JRadioButton rbt_TECAN;
    private javax.swing.JRadioButton rbt_WinSkan;
    // End of variables declaration//GEN-END:variables
}
