% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_forest.R
\name{predict.causal_forest}
\alias{predict.causal_forest}
\title{Predict with a causal forest}
\usage{
\method{predict}{causal_forest}(object, newdata = NULL,
  num.threads = NULL, estimate.variance = FALSE, ...)
}
\arguments{
\item{object}{The trained forest.}

\item{newdata}{Points at which predictions should be made. If NULL,
makes out-of-bag predictions on the training set instead
(i.e., provides predictions at Xi using only trees that did
not use the i-th training example).}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{estimate.variance}{Whether variance estimates for hat{tau}(x) are desired
(for confidence intervals).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Vector of predictions, along with (optional) variance estimates.
}
\description{
Gets estimates of tau(x) using a trained causal forest.
}
\examples{
\dontrun{
# Train a causal forest.
n = 100; p = 10
X = matrix(rnorm(n*p), n, p)
W = rbinom(n, 1, 0.5)
Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)
c.forest = causal_forest(X, Y, W)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
c.pred = predict(c.forest, X.test)

# Predict on out-of-bag training samples.
c.pred = predict(c.forest)

# Predict with confidence intervals; growing more trees is now recommended.
c.forest = causal_forest(X, Y, W, num.trees = 500)
c.pred = predict(c.forest, X.test, estimate.variance = TRUE)
}

}
