% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_forest.R
\name{quantile_forest}
\alias{quantile_forest}
\title{Quantile forest}
\usage{
quantile_forest(X, Y, quantiles = c(0.1, 0.5, 0.9), sample.fraction = 0.5,
  mtry = ceiling(2 * ncol(X)/3), num.trees = 2000, num.threads = NULL,
  min.node.size = NULL, seed = NULL, alpha = 0.05, honesty = TRUE)
}
\arguments{
\item{X}{The covariates used in the quantile regression.}

\item{Y}{The outcome.}

\item{quantiles}{Vector of quantiles used to calibrate the forest.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty is used, these subsamples will
further be cut in half.}

\item{mtry}{Number of variables tried for each split.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{min.node.size}{Minimum number of observations in each tree leaf.}

\item{seed}{The seed of the c++ random number generator.}

\item{alpha}{Maximum imbalance of a split.}

\item{honesty}{Should honest splitting (i.e., sub-sample splitting) be used?}
}
\value{
A trained quantile forest object.
}
\description{
Trains a regression forest that can be used to estimate
quantiles of the conditional distribution of Y given X = x.
}
