import os
import types


class Folders:

	
	

	def __init__(self):
		"""upon loading, it reads a text file containing the folder defaults. IF there is not a
		 text file present, the defaults will be set and a new text file written.
		 format = ROOTFOLDER:path_of_home_folder
		"""
		self.settings = {}  
		self.settingsfolder = os.environ['HOMEDRIVE'] + os.environ['HOMEPATH'] + os.sep + 'Motif-Mapper'
		self.rootfolder = os.environ['HOMEDRIVE'] + os.environ['HOMEPATH'] + os.sep + 'Motif-Mapper'


		r = self.loadDefaultsFromFile()
		print r
		if r == 0:
			self.makeDefaults()
		
		

	def __str__(self):

		for k in self.settings.items():
			print k
		
		return '-end of settings-'



	def makeDirectory(self, _path):
		"""this will add a path. the truncate option (from the left) is added for reading
		 from the settings file which carries a leadstring. See loadDefaultsFromFile.
		"""

		if not os.path.exists(_path):
			try:
				
				os.makedirs(_path)  
				return 1

			except IOError, e:
				print e
				return 0
		else:
			return 1
		


	def loadDefaultsFromFile(self):
		"""this will load the settings file from the folder where this module is called.
		 it is intended to hold settings for the user, to set the root folder location.
  		 the default location will be under the users HOMEPATH on the local machine
		"""
		try:
			if os.path.exists(self.settingsfolder + os.sep + "mm_settings.txt"):
				f = open(self.settingsfolder + os.sep + "mm_settings.txt") #default is read-only


				#process information, if failed for anyreason - use defaults
				for line in f:
					pos = line.find('ROOTFOLDER:')
					if pos > -1:
											
						if self.makeDirectory(line[pos+11:-1]) == 1:
							self.settings['ROOTFOLDER'] = line[11:-1] # 0+len('HOMEPATH')+1
							self.rootfolder = self.settings['ROOTFOLDER']
						else:
							print "failed to set folder"
							return 0			#assume file is corrupt
						

				f.close()
				return 1
			else:
				return 0
		except IOError, e:
			print "ERROR ENCOUNTERED: " + e
			return 0
			


	def makeDefaults(self):
		"""called by __init__ to set defaults
		"""

		self.makeDirectory(self.settingsfolder)
		f = open(self.settingsfolder + os.sep + "mm_settings.txt", 'w') #for writing, previous file, if exists will be erased
		
		#write ROOTFOLDER path
		self.settings['ROOTFOLDER'] = self.rootfolder
		f.write("ROOTFOLDER:" + self.settings['ROOTFOLDER'] + "\n")
		
		f.close()

	

	def saveDefaults(self):
		"""this can be called by the user to save any changes they may have made. The correct format
		was already given by makeDefaults during initilization.
		"""
		
		f = open(self.settingsfolder + os.sep + "mm_settings.txt", 'w') #for writing, previous file, if exists will be erased

		for k in self.settings.items():
			f.write(k[0] + ':' +  k[1] + "\n")	

		f.close()
	

	def makeFilelist(self, manual=0, dir = ''):
		"""this will make a list of path names either all from a folder (dir), manual=0
		or manually typed in, manual=1
		"""

		_files = []

		if manual != 1 and manual != 0:
			raise ValueError, "manual option is either 0 (all files from folder) or 1 (typed in)"

		if manual == 0 and dir == '':
			raise ValueError, "the manual option requires a directory path" 

		if manual == 0:
			try:
				_files = os.listdir(dir)
				print str(len(_files)) + " files in list"
			except IOError, e:
				print e

		else:
			ipt = ''	
			while ipt != 'q':
				ipt = raw_input("Enter a full file path. Enter 'q' to quit.\n")

				if os.path.exists(ipt):
					_files.append(ipt)

		


		return _files

