﻿using UnityEngine;
using System.Collections;
/// <summary>
/// This class serves as Userinterface to provide input to the motors.
/// You can change the values of the sliders to change the vibration strength.
/// The actual sending is performed in the ArduinoConnector-Script.
/// </summary>
public class SliderGUI : MonoBehaviour
{

    public float vSliderValue1 = 0.0F;
    public float vSliderValue2 = 0.0F;
    public float vSliderValue3 = 0.0F;
    public float vSliderValue4 = 0.0F;
    public float vSliderValue5 = 0.0F;

    private GUIStyle style = new GUIStyle();

    void Start()
    {
        this.style.alignment = TextAnchor.MiddleCenter;
    }

    void OnGUI()
    {
        float worldScreenHeight = Screen.height;
        float worldScreenWidth = Screen.width;

        float xAnchor = worldScreenWidth / 7.0f;
        float sliderWidth = worldScreenWidth / 6.0f;
        float sliderOffset = worldScreenHeight * .05f;
        float sliderHeight = worldScreenHeight * .90f;

        vSliderValue1 = GUI.VerticalSlider(new Rect(xAnchor * 2.0f - sliderWidth * .5f, sliderOffset, sliderWidth, sliderHeight), vSliderValue1, 255.0F, 0.0F);
        vSliderValue2 = GUI.VerticalSlider(new Rect(xAnchor * 3.0f - sliderWidth * .5f, sliderOffset, sliderWidth, sliderHeight), vSliderValue2, 255.0F, 0.0F);
        vSliderValue3 = GUI.VerticalSlider(new Rect(xAnchor * 4.0f - sliderWidth * .5f, sliderOffset, sliderWidth, sliderHeight), vSliderValue3, 255.0F, 0.0F);
        vSliderValue4 = GUI.VerticalSlider(new Rect(xAnchor * 5.0f - sliderWidth * .5f, sliderOffset, sliderWidth, sliderHeight), vSliderValue4, 255.0F, 0.0F);
        vSliderValue5 = GUI.VerticalSlider(new Rect(xAnchor * 6.0f - sliderWidth * .5f, sliderOffset, sliderWidth, sliderHeight), vSliderValue5, 255.0F, 0.0F);

        GUI.Box(new Rect(xAnchor * 2.0f - sliderWidth, sliderOffset * .5f, sliderWidth, sliderOffset * .5f), "PWM  5", style);
        GUI.Box(new Rect(xAnchor * 3.0f - sliderWidth, sliderOffset * .5f, sliderWidth, sliderOffset * .5f), "PWM  6", style);
        GUI.Box(new Rect(xAnchor * 4.0f - sliderWidth, sliderOffset * .5f, sliderWidth, sliderOffset * .5f), "PWM  9", style);
        GUI.Box(new Rect(xAnchor * 5.0f - sliderWidth, sliderOffset * .5f, sliderWidth, sliderOffset * .5f), "PWM 10", style);
        GUI.Box(new Rect(xAnchor * 6.0f - sliderWidth, sliderOffset * .5f, sliderWidth, sliderOffset * .5f), "PWM  3", style);
    }
}
