function displayPoolError(cluster, job)

% Copyright 2013-2015 The MathWorks, Inc.
% Raymond S. Norris (raymond.norris@mathworks.com)

CR = 10;
TAB = 9;

v = ver('matlab');
labs = num2str(numel(job.Tasks));
if str2double(v.Version)<8.2
    poolOpt = 'matlabpool';
    poolCmd = ['>> matlabpool open ' cluster.Profile ' ' labs ')'];
else
    poolOpt = 'pool';
    poolCmd = ['>> parpool(''' cluster.Profile ''',' labs ')'];
end

emsg = [CR CR '****************************************************' ...
        ...
        CR cluster.Profile ' does not support calling' ...
        CR CR TAB poolCmd ...
        CR CR 'Instead, use batch()' ...
        CR CR TAB '>> job = batch(...,''' poolOpt ''',' labs ');' ...
        CR CR 'Call' ...
        CR CR TAB '>> doc batch' ...
        CR CR 'for more help on using batch.' ...
           CR '****************************************************' ...
        ...
        ];
error(emsg)
