#############
# Example of code use
#############
# The opra_composition.py file, i.e., module, should be accessible to python,
# for example, in the same folder
import opra_composition as opra

#Setting the granularity OPRAm
m = 1

# Generating triads
i = 0
print("Turn triads of the type (", i ,", j, k) for m =", m, " ", opra.turn(m,i))
print("")

# Calculating composition
rAB=(3,1)
rBC=(0,2)

ACtotal = opra.compose_opra(rAB, rBC, m, opra.triangles)

srel = ACtotal[0]
trel = ACtotal[1]
rAC = ACtotal[2] #set of compositions C is the 3rd item of Ctotal

print("Composition: ", rAB, " o ", rBC, " = ", rAC)
print("This composition is generated by all combinations of s = ", srel, " and t =", trel)

# Calculating composition matrix
sA = ((3,1), (0,1), (1,1), (1,2), (1,3))
sB = ((0,2), (0,), (2,0))

LengthCompositionCell = 30
LengthRelationCell = 8
FormatCompTitle = "{{:^{}}}".format(LengthCompositionCell)
FormatCompCell = "{{:<{}}}".format(LengthCompositionCell)
FormatRelCell = "{{:^{}}}".format(LengthRelationCell)

sALength = len(sA)
sBLength = len(sB)

#Printing Title Row
print(FormatRelCell.format("sA o sB"),end='')
for rBC in sB:
    print(FormatCompTitle.format(str(rBC)),end='')
  
print()    
#Printing Rows
for rAB in sA:
    print(FormatRelCell.format(str(rAB)),end='')
    for rBC in sB:
        #print(rBC)
        ACtotal = opra.compose_opra(rAB, rBC, m, opra.triangles)
        srel = ACtotal[0]
        trel = ACtotal[1]
        #rAC = ACtotal[2] #set of compositions C is the 3rd item of Ctotal
        #print("Composition: ", rAB, " o ", rBC, " = ", rAC)
        CompositionCell = "s={}, t={}".format(srel, trel)
        print(FormatCompCell.format(CompositionCell),end='')
    print()
    