/**
 * Neurons (Header)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of RNNPBlib.
 * 
 * RNNPBlib is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * RNNPBlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with RNNPBlib. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

#include "RNNPB_Definitions.h"

#include <iostream>
#include <vector>
#include <deque>
#include <math.h>
#include <cmath>
#include "RNNPB_LUT.h"
using namespace std;

#include "RNNPB_NeuronActivationTypes.h"
#include "RNNPB_Weight.h"
#include "RNNPB_NeuronLayer.h"
#include "RNNPB_Helper.h"

class RNNPB_NeuronLayer;

class RNNPB_Neuron
{
	friend class RNNPB_Weight;
	friend class RNNPB_SecondOrderWeight;
	friend class RNNPB_ModulatedWeight;
	friend class RNNPB_TapDelayLineWeight;
	friend class RNNPB_NeuronLayer;
	friend class RNNPB_NetworkContainer;
	friend class RNNPB_ConstantWeight;
	friend class RNNPB_CVTrainer;

	#ifdef ENABLE_LOOKUP_TABLES
	static RNNPB_LUT lut;
	#endif

	RNNPB_NeuronLayer* neuron_layer;

	RNNPB_NetworkContainer* network;

	int parsed;


	ActivationType activationType;

	double activationSteepness;

	vector <RNNPB_Weight*> incoming_weights;
	vector <RNNPB_Weight*> outgoing_weights;

	bool isOutputNeuron;


	unsigned int iteration;


	bool constant;
	bool isRadial;


	double feedback;
	bool feedbackUptodate;
	double getFeedback();



	double input;
	bool inputUptodate;
	double getInput();

	double getRadialInput();

	void iterate();

	void clear();

protected:

	void subscribeNetwork(RNNPB_NetworkContainer* set, int run);

	RNNPB_NeuronLayer* getNeuronLayer();

	bool deltaErrorUptodate;
	double* deltaError;			//BUFFER
	double getDeltaError();

	bool activationDifferentialUptodate;
	double* activationDifferential;			//BUFFER
	double getActivationDifferential();

	double getInverseActivationOf(double output);

public:
	
	bool activationUptodate;
	double* activation;			//BUFFER
	double getActivation();


	//Error
	void setFeedback(double set_feedback);

	//"FeedForward"
	void setInput(double set_input);

	RNNPB_Neuron(RNNPB_NeuronLayer* set_neuron_layer, ActivationType set_type, double set_activation_parameter, double set_constant_activation);

	~RNNPB_Neuron();
};
