/**
 * Layer of Neurons (Header)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of RNNPBlib.
 * 
 * RNNPBlib is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * RNNPBlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with RNNPBlib. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

#include "RNNPB_Definitions.h"

#include "RNNPB_NeuronActivationTypes.h"

#include "RNNPB_Helper.h"
#include "RNNPB_Vector.h"
#include "RNNPB_Neuron.h"
#include "RNNPB_NetworkContainer.h"
#include "RNNPB_Weight.h"
#include <vector>

class RNNPB_NeuronLayer
{	
	friend class RNNPB_NetworkContainer;
	friend class RNNPB_CVTrainer;
	friend class RNNPB_Weight;
	friend class RNNPB_SecondOrderWeight;
	friend struct RNNPB_AssemblyTools;
	
protected:

	vector <RNNPB_Neuron*> neuron;

	RNNPB_Vector swapWeights();

	int parsed;
	void parseNetwork(RNNPB_NetworkContainer* parent, int run);

public:

	unsigned int size();

	void setConstant(bool set);

	void setOutgoingWeightsConstant(bool set);

	RNNPB_Vector getActivation();

	RNNPB_Vector getInput();	//Not used by RNNPB-Framework!

	RNNPB_NetworkContainer* getNetwork();

	void setInput(RNNPB_Vector set_input);

	void setFeedback(RNNPB_Vector set_input);

	RNNPB_NeuronLayer(unsigned int size, ActivationType set_type = Linear, double setActivationParameter = 0.0, double set_constant_activation = 0.0);
};
