############### Automated Colorimetric Assay ###############
############### ShinyR Fork                  ###############
###### V. 0.04
###### Stefan Bieker & Justine Bresson
###### Bresson et al. (2017) JXB
###### Only for non-commercial use
###### https://www.uni-tuebingen.de/fakultaeten/mathematisch-naturwissenschaftliche-fakultaet/fachbereiche/zentren/zmbp/gen-genetics/research-groups/zentgraf.html
###### Contact: ulrike.zentgraf@zmbp.uni-tuebingen.de
######          stefan.bieker@zmbp.uni-tuebingen.de
######          justine.bresson@zmbp.uni-tuebingen.de


library(shiny)
library(imager)
library(tidyr)
library(dplyr)
library(stringr)
library(ggplot2)
library(svglite)

aca <- function(files,control,sess){
  count <- as.numeric(nrow(files))
  results <- data.frame(Line = character(count), 
                        Plant = numeric(count), 
                        Leaf = numeric(count), 
                        WAS = numeric(count), 
                        PercentGreen = numeric(count),
                        PercentGreenYellow = numeric(count),
                        PercentYellow =numeric(count), 
                        PercentBrown = numeric(count), 
                        PercentPurple = numeric(count),
                        PercentUnknown = numeric(count),
                        Filename = character(count), 
                        Total = numeric(count), 
                        BG = numeric(count), 
                        Green = numeric(count), 
                        GreenYellow = numeric(count), 
                        Yellow = numeric(count), 
                        Brown=numeric(count), 
                        Unknown = numeric(count), 
                        Purple = numeric(count),
                        stringsAsFactors = FALSE)
  
  if (control == FALSE){
  for (i in 1:nrow(files)) {
    imagerHSV <- load.image(files[i,4])
    imagerHSV <- RGBtoHSV(imagerHSV)
    ####################################
    # Insert File Info Extraction here #
    ####################################
    results$Filename[i] <- as.character(files[i,1])
    results$Line[i] <- substr(files[i,1], 6, regexpr(" -", files[i,1])[1] - 1)
    results$Plant[i] <- substr(files[i,1], regexpr("Plant ", files[i,1])[1] + 6, regexpr(" - WAS",files[i,1])[1] - 1)
    results$Leaf[i] <- substr(files[i,1], regexpr("Leaf ", files[i,1])[1] + 5, regexpr(".png", files[i,1])[1] - 1)
    results$WAS[i] <- substr(files[i,1], regexpr("WAS ", files[i,1])[1] + 4, regexpr(" - Leaf", files[i,1])[1])
    
    
    tempBG <- which(imagerHSV[,,1,2] <= 0.1|imagerHSV[,,1,3] <= 0.15)
    tempGY <- which((is.element(round(imagerHSV[,,1,1]), 45:69) & imagerHSV[,,1,3] <= 0.65) &
                      (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    tempDG <- which(is.element(round(imagerHSV[,,1,1]), 70:180) & 
                      (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    tempY <- which((is.element(round(imagerHSV[,,1,1]), 45:69) & imagerHSV[,,1,3] > 0.65) &
                     (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    tempB <- which(is.element(round(imagerHSV[,,1,1]), 0:44) & 
                     (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    tempP <- which(is.element(round(imagerHSV[,,1,1]), 260:360)&
                     (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    
    tempall <- which(is.element(round(imagerHSV[,,1,1]),0:360))
    tempallcolors <- c(tempBG, tempB, tempDG, tempGY, tempY, tempP)
    tempunknown <- which(!is.element(tempall, tempallcolors))   
    
    results$Total[i] <- (nrow(imagerHSV)*ncol(imagerHSV))
    results$BG[i] <- length(tempBG)
    results$GreenYellow[i] <- length(tempGY)
    results$Green[i] <- length(tempDG)
    results$Yellow[i] <- length(tempY)
    results$Brown[i] <- length(tempB)
    results$Unknown[i] <- length(tempunknown)
    results$Purple[i] <- length(tempP)
    results$WOBG[i] <- length(tempall) - length(tempBG)
    incProgress(1/nrow(files), detail = paste("Processing Image ", i, "of ", nrow(files)))
  }
  } else
  {dir.create(file.path(paste(getwd(), "/Userdata/",sess,sep="")))
   dir.create(file.path(paste(getwd(), "/Userdata/",sess,"/Control",sep="")))
    
    for (i in 1:nrow(files)) {
    imagerHSV <- load.image(files[i,4])
    imagerHSV <- RGBtoHSV(imagerHSV)
    
    ####################################
    # Insert File Info Extraction here #
    ####################################
    results$Filename[i] <- as.character(files[i,1])
    results$Line[i] <- substr(files[i,1], 6, regexpr(" -", files[i,1])[1] - 1)
    results$Plant[i] <- substr(files[i,1], regexpr("Plant ", files[i,1])[1] + 6, regexpr(" - WAS",files[i,1])[1] - 1)
    results$Leaf[i] <- substr(files[i,1], regexpr("Leaf ", files[i,1])[1] + 5, regexpr(".png", files[i,1])[1] - 1)
    results$WAS[i] <- substr(files[i,1], regexpr("WAS ", files[i,1])[1] + 4, regexpr(" - Leaf", files[i,1])[1])
    
    
    tempBG <- which(imagerHSV[,,1,2] <= 0.1|imagerHSV[,,1,3] <= 0.15)
    tempGY <- which((is.element(round(imagerHSV[,,1,1]), 45:69) & imagerHSV[,,1,3] <= 0.65) &
                      (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    tempDG <- which(is.element(round(imagerHSV[,,1,1]), 70:180) & 
                      (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    tempY <- which((is.element(round(imagerHSV[,,1,1]), 45:69) & imagerHSV[,,1,3] > 0.65) &
                     (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    tempB <- which(is.element(round(imagerHSV[,,1,1]), 0:44) & 
                     (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    tempP <- which(is.element(round(imagerHSV[,,1,1]), 260:360)&
                     (imagerHSV[,,1,2] > 0.1 & imagerHSV[,,1,3] > 0.15))
    
    tempall <- which(is.element(round(imagerHSV[,,1,1]),0:360))
    tempallcolors <- c(tempBG, tempB, tempDG, tempGY, tempY, tempP)
    tempunknown <- which(!is.element(tempall, tempallcolors))   
    
    results$Total[i] <- (nrow(imagerHSV)*ncol(imagerHSV))
    results$BG[i] <- length(tempBG)
    results$GreenYellow[i] <- length(tempGY)
    results$Green[i] <- length(tempDG)
    results$Yellow[i] <- length(tempY)
    results$Brown[i] <- length(tempB)
    results$Unknown[i] <- length(tempunknown)
    results$Purple[i] <- length(tempP)
    results$WOBG[i] <- length(tempall) - length(tempBG)
    
    unknown <- HSVtoRGB(imagerHSV)
    unknown[tempBG] <- 5
    save.image(im = unknown, file = paste(getwd(),"/Userdata/", sess,"/Control/",substr(files[i,1],1,regexpr(".png", files[i,1])[1]-1),"background.png", sep=""))
    unknown <- HSVtoRGB(imagerHSV)
    unknown[tempGY] <- 5
    save.image(im = unknown, file = paste(getwd(),"/Userdata/", sess,"/Control/",substr(files[i,1],1,regexpr(".png", files[i,1])[1]-1),"GreenYellow.png", sep=""))
    unknown <-HSVtoRGB(imagerHSV)
    unknown[tempY] <- 5
    save.image(im = unknown, file = paste(getwd(),"/Userdata/", sess,"/Control/",substr(files[i,1],1,regexpr(".png", files[i,1])[1]-1),"yellow.png", sep=""))
    unknown <- HSVtoRGB(imagerHSV)
    unknown[tempB] <- 5
    save.image(im = unknown, file = paste(getwd(),"/Userdata/", sess,"/Control/",substr(files[i,1],1,regexpr(".png", files[i,1])[1]-1),"brown.png", sep=""))
    unknown <- HSVtoRGB(imagerHSV)
    unknown[tempDG] <- 5
    save.image(im = unknown, file = paste(getwd(),"/Userdata/", sess,"/Control/",substr(files[i,1],1,regexpr(".png", files[i,1])[1]-1),"green.png", sep=""))
    unknown <- HSVtoRGB(imagerHSV)
    unknown[tempP] <- 5
    save.image(im = unknown, file = paste(getwd(), "/Userdata/", sess,"/Control/",substr(files[i,1],1,regexpr(".png", files[i,1])[1]-1),"purple.png", sep=""))
    unknown <- HSVtoRGB(imagerHSV)
    unknown[tempunknown] <- 5 
    save.image(im = unknown, file = paste(getwd(),"/Userdata/", sess,"/Control/",substr(files[i,1],1,regexpr(".png", files[i,1])[1]-1),"unknown.png", sep=""))
    incProgress(1/nrow(files), detail = paste("Processing Image ", i, " and its control images"))
    }
    zip(zipfile = paste(getwd(),"/Userdata/",sess,"/controlimages.zip", sep=""), files = paste(getwd(),"/Userdata/",sess,"/Control/", sep="" ),flags = "-jr9X")
  }
  results$PercentGreen <- as.numeric(results$Green/(results$WOBG/100))
  results$PercentGreenYellow <- as.numeric(results$GreenYellow/(results$WOBG/100))
  results$PercentYellow <- as.numeric(results$Yellow/(results$WOBG/100))
  results$PercentBrown <- as.numeric(results$Brown/(results$WOBG/100))
  results$PercentUnknown <- as.numeric(results$Unknown/(results$WOBG/100))
  results$PercentPurple <- as.numeric(results$Purple/(results$WOBG/100))
  results$Line <- as.factor(results$Line)
  
  return(results)
}

plotter <- function(sess,form){
  cat("function executed")
  results <- read.csv(paste(getwd(),"/Userdata/",sess,"/result.csv", sep=""))
  results$WAS <- as.numeric(results$WAS)
  results$Leaf <- as.numeric(results$Leaf)
  gathereddata <- results %>% gather(key="color",value="Percent",
                                     c(PercentGreen,PercentGreenYellow,
                                       PercentYellow,PercentBrown,
                                       PercentUnknown,PercentPurple), na.rm=TRUE)
  gathereddata$color <- str_split_fixed(string = gathereddata$color, 
                                        pattern = "Percent", n=2)[,2]
  
  summarydatawholeplant <- ddply(gathereddata, c("Line", "WAS", "color"), summarise,
                                 N = length(Percent),
                                 mean = mean(Percent),
                                 sd =sd(Percent),
                                 se = sd / sqrt(N),
                                 med = median(Percent),
                                 inter = IQR(Percent),
                                 lower = quantile(Percent)[2],
                                 upper = quantile(Percent)[4],
                                 ybegin = mean - se,
                                 yend =  mean + se
  )
  
  summarydatasingleleaf <- ddply(gathereddata, c("Line", "Leaf", "WAS", "color"),summarise,
                                 N = length(Percent),
                                 mean = mean(Percent),
                                 sd =sd(Percent),
                                 se = sd / sqrt(N),
                                 med = median(Percent),
                                 inter = IQR(Percent),
                                 lower = quantile(Percent)[2],
                                 upper = quantile(Percent)[4],
                                 ybegin = mean - se,
                                 yend =  mean + se
  )
  
  summarydatasingleleaf$Leaf <- as.numeric(summarydatasingleleaf$Leaf)
  summarydatasingleleaf$Line <- as.factor(summarydatasingleleaf$Line)
  summarydatawholeplant$Line <- as.factor(summarydatawholeplant$Line)
  summarydatawholeplant$WAS <- as.factor(summarydatawholeplant$WAS)
  gathereddata$Line <- as.factor(gathereddata$Line)
  
  
  summarydatasingleleaf$color <- factor(summarydatasingleleaf$color, levels =
                                          c("Unknown","Purple","Brown",
                                            "Yellow","GreenYellow","Green"))
  summarydatawholeplant$color <- factor(summarydatawholeplant$color, levels =
                                          c("Unknown","Purple","Brown",
                                            "Yellow","GreenYellow","Green"))
  gathereddata$color <- factor(gathereddata$color, levels = 
                                 c("Unknown","Purple","Brown","Yellow",
                                   "GreenYellow","Green"))

  ####################################
  ### Plots on general information ###
  ####################################
  
  minleaf=1
  maxleaf=15
  #text.on.each.panel <-as.character("Leaf ")
  incProgress(1/5, detail = paste("Biological Replicates"))
  ggplot(data= subset(summarydatasingleleaf, is.element(summarydatasingleleaf$Leaf, 
                                                        minleaf:maxleaf)) , aes(x=WAS, y=N))+
    geom_count(stat="identity")+
    theme_bw()+
    theme(plot.title = element_text(hjust = 0.5,size=16,face="bold"),
          axis.text=element_text(size=12),
          axis.title=element_text(size=14,face="bold")) +
    scale_y_continuous(limits = c(0,(max(summarydatasingleleaf$N)+1))) +
    labs(x="Weeks after Sowing", y=expression(bold("Number Replicates")))+
    ggtitle("Biol. Replicates Leaf-Wise") +
    facet_grid(Line~Leaf, labeller = 
                 label_bquote(cols=paste("Leaf ",.(Leaf), sep="")))
  
  ggsave(paste(getwd(), "/Userdata/",sess,"/Plots/Replicates.",as.character(form),sep=""), device = as.character(form), plot=last_plot(),
         width=0.6*max(summarydatasingleleaf$Leaf)+0.5*length(levels(as.factor(summarydatasingleleaf$WAS))), 
         height=2*length(levels(summarydatasingleleaf$Line)),limitsize = FALSE)
  
  
  incProgress(1/4, detail = paste("Color percentages per leafposition"))
  attach(gathereddata)
  for (k in 1:length(levels(Line))){
    ggplot(data = subset(gathereddata, Line == levels(Line)[k]), 
           aes(x=WAS, y=Percent,group=WAS))+
      geom_boxplot(stat="boxplot")+
      labs(y="Percent Pixels")+
      ggtitle(paste("Whole Rosette ", levels(Line)[k]))+
      theme(plot.title = element_text(hjust = 0.5,size=16,face="bold"),
            axis.text=element_text(size=12),
            axis.title=element_text(size=14,face="bold")) +
      facet_wrap(~color, nrow = ceiling(length(levels(as.factor(Line)))/2))
    ggsave(paste(getwd(), "/Userdata/",sess,"/Plots/", levels(Line)[k],"-Colors_Whole_Rosette.", as.character(form),sep=""),
           plot=last_plot(),width = NA, height = NA,limitsize = FALSE)
    
    for (j in 1:length(levels(color))){
      ggplot(data = subset(gathereddata, Line == levels(Line)[k] & color == levels(color)[j]), 
             aes(x=WAS, y=Percent,group=WAS))+
        geom_boxplot(stat="boxplot")+
        labs(y="Percent Pixels")+
        ggtitle(paste(levels(color)[j], "Pixels" , levels(Line)[k]))+
        theme(plot.title = element_text(hjust = 0.5,size=16,face="bold"),
              axis.text=element_text(size=12),
              axis.title=element_text(size=14,face="bold")) +
        facet_wrap(~Leaf, labeller = label_bquote(cols=paste("Leaf ",.(Leaf), sep="")))
      ggsave(paste(getwd(), "/Userdata/",sess,"/Plots/",levels(Line)[k],"-",levels(color)[j],
                   "_Pixels_PerLeaf.",as.character(form), sep=""), device=as.character(form), width = NA, height = NA,limitsize = FALSE)
    }
  }
  detach(gathereddata)  
  
  ###################################
  ### Adjust errorbar coordinates ###
  ### for stacked barcharts       ###
  ###################################
  
  frames <- c("summarydatasingleleaf", "summarydatawholeplant")
  for (i in 1:2){
    tf <- get(frames[i])
    tf$ybegin[tf$color=="Unknown"] <- tf$ybegin[tf$color=="Unknown"] + 
      tf$mean[tf$color=="Yellow"] + 
      tf$mean[tf$color=="Green"] +
      tf$mean[tf$color=="GreenYellow"] + 
      tf$mean[tf$color=="Purple"] + 
      tf$mean[tf$color=="Brown"]
    tf$yend[tf$color=="Unknown"] <- tf$mean[tf$color=="Unknown"] + 
      tf$mean[tf$color=="Yellow"] + 
      tf$mean[tf$color=="Green"] +
      tf$mean[tf$color=="GreenYellow"] + 
      tf$mean[tf$color=="Purple"] + 
      tf$mean[tf$color=="Brown"]
    tf$ybegin[tf$color=="Purple"] <- tf$ybegin[tf$color=="Purple"] + 
      tf$mean[tf$color=="Yellow"] + 
      tf$mean[tf$color=="Brown"] + 
      tf$mean[tf$color=="Green"] +
      tf$mean[tf$color=="GreenYellow"] 
    tf$yend[tf$color=="Purple"] <- tf$mean[tf$color=="Purple"] + 
      tf$mean[tf$color=="Yellow"] + 
      tf$mean[tf$color=="Green"] +
      tf$mean[tf$color=="GreenYellow"] + 
      tf$mean[tf$color=="Brown"] 
    tf$ybegin[tf$color=="Brown"] <- tf$ybegin[tf$color=="Brown"] + 
      tf$mean[tf$color=="Yellow"] + 
      tf$mean[tf$color=="Green"] +
      tf$mean[tf$color=="GreenYellow"] 
    tf$yend[tf$color=="Brown"] <- tf$mean[tf$color=="Brown"] + 
      tf$mean[tf$color=="Yellow"]+ 
      tf$mean[tf$color=="Green"] +
      tf$mean[tf$color=="GreenYellow"]
    tf$ybegin[tf$color=="Yellow"] <- tf$ybegin[tf$color=="Yellow"]+ 
      tf$mean[tf$color=="Green"] +
      tf$mean[tf$color=="GreenYellow"]
    tf$yend[tf$color=="Yellow"] <- tf$mean[tf$color=="Yellow"] + 
      tf$mean[tf$color=="Green"] +
      tf$mean[tf$color=="GreenYellow"]
    tf$ybegin[tf$color=="GreenYellow"] <- tf$ybegin[tf$color=="GreenYellow"] +
      tf$mean[tf$color=="Green"]
    tf$yend[tf$color=="GreenYellow"] <- tf$mean[tf$color=="GreenYellow"] +
      tf$mean[tf$color=="Green"]
    tf$ybegin[tf$color=="Green"] <- tf$ybegin[tf$color=="Green"]
    tf$yend[tf$color=="Green"] <- tf$mean[tf$color=="Green"]
    assign(frames[i], tf)
  }
  
  
  ##############################
  ### Plot stacked barcharts ###
  ### PER GENOTYPE           ###
  ##############################
  incProgress(1/4, detail = paste("Stacked barcharts per Line "))
  
  for (k in 1:length(levels(summarydatasingleleaf$Line))){
    wholeplant <- subset(summarydatawholeplant, summarydatawholeplant$Line==
                           levels(summarydatawholeplant$Line)[k])
    
                   ggplot(wholeplant,aes(x=WAS, y= mean,fill=color))+
                   geom_bar(stat = "identity",color="black")+
                   scale_fill_manual(values=c("white","purple","burlywood4",
                                              "yellow","green","chartreuse4"))+
                   theme_bw()+
                   theme(plot.title = element_text(hjust = 0.5,size=16,face="bold"),
                         axis.text=element_text(size=12),
                         axis.title=element_text(size=14,face="bold")) +
                   geom_errorbar(aes(x=WAS, ymax=yend, ymin=ybegin), na.rm=TRUE,
                                 size=0.25,width=0.25)+
                   ggtitle(paste("Whole Rosette ", levels(summarydatawholeplant$Line)[k]))

                   ggsave(paste(getwd(), "/Userdata/",sess,"/Plots/",levels(summarydatawholeplant$Line)[k],"-stacked.",as.character(form),sep=""), 
                          device=as.character(form), 
                          width = NA, 
                          height = NA,
                          limitsize = FALSE,
                          plot=last_plot())
  }           
  
  ##############################
  ### Plot stacked barcharts ###
  ### ALL GENOTYPES          ###
  ##############################
  incProgress(1/4, detail = paste("Stacked barcharts per leaf and line "))
  
  minleaf <- 1
  maxleaf <- 25
  ggplot(subset(summarydatasingleleaf, is.element(summarydatasingleleaf$Leaf, 
                                                  minleaf:maxleaf)), 
         aes(x=Line, y= mean,fill=color))+
    geom_bar(stat = "identity",color="black")+
    labs(x="Leaf",y="WAS")+
    scale_fill_manual(values=c("white","purple","burlywood4",
                               "yellow","green", "chartreuse4"))+
    theme_bw()+
    theme(axis.text=element_text(size=12),
          axis.title=element_text(size=20,face="bold")) +
    geom_errorbar(aes(x=Line, ymax=yend, ymin=ybegin), na.rm=TRUE,
                  size=0.25,width=0.25)+
    facet_grid(WAS~Leaf, labeller = 
                 label_bquote(cols=paste("Leaf ",.(Leaf), sep="")))
  ggsave(paste(getwd(),"/Userdata/",sess,"/Plots/ColorLeafLineTime.",as.character(form),sep=""),device= as.character(form),
         plot=last_plot(),height = max(summarydatasingleleaf$WAS)*1.5,
         width=((maxleaf-(minleaf-1))*(1.2*length(levels(summarydatasingleleaf$Line))))
         , limitsize=FALSE)
  
}

shinyServer(
  function(input, output,session) {options(shiny.maxRequestSize=32*1024^2)
    observeEvent(input$start, {
      result <- reactive({withProgress(message="Progress: ", aca(input$PNGs,input$control,session$token))})
      output$results <- renderTable({result()})
    if (input$plots == TRUE){
      dir.create(file.path(paste(getwd(), "/Userdata/",sep="")))
      dir.create(file.path(paste(getwd(), "/Userdata/",session$token,sep="")))
      dir.create(file.path(paste(getwd(), "/Userdata/",session$token,"/Plots",sep="")))
      write.csv(result(), file = paste(getwd(),"/Userdata/",session$token,"/result.csv", sep="") , quote = FALSE, row.names = FALSE)
     withProgress(message = "Plotting", plotter(session$token,input$fileformat))
     zip(zipfile = paste(getwd(),"/Userdata/",session$token,"/plots.zip", sep=""), files = paste(getwd(),"/Userdata/",session$token,"/Plots/", sep="" ),flags = "-jr9X")
    }
    if (input$control == FALSE && input$plots == FALSE){
    output$downloadData <- downloadHandler(
      filename = function() { paste(input$experiment, '-ACA.csv', sep="") },
      content = function(file) {
        write.csv(result(), file , quote = FALSE, row.names = FALSE)
      })} else { if (input$control == TRUE && input$plots == FALSE){
        output$downloadData <- downloadHandler(
          filename = function() { paste(input$experiment, '-ACA.zip', sep="") },
          content = function(file) {
            write.csv(result(), file = paste(getwd(),"/Userdata/",session$token,"/result.csv", sep="") , quote = FALSE, row.names = FALSE)
            fs <- c(as.character(paste(getwd(),"/Userdata/",session$token,"/controlimages.zip", sep="")), as.character(paste(getwd(),"/Userdata/",session$token,"/result.csv", sep="")))
            zip(zipfile=file, files=fs, flags = "-jr9X" )
          },
          contentType = "application/zip"
          )
      } else {  if (input$control == FALSE && input$plots == TRUE){
        output$downloadData <- downloadHandler(
          filename = function() { paste(input$experiment, '-ACA.zip', sep="") },
          content = function(file) {
            fs <- c(as.character(paste(getwd(),"/Userdata/",session$token,"/plots.zip", sep="")), as.character(paste(getwd(),"/Userdata/",session$token,"/result.csv", sep="")))
            zip(zipfile=file, files=fs, flags = "-jr9X" )
          },
          contentType = "application/zip"
        )
      }
      
        else {if (input$control == TRUE && input$plots == TRUE){
          output$downloadData <- downloadHandler(
            filename = function() { paste(input$experiment, '-ACA.zip', sep="") },
            content = function(file) {
              fs <- c(as.character(paste(getwd(),"/Userdata/",session$token,"/controlimages.zip", sep="")),as.character(paste(getwd(),"/Userdata/",session$token,"/plots.zip", sep="")), as.character(paste(getwd(),"/Userdata/",session$token,"/result.csv", sep="")))
              zip(zipfile=file, files=fs, flags = "-jr9X" )
            },
            contentType = "application/zip"
          )
        }
          else
            cat("Error")
          }
      }}
    })
    observeEvent(input$plots, {
      if (input$plots == TRUE){
      insertUI(
        selector = "#container",
        where = "afterEnd",
        multiple = TRUE,
        ui = tags$div(
          selectInput("fileformat","Select Fileformat", c("PDF" = "pdf", "SVG" ="svg", "PNG" ="png")), 
          id = "dropdown")
            )
      }
      else {
        removeUI(selector = "#dropdown")
      }
        })
    })

