library(shiny)
shinyUI(fluidPage(
  titlePanel("Automated Colourimetric Assay (v. 0.04)"),
  
  sidebarLayout(
    sidebarPanel(
      textInput("experiment", "Session Name"),
      helpText("Give your data a name for later identification (not required)."),
      fileInput('PNGs', 'Choose PNG Files',
                accept=c('.png'),
                multiple=TRUE
                ),
      helpText("Select cleaned leaf images to analyse. Select all by pressing 'Ctrl + A'. To choose multiple files hold 'Ctrl' or 'Shift' while selecting. Maximum upload size 32 MB."),
      h3("Options"),
      checkboxInput("control", "Produce control images", value= FALSE),
      checkboxInput("plots", "Generate plots",value= FALSE),
      tags$div(id="container"),
      helpText("Note: To produce plots from your data, the filename structure needs to be as follows: Line X - Plant Y - WAS Z - Leaf XYZ.png."),
      
      actionButton("start", "Start Analysis"),
      downloadButton('downloadData')
    ),

    mainPanel(h2("Introduction"),
              p("This is the online variant of ACA, developed by Stefan Bieker and Dr. Justine Bresson. It is designed to identify and quantify colours typically occuring over the development of a plants' leaf. In that way, this app allows to quantify the progression of leaf ageing on macroscopic level."),
              p("The here presented online version is a not customizable", em("ShinyR"), " fork of the script published in ", code("enter reference here."), "If used for data analysis in a publication, please cite accordingly."),
              p("The full and customizable source can be downloaded at the website of", a("Project group Prof. Dr. U. Zentgraf (ZMBP - University Tuebingen)",
                                                                            href = "http://www.uni-tuebingen.de/fakultaeten/mathematisch-naturwissenschaftliche-fakultaet/fachbereiche/zentren/zmbp/gen-genetics/research-groups/zentgraf.html")),
              br(),
              br(),
              br(),
              h2("Instructions"),
              p("Images of single leaves need to be prepared as described in", em("Bresson et al., 2017."), "These pictures are then uploaded (", em("'Browse...'"), "), and a session name can be defined (optional). When the upload is finished, analysis can be started by pressing ", em("'Start Analysis'"), "."),
              p("If checked,", em("control images")," are generated for each input image in which pixels identified as green, green-yellow etc. are overlayed in red."),
              p("For analysis and presentation of the data, plots can be automatically generated (check ", em("'Generate Plots'"), "). For the software to be able to assign the results to e.g. genotypes and timepoints, it is necessary to structure the filenames as indicated on the left. The output fileformat may be chosen (default: svg)."),
              p("After finished analysis, data can be download by pressing ")
    ))
))