/*
 * Decompiled with CFR 0.152.
 */
package efault;

import chip.MicroArrayResult;
import chip.MicroArrayResultParser;
import efault.Config;
import efault.Main;
import genomic.AbstractSequenceFeature;
import genomic.ArrayProbe;
import genomic.Gene;
import genomic.Genome;
import genomic.NCRNA;
import genomic.NCRNAAnnotater;
import genomic.NCRNATableParser;
import genomic.NCRNATranscript;
import genomic.PromotorRegion;
import genomic.PromotorRegionPredicter;
import genomic.ProteinTableParser;
import genomic.SequenceFeatureLight;
import genomic.SequenceFeatureTools;
import genomic.TSS;
import genomic.TSSGFFParser;
import genomic.TUAnnotater;
import genomic.UTR;
import interact.IntaRNAParser;
import interact.TranskriptInteraction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import promoter.PCFinder;
import promoter.PCMatch;
import promoter.PCMatchClassifier;
import promoter.PCPattern;
import promoter.PCPatternParser;
import promoter.PCTableParser;
import rfam.QueryParser;
import rfam.RfamTest;
import rfam.RfamTestParser;
import seq.DNASequence;
import seq.FASTAEntry;
import seq.FASTAParser;
import seq.FASTAWriter;
import seq.SequenceTools;
import sidd.SIDDAbstractGeneProfiler;
import sidd.SIDDDNAProfiler;
import sidd.SIDDProfileAnalyzer;
import sidd.SIDDProfileReader;
import sidd.SIDDSettings;
import sidd.SIDDSite;
import sidd.SIDDSiteClassifier;
import sidd.SIDDTableParser;
import term.TermTableParser;
import term.Terminator;
import term.TerminatorClassifier;
import term.TransTermParser;

public class Aux {
    public static void doStuff() throws Exception {
    }

    private static void compare2ncRNApredictions() throws Exception {
        List<NCRNA> ncRNAs2 = NCRNATableParser.parseNCRNATable("data/ncRNAcrds/multiWin_newProgr.crd");
        boolean overlaps = false;
        HashSet<NCRNA> overlaps1 = new HashSet<NCRNA>();
        HashSet<NCRNA> overlaps2 = new HashSet<NCRNA>();
        for (NCRNA nc1 : Main.ncRNAs) {
            for (NCRNA nc2 : ncRNAs2) {
                if (nc1.numOverlappingBases(nc2) <= 0) continue;
                overlaps1.add(nc1);
                overlaps2.add(nc2);
                System.out.println(String.valueOf(nc1.getID()) + " " + nc2.getID() + " " + nc1.getLength() + " " + nc2.getLength() + " " + nc1.numOverlappingBases(nc2));
            }
        }
        System.out.println(String.valueOf(overlaps1.size()) + " " + overlaps2.size());
    }

    private static void map2ncRNApredictions() throws Exception {
        List<NCRNA> ncRNAs1 = NCRNATableParser.parseNCRNATable("data/ncRNAcrds/multiWin_newProgr.crd");
        List<NCRNA> ncRNAs2 = NCRNATableParser.parseNCRNATable("data/ncRNAcrds/ScoeliArrayNCRNAs.crd");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        NCRNAAnnotater anno = new NCRNAAnnotater(ncRNAs1);
        anno.annotateWithGenes(genes);
        anno = new NCRNAAnnotater(ncRNAs2);
        anno.annotateWithGenes(genes);
        int percthres = 80;
        boolean count = false;
        block0: for (NCRNA nc1 : ncRNAs1) {
            count = false;
            for (NCRNA nc2 : ncRNAs2) {
                if (!((double)nc1.numOverlappingBases(nc2) >= (double)(nc2.getLength() * percthres) / 100.0) || nc1.numGenes() != 1 || nc2.numGenes() != 1 || !nc1.getGenes().get(0).equals(nc2.getGenes().get(0))) continue;
                System.out.println(String.valueOf(nc1.getID()) + " " + nc2.getID() + " " + nc1.getStart() + " " + nc1.getEnd() + " " + nc2.getStrand() + " " + nc1.getGenes().get(0).getID());
                continue block0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void comparencRNApredictionToAlignWins() throws Exception {
        void var4_8;
        List<NCRNA> wins = NCRNATableParser.parseNCRNATable("data/ncRNAcrds/CoAvGr3_rnazwindow_wins.crd");
        LinkedList<SequenceFeatureLight> regs = new LinkedList<SequenceFeatureLight>();
        int tmpS = 0;
        int tmpE = 0;
        for (AbstractSequenceFeature abstractSequenceFeature : wins) {
            if (tmpS == 0 && tmpE == 0) {
                tmpS = abstractSequenceFeature.getStart();
                tmpE = abstractSequenceFeature.getEnd();
                continue;
            }
            if (abstractSequenceFeature.getStart() > tmpE) {
                regs.add(new SequenceFeatureLight("" + (regs.size() + 1), tmpS, tmpE, '.'));
                tmpS = abstractSequenceFeature.getStart();
                tmpE = abstractSequenceFeature.getEnd();
                continue;
            }
            tmpE = abstractSequenceFeature.getEnd();
        }
        regs.add(new SequenceFeatureLight("" + (regs.size() + 1), tmpS, tmpE, '.'));
        boolean bl = false;
        for (SequenceFeatureLight sf : regs) {
            var4_8 += sf.getLength();
        }
        boolean overlaps = false;
        HashSet<NCRNA> overlaps1 = new HashSet<NCRNA>();
        for (NCRNA nc1 : Main.ncRNAs) {
            for (SequenceFeatureLight reg : regs) {
                if (nc1.numOverlappingBases(reg) != nc1.getLength()) continue;
                overlaps1.add(nc1);
                System.out.println(nc1.getID());
            }
        }
        System.out.println("regions covered by alignment: " + overlaps1.size());
        System.out.println("coverage: " + (int)var4_8 + "/" + Main.genome.getLength() + " " + (double)var4_8 / (double)Main.genome.getLength() * 100.0 + "%");
    }

    private static void ncRNAAnalyzation() throws Exception {
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites.sidd");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/coeliPCMatches.pcm");
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        FileWriter w = new FileWriter("data/test.out");
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        int ncRNAsContTerms = 0;
        int ncRNAsOverGene = 0;
        int ncRNAsContSIDD = 0;
        int ncRNAsContPCM = 0;
        int ncRNAsContTermsAndSIDD = 0;
        while (ncIt.hasNext()) {
            NCRNA currNCRNA = ncIt.next();
            currNCRNA.removeOverlappingTerminators();
            currNCRNA.classifyTermination();
            currNCRNA.classifySIDDSites();
            currNCRNA.classifyPCMatches();
            if (currNCRNA.numGenes() > 0) {
                ++ncRNAsOverGene;
            }
            if (currNCRNA.numTerminators() > 0) {
                ++ncRNAsContTerms;
            }
            if (currNCRNA.numSIDDSites() > 0) {
                ++ncRNAsContSIDD;
            }
            if (currNCRNA.numPCMatches() > 0) {
                ++ncRNAsContPCM;
            }
            if (currNCRNA.numTerminators() > 0 && currNCRNA.numSIDDSites() > 0) {
                ++ncRNAsContTermsAndSIDD;
            }
            w.write(String.valueOf(currNCRNA.toString()) + "\n");
            for (Terminator currTerm : currNCRNA.getTerminators()) {
                w.write("\t" + currTerm.toString() + "\n");
            }
            for (SIDDSite currSIDD : currNCRNA.getSIDDSites()) {
                w.write("\t" + currSIDD.toString() + "\n");
            }
            for (PCMatch currPCM : currNCRNA.getPCMatches()) {
                w.write("\t" + currPCM.toString() + "\n");
            }
            for (Gene currGene : currNCRNA.getGenes()) {
                w.write("\t" + currGene.toString() + "\n");
            }
            w.write("\n");
        }
        w.write(String.valueOf(ncRNAsContTerms) + " ncRNAs containing a terminator\n");
        w.write(String.valueOf(ncRNAsContSIDD) + " ncRNAs containing a SIDDSite\n");
        w.write(String.valueOf(ncRNAsContTermsAndSIDD) + " ncRNAs containing a terminator and a SIDDSite\n");
        w.write(String.valueOf(ncRNAsContPCM) + " ncRNAs containing a promoter consensus match\n");
        w.write(String.valueOf(ncRNAsOverGene) + " ncRNAs in gene context\n");
        w.close();
    }

    private static void ncRNAAnalyzation2() throws Exception {
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/pcMatches.out");
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        int ncRNAsTotal = 0;
        int ncRNAsContTerms = 0;
        int ncRNAsContTermsShared = 0;
        int ncRNAsContSIDD = 0;
        int ncRNAsContSIDDShared = 0;
        int ncRNAsContPCM = 0;
        int ncRNAsContPCMShared = 0;
        int ncRNAsContTermsAndSIDD = 0;
        int ncRNAsContNothingButGene = 0;
        int ncRNAsOverGene = 0;
        int antisenseDueToTerm = 0;
        int antisenseDueToTermShared = 0;
        int antisenseDueToSIDD = 0;
        int antisenseDueToSIDDShared = 0;
        int antisenseDueToPCM = 0;
        int antisenseDueToPCMShared = 0;
        int antisenseDueToTermAndSIDD = 0;
        int antisenseDueToTermAndSIDDAndPCM = 0;
        while (ncIt.hasNext()) {
            NCRNA currNCRNA = ncIt.next();
            currNCRNA.removeOverlappingTerminators();
            currNCRNA.classifyTermination();
            currNCRNA.classifySIDDSites();
            currNCRNA.classifyPCMatches();
            ++ncRNAsTotal;
            if (currNCRNA.numGenes() > 0) {
                ++ncRNAsOverGene;
            }
            if (currNCRNA.getTerminationClass() == 'T') {
                ++ncRNAsContTerms;
            }
            if (currNCRNA.getTerminationClass() == 't') {
                ++ncRNAsContTerms;
                ++ncRNAsContTermsShared;
            }
            if (currNCRNA.getTerminationClass() == 'A') {
                ++antisenseDueToTerm;
                ++ncRNAsContTerms;
            }
            if (currNCRNA.getTerminationClass() == 'a') {
                ++ncRNAsContTerms;
                ++ncRNAsContTermsShared;
                ++antisenseDueToTerm;
                ++antisenseDueToTermShared;
            }
            if (currNCRNA.getSiddClass() == 'S') {
                ++ncRNAsContSIDD;
            }
            if (currNCRNA.getSiddClass() == 's') {
                ++ncRNAsContSIDD;
                ++ncRNAsContSIDDShared;
            }
            if (currNCRNA.getSiddClass() == 'A') {
                ++antisenseDueToSIDD;
                ++ncRNAsContSIDD;
            }
            if (currNCRNA.getSiddClass() == 'a') {
                ++ncRNAsContSIDD;
                ++ncRNAsContSIDDShared;
                ++antisenseDueToSIDD;
                ++antisenseDueToSIDDShared;
            }
            if (currNCRNA.getPcClass() == 'P') {
                ++ncRNAsContPCM;
            }
            if (currNCRNA.getPcClass() == 'p') {
                ++ncRNAsContPCM;
                ++ncRNAsContPCMShared;
            }
            if (currNCRNA.getPcClass() == 'A') {
                ++antisenseDueToPCM;
                ++ncRNAsContPCM;
            }
            if (currNCRNA.getPcClass() == 'a') {
                ++ncRNAsContPCM;
                ++ncRNAsContPCMShared;
                ++antisenseDueToPCM;
                ++antisenseDueToPCMShared;
            }
            if (currNCRNA.getTerminationClass() != 'X' && currNCRNA.getTerminationClass() != 'G' && currNCRNA.getSiddClass() != 'X' && currNCRNA.getSiddClass() != 'G') {
                ++ncRNAsContTermsAndSIDD;
            }
            if (!(currNCRNA.getTerminationClass() != 'A' && currNCRNA.getTerminationClass() != 'a' || currNCRNA.getSiddClass() != 'A' && currNCRNA.getSiddClass() != 'a')) {
                ++antisenseDueToTermAndSIDD;
            }
            if (!(currNCRNA.getTerminationClass() != 'A' && currNCRNA.getTerminationClass() != 'a' || currNCRNA.getSiddClass() != 'A' && currNCRNA.getSiddClass() != 'a' || currNCRNA.getPcClass() != 'A' && currNCRNA.getPcClass() != 'a')) {
                ++antisenseDueToTermAndSIDDAndPCM;
            }
            if (currNCRNA.getTerminationClass() != 'G' || currNCRNA.getSiddClass() != 'G' || currNCRNA.getPcClass() != 'G') continue;
            ++ncRNAsContNothingButGene;
        }
        System.out.println(String.valueOf(ncRNAsTotal) + " ncRNAs in total");
        System.out.println(String.valueOf(ncRNAsContTerms) + " ncRNAs containing a terminator - " + ncRNAsContTermsShared + " shared");
        System.out.println(String.valueOf(ncRNAsContSIDD) + " ncRNAs containing a SIDDSite - " + ncRNAsContSIDDShared + " shared");
        System.out.println(String.valueOf(ncRNAsContPCM) + " ncRNAs containing a promoter consensus match - " + ncRNAsContPCMShared + " shared");
        System.out.println(String.valueOf(ncRNAsContTermsAndSIDD) + " ncRNAs containing a terminator and a SIDDSite");
        System.out.println(String.valueOf(ncRNAsOverGene) + " ncRNAs in gene context");
        System.out.println(String.valueOf(antisenseDueToTerm) + " ncRNAs antisense due to terminator - " + antisenseDueToTermShared + " shared");
        System.out.println(String.valueOf(antisenseDueToSIDD) + " ncRNAs antisense due to SIDDSite - " + antisenseDueToSIDDShared + " shared");
        System.out.println(String.valueOf(antisenseDueToPCM) + " ncRNAs antisense due to promoter consensus match - " + antisenseDueToPCMShared + " shared");
        System.out.println(String.valueOf(antisenseDueToTermAndSIDD) + " ncRNAs antisense due to terminator and SIDDSite");
        System.out.println(String.valueOf(antisenseDueToTermAndSIDDAndPCM) + " ncRNAs antisense due to terminator and SIDDSite and promoter consensus match");
        System.out.println(String.valueOf(ncRNAsContNothingButGene) + " ncRNAs containing nothing but gene");
    }

    private static void checkHighExpressedNCRNAsForPredTranscripts() throws Exception {
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/pcMatches.out");
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        List<String> fowNCs = Arrays.asList(QueryParser.parseQueries(new File("data/intergenic_ncrnas_f199_fow_greater-8.txt")));
        List<String> revNCs = Arrays.asList(QueryParser.parseQueries(new File("data/intergenic_ncrnas_f199_rev_greater-8.txt")));
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        int numOfDifferentNCs = 0;
        int matchOnOneStrand = 0;
        int matchOnTheRightStrand = 0;
        block0: while (ncIt.hasNext()) {
            NCRNA currNC = ncIt.next();
            if (!fowNCs.contains(currNC.getID()) && !revNCs.contains(currNC.getID())) continue;
            ++numOfDifferentNCs;
            currNC.predictNCRNATranscripts();
            if (currNC.numPredictedNCRNATranscripts() > 0) {
                ++matchOnOneStrand;
            }
            if (fowNCs.contains(currNC.getID())) {
                for (NCRNATranscript currTrans : currNC.getPredictedNCRNATranscripts()) {
                    if (currTrans.getStrand() != '+') continue;
                    ++matchOnTheRightStrand;
                    break;
                }
            }
            if (!revNCs.contains(currNC.getID())) continue;
            for (NCRNATranscript currTrans : currNC.getPredictedNCRNATranscripts()) {
                if (currTrans.getStrand() != '-') continue;
                ++matchOnTheRightStrand;
                continue block0;
            }
        }
        System.out.println("predicted as Transcript: " + matchOnOneStrand + "/" + numOfDifferentNCs);
        System.out.println("predicted as Transcript on the right strand: " + matchOnTheRightStrand + "/" + (fowNCs.size() + revNCs.size()));
    }

    private static void ncRNAAnalyzationRfam() throws Exception {
        List<RfamTest> rfamTests = RfamTestParser.parseRfamTestsNew("data/RfamGenes.gff");
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ncRNAcrds/multiWin_CoAvGr3.gff");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/coeliPCMatches.pcm");
        LinkedList<NCRNATranscript> tUnits = new LinkedList<NCRNATranscript>();
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        for (NCRNA currNCRNA : ncRNAs) {
            currNCRNA.removeOverlappingTerminators();
            currNCRNA.classifyTermination();
            currNCRNA.classifySIDDSites();
            currNCRNA.classifyPCMatches();
            currNCRNA.predictNCRNATranscripts();
            tUnits.addAll(currNCRNA.getPredictedNCRNATranscripts());
        }
        int total = 0;
        int overlapNC = 0;
        int coveredNC = 0;
        int overlapTU = 0;
        int coveredTU = 0;
        Iterator<RfamTest> testIt = rfamTests.iterator();
        HashSet<NCRNA> ncsWithRfamAnno = new HashSet<NCRNA>();
        HashSet<RfamTest> rfamsWithNC = new HashSet<RfamTest>();
        while (testIt.hasNext()) {
            RfamTest currRfam = testIt.next();
            ++total;
            boolean overlap = false;
            boolean covered = false;
            for (NCRNA currNCRNA : ncRNAs) {
                if (currNCRNA.numOverlappingBases(currRfam) > 0) {
                    overlap = true;
                    ncsWithRfamAnno.add(currNCRNA);
                    rfamsWithNC.add(currRfam);
                }
                if (currRfam.getStart() < currNCRNA.getStart() || currRfam.getEnd() > currNCRNA.getEnd()) continue;
                covered = true;
            }
            if (overlap) {
                ++overlapNC;
            }
            if (covered) {
                ++coveredNC;
            }
            overlap = false;
            covered = false;
            Iterator tuIt = tUnits.iterator();
            AbstractSequenceFeature outNC = null;
            while (tuIt.hasNext()) {
                NCRNATranscript currTU = (NCRNATranscript)tuIt.next();
                if (currTU.getStrand() != currRfam.getStrand()) continue;
                if (currTU.numOverlappingBases(currRfam) > 0) {
                    overlap = true;
                }
                if (currRfam.getStart() < currTU.getStart() || currRfam.getEnd() > currTU.getEnd()) continue;
                covered = true;
                outNC = currTU.getNcrna();
            }
            if (overlap) {
                ++overlapTU;
            }
            if (!covered) continue;
            ++coveredTU;
            System.out.println(currRfam.getID());
            System.out.println(outNC.getID());
            System.out.println(String.valueOf(currRfam.getStart()) + " " + currRfam.getEnd() + " " + currRfam.getStrand());
        }
        int intergenicNCsNoAnnoButWithSiddTerm = 0;
        for (NCRNA nc : ncRNAs) {
            if (ncsWithRfamAnno.contains(nc) || nc.numGenes() != 0 || nc.numTerminators() <= 0 || nc.numSIDDSites() <= 0) continue;
            ++intergenicNCsNoAnnoButWithSiddTerm;
        }
        int intergenicNCsNoAnno = 0;
        for (NCRNA nc : ncRNAs) {
            if (ncsWithRfamAnno.contains(nc) || nc.numGenes() != 0) continue;
            ++intergenicNCsNoAnno;
        }
        System.out.println("total: " + total);
        System.out.println("overlapNC: " + overlapNC);
        System.out.println("coveredNC: " + coveredNC);
        System.out.println("overlapTU: " + overlapTU);
        System.out.println("coveredTU: " + coveredTU);
        System.out.println("intergenic ncRNAs without anno but with sidd and term: " + intergenicNCsNoAnnoButWithSiddTerm);
        System.out.println("intergenic ncRNAs without anno: " + intergenicNCsNoAnno);
        ArrayList<String> blib = new ArrayList<String>();
        for (NCRNA nCRNA : ncsWithRfamAnno) {
            blib.add(nCRNA.getID());
        }
        Collections.sort(blib);
        for (String string : blib) {
        }
    }

    private static void ncRNAAnalyzationChip() throws Exception {
        double expCut = 0.0;
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/coeliPCMatches.pcm");
        List<MicroArrayResult> maResults = MicroArrayResultParser.parseMicroArrayResults(new File("data/ExpressionMatrix_ncRNA_ordered_diff.csv"));
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        SequenceFeatureTools.annotateWithMicroArrayResults(ncRNAs, maResults);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        int ncRNAsTotal = 0;
        int ncRNAsContTerms = 0;
        int ncRNAsContTermsShared = 0;
        int ncRNAsContSIDD = 0;
        int ncRNAsContSIDDShared = 0;
        int ncRNAsContPCM = 0;
        int ncRNAsContPCMShared = 0;
        int ncRNAsContTermsAndSIDD = 0;
        int ncRNAsOverGene = 0;
        int antisenseDueToTerm = 0;
        int antisenseDueToTermShared = 0;
        int antisenseDueToSIDD = 0;
        int antisenseDueToSIDDShared = 0;
        int antisenseDueToPCM = 0;
        int antisenseDueToPCMShared = 0;
        int antisenseDueToTermAndSIDD = 0;
        while (ncIt.hasNext()) {
            NCRNA currNCRNA = ncIt.next();
            currNCRNA.removeOverlappingTerminators();
            currNCRNA.classifyTermination();
            currNCRNA.classifySIDDSites();
            currNCRNA.classifyPCMatches();
            if (currNCRNA.numMicroArrayResults() <= 0) continue;
            MicroArrayResult maRes = currNCRNA.getMicroArrayResults().iterator().next();
            double meanB = Aux.arrayMean(maRes.getValues(), 1, 16);
            double meanC = Aux.arrayMean(maRes.getValues(), 17, 24);
            if (meanB < expCut && meanC < expCut) continue;
            ++ncRNAsTotal;
            if (currNCRNA.numGenes() > 0) {
                ++ncRNAsOverGene;
            }
            if (currNCRNA.getTerminationClass() == 'T') {
                ++ncRNAsContTerms;
            }
            if (currNCRNA.getTerminationClass() == 't') {
                ++ncRNAsContTerms;
                ++ncRNAsContTermsShared;
            }
            if (currNCRNA.getTerminationClass() == 'A') {
                ++antisenseDueToTerm;
                ++ncRNAsContTerms;
            }
            if (currNCRNA.getTerminationClass() == 'a') {
                ++ncRNAsContTerms;
                ++ncRNAsContTermsShared;
                ++antisenseDueToTerm;
                ++antisenseDueToTermShared;
            }
            if (currNCRNA.getSiddClass() == 'S') {
                ++ncRNAsContSIDD;
            }
            if (currNCRNA.getSiddClass() == 's') {
                ++ncRNAsContSIDD;
                ++ncRNAsContSIDDShared;
            }
            if (currNCRNA.getSiddClass() == 'A') {
                ++antisenseDueToSIDD;
                ++ncRNAsContSIDD;
            }
            if (currNCRNA.getSiddClass() == 'a') {
                ++ncRNAsContSIDD;
                ++ncRNAsContSIDDShared;
                ++antisenseDueToSIDD;
                ++antisenseDueToSIDDShared;
            }
            if (currNCRNA.getPcClass() == 'P') {
                ++ncRNAsContPCM;
            }
            if (currNCRNA.getPcClass() == 'p') {
                ++ncRNAsContPCM;
                ++ncRNAsContPCMShared;
            }
            if (currNCRNA.getPcClass() == 'A') {
                ++antisenseDueToPCM;
                ++ncRNAsContPCM;
            }
            if (currNCRNA.getPcClass() == 'a') {
                ++ncRNAsContPCM;
                ++ncRNAsContPCMShared;
                ++antisenseDueToPCM;
                ++antisenseDueToPCMShared;
            }
            if (currNCRNA.getTerminationClass() != 'X' && currNCRNA.getTerminationClass() != 'G' && currNCRNA.getSiddClass() != 'X' && currNCRNA.getSiddClass() != 'G') {
                ++ncRNAsContTermsAndSIDD;
            }
            if (currNCRNA.getTerminationClass() != 'A' && currNCRNA.getTerminationClass() != 'a' || currNCRNA.getSiddClass() != 'A' && currNCRNA.getSiddClass() != 'a') continue;
            ++antisenseDueToTermAndSIDD;
        }
        System.out.println(String.valueOf(ncRNAsTotal) + " ncRNAs in total");
        System.out.println(String.valueOf(ncRNAsContTerms) + " ncRNAs containing a terminator - " + ncRNAsContTermsShared + " shared");
        System.out.println(String.valueOf(ncRNAsContSIDD) + " ncRNAs containing a SIDDSite - " + ncRNAsContSIDDShared + " shared");
        System.out.println(String.valueOf(ncRNAsContPCM) + " ncRNAs containing a promoter consensus match - " + ncRNAsContPCMShared + " shared");
        System.out.println(String.valueOf(ncRNAsContTermsAndSIDD) + " ncRNAs containing a terminator and a SIDDSite");
        System.out.println(String.valueOf(ncRNAsOverGene) + " ncRNAs in gene context");
        System.out.println(String.valueOf(antisenseDueToTerm) + " ncRNAs antisense due to terminator - " + antisenseDueToTermShared + " shared");
        System.out.println(String.valueOf(antisenseDueToSIDD) + " ncRNAs antisense due to SIDDSite - " + antisenseDueToSIDDShared + " shared");
        System.out.println(String.valueOf(antisenseDueToPCM) + " ncRNAs antisense due to promoter consensus match - " + antisenseDueToPCMShared + " shared");
        System.out.println(String.valueOf(antisenseDueToTermAndSIDD) + " ncRNAs antisense due to terminator and SIDDSite");
    }

    private static void writeNCRNAscoTable() throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter("ncRNA_SCO_IDs.txt"));
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithGenes(genes);
        for (NCRNA currNC : ncRNAs) {
            Gene currGene2;
            if (currNC.numGenes() == 1) {
                w.append("ncRNA" + currNC.getID() + "\t" + currNC.getGenes().get(0).getID());
                w.newLine();
            }
            if (currNC.numGenes() <= 1) continue;
            boolean ab = false;
            Iterator<Gene> geneIt = currNC.getGenes().iterator();
            char tmpStrand = geneIt.next().getStrand();
            while (geneIt.hasNext()) {
                if (geneIt.next().getStrand() == tmpStrand) continue;
                ab = true;
            }
            if (ab) {
                w.append("ncRNA" + currNC.getID() + "a");
                for (Gene currGene2 : currNC.getGenes()) {
                    if (currGene2.getStrand() != '-') continue;
                    w.append("\t" + currGene2.getID());
                }
                w.newLine();
                w.append("ncRNA" + currNC.getID() + "b");
                for (Gene currGene2 : currNC.getGenes()) {
                    if (currGene2.getStrand() != '+') continue;
                    w.append("\t" + currGene2.getID());
                }
                w.newLine();
                continue;
            }
            w.append("ncRNA" + currNC.getID());
            geneIt = currNC.getGenes().iterator();
            currGene2 = geneIt.next();
            while (geneIt.hasNext()) {
                w.append("\t" + currGene2.getID());
                currGene2 = geneIt.next();
            }
            w.newLine();
        }
        w.close();
    }

    private static void writeNCRNAigTable(char strand) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter("mwloc_IG_IDs_rev.txt"));
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ncRNAcrds/multiWin_CoAvGr3.gff");
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/IGProbePos_IGonly.csv");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithIGProbes(probes);
        annotater.annotateWithGenes(genes);
        for (NCRNA currNC : ncRNAs) {
            if (currNC.numIGProbes() < 8 || currNC.numGenes() != 0) continue;
            bw.append("ncRNA" + currNC.getID());
            currNC.numGenes();
            for (ArrayProbe probe : currNC.getIGProbes()) {
                if (probe.getStrand() != strand) continue;
                bw.append("\t" + probe.getID());
            }
            bw.newLine();
        }
        bw.close();
    }

    private static void writeNCTableFromTiling() throws Exception {
        int minNumProbes = 4;
        BufferedWriter bw = new BufferedWriter(new FileWriter("mwloc_IDs_both-strands.txt"));
        List<NCRNA> ncRNAs = Main.ncRNAs;
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/tilingMap.tsv");
        List<Gene> genes = Main.genes;
        LinkedList<Terminator> terms = new LinkedList();
        if (Main.terminatorsFile.exists()) {
            terms = TermTableParser.parseTermTable(Main.terminatorsFile.getAbsolutePath());
        }
        LinkedList<SIDDSite> sidds = new LinkedList();
        if (Main.siddSitesFile.exists()) {
            sidds = SIDDTableParser.parseSIDDTable(Main.siddSitesFile.getAbsolutePath());
        }
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithIGProbes(probes);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithTerminators(terms);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        StringBuffer sb = new StringBuffer();
        while (ncIt.hasNext()) {
            NCRNA currNC = ncIt.next();
            currNC.predictNCRNATranscripts();
            int tmpNumProbes = 0;
            sb = new StringBuffer();
            sb.append(String.valueOf(currNC.getID()) + "_fow");
            for (ArrayProbe ap : currNC.getIGProbes()) {
                if ('+' != ap.getStrand()) continue;
                sb.append("\t" + ap.getID());
                ++tmpNumProbes;
            }
            if (tmpNumProbes >= minNumProbes) {
                bw.append(String.valueOf(sb.toString()) + "\n");
            }
            tmpNumProbes = 0;
            sb = new StringBuffer();
            sb.append(String.valueOf(currNC.getID()) + "_rev");
            for (ArrayProbe ap : currNC.getIGProbes()) {
                if ('-' != ap.getStrand()) continue;
                sb.append("\t" + ap.getID());
                ++tmpNumProbes;
            }
            if (tmpNumProbes < minNumProbes) continue;
            bw.append(String.valueOf(sb.toString()) + "\n");
        }
        bw.close();
    }

    private static void writeTU_NC_CompareTablesFromTiling() throws Exception {
        int minNumProbes = 3;
        BufferedWriter tubw = new BufferedWriter(new FileWriter("mwlocTU_compIDs_50-6.txt"));
        BufferedWriter ncbw = new BufferedWriter(new FileWriter("mwlocNC_compIDs_50-6.txt"));
        List<NCRNA> ncRNAs = Main.ncRNAs;
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/tilingMap.tsv");
        List<Gene> genes = Main.genes;
        LinkedList<Terminator> terms = new LinkedList();
        if (Main.terminatorsFile.exists()) {
            terms = TermTableParser.parseTermTable(Main.terminatorsFile.getAbsolutePath());
        }
        LinkedList<SIDDSite> sidds = new LinkedList();
        if (Main.siddSitesFile.exists()) {
            sidds = SIDDTableParser.parseSIDDTable(Main.siddSitesFile.getAbsolutePath());
        }
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithIGProbes(probes);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithTerminators(terms);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        StringBuffer tusb = new StringBuffer();
        StringBuffer ncsb = new StringBuffer();
        char[] singleStrand = new char[1];
        char[] bothStrands = new char[]{'+', '-'};
        while (ncIt.hasNext()) {
            char[] tmpStrands;
            NCRNA currNC = ncIt.next();
            currNC.predictNCRNATranscripts();
            if (currNC.numGenes() > 1) continue;
            if (currNC.numGenes() == 1) {
                singleStrand[0] = currNC.getGenes().get(0).getStrand() == '+' ? 45 : 43;
                tmpStrands = singleStrand;
            } else {
                tmpStrands = bothStrands;
            }
            char[] cArray = tmpStrands;
            int n = tmpStrands.length;
            int n2 = 0;
            while (n2 < n) {
                char strand = cArray[n2];
                for (NCRNATranscript tu : currNC.getPredictedNCRNATranscripts()) {
                    if (tu.getStrand() != strand) continue;
                    int tmpNumProbesTU = 0;
                    int tmpNumProbesNC = 0;
                    tusb = new StringBuffer();
                    tusb.append(tu.getID());
                    ncsb = new StringBuffer();
                    ncsb.append("NC_" + tu.getID());
                    for (ArrayProbe ap : probes) {
                        if (tu.getStrand() != ap.getStrand() || tu.numOverlappingBases(ap) != 25) continue;
                        tusb.append("\t" + ap.getID());
                        ++tmpNumProbesTU;
                    }
                    for (ArrayProbe ap : probes) {
                        if (strand != ap.getStrand() || tu.numOverlappingBases(ap) != 0 || currNC.numOverlappingBases(ap) != 25) continue;
                        ncsb.append("\t" + ap.getID());
                        ++tmpNumProbesNC;
                    }
                    if (tmpNumProbesNC < minNumProbes || tmpNumProbesTU < minNumProbes) continue;
                    tubw.append(String.valueOf(tusb.toString()) + "\n");
                    ncbw.append(String.valueOf(ncsb.toString()) + "\n");
                }
                ++n2;
            }
        }
        tubw.close();
        ncbw.close();
    }

    private static void writeArrayProbeClasses() throws Exception {
        BufferedWriter bwGene = new BufferedWriter(new FileWriter("tilingProbeClass_50-6_gene.txt"));
        BufferedWriter bwNC = new BufferedWriter(new FileWriter("tilingProbeClass_50-6_ncRNA.txt"));
        BufferedWriter bwTU = new BufferedWriter(new FileWriter("tilingProbeClass_50-6_TU.txt"));
        BufferedWriter bwOther = new BufferedWriter(new FileWriter("tilingProbeClass_50-6_other.txt"));
        List<NCRNA> ncRNAs = Main.ncRNAs;
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/tilingMap.tsv");
        List<Gene> genes = Main.genes;
        LinkedList<ArrayProbe> geneProbes = new LinkedList<ArrayProbe>();
        LinkedList<ArrayProbe> ncRNAProbes = new LinkedList<ArrayProbe>();
        LinkedList<ArrayProbe> tuProbes = new LinkedList<ArrayProbe>();
        LinkedList<ArrayProbe> otherProbes = new LinkedList<ArrayProbe>();
        LinkedList<Terminator> terms = new LinkedList();
        if (Main.terminatorsFile.exists()) {
            terms = TermTableParser.parseTermTable(Main.terminatorsFile.getAbsolutePath());
        }
        LinkedList<SIDDSite> sidds = new LinkedList();
        if (Main.siddSitesFile.exists()) {
            sidds = SIDDTableParser.parseSIDDTable(Main.siddSitesFile.getAbsolutePath());
        }
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithIGProbes(probes);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithTerminators(terms);
        LinkedList<NCRNATranscript> tus = new LinkedList<NCRNATranscript>();
        for (NCRNA nc : ncRNAs) {
            nc.predictNCRNATranscripts();
            tus.addAll(nc.getPredictedNCRNATranscripts());
        }
        for (ArrayProbe ap : probes) {
            boolean[] oBoo = Aux.sfCompletelyOverlapsOtherSFs(ap, genes, ncRNAs, tus);
            if (oBoo[0]) {
                geneProbes.add(ap);
                continue;
            }
            if (!oBoo[0] && oBoo[1] && !oBoo[2]) {
                ncRNAProbes.add(ap);
                continue;
            }
            if (oBoo[2]) {
                tuProbes.add(ap);
                continue;
            }
            if (oBoo[0] || oBoo[1] || oBoo[2]) continue;
            otherProbes.add(ap);
        }
        bwGene.append("gene");
        for (ArrayProbe ap : geneProbes) {
            bwGene.append("\n" + ap.getID());
        }
        bwNC.append("ncRNA");
        for (ArrayProbe ap : ncRNAProbes) {
            bwNC.append("\n" + ap.getID());
        }
        bwTU.append("TU");
        for (ArrayProbe ap : tuProbes) {
            bwTU.append("\n" + ap.getID());
        }
        bwOther.append("other");
        for (ArrayProbe ap : otherProbes) {
            bwOther.append("\n" + ap.getID());
        }
    }

    private static boolean[] sfCompletelyOverlapsOtherSFs(AbstractSequenceFeature sf, List<? extends AbstractSequenceFeature> ... otherSFs) {
        boolean[] res = new boolean[otherSFs.length];
        int i = 0;
        while (i < otherSFs.length) {
            List<? extends AbstractSequenceFeature> sfs = otherSFs[i];
            for (AbstractSequenceFeature abstractSequenceFeature : sfs) {
                if (sf.numOverlappingBases(abstractSequenceFeature) != sf.getLength() || sf.getStrand() != abstractSequenceFeature.getStrand() && sf.getStrand() != '.' && abstractSequenceFeature.getStrand() != '.') continue;
                res[i] = true;
                break;
            }
            ++i;
        }
        return res;
    }

    private static void writeTUTableAndMIOTableFromTiling() throws Exception {
        int minNumProbes = 4;
        BufferedWriter bw = new BufferedWriter(new FileWriter("mwlocTU_IDs_50-6.txt"));
        BufferedWriter miobw = new BufferedWriter(new FileWriter("mwlocTU_MIOs_50-6.txt"));
        List<NCRNA> ncRNAs = Main.ncRNAs;
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/tilingMap.tsv");
        List<Gene> genes = Main.genes;
        LinkedList<Terminator> terms = new LinkedList();
        if (Main.terminatorsFile.exists()) {
            terms = TermTableParser.parseTermTable(Main.terminatorsFile.getAbsolutePath());
        }
        LinkedList<SIDDSite> sidds = new LinkedList();
        if (Main.siddSitesFile.exists()) {
            sidds = SIDDTableParser.parseSIDDTable(Main.siddSitesFile.getAbsolutePath());
        }
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithIGProbes(probes);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithTerminators(terms);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        StringBuffer sb = new StringBuffer();
        StringBuffer miosb = new StringBuffer();
        miobw.append("TU_ID\tnclocusID\tstart\tend\tstrand\tsidd\tterm\tasGenes\tisAs\n");
        LinkedList<NCRNATranscript> tus = new LinkedList<NCRNATranscript>();
        for (NCRNA nc : ncRNAs) {
            nc.predictNCRNATranscripts();
            tus.addAll(nc.getPredictedNCRNATranscripts());
        }
        new TUAnnotater(tus).annotateWithGenes(genes);
        for (NCRNATranscript tu : tus) {
            if (tu.numASGenes() < tu.numGenes()) continue;
            int tmpNumProbes = 0;
            sb = new StringBuffer();
            sb.append(tu.getID());
            for (ArrayProbe ap : probes) {
                if (tu.getStrand() != ap.getStrand() || tu.numOverlappingBases(ap) != 25) continue;
                sb.append("\t" + ap.getID());
                ++tmpNumProbes;
            }
            if (tmpNumProbes < minNumProbes) continue;
            bw.append(String.valueOf(sb.toString()) + "\n");
            miobw.append(String.valueOf(tu.toString()) + "\n");
        }
        bw.close();
        miobw.close();
    }

    private static void writeRfamIgTable() throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter("Rfam_IG_IDs.txt"));
        List<RfamTest> rfams = RfamTestParser.parseRfamTests("data/Rfam_annos.txt");
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/IGProbePos_IGonly.csv");
        RfamTest.annotateWithIGProbes(rfams, probes);
        for (RfamTest currRfam : rfams) {
            if (currRfam.numIGProbes() < 1) continue;
            bw.append(currRfam.getID());
            for (ArrayProbe probe : currRfam.getIGProbes()) {
                bw.append("\t" + probe.getID());
            }
            bw.newLine();
        }
        bw.close();
    }

    private static void writeUTRigTable() throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter("UTR_IG_IDs.txt"));
        List<UTR> utrs = UTR.parseUTRTable("data/coeliUTRs.out");
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/IGProbePos_IGonly.csv");
        UTR.annotateWithIGProbes(utrs, probes);
        for (UTR currUTR : utrs) {
            if (currUTR.numIGProbes() < 1) continue;
            bw.append(currUTR.getID());
            List<ArrayProbe> probeList = currUTR.getIGProbes();
            Collections.sort(probeList);
            if (currUTR.getStrand() == '+' && currUTR.is5prime() || currUTR.getStrand() != '-' || !currUTR.is5prime()) {
                // empty if block
            }
            Collections.reverse(probeList);
            for (ArrayProbe probe : probeList) {
                bw.append("\t" + probe.getID());
            }
            bw.newLine();
        }
        bw.close();
    }

    private static void writeUTRigSetTable() throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter("UTR_IGset_IDs.txt"));
        List<UTR> utrs = UTR.parseUTRTable("data/coeliUTRs.out");
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/IGProbePos_IGonly.csv");
        UTR.annotateWithIGProbes(utrs, probes);
        Iterator<UTR> utrIt = utrs.iterator();
        LinkedList<String> tmpIGsetNames = new LinkedList<String>();
        while (utrIt.hasNext()) {
            UTR currUTR = utrIt.next();
            if (currUTR.numIGProbes() < 1) continue;
            bw.append(currUTR.getID());
            bw.append("\t" + currUTR.getID().charAt(currUTR.getID().length() - 4));
            Iterator<ArrayProbe> probeIt = currUTR.getIGProbes().iterator();
            tmpIGsetNames.clear();
            while (probeIt.hasNext()) {
                ArrayProbe probe = probeIt.next();
                if (tmpIGsetNames.contains(probe.getProbeSetID())) continue;
                bw.append("\t" + probe.getProbeSetID());
                tmpIGsetNames.add(probe.getProbeSetID());
            }
            bw.newLine();
        }
        bw.close();
    }

    private static void writeUTRscoTable() throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter("UTR_SCO_IDs.txt"));
        List<UTR> utrs = UTR.parseUTRTable("data/coeliUTRs.out");
        List<ArrayProbe> probes = ArrayProbe.parseTilingMap("data/IGProbePos_IGonly.csv");
        UTR.annotateWithIGProbes(utrs, probes);
        for (UTR currUTR : utrs) {
            if (currUTR.numIGProbes() < 1) continue;
            bw.append(String.valueOf(currUTR.getID()) + "\t" + currUTR.getParentGeneID());
            bw.newLine();
        }
        bw.close();
    }

    private static void transUnits() throws Exception {
        int noTermCount = 0;
        int overlapping = 0;
        int antisense = 0;
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/coeliPCMatches.pcm");
        BufferedWriter w = new BufferedWriter(new FileWriter("tUnits_65-4.out"));
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        for (NCRNA currNCRNA : ncRNAs) {
            currNCRNA.removeOverlappingTerminators();
            currNCRNA.classifyTermination();
            currNCRNA.classifySIDDSites();
            currNCRNA.classifyPCMatches();
            currNCRNA.predictNCRNATranscripts();
            for (NCRNATranscript tUnit : currNCRNA.getPredictedNCRNATranscripts()) {
                int conf;
                Terminator term = tUnit.getTerminator();
                SIDDSite sidd = tUnit.getSiddSite();
                int length = tUnit.getLength();
                double minG = sidd.getMinIncEnergy();
                if (term != null) {
                    conf = term.getConfidence();
                } else {
                    conf = 0;
                    ++noTermCount;
                }
                Iterator<Gene> geneIt = genes.iterator();
                boolean overlappingB = false;
                boolean antisenseB = false;
                while (geneIt.hasNext()) {
                    Gene currGene = geneIt.next();
                    if (tUnit.numOverlappingBases(currGene) <= 0) continue;
                    overlappingB = true;
                    if (currGene.getStrand() == tUnit.getStrand()) continue;
                    antisenseB = true;
                }
                if (overlappingB) {
                    ++overlapping;
                }
                if (antisenseB) {
                    ++antisense;
                }
                w.append(String.valueOf(tUnit.getID()) + "\t" + length + "\t" + minG + "\t" + conf);
                w.newLine();
            }
        }
        System.out.println(String.valueOf(noTermCount) + " transcription units without terminator");
        System.out.println(String.valueOf(overlapping) + " transcription units overlapping coding region");
        System.out.println(String.valueOf(antisense) + " transcription units antisense");
        w.close();
    }

    private static void predictUTRs() throws Exception {
        LinkedList<Terminator> terms = new LinkedList();
        if (Main.terminatorsFile.exists()) {
            terms = TermTableParser.parseTermTable(Main.terminatorsFile.getAbsolutePath());
        }
        List<SIDDSite> sidds = new LinkedList<SIDDSite>();
        if (Main.siddSitesFile.exists()) {
            sidds = SIDDTableParser.parseSIDDTable(Main.siddSitesFile.getAbsolutePath());
        }
        List<UTR> utrs = UTR.predictUTRs(Main.genes, sidds, terms, 4.0, 70, 300, 300);
        SequenceFeatureTools.writeSequenceFeatures(utrs, "data/soeUTRs.out");
    }

    private static void predictUTRregions() throws Exception {
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<UTR> utrs = UTR.predictUTRregions(genes, 300);
        SequenceFeatureTools.writeSequenceFeatures(utrs, "data/coeliUTRs.out");
    }

    private static void promotorDNAStabStuff(List<NCRNA> ncRNAs) throws Exception {
        BufferedReader genomeR = new BufferedReader(new FileReader("data/NC_000913.fna"));
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(genomeR).get(0);
        Genome coeliG = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        coeliG.calculateGibbsEnergies();
        System.out.println(String.valueOf(coeliG.getMeanGibbsEnergy()) + " " + coeliG.getSdGibbsEnergy());
        int upRegSize = 100;
        PromotorRegionPredicter promRegPred = new PromotorRegionPredicter(coeliG, -18.63, 1.07);
        promRegPred.predictPromotorRegions();
        LinkedList<PromotorRegion> promregs = promRegPred.getPromRegs();
        for (PromotorRegion promreg : promregs) {
            System.out.println(promreg.toString());
        }
    }

    private static void extractNCRNARegs(int index) throws Exception {
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        BufferedReader genomeR = new BufferedReader(new FileReader("data/NC_003888.fasta"));
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(genomeR).get(0);
        Genome coeliG = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        NCRNA ncRNA = ncRNAs.get(index);
        DNASequence seq = coeliG.getSequence().getSubsequence(ncRNA.getStart() - 1000, ncRNA.getEnd() + 1000);
        FASTAEntry<DNASequence> fasta = new FASTAEntry<DNASequence>(ncRNA.getID(), seq);
        LinkedList<FASTAEntry> list = new LinkedList<FASTAEntry>();
        list.add(fasta);
        BufferedWriter bw = new BufferedWriter(new FileWriter("data/ncRNAReg.fasta"));
        FASTAWriter.write(bw, list);
        bw.close();
    }

    private static void siddTesting(boolean fastaInput, int start, int end, boolean shuffle) throws Exception {
        DNASequence seq;
        if (!fastaInput) {
            BufferedReader genomeReader = new BufferedReader(new FileReader("data/NC_003888.fasta"));
            seq = FASTAParser.parseDNA(genomeReader).get(0).getSequence().getSubsequence(start, end);
        } else {
            BufferedReader siddInputR = new BufferedReader(new FileReader("data/siddInput.fasta"));
            FASTAEntry<DNASequence> siddInput = FASTAParser.parseDNA(siddInputR).get(0);
            seq = siddInput.getSequence();
        }
        FASTAEntry<DNASequence> fa = new FASTAEntry<DNASequence>("bla", seq);
        LinkedList<FASTAEntry> fas = new LinkedList<FASTAEntry>();
        fas.add(fa);
        FASTAWriter.write(new BufferedWriter(new FileWriter("data/aSeq.fa")), fas);
        BufferedWriter siddProfileW = new BufferedWriter(new FileWriter("data/siddProfile.out"));
        if (shuffle) {
            seq = SequenceTools.shuffle(seq);
        }
        SIDDDNAProfiler siddP = new SIDDDNAProfiler(seq, 1, seq.getLength(), true);
        siddP.setTheta(12.0);
        siddP.setSigma(-0.055);
        siddP.runProfiler();
        double[] px = siddP.getPx();
        double[] Gx = siddP.getGx();
        System.out.println(siddP.getMeanG());
        System.out.println(siddP.getMinG());
        int i = 0;
        while (i < px.length) {
            siddProfileW.append(String.valueOf(Math.rint(px[i] * 10000.0) / 10000.0) + "\t");
            ++i;
        }
        siddProfileW.newLine();
        i = 0;
        while (i < Gx.length) {
            siddProfileW.append(String.valueOf(Math.rint(Gx[i] * 1000.0) / 1000.0) + "\t");
            ++i;
        }
        siddProfileW.close();
    }

    private static void siddSitesToGFF() throws Exception {
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites.sidd");
        Iterator<SIDDSite> siddIt = sidds.iterator();
        BufferedWriter bw = new BufferedWriter(new FileWriter("data/coeliSIDDSites.gff"));
        while (siddIt.hasNext()) {
            SIDDSite cS = siddIt.next();
            bw.append("NC_003888\tsiddPrediction\tsiddSite\t" + cS.getStart() + "\t" + cS.getEnd() + "\t" + cS.getMinIncEnergy() + "\t" + cS.getStrand() + "\t" + "." + "\t" + "name \"" + cS.getID() + "\"" + "\n");
        }
        bw.close();
    }

    private static void checkTSSforSidds(int upstream, int downstream) throws Exception {
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites7000.out");
        List<TSS> tss = TSSGFFParser.parseGFF("data/coeliTSS_paperOnly.gff");
        Iterator<TSS> tssIt = tss.iterator();
        Iterator<SIDDSite> siddIt = sidds.iterator();
        int positiveCount = 0;
        int allCount = 0;
        boolean siddHit = false;
        while (tssIt.hasNext()) {
            TSS tssSite = tssIt.next();
            double bestScore = Double.MAX_VALUE;
            int bestScoresDist = Integer.MAX_VALUE;
            siddHit = false;
            System.out.print(tssSite.toString());
            for (SIDDSite siddSite : sidds) {
                if (tssSite.getStrand() == '+') {
                    if (siddSite.getEnd() < tssSite.getStart() - upstream || siddSite.getStart() > tssSite.getEnd() + downstream) continue;
                    siddHit = true;
                    if (!(siddSite.getMinIncEnergy() < bestScore)) continue;
                    bestScore = siddSite.getMinIncEnergy();
                    if (siddSite.getStart() < tssSite.getStart() && siddSite.getEnd() > tssSite.getEnd()) {
                        bestScoresDist = 0;
                        continue;
                    }
                    bestScoresDist = Math.min(Math.abs(tssSite.getStart() - siddSite.getEnd()), Math.abs(tssSite.getStart() - siddSite.getStart()));
                    continue;
                }
                if (siddSite.getEnd() < tssSite.getStart() - downstream || siddSite.getStart() > tssSite.getEnd() + upstream) continue;
                siddHit = true;
                if (!(siddSite.getMinIncEnergy() < bestScore)) continue;
                bestScore = siddSite.getMinIncEnergy();
                bestScoresDist = siddSite.getStart() < tssSite.getStart() && siddSite.getEnd() > tssSite.getEnd() ? 0 : Math.min(Math.abs(tssSite.getStart() - siddSite.getEnd()), Math.abs(tssSite.getStart() - siddSite.getStart()));
            }
            if (siddHit) {
                System.out.print("\t" + bestScore + "\t" + bestScoresDist);
                ++positiveCount;
            }
            System.out.println("");
        }
        allCount = tss.size();
        System.out.println(positiveCount);
        System.out.println(allCount);
    }

    private static void writeTSSRPlotTable(int contextRange) throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter("tssSiddPlots7000.out"));
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        List<TSS> tssList = TSSGFFParser.parseGFF("data/coeliTSS_paperOnly.gff");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        SIDDProfileReader siddReader = new SIDDProfileReader("data/coeliSiddProfile7000.out", Main.genome.getLength());
        siddReader.readProfile();
        double[] Gx = siddReader.getGx();
        for (TSS currTSS : tssList) {
            Iterator<Gene> geneIt = genes.iterator();
            int tmpATGPos = Integer.MAX_VALUE;
            while (geneIt.hasNext()) {
                Gene currGene = geneIt.next();
                if (currGene.getStrand() != currTSS.getStrand()) continue;
                if (currTSS.getStrand() == '+' && currGene.getStart() >= currTSS.getStart() && Math.abs(currGene.getStart() - currTSS.getStart()) < Math.abs(tmpATGPos - currTSS.getStart())) {
                    tmpATGPos = currGene.getStart();
                }
                if (currTSS.getStrand() != '-' || currGene.getEnd() > currTSS.getStart() || Math.abs(currTSS.getStart() - currGene.getEnd()) >= Math.abs(currTSS.getStart() - tmpATGPos)) continue;
                tmpATGPos = currGene.getEnd();
            }
            int startRegion = currTSS.getStart() - contextRange;
            int endRegion = currTSS.getStart() + contextRange;
            if (startRegion - 1 < 0) {
                startRegion = 1;
            }
            if (endRegion - 1 >= Gx.length) {
                endRegion = Gx.length;
            }
            int i = startRegion;
            while (i <= endRegion) {
                w.write(String.valueOf(Gx[i - 1]) + "\t");
                ++i;
            }
            w.write(String.valueOf(startRegion) + "\t");
            w.write(String.valueOf(endRegion) + "\t");
            w.write(String.valueOf(currTSS.getStart()) + "\t");
            w.write(String.valueOf(tmpATGPos) + "\t");
            w.write(String.valueOf(currTSS.getID()) + "\n");
        }
        w.close();
    }

    private static void writeNCRNARPlotTable(int contextRange, String[] IDs) throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter("data/ncRNAsidds.sidd"));
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        SIDDProfileReader siddReader = new SIDDProfileReader("data/coeliSiddProfile10000.out", Main.genome.getLength());
        siddReader.readProfile();
        double[] Gx = siddReader.getGx();
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncrnas = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terms = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        NCRNAAnnotater ncAnno = new NCRNAAnnotater(ncrnas);
        ncAnno.annotateWithGenes(genes);
        ncAnno.annotateWithTerminators(terms);
        Iterator<NCRNA> ncrnaIt = ncrnas.iterator();
        StringBuffer titleString = new StringBuffer();
        while (ncrnaIt.hasNext()) {
            NCRNA currNCRNA = ncrnaIt.next();
            boolean IDHit = false;
            int i = 0;
            while (i < IDs.length) {
                if (IDs[i].equalsIgnoreCase(currNCRNA.getID())) {
                    IDHit = true;
                }
                ++i;
            }
            if (!IDHit) continue;
            int startRegion = currNCRNA.getStart() - contextRange;
            int endRegion = currNCRNA.getEnd() + contextRange;
            if (startRegion - 1 < 0) {
                startRegion = 1;
            }
            if (endRegion - 1 >= Gx.length) {
                endRegion = Gx.length;
            }
            titleString.setLength(0);
            titleString.append("ncRNA" + currNCRNA.getID());
            for (Gene currGene : currNCRNA.getGenes()) {
                titleString.append("_" + currGene.getID() + "(" + currGene.getStrand() + ")");
            }
            i = startRegion;
            while (i <= endRegion) {
                w.write(String.valueOf(Gx[i - 1]) + "\t");
                ++i;
            }
            w.write(String.valueOf(startRegion) + "\t");
            w.write(String.valueOf(endRegion) + "\t");
            w.write(String.valueOf(currNCRNA.getStart()) + "\t");
            w.write(String.valueOf(currNCRNA.getEnd()) + "\t");
            w.write(String.valueOf(titleString.toString()) + "\n");
            for (Gene currGene : currNCRNA.getGenes()) {
                if (currGene.getStrand() == '-') {
                    w.write(String.valueOf(currGene.getEnd()) + "\t" + currGene.getStart() + "\t");
                    continue;
                }
                w.write(String.valueOf(currGene.getStart()) + "\t" + currGene.getEnd() + "\t");
            }
            w.write("\n");
            for (Terminator currTerm : currNCRNA.getTerminators()) {
                if (currTerm.getStrand() == '-') {
                    w.write(String.valueOf(currTerm.getEnd()) + "\t" + currTerm.getStart() + "\t");
                    continue;
                }
                w.write(String.valueOf(currTerm.getStart()) + "\t" + currTerm.getEnd() + "\t");
            }
            w.write("\n");
        }
        w.close();
    }

    private static void writeGeneRPlotTable(int contextRange, String[] IDs) throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter("data/geneSidds.sidd"));
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        SIDDProfileReader siddReader = new SIDDProfileReader("data/coeliSiddProfile10000.out", Main.genome.getLength());
        siddReader.readProfile();
        double[] Gx = siddReader.getGx();
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncrnas = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terms = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        NCRNAAnnotater ncAnno = new NCRNAAnnotater(ncrnas);
        ncAnno.annotateWithGenes(genes);
        ncAnno.annotateWithTerminators(terms);
        Iterator<NCRNA> ncrnaIt = ncrnas.iterator();
        Iterator<Gene> geneIt = genes.iterator();
        StringBuffer titleString = new StringBuffer();
        while (geneIt.hasNext()) {
            int end;
            int start;
            Gene currGene = geneIt.next();
            boolean IDHit = false;
            int i = 0;
            while (i < IDs.length) {
                if (IDs[i].equalsIgnoreCase(currGene.getID())) {
                    IDHit = true;
                }
                ++i;
            }
            if (!IDHit) continue;
            int startRegion = currGene.getStart() - contextRange;
            int endRegion = currGene.getEnd() + contextRange;
            if (startRegion - 1 < 0) {
                startRegion = 1;
            }
            if (endRegion - 1 >= Gx.length) {
                endRegion = Gx.length;
            }
            titleString.setLength(0);
            titleString.append(currGene.getID());
            if (currGene.getStrand() == '+') {
                start = currGene.getStart();
                end = currGene.getEnd();
            } else {
                start = currGene.getEnd();
                end = currGene.getStart();
            }
            i = startRegion;
            while (i <= endRegion) {
                w.write(String.valueOf(Gx[i - 1]) + "\t");
                ++i;
            }
            w.write(String.valueOf(startRegion) + "\t");
            w.write(String.valueOf(endRegion) + "\t");
            w.write(String.valueOf(start) + "\t");
            w.write(String.valueOf(end) + "\t");
            w.write(String.valueOf(titleString.toString()) + "\n");
        }
        w.close();
    }

    private static void writeNCRNAsWithOrWithoutStrand() throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter("multiwin_CoAvGr3_withStrandOrNot.crd"));
        List<NCRNA> ncRNAs = Main.ncRNAs;
        List<Gene> genes = Main.genes;
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithGenes(genes);
        for (NCRNA nc : ncRNAs) {
            char strand;
            if (nc.numGenes() == 0) {
                strand = '.';
                bw.append(String.valueOf(nc.getID()) + "\t" + nc.getStart() + "\t" + nc.getEnd() + "\t" + strand + "\n");
                continue;
            }
            strand = nc.getGenes().get(0).getStrand();
            for (Gene gene : nc.getGenes()) {
                if (strand == gene.getStrand()) continue;
            }
            strand = SequenceFeatureTools.complementStrand(strand);
            bw.append(String.valueOf(nc.getID()) + "\t" + nc.getStart() + "\t" + nc.getEnd() + "\t" + strand + "\n");
        }
        bw.close();
    }

    private static void promCons() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader("data/NC_003888.fasta"));
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(reader).get(0);
        Genome genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        List<PCPattern> pcPatterns = PCPatternParser.parsePCPatterns("data/coeliPCPattern.txt");
        PCFinder pcf = new PCFinder(genome, ncRNAs, pcPatterns);
        pcf.findConsensusMatches();
        SequenceFeatureTools.writeSequenceFeatures(pcf.getProms(), "data/promConsMatches.pcm");
    }

    private static void selectedNCRNAsToFasta() throws Exception {
        int upDownReg = 50;
        BufferedReader gReader = new BufferedReader(new FileReader("data/NC_003888.fasta"));
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        BufferedWriter fastaW = new BufferedWriter(new FileWriter("data/selectedNCRNAs.fasta"));
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(gReader).get(0);
        Genome genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<FASTAEntry> fastas = new LinkedList<FASTAEntry>();
        NCRNAAnnotater anno = new NCRNAAnnotater(ncRNAs);
        anno.annotateWithGenes(genes);
        for (NCRNA currNCRNA : ncRNAs) {
            boolean addToFasta = true;
            if (!addToFasta) continue;
            String id = currNCRNA.getID();
            int start = currNCRNA.getStart() - upDownReg;
            int end = currNCRNA.getEnd() + upDownReg;
            if (start < 1) {
                start = 1;
            }
            if (end > genome.getEnd()) {
                end = genome.getEnd();
            }
            FASTAEntry<DNASequence> currFasta = new FASTAEntry<DNASequence>(id, genome.getSequence().getSubsequence(start, end));
            fastas.add(currFasta);
        }
        FASTAWriter.write(fastaW, fastas);
        fastaW.close();
    }

    private static void chipAnalysis() throws Exception {
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites.sidd");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/coeliPCMatches.pcm");
        List<MicroArrayResult> maResults = MicroArrayResultParser.parseMicroArrayResults(new File("data/ExpressionMatrix_ncRNA_ordered.csv"));
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        SequenceFeatureTools.annotateWithMicroArrayResults(ncRNAs, maResults);
        double expCut = 10.0;
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        MicroArrayResult maRes2 = null;
        double meanB2 = 0.0;
        double meanC2 = 0.0;
        while (ncIt.hasNext()) {
            NCRNA currNCRNA = ncIt.next();
            currNCRNA.removeOverlappingTerminators();
            currNCRNA.classifyTermination();
            currNCRNA.classifySIDDSites();
            currNCRNA.classifyPCMatches();
            if (currNCRNA.numMicroArrayResults() == 0) continue;
            Iterator<MicroArrayResult> maresIt = currNCRNA.getMicroArrayResults().iterator();
            MicroArrayResult maRes = maresIt.next();
            double meanB = Aux.arrayMean(maRes.getValues(), 1, 16);
            double meanC = Aux.arrayMean(maRes.getValues(), 17, 24);
            boolean printBoth = false;
            if (currNCRNA.numMicroArrayResults() > 1) {
                maRes2 = maresIt.next();
                meanB2 = Aux.arrayMean(maRes2.getValues(), 1, 16);
                meanC2 = Aux.arrayMean(maRes2.getValues(), 17, 24);
                if (meanB2 > expCut || meanC2 > expCut) {
                    printBoth = true;
                }
            }
            if (meanB > expCut || meanC > expCut) {
                System.out.println(currNCRNA.toString());
                System.out.println("\t" + meanB + "\t" + meanC);
            }
            if (!printBoth) continue;
            System.out.println(currNCRNA.toString());
            System.out.println("\t" + meanB2 + "\t" + meanC2);
        }
    }

    private static double arrayMean(double[] array, int from, int to) {
        double res = 0.0;
        int i = from;
        while (i < to) {
            res += array[i];
            ++i;
        }
        return res /= (double)(to - from + 1);
    }

    private static void siddSitesTest() throws Exception {
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        SIDDProfileReader spr = new SIDDProfileReader("data/coeliSiddProfile10000.out", Main.genome.getLength());
        spr.readProfile();
        List<SIDDSite> sidds = SIDDProfileAnalyzer.extractSIDDSites(spr.getGx(), 6.0);
        SequenceFeatureTools.writeSequenceFeatures(sidds, "data/coeliSIDDSites10000.out");
    }

    private static void writeTermInOutConfPlot() throws Exception {
        TransTermParser tp = new TransTermParser("data/terms_50.tt");
        tp.parse();
        LinkedList<Terminator> terms = tp.getTerminators();
        System.out.println(terms.size());
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        BufferedWriter wIn = new BufferedWriter(new FileWriter("termsIn2.out"));
        BufferedWriter wOut = new BufferedWriter(new FileWriter("termsOut2.out"));
        boolean inCoding = false;
        for (Terminator currTerm : terms) {
            Iterator<Gene> geneIt = genes.iterator();
            inCoding = false;
            while (geneIt.hasNext()) {
                Gene currGene = geneIt.next();
                if (currGene.getStart() > currTerm.getStart()) break;
                if (currGene.getEnd() < currTerm.getEnd()) continue;
                inCoding = true;
                break;
            }
            if (inCoding) {
                wIn.append(Integer.toString(currTerm.getConfidence()));
                wIn.newLine();
                continue;
            }
            wOut.append(Integer.toString(currTerm.getConfidence()));
            wOut.newLine();
        }
        wIn.close();
        wOut.close();
    }

    private static void writeSIDDInOutEnergyPlot() throws Exception {
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        BufferedWriter wIn = new BufferedWriter(new FileWriter("siddsIn10000.out"));
        BufferedWriter wOut = new BufferedWriter(new FileWriter("siddsOut10000.out"));
        boolean inCoding = false;
        for (SIDDSite currSidd : sidds) {
            Iterator<Gene> geneIt = genes.iterator();
            inCoding = false;
            while (geneIt.hasNext()) {
                Gene currGene = geneIt.next();
                if (currGene.getStart() > currSidd.getStart()) break;
                if (currGene.getEnd() < currSidd.getEnd()) continue;
                inCoding = true;
                break;
            }
            if (inCoding) {
                wIn.append(Double.toString(currSidd.getMinIncEnergy()));
                wIn.newLine();
                continue;
            }
            wOut.append(Double.toString(currSidd.getMinIncEnergy()));
            wOut.newLine();
        }
        wIn.close();
        wOut.close();
    }

    private static void writeTermDistPlot() throws Exception {
        int maxDist = 500;
        int minConf = 65;
        TransTermParser tp = new TransTermParser("data/terms_50.tt");
        tp.parse();
        LinkedList<Terminator> terms = tp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        BufferedWriter w = new BufferedWriter(new FileWriter("termsDist.out"));
        block0: for (Gene currGene : genes) {
            Terminator currTerm;
            ListIterator termIt;
            if (currGene.getStrand() == '+') {
                termIt = terms.listIterator();
                while (termIt.hasNext()) {
                    currTerm = (Terminator)termIt.next();
                    if (currTerm.getEnd() - currGene.getEnd() > maxDist) continue block0;
                    if (currTerm.getStrand() != '+' || currTerm.getConfidence() < minConf || currTerm.getEnd() < currGene.getEnd()) continue;
                    w.append(String.valueOf(Integer.toString(currTerm.getEnd() - currGene.getEnd())) + "\t" + currTerm.getConfidence());
                    w.newLine();
                }
                continue;
            }
            termIt = terms.listIterator(terms.size());
            while (termIt.hasPrevious()) {
                currTerm = (Terminator)termIt.previous();
                if (currTerm.getStrand() != '-') continue;
                if (currGene.getStart() - currTerm.getStart() > maxDist) continue block0;
                if (currTerm.getConfidence() < minConf || currTerm.getStart() > currGene.getStart()) continue;
                w.append(String.valueOf(Integer.toString(currGene.getStart() - currTerm.getStart())) + "\t" + currTerm.getConfidence());
                w.newLine();
            }
        }
        w.close();
    }

    private static void writeTermNCDistPlot() throws Exception {
        int maxDist = 500;
        int minConf = 65;
        TransTermParser tp = new TransTermParser("data/terms_50.tt");
        tp.parse();
        LinkedList<Terminator> terms = tp.getTerminators();
        List<NCRNA> ncrnas = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        BufferedWriter w = new BufferedWriter(new FileWriter("termsNCDist.out"));
        int tmpDist = 0;
        for (NCRNA currNcrna : ncrnas) {
            ListIterator termIt = terms.listIterator();
            while (termIt.hasNext()) {
                Terminator currTerm = (Terminator)termIt.next();
                if (currTerm.getStrand() == '+') {
                    if (currTerm.getEnd() - currNcrna.getEnd() > maxDist || currTerm.getConfidence() < minConf || currTerm.getEnd() < currNcrna.getStart()) continue;
                    tmpDist = currTerm.getEnd() - currNcrna.getEnd();
                    if (tmpDist < 0) {
                        tmpDist = 0;
                    }
                } else {
                    if (currNcrna.getStart() - currTerm.getStart() > maxDist || currTerm.getConfidence() < minConf || currTerm.getStart() > currNcrna.getEnd()) continue;
                    tmpDist = currNcrna.getStart() - currTerm.getStart();
                    if (tmpDist < 0) {
                        tmpDist = 0;
                    }
                }
                w.append(String.valueOf(Integer.toString(tmpDist)) + "\t" + currTerm.getConfidence());
                w.newLine();
            }
        }
        w.close();
    }

    private static void writeSIDDDistPlot() throws Exception {
        int maxDist = 500;
        double maxEn = 4.0;
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        BufferedWriter w = new BufferedWriter(new FileWriter("siddsDist10000-4.out"));
        block0: for (Gene currGene : genes) {
            SIDDSite currSidd;
            ListIterator<SIDDSite> siddIt;
            if (currGene.getStrand() == '-') {
                siddIt = sidds.listIterator();
                while (siddIt.hasNext()) {
                    currSidd = siddIt.next();
                    if (currSidd.getEnd() - currGene.getEnd() > maxDist) continue block0;
                    if (currSidd.getMinIncEnergy() > maxEn || currSidd.getEnd() < currGene.getEnd()) continue;
                    w.append(String.valueOf(Integer.toString(currSidd.getEnd() - currGene.getEnd())) + "\t" + currSidd.getMinIncEnergy());
                    w.newLine();
                }
                continue;
            }
            siddIt = sidds.listIterator(sidds.size());
            while (siddIt.hasPrevious()) {
                currSidd = siddIt.previous();
                if (currGene.getStart() - currSidd.getStart() > maxDist) continue block0;
                if (currSidd.getMinIncEnergy() > maxEn || currSidd.getStart() > currGene.getStart()) continue;
                w.append(String.valueOf(Integer.toString(currGene.getStart() - currSidd.getStart())) + "\t" + currSidd.getMinIncEnergy());
                w.newLine();
            }
        }
        w.close();
    }

    private static void writeSIDDNCDistPlot() throws Exception {
        int maxDist = 500;
        double maxEn = 4.0;
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites.sidd");
        List<NCRNA> ncrnas = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        BufferedWriter w = new BufferedWriter(new FileWriter("siddsNCDist.out"));
        int tmpDist1 = 0;
        int tmpDist2 = 0;
        int tmpDistMin = 0;
        for (NCRNA currNcrna : ncrnas) {
            ListIterator<SIDDSite> siddIt = sidds.listIterator();
            while (siddIt.hasNext()) {
                SIDDSite currSidd = siddIt.next();
                tmpDist1 = currNcrna.getStart() - currSidd.getEnd();
                tmpDistMin = Math.max(tmpDist1, tmpDist2 = currSidd.getStart() - currNcrna.getEnd());
                if (tmpDistMin > maxDist || currSidd.getMinIncEnergy() > maxEn) continue;
                w.append(String.valueOf(Integer.toString(tmpDistMin)) + "\t" + currSidd.getMinIncEnergy());
                w.newLine();
            }
        }
        w.close();
    }

    private static void siddAbstractProfiling(int upstreamRegSize, int codingRegSize, String outfilename) throws Exception {
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        LinkedList<Gene> genes2 = new LinkedList<Gene>();
        genes2.add(genes.get(4229));
        genes2.add(genes.get(2197));
        genes2 = genes;
        SIDDAbstractGeneProfiler profiler = new SIDDAbstractGeneProfiler(Main.genome, genes2, upstreamRegSize, codingRegSize);
        profiler.profileUpstreamRegions();
        BufferedWriter bw = new BufferedWriter(new FileWriter(outfilename));
        for (String s : profiler.getResStrings()) {
            bw.append(String.valueOf(s) + "\n");
        }
        bw.close();
    }

    private static void writeGeneSIDDProfileMatrix(int upstreamRegSize, int codingRegSize, String outfilename) throws Exception {
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        SIDDProfileReader spr = new SIDDProfileReader("data/coeli_sidds/siddProfile_sig0-06.out", Main.genome.getLength());
        spr.readProfile();
        double[] bigProfile = spr.getGx();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        BufferedWriter resw = new BufferedWriter(new FileWriter(outfilename));
        for (Gene g : genes) {
            int i;
            int tmpEnd;
            int tmpStart;
            if (g.getStrand() == '+') {
                tmpStart = g.getStart() - upstreamRegSize;
                tmpEnd = g.getStart() + codingRegSize - 1;
            } else {
                tmpStart = g.getEnd() - codingRegSize + 1;
                tmpEnd = g.getEnd() + upstreamRegSize;
            }
            if (tmpStart >= tmpEnd) {
                throw new Error("This should never happen!");
            }
            if (tmpStart < 1 || tmpEnd > Main.genome.getEnd()) continue;
            resw.append(g.getID());
            if (g.getStrand() == '+') {
                i = tmpStart - 1;
                while (i <= tmpEnd - 1) {
                    resw.append("\t" + bigProfile[i]);
                    ++i;
                }
            } else {
                i = tmpEnd - 1;
                while (i >= tmpStart - 1) {
                    resw.append("\t" + bigProfile[i]);
                    --i;
                }
            }
            resw.newLine();
        }
        resw.close();
    }

    private static void writeNcSIDDProfileMatrix(int RegSize, String outfilename) throws Exception {
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        SIDDProfileReader spr = new SIDDProfileReader("data/gi_32141095_ref_NC_003888_3/siddProfile.out", Main.genome.getLength());
        spr.readProfile();
        double[] bigProfile = spr.getGx();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/BAK_gi_32141095_ref_NC_003888_3/siddSites.out");
        List<Terminator> terms = TermTableParser.parseTermTable("data/BAK_gi_32141095_ref_NC_003888_3/terminators.out");
        NCRNAAnnotater ncAnno = new NCRNAAnnotater(ncRNAs);
        ncAnno.annotateWithSIDDSites(sidds);
        ncAnno.annotateWithTerminators(terms);
        LinkedList<NCRNATranscript> ncTranscripts = new LinkedList<NCRNATranscript>();
        for (NCRNA nc : ncRNAs) {
            nc.predictNCRNATranscripts();
            ncTranscripts.addAll(nc.getPredictedNCRNATranscripts());
        }
        BufferedWriter resw = new BufferedWriter(new FileWriter(outfilename));
        for (NCRNA nc : ncRNAs) {
            int tmpEnd;
            int halflength = (nc.getEnd() - nc.getStart()) / 2 + nc.getStart();
            int tmpStart = halflength - RegSize / 2;
            if (tmpStart >= (tmpEnd = halflength + RegSize / 2)) {
                throw new Error("This should never happen!");
            }
            if (tmpStart < 1 || tmpEnd > Main.genome.getEnd()) continue;
            resw.append(nc.getID());
            int i = tmpStart - 1;
            while (i <= tmpEnd - 1) {
                resw.append("\t" + bigProfile[i]);
                ++i;
            }
            resw.newLine();
        }
        resw.close();
    }

    private static void writeNcTuSIDDProfileMatrix(int upstreamRegSize, int codingRegSize, String outfilename) throws Exception {
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        SIDDProfileReader spr = new SIDDProfileReader("data/gi_32141095_ref_NC_003888_3/siddProfile.out", Main.genome.getLength());
        spr.readProfile();
        double[] bigProfile = spr.getGx();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/BAK_gi_32141095_ref_NC_003888_3/siddSites.out");
        List<Terminator> terms = TermTableParser.parseTermTable("data/BAK_gi_32141095_ref_NC_003888_3/terminators.out");
        NCRNAAnnotater ncAnno = new NCRNAAnnotater(ncRNAs);
        ncAnno.annotateWithSIDDSites(sidds);
        ncAnno.annotateWithTerminators(terms);
        LinkedList<NCRNATranscript> ncTranscripts = new LinkedList<NCRNATranscript>();
        for (NCRNA nc : ncRNAs) {
            nc.predictNCRNATranscripts();
            ncTranscripts.addAll(nc.getPredictedNCRNATranscripts());
        }
        BufferedWriter resw = new BufferedWriter(new FileWriter(outfilename));
        for (NCRNATranscript ncT : ncTranscripts) {
            int i;
            int tmpEnd;
            int tmpStart;
            if (ncT.getStrand() == '+') {
                tmpStart = ncT.getStart() - upstreamRegSize;
                tmpEnd = ncT.getStart() + codingRegSize - 1;
            } else {
                tmpStart = ncT.getEnd() - codingRegSize + 1;
                tmpEnd = ncT.getEnd() + upstreamRegSize;
            }
            if (tmpStart >= tmpEnd) {
                throw new Error("This should never happen!");
            }
            if (tmpStart < 1 || tmpEnd > Main.genome.getEnd()) continue;
            resw.append(ncT.getID());
            if (ncT.getStrand() == '+') {
                i = tmpStart - 1;
                while (i <= tmpEnd - 1) {
                    resw.append("\t" + bigProfile[i]);
                    ++i;
                }
            } else {
                i = tmpEnd - 1;
                while (i >= tmpStart - 1) {
                    resw.append("\t" + bigProfile[i]);
                    --i;
                }
            }
            resw.newLine();
        }
        resw.close();
    }

    private static void countTermsSiddsPromsForGenes(int updownstreamsize, int termthres, double siddthres) throws Exception {
        int countsidd = 0;
        int countterm = 0;
        int countpc = 0;
        int allcount = 0;
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcmatches = PCTableParser.parseSIDDTable("data/pcMatches.out");
        Iterator<Gene> geneit = genes.iterator();
        Iterator termit = terminators.iterator();
        Iterator<SIDDSite> siddit = sidds.iterator();
        Iterator<PCMatch> pcit = pcmatches.iterator();
        block0: while (geneit.hasNext()) {
            Gene currgene = geneit.next();
            ++allcount;
            if (currgene.getStrand() == '+') {
                for (Terminator currterm : terminators) {
                    if (currterm.getEnd() < currgene.getEnd() || currterm.getStart() > currgene.getEnd() + updownstreamsize || currterm.getStrand() != currgene.getStrand() || currterm.getConfidence() < termthres) continue;
                    ++countterm;
                    break;
                }
                for (SIDDSite currsidd : sidds) {
                    if (currsidd.getEnd() < currgene.getStart() - updownstreamsize || currsidd.getStart() > currgene.getStart() || !(currsidd.getMinIncEnergy() <= siddthres)) continue;
                    ++countsidd;
                    break;
                }
                for (PCMatch currpc : pcmatches) {
                    if (currpc.getEnd() < currgene.getStart() - updownstreamsize || currpc.getStart() > currgene.getStart()) continue;
                    ++countpc;
                    continue block0;
                }
                continue;
            }
            for (Terminator currterm : terminators) {
                if (currterm.getStart() > currgene.getStart() || currterm.getEnd() < currgene.getStart() - updownstreamsize || currterm.getStrand() != currgene.getStrand() || currterm.getConfidence() < termthres) continue;
                ++countterm;
                break;
            }
            for (SIDDSite currsidd : sidds) {
                if (currsidd.getStart() > currgene.getEnd() + updownstreamsize || currsidd.getEnd() < currgene.getEnd() || !(currsidd.getMinIncEnergy() <= siddthres)) continue;
                ++countsidd;
                break;
            }
            for (PCMatch currpc : pcmatches) {
                if (currpc.getStart() > currgene.getEnd() + updownstreamsize || currpc.getEnd() < currgene.getEnd()) continue;
                ++countpc;
                continue block0;
            }
        }
        System.out.println(String.valueOf(updownstreamsize) + "\t" + termthres + "\t" + siddthres);
        System.out.println("countterm: " + countterm);
        System.out.println("countsidd: " + countsidd);
        System.out.println("countpc: " + countpc);
        System.out.println("allcount: " + allcount);
    }

    private static void antisenseSCOtoXML() throws Exception {
        int maxDistToSCO = 200;
        double maxSIDD = Config.getDouble("siddEnergyCutoff");
        int minConf = Config.getInt("transtermConfidenceCutoff");
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/coeliPCMatches.pcm");
        LinkedList<Gene> selGenes = new LinkedList<Gene>();
        LinkedList<AbstractSequenceFeature> selFeatures = new LinkedList<AbstractSequenceFeature>();
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        while (ncIt.hasNext()) {
            ncIt.next().predictNCRNATranscripts();
        }
        for (Gene currGene : genes) {
            boolean selGene = false;
            for (NCRNA currNCRNA : ncRNAs) {
                for (NCRNATranscript currT : currNCRNA.getPredictedNCRNATranscripts()) {
                    if (currGene.numOverlappingBases(currT) <= 0 || currGene.getStrand() == currT.getStrand() || currGene.numOverlappingBases(currNCRNA) <= 0) continue;
                    selGene = true;
                    break;
                }
                if (selGene) break;
            }
            if (!selGene) continue;
            selGenes.add(currGene);
        }
        selFeatures.addAll(selGenes);
        block4: for (Terminator currTerm : terminators) {
            for (Gene currGene : selGenes) {
                if (currTerm.distanceTo(currGene) > maxDistToSCO || currTerm.getConfidence() < minConf) continue;
                selFeatures.add(currTerm);
                continue block4;
            }
        }
        block6: for (SIDDSite currSIDD : sidds) {
            for (Gene currGene : selGenes) {
                if (currSIDD.distanceTo(currGene) > maxDistToSCO || !(currSIDD.getMinIncEnergy() <= maxSIDD)) continue;
                selFeatures.add(currSIDD);
                continue block6;
            }
        }
        for (NCRNA currNCRNA : ncRNAs) {
            boolean selNC = false;
            for (NCRNATranscript currT : currNCRNA.getPredictedNCRNATranscripts()) {
                for (Gene currGene : selGenes) {
                    if (currT.numOverlappingBases(currGene) <= 0 || currT.getStrand() == currGene.getStrand()) continue;
                    selNC = true;
                    break;
                }
                if (selNC) break;
            }
            if (!selNC) continue;
            selFeatures.add(currNCRNA);
        }
        Collections.sort(selFeatures);
        BufferedWriter bw = new BufferedWriter(new FileWriter("antisenseSCOs.txt"));
        for (AbstractSequenceFeature currSF : selFeatures) {
            NCRNA currNCRNA;
            if (currSF instanceof Gene) {
                Gene currGene;
                currGene = (Gene)currSF;
                bw.write(String.valueOf(currGene.getID()) + "\t" + currGene.getStart() + "\t" + currGene.getEnd() + "\t" + currGene.getStrand() + "\t" + "\t");
                bw.newLine();
            }
            if (currSF instanceof Terminator) {
                Terminator currTerm;
                currTerm = (Terminator)currSF;
                bw.write(String.valueOf(currTerm.getID()) + "\t" + currTerm.getStart() + "\t" + currTerm.getEnd() + "\t" + currTerm.getStrand() + "\t" + currTerm.getConfidence() + "\t");
                bw.newLine();
            }
            if (currSF instanceof SIDDSite) {
                SIDDSite currSIDD;
                currSIDD = (SIDDSite)currSF;
                bw.write(String.valueOf(currSIDD.getID()) + "\t" + currSIDD.getStart() + "\t" + currSIDD.getEnd() + "\t" + currSIDD.getStrand() + "\t" + currSIDD.getMinIncEnergy() + "\t");
                bw.newLine();
            }
            if (!(currSF instanceof NCRNA)) continue;
            currNCRNA = (NCRNA)currSF;
            boolean ncX = false;
            for (NCRNATranscript currT : currNCRNA.getPredictedNCRNATranscripts()) {
                for (Gene currGene : selGenes) {
                    if (currT.numOverlappingBases(currGene) <= 0 || currT.getStrand() == currGene.getStrand()) continue;
                    ncX = true;
                    break;
                }
                if (ncX) break;
            }
            bw.write("ncRNA" + currNCRNA.getID() + "\t" + currNCRNA.getStart() + "\t" + currNCRNA.getEnd() + "\t" + currNCRNA.getStrand() + "\t" + "\t");
            if (!ncX) continue;
            bw.newLine();
        }
        bw.close();
        LinkedList<NCRNATranscript> antisenseTs = new LinkedList<NCRNATranscript>();
        for (NCRNA currNCRNA : ncRNAs) {
            block15: for (NCRNATranscript currT : currNCRNA.getPredictedNCRNATranscripts()) {
                for (Gene currGene : genes) {
                    if (currT.numOverlappingBases(currGene) <= 0 || currT.getStrand() == currGene.getStrand()) continue;
                    antisenseTs.add(currT);
                    continue block15;
                }
            }
        }
        Collections.sort(antisenseTs);
        bw = new BufferedWriter(new FileWriter("predAntisenseTranscripts.txt"));
        for (NCRNATranscript currT : antisenseTs) {
            bw.write(String.valueOf(currT.getID()) + "\t" + currT.getStart() + "\t" + currT.getEnd() + "\t" + currT.getStrand() + "\t" + currT.getSiddSite().getMinIncEnergy() + "\t" + currT.getTerminator().getConfidence() + "\t");
            for (Gene currGene : genes) {
                if (currT.numOverlappingBases(currGene) <= 0 || currT.getStrand() == currGene.getStrand()) continue;
                bw.write(currGene.getID());
                break;
            }
            bw.newLine();
        }
        bw.close();
    }

    private static void writeSelectedIGProbeRegionsToFASTA(String igProbeIDsFilename, String igProbeFilename, int regionSize, String fastaFilename) throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(igProbeIDsFilename));
        LinkedList<String> probeIds = new LinkedList<String>();
        String id = r.readLine();
        while (id != null) {
            probeIds.add(id);
            id = r.readLine();
        }
        List<ArrayProbe> allIgProbes = ArrayProbe.parseTilingMap(igProbeFilename);
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        Iterator idIt = probeIds.iterator();
        Iterator<ArrayProbe> probeIt = allIgProbes.iterator();
        LinkedList<ArrayProbe> selectedProbes = new LinkedList<ArrayProbe>();
        while (idIt.hasNext()) {
            String tmpID = (String)idIt.next();
            System.out.println("IDsearch: " + tmpID);
            for (ArrayProbe tmpProbe : allIgProbes) {
                if (!tmpProbe.getID().equalsIgnoreCase(tmpID)) continue;
                selectedProbes.add(tmpProbe);
            }
        }
        probeIt = selectedProbes.iterator();
        Iterator<Gene> geneIt = genes.iterator();
        LinkedList<FASTAEntry> fastaOut = new LinkedList<FASTAEntry>();
        while (probeIt.hasNext()) {
            ArrayProbe tmpProbe;
            tmpProbe = probeIt.next();
            int tmpStart = tmpProbe.getStart() - regionSize / 2 + 1;
            int tmpEnd = tmpProbe.getEnd() + regionSize / 2;
            System.out.print("processing: " + tmpProbe.getID());
            for (Gene tmpGene : genes) {
                if (tmpStart >= tmpGene.getStart() && tmpStart <= tmpGene.getEnd()) {
                    tmpStart = tmpGene.getEnd() + 1;
                }
                if (tmpEnd < tmpGene.getStart() || tmpEnd > tmpGene.getEnd()) continue;
                tmpEnd = tmpGene.getStart() - 1;
            }
            if (tmpStart < 1) {
                tmpStart = 1;
            }
            if (tmpEnd > Main.genome.getEnd()) {
                tmpEnd = Main.genome.getEnd();
            }
            System.out.println(" " + tmpStart + " " + tmpEnd);
            if (tmpStart >= tmpEnd || tmpEnd - tmpStart + 1 < 100) continue;
            DNASequence tmpSeq = Main.genome.getSequence().getSubsequence(tmpStart, tmpEnd);
            if (tmpProbe.getStrand() == '-') {
                tmpSeq = SequenceTools.reverseComplementDNA(tmpSeq);
            }
            fastaOut.add(new FASTAEntry<DNASequence>(String.valueOf(tmpProbe.getID()) + "_" + tmpProbe.getStart() + "_" + tmpProbe.getStrand(), tmpSeq));
        }
        FASTAWriter.write(new BufferedWriter(new FileWriter(fastaFilename)), fastaOut);
    }

    private static void writeSelectedIGProbeDistanceToSCOsDistributions(String igProbeIDsFilename, String igProbeFilename, String outfile) throws Exception {
        LinkedList<String> probeIds = new LinkedList<String>();
        if (igProbeIDsFilename != null) {
            BufferedReader r = new BufferedReader(new FileReader(igProbeIDsFilename));
            String id = r.readLine();
            while (id != null) {
                probeIds.add(id);
                id = r.readLine();
            }
        }
        List<ArrayProbe> allIgProbes = ArrayProbe.parseTilingMap(igProbeFilename);
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        Iterator idIt = probeIds.iterator();
        Iterator<Object> probeIt = allIgProbes.iterator();
        List<Object> selectedProbes = new LinkedList();
        if (igProbeIDsFilename != null) {
            while (idIt.hasNext()) {
                String tmpID = (String)idIt.next();
                System.out.println("IDsearch: " + tmpID);
                for (ArrayProbe tmpProbe : allIgProbes) {
                    if (!tmpProbe.getID().equalsIgnoreCase(tmpID)) continue;
                    selectedProbes.add(tmpProbe);
                }
            }
        } else {
            selectedProbes = allIgProbes;
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(outfile));
        probeIt = selectedProbes.iterator();
        Iterator<Gene> geneIt = genes.iterator();
        while (probeIt.hasNext()) {
            ArrayProbe tmpProbe;
            tmpProbe = (ArrayProbe)probeIt.next();
            if (!tmpProbe.getProbeSetID().startsWith("IG")) continue;
            System.out.println("processing: " + tmpProbe.getID());
            int tmpMin = Integer.MAX_VALUE;
            String tmpMinSCO = "NA";
            for (Gene tmpGene : genes) {
                if (tmpGene.getStrand() != tmpProbe.getStrand() || tmpProbe.distanceTo(tmpGene) >= tmpMin) continue;
                tmpMin = tmpProbe.distanceTo(tmpGene);
                tmpMinSCO = tmpGene.getID();
            }
            w.write(String.valueOf(tmpProbe.getID()) + "\t" + tmpMin + "\t" + tmpMinSCO);
            w.newLine();
        }
        w.close();
    }

    private static void clusterIdsOut(int from, int to) throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter("clusterIDs.txt"));
        int i = from;
        while (i <= to) {
            w.write("SCO" + i);
            w.newLine();
            ++i;
        }
        w.close();
    }

    private static void mapSCOsToAffyIDs(String igProbeFilename) throws Exception {
        List<ArrayProbe> allProbes = ArrayProbe.parseTilingMap(igProbeFilename);
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        HashMap<String, Integer> affyIds = new HashMap<String, Integer>();
        Iterator<Gene> geneIt = genes.iterator();
        BufferedWriter w = new BufferedWriter(new FileWriter("scoAffyMap.tsv"));
        while (geneIt.hasNext()) {
            Gene tmpGene = geneIt.next();
            w.write(tmpGene.getID());
            System.out.println(tmpGene.getID());
            affyIds.clear();
            for (ArrayProbe tmpProbe : allProbes) {
                if (tmpProbe.getStrand() != tmpGene.getStrand() || tmpProbe.getStart() < tmpGene.getStart() || tmpProbe.getStart() > tmpGene.getEnd() || tmpProbe.getEnd() < tmpGene.getStart() || tmpProbe.getEnd() > tmpGene.getEnd()) continue;
                String tmpId = tmpProbe.getProbeSetID();
                Integer tmpInt = (Integer)affyIds.get(tmpId);
                if (tmpInt != null) {
                    affyIds.put(tmpId, tmpInt + 1);
                    continue;
                }
                affyIds.put(tmpId, 1);
            }
            for (String tmpId : affyIds.keySet()) {
                w.write("\t" + tmpId + ":" + affyIds.get(tmpId));
            }
            w.newLine();
        }
        w.close();
    }

    /*
     * WARNING - void declaration
     */
    private static void writeNCRNAsAndSCOsToTranskriptFasta(String ncIDFile, String scoIDFile, int minLength, int maxLength, boolean antisenseOnly) throws Exception {
        DNASequence tmpSeq;
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/pcMatches.out");
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        int numNCRNAs = 0;
        int numSCOs = 0;
        if (maxLength <= minLength) {
            System.out.println("maxLength <= minLength: maxLength set to MAX_VALUE");
            maxLength = Integer.MAX_VALUE;
        }
        List<Object> selectedNCs = new LinkedList();
        if (ncIDFile != null) {
            void var29_29;
            String[] ncIds;
            String[] stringArray = ncIds = QueryParser.parseQueries(new File(ncIDFile));
            int n = ncIds.length;
            boolean bl = false;
            while (var29_29 < n) {
                String id = stringArray[var29_29];
                for (NCRNA nc : ncRNAs) {
                    if (!nc.getID().equalsIgnoreCase(id)) continue;
                    selectedNCs.add(nc);
                }
                ++var29_29;
            }
        } else {
            selectedNCs = ncRNAs;
        }
        List<Object> selectedSCOs = new LinkedList();
        if (scoIDFile != null) {
            void var30_23;
            String[] scoIds;
            String[] stringArray = scoIds = QueryParser.parseQueries(new File(scoIDFile));
            int n3 = scoIds.length;
            boolean bl = false;
            while (var30_23 < n3) {
                String string = stringArray[var30_23];
                for (Gene sco : genes) {
                    if (!sco.getID().equalsIgnoreCase(string)) continue;
                    selectedSCOs.add(sco);
                }
                ++var30_23;
            }
        } else {
            selectedSCOs = genes;
        }
        LinkedList<FASTAEntry> ncTranskripts = new LinkedList<FASTAEntry>();
        for (NCRNA nCRNA : selectedNCs) {
            if (nCRNA.getLength() < minLength || nCRNA.getLength() > maxLength) continue;
            tmpSeq = Main.genome.getSequence().getSubsequence(nCRNA.getStart(), nCRNA.getEnd());
            if (nCRNA.numGenes() > 0) {
                if (nCRNA.numGenes() > 0 && nCRNA.getGenes().get(0).getStrand() == '+') {
                    tmpSeq = SequenceTools.reverseComplementDNA(tmpSeq);
                }
                ncTranskripts.add(new FASTAEntry<DNASequence>(nCRNA.getID(), tmpSeq));
                ++numNCRNAs;
                continue;
            }
            if (antisenseOnly) continue;
            ncTranskripts.add(new FASTAEntry<DNASequence>(String.valueOf(nCRNA.getID()) + "+", tmpSeq));
            tmpSeq = SequenceTools.reverseComplementDNA(tmpSeq);
            ncTranskripts.add(new FASTAEntry<DNASequence>(String.valueOf(nCRNA.getID()) + "-", tmpSeq));
            numNCRNAs += 2;
        }
        LinkedList<FASTAEntry> linkedList = new LinkedList<FASTAEntry>();
        for (Gene gene : selectedSCOs) {
            if (gene.getLength() < minLength || gene.getLength() > maxLength) continue;
            tmpSeq = Main.genome.getSequence().getSubsequence(gene.getStart(), gene.getEnd());
            if (gene.getStrand() == '-') {
                tmpSeq = SequenceTools.reverseComplementDNA(tmpSeq);
            }
            linkedList.add(new FASTAEntry<DNASequence>(gene.getID(), tmpSeq));
            ++numSCOs;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("ncRNAs_intarna.fasta"));
        FASTAWriter.write(bufferedWriter, ncTranskripts);
        bufferedWriter.close();
        BufferedWriter scow = new BufferedWriter(new FileWriter("SCOs_intarna.fasta"));
        FASTAWriter.write(scow, linkedList);
        scow.close();
        System.out.println(String.valueOf(numNCRNAs) + " ncRNAs; " + numSCOs + " Genes");
    }

    private static void intarnaAnalysisNCbased(String resultFile) throws Exception {
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/pcMatches.out");
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        IntaRNAParser intarnaP = new IntaRNAParser(resultFile, ncRNAs, genes);
        intarnaP.parseAndAnnotate();
        LinkedList<NCRNA> ncRNAsSel = new LinkedList<NCRNA>();
        for (NCRNA nc : ncRNAs) {
            if (nc.numInteractions() <= 0) continue;
            ncRNAsSel.add(nc);
        }
        for (NCRNA nc : ncRNAsSel) {
            Collections.sort(nc.getInteractions());
            if (nc.getInteractions().get(0).getEnergy() > -20.0) continue;
            Gene currGene = nc.getGenes().get(0);
            TranskriptInteraction tmpInteraction = null;
            for (TranskriptInteraction ti : nc.getInteractions()) {
                if (!ti.getTarget().getID().equalsIgnoreCase(currGene.getID())) continue;
                tmpInteraction = ti;
                break;
            }
            System.out.print(String.valueOf(nc.getID()) + "\t" + (nc.getInteractions().indexOf(tmpInteraction) + 1) + "/" + nc.getInteractions().size());
            for (TranskriptInteraction ti : nc.getInteractions()) {
                System.out.print("\t" + ti.getTarget().getID() + ":" + ti.getEnergy() + ":" + ti.getInteractionLength() + ":" + ti.getNormEnergy());
            }
            System.out.println("");
        }
    }

    private static void intarnaAnalysisSCObased(String resultFile) throws Exception {
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/pcMatches.out");
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        IntaRNAParser intarnaP = new IntaRNAParser(resultFile, ncRNAs, genes);
        intarnaP.parseAndAnnotate();
        LinkedList<Gene> scoSel = new LinkedList<Gene>();
        for (Gene gene : genes) {
            if (gene.numInteractions() <= 0) continue;
            scoSel.add(gene);
        }
        for (Gene gene : scoSel) {
            Collections.sort(gene.getInteractions());
            System.out.print(String.valueOf(gene.getID()) + "\t" + gene.getInteractions().size());
            for (TranskriptInteraction ti : gene.getInteractions()) {
                if (ti.getEnergy() > -20.0) continue;
                System.out.print("\t" + ti.getHunter().getID() + ":" + ti.getEnergy() + ":" + ti.getInteractionLength() + ":" + ti.getNormEnergy());
            }
            System.out.println("");
        }
    }

    private static void intarnaAnalysisSCOinteractionProfile(String resultFile) throws Exception {
        TransTermParser ttp = new TransTermParser("data/terms_50.tt");
        ttp.parse();
        List<NCRNA> ncRNAs = NCRNATableParser.parseNCRNATable("data/ScoeliAllncRNAs.crd");
        LinkedList<Terminator> terminators = ttp.getTerminators();
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        List<SIDDSite> sidds = SIDDTableParser.parseSIDDTable("data/coeliSIDDSites10000.out");
        List<PCMatch> pcMatches = PCTableParser.parseSIDDTable("data/pcMatches.out");
        new TerminatorClassifier(terminators).classifyGeneContext(genes);
        new SIDDSiteClassifier(sidds).classifyGeneContext(genes);
        new PCMatchClassifier(pcMatches).classifyGeneContext(genes);
        NCRNAAnnotater annotater = new NCRNAAnnotater(ncRNAs);
        annotater.annotateWithTerminators(terminators);
        annotater.annotateWithGenes(genes);
        annotater.annotateWithSIDDSites(sidds);
        annotater.annotateWithPCMatches(pcMatches);
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        IntaRNAParser intarnaP = new IntaRNAParser(resultFile, ncRNAs, genes);
        intarnaP.parseAndAnnotate();
        LinkedList<Gene> scoSel = new LinkedList<Gene>();
        for (Gene gene : genes) {
            if (gene.numInteractions() <= 0) continue;
            scoSel.add(gene);
        }
        for (Gene g : scoSel) {
            double[] profile = new double[g.getLength()];
            for (TranskriptInteraction ti : g.getInteractions()) {
                int i = ti.getTargetStart();
                while (i <= ti.getTargetEnd()) {
                    int n = i - 1;
                    profile[n] = profile[n] + Math.log(Math.exp(-(ti.getEnergy() / (SIDDSettings.GAS_CONSTANT * SIDDSettings.DEFAULT_TEMPERATURE))));
                    ++i;
                }
            }
            System.out.print(g.getID());
            double[] dArray = profile;
            int n = profile.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                System.out.print("\t" + d);
                ++n2;
            }
            System.out.println("");
        }
    }

    public static void writeStrandDepSCOids() throws Exception {
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        BufferedWriter w = new BufferedWriter(new FileWriter("sco_ids_rev.txt"));
        for (Gene g : genes) {
            if (g.getStrand() != '-') continue;
            w.write(String.valueOf(g.getID()) + "\n");
        }
        w.close();
    }

    public static void extractUniqueIntergenicRegions(int minLength, int maxLength, int assumedUTRlength) throws Exception {
        List<Gene> genes = ProteinTableParser.parseProteinTable("data/NC_003888.ptt");
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        Main.genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
        char[] genomeCh = (String.valueOf(Main.genome.getSequence().getSequenceString()) + SequenceTools.reverseComplementDNA(Main.genome.getSequence())).toCharArray();
        BufferedWriter w = new BufferedWriter(new FileWriter("uniq_interg_regs.txt"));
        Collections.sort(genes);
        Iterator<Gene> it = genes.iterator();
        LinkedList<FASTAEntry> intergenics = new LinkedList<FASTAEntry>();
        Gene nextgene = it.next();
        while (it.hasNext()) {
            Gene thisgene = nextgene;
            nextgene = it.next();
            int start = thisgene.getEnd() + assumedUTRlength;
            int end = nextgene.getStart() - assumedUTRlength;
            if (end <= start || end - start < minLength) continue;
            if (end - start > maxLength) {
                end -= end - start - maxLength;
            }
            boolean start1 = false;
            int start2 = 0;
            int matches = 0;
            int maxMatch = 0;
            int pos = 0;
            while (pos < genomeCh.length - 1 - (end - start)) {
                start2 = pos;
                if (!(pos + end - start >= start - 1 && pos + end - start <= end - 1 || pos >= start - 1 && pos <= end - 1)) {
                    matches = 0;
                    int diff_iterator = 0;
                    while (diff_iterator != end - start) {
                        matches = genomeCh[start - 1 + diff_iterator] == genomeCh[start2 + diff_iterator] ? ++matches : 0;
                        ++diff_iterator;
                    }
                    maxMatch = Math.max(maxMatch, matches);
                }
                ++pos;
            }
            System.out.println(start);
            intergenics.add(new FASTAEntry<DNASequence>(String.valueOf(start) + "-" + end + "_" + (end - start) + "_" + maxMatch, Main.genome.getSequence().getSubsequence(start, end)));
        }
        FASTAWriter.write(w, intergenics);
    }

    public static void test() {
        String[] t = new String[]{"hallo", "du", "sack"};
        List<String> l = Arrays.asList(t);
        for (String i : l) {
            System.out.println(i);
        }
    }
}

