/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import interact.TranskriptInteraction;
import java.util.LinkedList;
import java.util.List;
import seq.Sequence;

public abstract class AbstractSequenceFeature
implements Comparable {
    private String ID;
    private int start;
    private int end;
    private char strand;
    private Sequence sequence;
    private int[] interactionProfileN;
    private double[] interactionProfileG;
    private double[] interactionProfileZ;
    private double[] interactionProfileZZ;
    private double[] interactionProfileZZnet;
    private double Z;
    private double Znet;
    private List<TranskriptInteraction> interactions;

    public AbstractSequenceFeature() {
        this("", 0, 0, '.');
    }

    public AbstractSequenceFeature(String ID, int start, int end, char strand) {
        this.ID = ID.trim();
        if (end > start) {
            this.start = start;
            this.end = end;
        } else {
            this.start = end;
            this.end = start;
        }
        this.setStrand(strand);
        this.interactions = new LinkedList<TranskriptInteraction>();
    }

    public int compareTo(Object o) {
        AbstractSequenceFeature sf = (AbstractSequenceFeature)o;
        int res = this.getStart() - sf.getStart();
        if (res == 0) {
            return this.getEnd() - sf.getEnd();
        }
        return res;
    }

    public int numOverlappingBases(AbstractSequenceFeature anotherSF) {
        int res = Math.min(this.getEnd() - anotherSF.getStart() + 1, anotherSF.getEnd() - this.getStart() + 1);
        if ((res = Math.min(res, Math.min(this.getLength(), anotherSF.getLength()))) > 0) {
            return res;
        }
        return 0;
    }

    public int distanceTo(AbstractSequenceFeature anotherSF) {
        int res = this.numOverlappingBases(anotherSF) > 0 ? 0 : Math.min(Math.abs(anotherSF.getStart() - this.getEnd() - 1), Math.abs(this.getStart() - anotherSF.getEnd() - 1));
        return res;
    }

    public String toString() {
        return String.valueOf(this.ID) + "\t" + this.start + "\t" + this.end + "\t" + this.strand;
    }

    public String getID() {
        return this.ID;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    protected void setStart_WARNING(int newStart) {
        this.start = newStart;
    }

    protected void setEnd_WARNING(int newEnd) {
        this.end = newEnd;
    }

    public int getLength() {
        return this.getEnd() - this.getStart() + 1;
    }

    public char getStrand() {
        return this.strand;
    }

    public void addInteraction(TranskriptInteraction ti) {
        this.interactions.add(ti);
    }

    public List<TranskriptInteraction> getInteractions() {
        return this.interactions;
    }

    public void clearInteractions() {
        this.interactions.clear();
    }

    public int numInteractions() {
        return this.interactions.size();
    }

    public void setInteractionProfiles(int[] profileN, double[] profileZ, double[] profileG, double Z, double Znet) {
        if (profileN.length != this.getLength() || profileZ.length != this.getLength() || profileG.length != this.getLength()) {
            throw new IllegalArgumentException("The interaction profile's length has to match the length of the sequence feature!");
        }
        this.interactionProfileG = profileG;
        this.interactionProfileN = profileN;
        this.interactionProfileZ = profileZ;
        this.Z = Z;
        this.Znet = Znet;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setStrand(char strand) {
        this.strand = strand == '+' ? (char)43 : (strand == '-' ? (char)45 : (char)46);
    }

    public void setSequence(Sequence sequence) {
        if (!this.isSequenceConsitentWithFeatureType(sequence)) {
            throw new IllegalArgumentException("Sequence inconsistent with feature type");
        }
        this.sequence = sequence;
    }

    public abstract boolean isSequenceConsitentWithFeatureType(Sequence var1);

    public abstract String toGFFString();

    public int[] getInteractionProfileN() {
        return this.interactionProfileN;
    }

    public double[] getInteractionProfileG() {
        return this.interactionProfileG;
    }

    public double[] getInteractionProfileZ() {
        if (this.interactionProfileZ == null) {
            return null;
        }
        if (this.interactionProfileZZ == null) {
            this.interactionProfileZZ = (double[])this.interactionProfileZ.clone();
            int i = 0;
            while (i < this.interactionProfileZZ.length) {
                int n = i++;
                this.interactionProfileZZ[n] = this.interactionProfileZZ[n] / this.Z;
            }
        }
        return this.interactionProfileZZ;
    }

    public double[] getInteractionProfileZnet() {
        if (this.interactionProfileZ == null) {
            return null;
        }
        if (this.interactionProfileZZnet == null) {
            this.interactionProfileZZnet = (double[])this.interactionProfileZ.clone();
            int i = 0;
            while (i < this.interactionProfileZZnet.length) {
                int n = i++;
                this.interactionProfileZZnet[n] = this.interactionProfileZZnet[n] / this.Znet;
            }
        }
        return this.interactionProfileZZnet;
    }

    public double getZ() {
        return this.Z;
    }

    public double getZnet() {
        return this.Znet;
    }
}

