/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Config;
import genomic.Gene;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;

public class ProteinTableParser {
    private static final char COMMENT_CHAR = Config.getChar("commentChar");

    public static List<Gene> parseProteinTable(String filename) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        LinkedList<Gene> genes = new LinkedList<Gene>();
        String line = br.readLine();
        while (line != null) {
            int end;
            int start;
            if ((line = line.trim()).length() == 0) {
                line = br.readLine();
                continue;
            }
            if (line.charAt(0) == COMMENT_CHAR) {
                line = br.readLine();
                continue;
            }
            String[] lineFields = line.split("[\\s]+");
            if (lineFields.length < 9) {
                line = br.readLine();
                continue;
            }
            String[] startEndStr = lineFields[0].split("\\.\\.");
            if (startEndStr.length != 2) {
                line = br.readLine();
                continue;
            }
            try {
                start = Integer.parseInt(startEndStr[0]);
                end = Integer.parseInt(startEndStr[1]);
            }
            catch (NumberFormatException e) {
                line = br.readLine();
                continue;
            }
            String name = lineFields[5];
            if (name.equalsIgnoreCase("-")) {
                name = lineFields[4];
            }
            char strand = lineFields[1].charAt(0);
            genes.add(new Gene(name, start, end, strand));
            line = br.readLine();
        }
        br.close();
        return genes;
    }
}

