/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import chip.MicroArrayResult;
import genomic.AbstractSequenceFeature;
import genomic.MASequenceFeature;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SequenceFeatureTools {
    public static void writeSequenceFeatures(List<? extends AbstractSequenceFeature> seqFeatures, String filename) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        Iterator<? extends AbstractSequenceFeature> featureIt = seqFeatures.iterator();
        while (featureIt.hasNext()) {
            bw.append(String.valueOf(featureIt.next().toString()) + "\n");
        }
        bw.close();
    }

    public static void annotateWithMicroArrayResults(List<? extends MASequenceFeature> seqFeatures, List<MicroArrayResult> maResults) {
        if (seqFeatures.size() == 0 || maResults.size() == 0) {
            return;
        }
        Comparator<MASequenceFeature> lexoComp1 = new Comparator<MASequenceFeature>(){

            @Override
            public int compare(MASequenceFeature o1, MASequenceFeature o2) {
                return o1.getID().compareTo(o2.getID());
            }
        };
        Comparator<MicroArrayResult> lexoComp2 = new Comparator<MicroArrayResult>(){

            @Override
            public int compare(MicroArrayResult o1, MicroArrayResult o2) {
                return o1.getID().compareTo(o2.getID());
            }
        };
        Collections.sort(seqFeatures, lexoComp1);
        Collections.sort(maResults, lexoComp2);
        Iterator<? extends MASequenceFeature> featureIt = seqFeatures.iterator();
        Iterator<MicroArrayResult> maResultIt = maResults.iterator();
        MASequenceFeature currFeature = featureIt.next();
        while (maResultIt.hasNext()) {
            MicroArrayResult currMAResult = maResultIt.next();
            while (featureIt.hasNext()) {
                if (currFeature.getID().compareTo(currMAResult.getID()) >= 0) break;
                currFeature = featureIt.next();
            }
            if (!currFeature.getID().equals(currMAResult.getID())) continue;
            currFeature.addMicroArrayResult(currMAResult);
            currMAResult.setTarget(currFeature);
        }
        Collections.sort(seqFeatures);
    }

    public static char complementStrand(char strand) {
        switch (strand) {
            case '+': {
                return '-';
            }
            case '-': {
                return '+';
            }
            case '.': {
                return '.';
            }
        }
        throw new IllegalArgumentException("Argument has to be a strand specifier: '+', '-' or '.'");
    }
}

