/*
 * Decompiled with CFR 0.152.
 */
package interact;

import efault.Config;
import interact.TranskriptInteraction;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ThresholdProvider {
    private List<TranskriptInteraction> interactions;
    private static final boolean autoThres = Config.getBoolean("autoThres");
    private static final double veryGoodEnergyPerc = Config.getDouble("veryGoodEnergyPerc");
    private static final double veryGoodLengthPerc = Config.getDouble("veryGoodLengthPerc");
    private static final double goodEnergyPerc = Config.getDouble("goodEnergyPerc");
    private static final double goodLengthPerc = Config.getDouble("goodLengthPerc");
    private double veryGoodEnergyThres = Config.getDouble("veryGoodEnergyThres");
    private int veryGoodLengthThres = Config.getInt("veryGoodLengthThres");
    private double goodEnergyThres = Config.getDouble("goodEnergyThres");
    private int goodLengthThres = Config.getInt("goodLengthThres");

    public ThresholdProvider(List<TranskriptInteraction> interactions) {
        this.interactions = interactions;
        if (autoThres) {
            this.guess();
        }
    }

    private void guess() {
        Comparator<TranskriptInteraction> enerComp = new Comparator<TranskriptInteraction>(){

            @Override
            public int compare(TranskriptInteraction o1, TranskriptInteraction o2) {
                return Double.compare(o1.getEnergy(), o2.getEnergy());
            }
        };
        LinkedList<TranskriptInteraction> enerSorted = new LinkedList<TranskriptInteraction>(this.interactions);
        Collections.sort(enerSorted, enerComp);
        this.veryGoodEnergyThres = ((TranskriptInteraction)enerSorted.get((int)Math.round((double)enerSorted.size() / 100.0 * veryGoodEnergyPerc + 0.5))).getEnergy();
        this.goodEnergyThres = ((TranskriptInteraction)enerSorted.get((int)Math.round((double)enerSorted.size() / 100.0 * goodEnergyPerc + 0.5))).getEnergy();
        Comparator<TranskriptInteraction> lenComp = new Comparator<TranskriptInteraction>(){

            @Override
            public int compare(TranskriptInteraction o1, TranskriptInteraction o2) {
                return o2.getInteractionLength() - o1.getInteractionLength();
            }
        };
        LinkedList<TranskriptInteraction> lenSorted = new LinkedList<TranskriptInteraction>(this.interactions);
        Collections.sort(lenSorted, lenComp);
        this.veryGoodLengthThres = ((TranskriptInteraction)lenSorted.get((int)Math.round((double)lenSorted.size() / 100.0 * veryGoodLengthPerc + 0.5))).getInteractionLength();
        this.goodLengthThres = ((TranskriptInteraction)lenSorted.get((int)Math.round((double)lenSorted.size() / 100.0 * goodLengthPerc + 0.5))).getInteractionLength();
    }

    public double getVeryGoodEnergyThres() {
        return this.veryGoodEnergyThres;
    }

    public int getVeryGoodLengthThres() {
        return this.veryGoodLengthThres;
    }

    public double getGoodEnergyThres() {
        return this.goodEnergyThres;
    }

    public int getGoodLengthThres() {
        return this.goodLengthThres;
    }
}

