/*
 * Decompiled with CFR 0.152.
 */
package seq;

import efault.Config;
import seq.DNASequence;

public class SequenceTools {
    static final double G_AA = Config.getDouble("thermoG_AA");
    static final double G_TT = Config.getDouble("thermoG_TT");
    static final double G_AT = Config.getDouble("thermoG_AT");
    static final double G_TA = Config.getDouble("thermoG_TA");
    static final double G_CA = Config.getDouble("thermoG_CA");
    static final double G_TG = Config.getDouble("thermoG_TG");
    static final double G_GT = Config.getDouble("thermoG_GT");
    static final double G_AC = Config.getDouble("thermoG_AC");
    static final double G_CT = Config.getDouble("thermoG_CT");
    static final double G_AG = Config.getDouble("thermoG_AG");
    static final double G_GA = Config.getDouble("thermoG_GA");
    static final double G_TC = Config.getDouble("thermoG_TC");
    static final double G_CG = Config.getDouble("thermoG_CG");
    static final double G_GC = Config.getDouble("thermoG_GC");
    static final double G_GG = Config.getDouble("thermoG_GG");
    static final double G_CC = Config.getDouble("thermoG_CC");

    public static DNASequence shuffle(DNASequence seq) {
        char[] chars = seq.getSequenceString().toCharArray();
        int length = chars.length;
        int i = 0;
        int j = 0;
        while (i < length) {
            j = (int)((double)i + Math.random() * (double)(length - i));
            char tmp = chars[i];
            chars[i] = chars[j];
            chars[j] = tmp;
            ++i;
        }
        return new DNASequence(new String(chars));
    }

    public static DNASequence reverseComplementDNA(DNASequence dna) {
        if (dna == null) {
            return null;
        }
        StringBuffer res = new StringBuffer(dna.getLength());
        int i = dna.getLength();
        while (i >= 1) {
            char complChar;
            char tmpChar = dna.getSymbolAt(i);
            switch (tmpChar) {
                case 'A': {
                    complChar = 'T';
                    break;
                }
                case 'a': {
                    complChar = 't';
                    break;
                }
                case 'T': {
                    complChar = 'A';
                    break;
                }
                case 't': {
                    complChar = 'a';
                    break;
                }
                case 'G': {
                    complChar = 'C';
                    break;
                }
                case 'g': {
                    complChar = 'c';
                    break;
                }
                case 'C': {
                    complChar = 'G';
                    break;
                }
                case 'c': {
                    complChar = 'g';
                    break;
                }
                case 'N': {
                    complChar = 'N';
                    break;
                }
                case 'n': {
                    complChar = 'n';
                    break;
                }
                default: {
                    complChar = 'N';
                    System.err.println("Cannot create reverse complement!");
                }
            }
            res.append(complChar);
            --i;
        }
        return new DNASequence(res.toString());
    }

    public static double[] getGibbsEnergies(DNASequence seq) {
        double[] res = new double[seq.getLength()];
        int seqLength = seq.getLength();
        int i = 0;
        while (i <= seqLength - 15) {
            double tmpG = 0.0;
            int j = 0;
            while (j <= 13) {
                char nuc1 = seq.getSymbolAt(i + j + 1);
                char nuc2 = seq.getSymbolAt(i + j + 1 + 1);
                block0 : switch (nuc1) {
                    case 'A': 
                    case 'a': {
                        switch (nuc2) {
                            case 'A': 
                            case 'a': {
                                tmpG += G_AA;
                                break block0;
                            }
                            case 'T': 
                            case 't': {
                                tmpG += G_AT;
                                break block0;
                            }
                            case 'C': 
                            case 'c': {
                                tmpG += G_AC;
                                break block0;
                            }
                            case 'G': 
                            case 'g': {
                                tmpG += G_AG;
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Bad sequence character: " + nuc2);
                    }
                    case 'T': 
                    case 't': {
                        switch (nuc2) {
                            case 'A': 
                            case 'a': {
                                tmpG += G_TA;
                                break block0;
                            }
                            case 'T': 
                            case 't': {
                                tmpG += G_TT;
                                break block0;
                            }
                            case 'C': 
                            case 'c': {
                                tmpG += G_TC;
                                break block0;
                            }
                            case 'G': 
                            case 'g': {
                                tmpG += G_TG;
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Bad sequence character: " + nuc2);
                    }
                    case 'C': 
                    case 'c': {
                        switch (nuc2) {
                            case 'A': 
                            case 'a': {
                                tmpG += G_CA;
                                break block0;
                            }
                            case 'T': 
                            case 't': {
                                tmpG += G_CT;
                                break block0;
                            }
                            case 'C': 
                            case 'c': {
                                tmpG += G_CC;
                                break block0;
                            }
                            case 'G': 
                            case 'g': {
                                tmpG += G_CG;
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Bad sequence character: " + nuc2);
                    }
                    case 'G': 
                    case 'g': {
                        switch (nuc2) {
                            case 'A': 
                            case 'a': {
                                tmpG += G_GA;
                                break block0;
                            }
                            case 'T': 
                            case 't': {
                                tmpG += G_GT;
                                break block0;
                            }
                            case 'C': 
                            case 'c': {
                                tmpG += G_GC;
                                break block0;
                            }
                            case 'G': 
                            case 'g': {
                                tmpG += G_GG;
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Bad sequence character: " + nuc2);
                    }
                    default: {
                        throw new IllegalArgumentException("Bad sequence character: " + nuc1);
                    }
                }
                ++j;
            }
            res[i] = tmpG;
            ++i;
        }
        int k = i;
        while (k < res.length) {
            res[k] = res[i];
            ++k;
        }
        return res;
    }
}

