/*
 * Decompiled with CFR 0.152.
 */
package sidd;

import efault.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import seq.DNASequence;
import sidd.SIDDAbstractProfile;
import sidd.SIDDDNAProfiler;
import sidd.SIDDProfileAnalyzer;
import sidd.SIDDSettings;

public class SIDDDNAProfiler2 {
    private DNASequence seq;
    private int start;
    private int end;
    private boolean linear;
    private List<SIDDAbstractProfile> abstractProfiles;
    private double[][] Gc;
    private int[][] GcI;
    private double[] Gnc;
    private double[][] Y;
    private double[][] Ye;
    private double[] px;
    private double[] Gx;
    private double minGc;
    private double minGnc;
    private double minG;
    private double Z;
    private double meanG;
    private double sigma;
    private double C;
    private double K;
    private double a;
    private double T;
    private double R;
    private double A;
    private double theta;
    private int W;
    private int N;
    private double G_AA;
    private double G_TT;
    private double G_AT;
    private double G_TA;
    private double G_CA;
    private double G_TG;
    private double G_GT;
    private double G_AC;
    private double G_CT;
    private double G_AG;
    private double G_GA;
    private double G_TC;
    private double G_CG;
    private double G_GC;
    private double G_GG;
    private double G_CC;

    public SIDDDNAProfiler2(DNASequence seq, int start, int end, boolean linear) {
        this.N = Math.abs(end - start + 1);
        if (start >= end) {
            this.N = Math.abs(seq.getLength() - start + end + 1);
        }
        this.seq = seq;
        this.start = start;
        this.end = end;
        this.linear = linear;
        this.sigma = SIDDSettings.DEFAULT_SUPERHELIX_DENSITY;
        this.C = SIDDSettings.TORSIONAL_STIFFNESS;
        this.a = SIDDSettings.INIT_SEPARATION_ENERGY;
        this.T = SIDDSettings.DEFAULT_TEMPERATURE;
        this.R = SIDDSettings.GAS_CONSTANT;
        this.A = SIDDSettings.HELICAL_REPEAT;
        this.theta = SIDDSettings.DEFAULT_ENERGY_THRESHOLD;
        this.W = SIDDSettings.DEFAULT_SMALL_WINDOW_SIZE;
        this.setK();
        this.G_AA = SIDDSettings.G_AA;
        this.G_TT = SIDDSettings.G_TT;
        this.G_AT = SIDDSettings.G_AT;
        this.G_TA = SIDDSettings.G_TA;
        this.G_CA = SIDDSettings.G_CA;
        this.G_TG = SIDDSettings.G_TG;
        this.G_GT = SIDDSettings.G_GT;
        this.G_AC = SIDDSettings.G_AC;
        this.G_CT = SIDDSettings.G_CT;
        this.G_AG = SIDDSettings.G_AG;
        this.G_GA = SIDDSettings.G_GA;
        this.G_TC = SIDDSettings.G_TC;
        this.G_CG = SIDDSettings.G_CG;
        this.G_GC = SIDDSettings.G_GC;
        this.G_GG = SIDDSettings.G_GG;
        this.G_CC = SIDDSettings.G_CC;
        this.Gc = new double[this.W][this.N];
        this.GcI = new int[this.W][this.N];
        this.Gnc = new double[this.W];
        this.Y = new double[this.W][this.N];
        this.Ye = new double[this.W][this.N];
        this.px = new double[this.N];
        this.Gx = new double[this.N];
        this.minGc = Double.MAX_VALUE;
        this.minGnc = Double.MAX_VALUE;
        this.Z = 0.0;
        this.meanG = 0.0;
    }

    public void reset(int start, int end, boolean linear) {
        this.abstractProfiles = null;
        boolean isNchanged = false;
        int newN = Math.abs(end - start + 1);
        if (start >= end) {
            newN = Math.abs(this.seq.getLength() - start + end + 1);
        }
        if (newN != this.N) {
            isNchanged = true;
        }
        this.N = newN;
        this.start = start;
        this.end = end;
        this.linear = linear;
        this.setK();
        if (isNchanged) {
            this.Gc = new double[this.W][this.N];
            this.GcI = new int[this.W][this.N];
            this.Gnc = new double[this.W];
            this.Y = new double[this.W][this.N];
            this.Ye = new double[this.W][this.N];
            this.px = new double[this.N];
            this.Gx = new double[this.N];
        } else {
            int i = 0;
            while (i < this.W) {
                Arrays.fill(this.Gc[i], 0.0);
                Arrays.fill(this.GcI[i], 0);
                Arrays.fill(this.Y[i], 0.0);
                Arrays.fill(this.Ye[i], 0.0);
                ++i;
            }
            Arrays.fill(this.Gnc, 0.0);
            Arrays.fill(this.px, 0.0);
            Arrays.fill(this.Gx, 0.0);
        }
        this.minGc = Double.MAX_VALUE;
        this.minGnc = Double.MAX_VALUE;
        this.Z = 0.0;
        this.meanG = 0.0;
    }

    public void runProfiler() throws Exception {
        this.reset(this.start, this.end, this.linear);
        SIDDDNAProfiler profiler = new SIDDDNAProfiler(this.seq, this.start, this.end, this.linear);
        profiler.runProfiler();
        this.Gx = profiler.getGx();
        this.px = profiler.getPx();
        this.abstractProfiles = SIDDProfileAnalyzer.generateAbstractSIDDProfiles(this.Gx, Config.getDouble("siddEnergyCutoff"));
        this.calculateE();
        this.chemicals();
        this.clearE();
        this.nonChemicals();
        this.setMinG();
        this.oneRuns();
        this.twoRuns();
        this.threeRuns();
        this.considerBaseState();
        this.fill();
    }

    private void considerBaseState() {
        double alpha = this.sigma * ((double)this.N / this.A);
        double baseG = this.K * Math.pow(alpha, 2.0) * 0.5;
        this.Z += Math.exp(-baseG / (this.R * this.T));
        this.meanG += baseG * Math.exp(-baseG / (this.R * this.T));
    }

    private void setMinG() {
        this.minG = Double.MAX_VALUE;
        int i = 0;
        while (i < this.Gc.length) {
            this.minG = Math.min(this.minG, this.Gc[i][0] + this.Gnc[i]);
            ++i;
        }
        double alpha = this.sigma * ((double)this.N / this.A);
        double baseG = this.K * Math.pow(alpha, 2.0) / 2.0;
        this.minG = Math.min(this.minG, baseG);
    }

    private void setK() {
        this.K = SIDDSettings.K_CONSTANT_PART * (this.R * this.T) / (double)this.N;
    }

    private void chemicals() {
        int i = 0;
        while (i < this.W) {
            int j = 0;
            while (j < this.N) {
                double tmpG = this.getE(j, i + 1);
                this.Gc[i][j] = tmpG + this.a;
                this.GcI[i][j] = j;
                ++j;
            }
            this.coSort(this.Gc[i], this.GcI[i], 0, this.N);
            this.minGc = Math.min(this.minGc, this.Gc[i][0]);
            ++i;
        }
    }

    private void nonChemicals() {
        double alpha = this.sigma * ((double)this.N / this.A);
        int i = 0;
        while (i < this.W) {
            double term1 = 2.0 * Math.pow(Math.PI, 2.0) * this.C * this.K / (4.0 * Math.pow(Math.PI, 2.0) * this.C + this.K * (double)(i + 1));
            double term2 = Math.pow(alpha + (double)(i + 1) / this.A, 2.0);
            this.Gnc[i] = term1 * term2;
            this.minGnc = Math.min(this.minGnc, this.Gnc[i]);
            ++i;
        }
    }

    private void oneRuns() {
        int stateCount = 0;
        int i = 0;
        while (i < this.W) {
            int j = 0;
            while (j < this.N) {
                double tmpG = this.Gc[i][j] + this.Gnc[i];
                if (!(tmpG < this.minG + this.theta)) break;
                this.store(tmpG, i + 1, this.GcI[i][j]);
                this.storeToAbstractProfiles(tmpG, i + 1, this.GcI[i][j]);
                ++stateCount;
                if (tmpG < this.minG) {
                    this.minG = tmpG;
                }
                ++j;
            }
            ++i;
        }
    }

    private void twoRuns() {
        int stateCount = 0;
        int n1 = 0;
        while (n1 < this.W) {
            if (!(this.Gc[n1][0] + this.minGc + this.minGnc >= this.minG + this.theta)) {
                int n2 = 0;
                while (n1 + n2 + 2 <= this.W) {
                    if (!(this.Gc[n1][0] + this.Gc[n2][0] + this.Gnc[n1 + n2 + 1] >= this.minG + this.theta)) {
                        int i = 0;
                        while (i < this.N) {
                            if (this.Gc[n1][i] + this.Gc[n2][0] + this.Gnc[n1 + n2 + 1] >= this.minG + this.theta) break;
                            int j = 0;
                            while (j < this.N) {
                                double tmpG = this.Gc[n1][i] + this.Gc[n2][j] + this.Gnc[n1 + n2 + 1];
                                if (tmpG >= this.minG + this.theta || j >= i && j <= i + n1 || i >= j && i <= j + n2 || j + this.N >= i && j + this.N <= i + n1 || i + this.N >= j && i + this.N <= j + n2) break;
                                this.store(tmpG, n1 + 1, this.GcI[n1][i]);
                                this.store(tmpG, n2 + 1, this.GcI[n2][j]);
                                this.storeToAbstractProfiles(tmpG, n1 + 1, this.GcI[n1][i], n2 + 1, this.GcI[n2][j]);
                                ++stateCount;
                                if (tmpG < this.minG) {
                                    this.minG = tmpG;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
            }
            ++n1;
        }
    }

    private void threeRuns() {
        int stateCount = 0;
        int n1 = 0;
        while (n1 < this.W) {
            if (!(this.Gc[n1][0] + 2.0 * this.minGc + this.minGnc >= this.minG + this.theta)) {
                int n2 = 0;
                while (n1 + n2 + 2 <= this.W) {
                    if (!(this.Gc[n1][0] + this.Gc[n2][0] + this.minGc + this.minGnc >= this.minG + this.theta)) {
                        int n3 = 0;
                        while (n1 + n2 + n3 + 3 <= this.W) {
                            if (!(this.Gc[n1][0] + this.Gc[n2][0] + this.Gc[n3][0] + this.Gnc[n1 + n2 + n3 + 2] >= this.minG + this.theta)) {
                                int i = 0;
                                while (i < this.N) {
                                    if (this.Gc[n1][i] + this.Gc[n2][0] + this.Gc[n3][0] + this.Gnc[n1 + n2 + n3 + 2] >= this.minG + this.theta) break;
                                    int j = 0;
                                    while (j < this.N) {
                                        if (this.Gc[n1][i] + this.Gc[n2][j] + this.Gc[n3][0] + this.Gnc[n1 + n2 + n3 + 2] >= this.minG + this.theta) break;
                                        int k = 0;
                                        while (k < this.N) {
                                            double tmpG = this.Gc[n1][i] + this.Gc[n2][j] + this.Gc[n3][k] + this.Gnc[n1 + n2 + n3 + 2];
                                            if (tmpG >= this.minG + this.theta || j >= i && j <= i + n1 || i >= j && i <= j + n2 || k >= i && k <= i + n1 || i >= k && i <= k + n3 || k >= j && k <= j + n2 || j >= k && j <= k + n3 || j + this.N >= i && j + this.N <= i + n1 || i + this.N >= j && i + this.N <= j + n2 || k + this.N >= i && k + this.N <= i + n1 || i + this.N >= k && i + this.N <= k + n3 || k + this.N >= j && k + this.N <= j + n2 || j + this.N >= k && j + this.N <= k + n3) break;
                                            this.store(tmpG, n1 + 1, this.GcI[n1][i]);
                                            this.store(tmpG, n2 + 1, this.GcI[n2][j]);
                                            this.store(tmpG, n3 + 1, this.GcI[n3][k]);
                                            this.storeToAbstractProfiles(tmpG, n1 + 1, this.GcI[n1][i], n2 + 1, this.GcI[n2][j], n3 + 1, this.GcI[n3][k]);
                                            ++stateCount;
                                            if (tmpG < this.minG) {
                                                this.minG = tmpG;
                                            }
                                            ++k;
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n1;
        }
    }

    private void calculateE() {
        this.Gx[0] = this.nearestNeighborG(0);
        int n = 1;
        while (n < this.N) {
            this.Gx[n] = this.nearestNeighborG(n) + this.Gx[n - 1];
            ++n;
        }
    }

    private double getE(int relPos, int windowLength) {
        double tmpG = 0.0;
        int j = relPos;
        int i = windowLength - 1;
        if (j + i < this.N) {
            tmpG = j == 0 ? this.Gx[j + i] : this.Gx[j + i] - this.Gx[j - 1];
        } else if (this.linear) {
            tmpG = Double.MAX_VALUE;
        } else {
            tmpG += this.Gx[this.N - 1] - this.Gx[j - 1];
            tmpG += this.Gx[j + i - this.N];
        }
        return tmpG;
    }

    private void clearE() {
        Arrays.fill(this.Gx, 0.0);
    }

    private double nearestNeighborG(int relPos) {
        char rightN;
        char mid;
        char leftN;
        double tmpG = 0.0;
        if (relPos >= this.N) {
            relPos -= this.N;
        }
        if (relPos == 0) {
            leftN = this.getSeqSymbolAt(this.end);
            mid = this.getSeqSymbolAt(this.start);
            rightN = this.getSeqSymbolAt(this.start + 1);
        } else if (relPos == this.N - 1) {
            leftN = this.getSeqSymbolAt(this.end - 1);
            mid = this.getSeqSymbolAt(this.end);
            rightN = this.getSeqSymbolAt(this.start);
        } else {
            leftN = this.getSeqSymbolAt(this.start + relPos - 1);
            mid = this.getSeqSymbolAt(this.start + relPos);
            rightN = this.getSeqSymbolAt(this.start + relPos + 1);
        }
        char nuc1 = leftN;
        char nuc2 = mid;
        int i = 1;
        while (i >= 0) {
            block0 : switch (nuc1) {
                case 'A': 
                case 'a': {
                    switch (nuc2) {
                        case 'A': 
                        case 'a': {
                            tmpG += this.G_AA;
                            break block0;
                        }
                        case 'T': 
                        case 't': {
                            tmpG += this.G_AT;
                            break block0;
                        }
                        case 'C': 
                        case 'c': {
                            tmpG += this.G_AC;
                            break block0;
                        }
                        case 'G': 
                        case 'g': {
                            tmpG += this.G_AG;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Bad sequence character: " + nuc2);
                }
                case 'T': 
                case 't': {
                    switch (nuc2) {
                        case 'A': 
                        case 'a': {
                            tmpG += this.G_TA;
                            break block0;
                        }
                        case 'T': 
                        case 't': {
                            tmpG += this.G_TT;
                            break block0;
                        }
                        case 'C': 
                        case 'c': {
                            tmpG += this.G_TC;
                            break block0;
                        }
                        case 'G': 
                        case 'g': {
                            tmpG += this.G_TG;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Bad sequence character: " + nuc2);
                }
                case 'C': 
                case 'c': {
                    switch (nuc2) {
                        case 'A': 
                        case 'a': {
                            tmpG += this.G_CA;
                            break block0;
                        }
                        case 'T': 
                        case 't': {
                            tmpG += this.G_CT;
                            break block0;
                        }
                        case 'C': 
                        case 'c': {
                            tmpG += this.G_CC;
                            break block0;
                        }
                        case 'G': 
                        case 'g': {
                            tmpG += this.G_CG;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Bad sequence character: " + nuc2);
                }
                case 'G': 
                case 'g': {
                    switch (nuc2) {
                        case 'A': 
                        case 'a': {
                            tmpG += this.G_GA;
                            break block0;
                        }
                        case 'T': 
                        case 't': {
                            tmpG += this.G_GT;
                            break block0;
                        }
                        case 'C': 
                        case 'c': {
                            tmpG += this.G_GC;
                            break block0;
                        }
                        case 'G': 
                        case 'g': {
                            tmpG += this.G_GG;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Bad sequence character: " + nuc2);
                }
                default: {
                    throw new IllegalArgumentException("Bad sequence character: " + nuc1);
                }
            }
            nuc1 = mid;
            nuc2 = rightN;
            --i;
        }
        return tmpG / 2.0;
    }

    private char getSeqSymbolAt(int pos) {
        if (pos > this.seq.getLength()) {
            pos -= this.seq.getLength();
        }
        if (pos < 1) {
            pos = -pos + 1;
        }
        return this.seq.getSymbolAt(pos);
    }

    private void store(double energy, int length, int windowStart) {
        double tmp = Math.exp(-(energy / (this.R * this.T)));
        this.Z += tmp;
        this.meanG += energy * tmp;
        double[] dArray = this.Y[length - 1];
        int n = windowStart;
        dArray[n] = dArray[n] + energy * tmp;
        double[] dArray2 = this.Ye[length - 1];
        int n2 = windowStart;
        dArray2[n2] = dArray2[n2] + tmp;
    }

    private void storeToAbstractProfiles(double energy, int ... lengthStartPairs) {
        if (lengthStartPairs.length % 2 != 0) {
            throw new RuntimeException("The Array containing the 'length'-'start'-pairs has to be of even length!");
        }
        double tmp = Math.exp(-(energy / (this.R * this.T)));
        this.Z += tmp;
        this.meanG += energy * tmp;
        ArrayList<int[]> openRegs = new ArrayList<int[]>(lengthStartPairs.length / 2);
        int[] tmpInts = new int[2];
        int i = 0;
        while (i < lengthStartPairs.length - 1) {
            tmpInts[0] = lengthStartPairs[i + 1];
            tmpInts[1] = lengthStartPairs[i + 1] + lengthStartPairs[i];
            openRegs.add(tmpInts);
            i += 2;
        }
        for (SIDDAbstractProfile profile : this.abstractProfiles) {
            if (!profile.doesThisProfileMatchAnother(openRegs)) continue;
            profile.setFreeEnergy(profile.getFreeEnergy() + energy * tmp);
            profile.setProbability(profile.getProbability() + tmp);
        }
    }

    private void fill() {
        this.meanG /= this.Z;
        int i = 0;
        while (i < this.Y.length) {
            int j = 0;
            while (j < this.Y[0].length) {
                int k = j;
                int m = 0;
                while (m <= i) {
                    if (k >= this.N) {
                        k -= this.N;
                    }
                    int n = k;
                    this.px[n] = this.px[n] + this.Ye[i][j];
                    int n2 = k++;
                    this.Gx[n2] = this.Gx[n2] + this.Y[i][j];
                    ++m;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.Gx.length) {
            this.Gx[i] = this.Gx[i] / this.px[i] - this.meanG;
            ++i;
        }
        i = 0;
        while (i < this.px.length) {
            this.px[i] = this.px[i] / this.Z;
            ++i;
        }
    }

    private void finalizeAbstractProfiles() {
        for (SIDDAbstractProfile p : this.abstractProfiles) {
            p.setFreeEnergy(p.getFreeEnergy() / p.getProbability() - this.meanG);
            p.setProbability(p.getProbability() / this.Z);
        }
    }

    private void coSort(double[] x, int[] coX, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1] > x[j]) {
                    this.swap(x, coX, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med(x, l, l + s, l + 2 * s);
                m = this.med(x, m - s, m, m + s);
                n = this.med(x, n - 2 * s, n - s, n);
            }
            m = this.med(x, l, m, n);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    this.swap(x, coX, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    this.swap(x, coX, c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(x, coX, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(x, coX, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(x, coX, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.coSort(x, coX, off, s);
        }
        if ((s = d - c) > 1) {
            this.coSort(x, coX, n - s, s);
        }
    }

    private int med(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private void swap(double[] x, int[] coX, int a, int b) {
        this.swapD(x, a, b);
        this.swapI(coX, a, b);
    }

    private void vecswap(double[] x, int[] coX, int a, int b, int n) {
        this.vecswapD(x, a, b, n);
        this.vecswapI(coX, a, b, n);
    }

    private void swapD(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private void vecswapD(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swapD(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private void swapI(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private void vecswapI(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swapI(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    public double geta() {
        return this.a;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public int getW() {
        return this.W;
    }

    public DNASequence getSeq() {
        return this.seq;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public double[][] getGc() {
        return this.Gc;
    }

    public int[][] getGcI() {
        return this.GcI;
    }

    public double[] getGnc() {
        return this.Gnc;
    }

    public double[][] getY() {
        return this.Y;
    }

    public double[][] getYe() {
        return this.Ye;
    }

    public double[] getPx() {
        return this.px;
    }

    public double[] getGx() {
        return this.Gx;
    }

    public double getMinGc() {
        return this.minGc;
    }

    public double getMinGnc() {
        return this.minGnc;
    }

    public double getMinG() {
        return this.minG;
    }

    public double getZ() {
        return this.Z;
    }

    public double getMeanG() {
        return this.meanG;
    }

    public double getC() {
        return this.C;
    }

    public double getK() {
        return this.K;
    }

    public double getT() {
        return this.T;
    }

    public double getR() {
        return this.R;
    }

    public double getA() {
        return this.A;
    }

    public int getN() {
        return this.N;
    }

    public double getG_AA() {
        return this.G_AA;
    }

    public double getG_TT() {
        return this.G_TT;
    }

    public double getG_AT() {
        return this.G_AT;
    }

    public double getG_TA() {
        return this.G_TA;
    }

    public double getG_CA() {
        return this.G_CA;
    }

    public double getG_TG() {
        return this.G_TG;
    }

    public double getG_GT() {
        return this.G_GT;
    }

    public double getG_AC() {
        return this.G_AC;
    }

    public double getG_CT() {
        return this.G_CT;
    }

    public double getG_AG() {
        return this.G_AG;
    }

    public double getG_GA() {
        return this.G_GA;
    }

    public double getG_TC() {
        return this.G_TC;
    }

    public double getG_CG() {
        return this.G_CG;
    }

    public double getG_GC() {
        return this.G_GC;
    }

    public double getG_GG() {
        return this.G_GG;
    }

    public double getG_CC() {
        return this.G_CC;
    }

    public boolean isLinear() {
        return this.linear;
    }

    public void setLinear(boolean linear) {
        this.linear = linear;
    }

    public List<SIDDAbstractProfile> getAbstractProfiles() {
        return this.abstractProfiles;
    }
}

