@
  --------------------------------------------------------
   Simulation study with parametric bootstrap
   Revision for JoE June 22, 2001
   DGP: Burr (Price)
   Obserations: 3000
   --------------------------------------------------------
@
new;cls;
library co,cml,pgraph;
#include cml.dec;
#include co.dec;
#include co.ext;
#include cml.ext;
cmlcoset;
#include highfreq.dec;
#include highfreq.ext;
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
#include dtyfcacd.src;
#include testacd.src;

/* ************************************** */
/* Change this for each simulation        */
/* ************************************** */


/* Specify DGP */
 simstr   = "BURR";   /* Distribution Monte-Carlo Simulation:
                         EXPON - EACD,
                         WEIB  - WACD,
                         BURR  - BACD
                         GGAMMA - GGACD */
 s_omega  = 0.2;
 s_alpha  = 0.1;
 s_beta   = 0.7;
 s_theta  = 1.3|0.4;   /* Distribution Parameters:
                         EXPON --> leave
                         WEIB  --> Weibullparameter gamma
                         BURR  --> kappa|sigma_2
                         G. GAMMA --> gammaGG|alphaGG  */
 acd_start=s_omega|s_alpha|s_beta;

/* Initial parameters for two step estimation */

 init_dist_weibull=1;
 let init_dist_burr=1.3 0.4;
 let init_dist_gg=0.3873 5.9265;


/* ************************************** */
/* Do not change the following            */
/* ************************************** */

let _allcases=1;      /* All cases used for nonparametric density       */
__output=0;           /* Suppress output for simulations                */
exo = 0;
noexog=0;

/*
rep_low=1;            /* first Replikation after eventual break */
seed=60468;           /* First rep. */
*/

/*
rep_low=29;
seed=29;
*/

rep_low=49;
seed=49;

rep_low=115;
seed=139616696;


rep_low=169;
seed=169;

rep_low=202;
seed=202;

rep_low=203;
seed = 203;

rep_low=238;
seed = 238;

rep_low=278;
seed = 278;

rep_low=297;
seed = 297;

rep_low=298;
seed = 298;

rep_low=361;
seed = 361;

rep_low=387;
seed = 387;

rep_low=437;
seed= 886451566;



zuege=3000;           /* last replikation */
cases=zuege;
replik=500;          /* Number of Monte Carlo Replikations */
num_boot=99;         /* Number of bootstrap samples */
usemean =0;          /* use the mean as an estimate for lambda
                        exponential is used as a reference */
s_p=1;                /* Lag PSI */
s_q=1;                /* Lag x_i */
artstart=1;           /* Starting values type */
_cml_maxiters = 100;
_cml_algorithm = 3;
_cml_linesearch = 1;

 p = s_p; q = s_q;
 #include montcarl.prc;

/*
 modsim ="test";
 logfile = modsim $+ ".OUT";
 output file = ^logfile reset;
*/

 PRINT "Monte-Carlo Simulation based on";
 IF (UPPER(simstr)$=="EXPON");
  PRINT "Exponential";
 ELSEIF (UPPER(simstr)$=="WEIB");
  PRINT "Weibull";
 ELSEIF (UPPER(simstr)$=="BURR");
  PRINT "Burr";
 ELSE;
 ENDIF;
 PRINT "---------------------------------------------------------------";
 PRINT;
 PRINT "# replications:     " (replik-rep_low+1);
 PRINT "#drawings per replication " zuege;
 PRINT;
 PRINT "---------------------------------------------------------------";
 PRINT;
 PRINT "Parameters:       " s_theta';
 PRINT;
 PRINT "---------------------------------------------------------------";
 PRINT;
 PRINT "p:     " s_p;
 PRINT "q:     " s_q;
 PRINT;
 PRINT "omega: " s_omega;
 PRINT "alpha: " s_alpha';
 PRINT "beta:  " s_beta';
 PRINT;
 PRINT;

/* ********************************************** */
/* Loop over replications                         */
/* ********************************************** */

if rep_low == 1;

overdis_expo=zeros(replik,5);
overdis_wbll=zeros(replik,5);

D0000E1=zeros(replik,5);
D0501E1=zeros(replik,5);
D2001E1=zeros(replik,5);
D2501E1=zeros(replik,5);
D3001E1=zeros(replik,5);

D0000W1=zeros(replik,5);
D0501W1=zeros(replik,5);
D2001W1=zeros(replik,5);
D2501W1=zeros(replik,5);
D3001W1=zeros(replik,5);

D0000B1=zeros(replik,5);
D0501B1=zeros(replik,5);
D2001B1=zeros(replik,5);
D2501B1=zeros(replik,5);
D3001B1=zeros(replik,5);

D0000G1=zeros(replik,5);
D0501G1=zeros(replik,5);
D2001G1=zeros(replik,5);
D2501G1=zeros(replik,5);
D3001G1=zeros(replik,5);

/*H test uniform */
H0000E1=zeros(replik,5);
H0505E1=zeros(replik,5);
H0510E1=zeros(replik,5);
H0520E1=zeros(replik,5);
H2020E1=zeros(replik,5);

H0000W1=zeros(replik,5);
H0505W1=zeros(replik,5);
H0510W1=zeros(replik,5);
H0520W1=zeros(replik,5);
H2020W1=zeros(replik,5);

H0000B1=zeros(replik,5);
H0505B1=zeros(replik,5);
H0510B1=zeros(replik,5);
H0520B1=zeros(replik,5);
H2020B1=zeros(replik,5);

H0000G1=zeros(replik,5);
H0505G1=zeros(replik,5);
H0510G1=zeros(replik,5);
H0520G1=zeros(replik,5);
H2020G1=zeros(replik,5);

/* D test uniform log */
D0000E2=zeros(replik,5);
D0501E2=zeros(replik,5);
D0505E2=zeros(replik,5);

D0000W2=zeros(replik,5);
D0501W2=zeros(replik,5);
D0505W2=zeros(replik,5);

D0000B2=zeros(replik,5);
D0501B2=zeros(replik,5);
D0505B2=zeros(replik,5);

D0000G2=zeros(replik,5);
D0501G2=zeros(replik,5);
D0505G2=zeros(replik,5);

/*D test gamma */
D0000E3=zeros(replik,5);
D0505E3=zeros(replik,5);
D0510E3=zeros(replik,5);
D0520E3=zeros(replik,5);
D2020E3=zeros(replik,5);

D0000W3=zeros(replik,5);
D0505W3=zeros(replik,5);
D0510W3=zeros(replik,5);
D0520W3=zeros(replik,5);
D2020W3=zeros(replik,5);

D0000B3=zeros(replik,5);
D0505B3=zeros(replik,5);
D0510B3=zeros(replik,5);
D0520B3=zeros(replik,5);
D2020B3=zeros(replik,5);

D0000G3=zeros(replik,5);
D0505G3=zeros(replik,5);
D0510G3=zeros(replik,5);
D0520G3=zeros(replik,5);
D2020G3=zeros(replik,5);

/*H test gamma */
H0000E3=zeros(replik,5);
H0505E3=zeros(replik,5);
H0510E3=zeros(replik,5);
H0520E3=zeros(replik,5);
H2020E3=zeros(replik,5);

H0000W3=zeros(replik,5);
H0505W3=zeros(replik,5);
H0510W3=zeros(replik,5);
H0520W3=zeros(replik,5);
H2020W3=zeros(replik,5);

H0000B3=zeros(replik,5);
H0505B3=zeros(replik,5);
H0510B3=zeros(replik,5);
H0520B3=zeros(replik,5);
H2020B3=zeros(replik,5);

H0000G3=zeros(replik,5);
H0505G3=zeros(replik,5);
H0510G3=zeros(replik,5);
H0520G3=zeros(replik,5);
H2020G3=zeros(replik,5);

else;

loadm overdis_expo;
loadm overdis_wbll;

loadm D0000E1;
loadm D0501E1;
loadm D2001E1;
loadm D2501E1;
loadm D3001E1;

loadm D0000W1;
loadm D0501W1;
loadm D2001W1;
loadm D2501W1;
loadm D3001W1;

loadm D0000B1;
loadm D0501B1;
loadm D2001B1;
loadm D2501B1;
loadm D3001B1;

loadm D0000G1;
loadm D0501G1;
loadm D2001G1;
loadm D2501G1;
loadm D3001G1;

/*loadm H test uniform */
loadm H0000E1;
loadm H0505E1;
loadm H0510E1;
loadm H0520E1;
loadm H2020E1;

loadm H0000W1;
loadm H0505W1;
loadm H0510W1;
loadm H0520W1;
loadm H2020W1;

loadm H0000B1;
loadm H0505B1;
loadm H0510B1;
loadm H0520B1;
loadm H2020B1;

loadm H0000G1;
loadm H0505G1;
loadm H0510G1;
loadm H0520G1;
loadm H2020G1;

/* loadm D test uniform log */
loadm D0000E2;
loadm D0501E2;
loadm D0505E2;

loadm D0000W2;
loadm D0501W2;
loadm D0505W2;

loadm D0000B2;
loadm D0501B2;
loadm D0505B2;

loadm D0000G2;
loadm D0501G2;
loadm D0505G2;

/*loadm D test gamma */
loadm D0000E3;
loadm D0505E3;
loadm D0510E3;
loadm D0520E3;
loadm D2020E3;

loadm D0000W3;
loadm D0505W3;
loadm D0510W3;
loadm D0520W3;
loadm D2020W3;

loadm D0000B3;
loadm D0505B3;
loadm D0510B3;
loadm D0520B3;
loadm D2020B3;

loadm D0000G3;
loadm D0505G3;
loadm D0510G3;
loadm D0520G3;
loadm D2020G3;

/*loadm H test gamma */
loadm H0000E3;
loadm H0505E3;
loadm H0510E3;
loadm H0520E3;
loadm H2020E3;

loadm H0000W3;
loadm H0505W3;
loadm H0510W3;
loadm H0520W3;
loadm H2020W3;

loadm H0000B3;
loadm H0505B3;
loadm H0510B3;
loadm H0520B3;
loadm H2020B3;

loadm H0000G3;
loadm H0505G3;
loadm H0510G3;
loadm H0520G3;
loadm H2020G3;

endif;

rep = rep_low; DO WHILE (rep<=replik);

  PRINT; PRINT;
  PRINT "-----------------------------------------";
  PRINT "Replikation # " FTOS(rep,"%*.*lf",1,0);
  PRINT "-----------------------------------------";
  PRINT "omega: " s_omega;
  PRINT "alpha: " s_alpha';
  PRINT "beta:  " s_beta';
  PRINT; PRINT;

/* Simulate DGP  */

 seed_buf = seed;
 datasim  = simulate2(simstr,s_p,s_q,s_alpha,s_beta,s_omega,s_theta,zuege);


 xi_prep(datasim);

/* QML Estimation  */

 model     =  "EACD";
 distrib="EXPON";
 PARREST_qmle;
 {qmle_par_rep,void,void,void} = ACD_QML_twostep(acd_start,-999,initial_psi);
 "QML done par.";;qmle_par_rep';
 distrib="WEIBULL";
 PARREST_dist(distrib);
 {dist_weibull,f0,g,varcov,retcode} =cml(epsilon_hat,0,&li_dist,init_dist_weibull);
 "Weibull done par.";;dist_weibull';
 distrib="BURR";
 PARREST_dist(distrib);
 {dist_burr,f0,g,varcov,retcode}=cml(epsilon_hat,0,&li_dist,init_dist_burr);
 "Burr done par.";;dist_burr';
 distrib="GENGAM";
 PARREST_dist(distrib);
 {dist_gg,f0,g,varcov,retcode} = cml(epsilon_hat,0,&li_dist,init_dist_gg);
 "GG done par.";;dist_gg';

 /*Step 3 Initial testing */
 /*Standard Overdispersion test */

 overdis_expo_rep=overdis(0,0,1);
 overdis_wbll_rep=overdis(dist_weibull,1,1);

 overdis_expo_boot= overdis_expo_rep[2]~1|zeros(num_boot,2);
 overdis_wbll_boot= overdis_wbll_rep[2]~1|zeros(num_boot,2);

 model ="EACD";
 {fpar_eacd1,f_eacd1,hpar_eacd1,hf_eacd1,fhatn_eacd1,b_eacd1,xe1} = DTHTPRE3(qmle_par_rep,"UNIFORM",0,0,usemean);
 {fpar_eacd2,f_eacd2,hpar_eacd2,hf_eacd2,fhatn_eacd2,b_eacd2,xe2} = DTHTPRE3(qmle_par_rep,"UNIFORM",1,0,0);
  "Enter WACD";
 model ="WACD";
 {fpar_wacd1,f_wacd1,hpar_wacd1,hf_wacd1,fhatn_wacd1,b_wacd1,xw1} = DTHTPRE3(qmle_par_rep|dist_weibull,"UNIFORM",0,0,usemean);
 {fpar_wacd2,f_wacd2,hpar_wacd2,hf_wacd2,fhatn_wacd2,b_wacd2,xw2} = DTHTPRE3(qmle_par_rep|dist_weibull,"UNIFORM",1,0,0);
 "Enter BACD";
 model ="BACD";
 {fpar_bacd1,f_bacd1,hpar_bacd1,hf_bacd1,fhatn_bacd1,b_bacd1,xb1} = DTHTPRE3(qmle_par_rep|dist_burr,"UNIFORM",0,0,usemean);
 {fpar_bacd2,f_bacd2,hpar_bacd2,hf_bacd2,fhatn_bacd2,b_bacd2,xb2} = DTHTPRE3(qmle_par_rep|dist_burr,"UNIFORM",1,0,0);
  "Enter GGACD";
 model ="GGACD";
 {fpar_ggacd1,f_ggacd1,hpar_ggacd1,hf_ggacd1,fhatn_ggacd1,b_ggacd1,xg1} = DTHTPRE3(qmle_par_rep|dist_gg,"UNIFORM",0,0,usemean);
 {fpar_ggacd2,f_ggacd2,hpar_ggacd2,hf_ggacd2,fhatn_ggacd2,b_ggacd2,xg2} = DTHTPRE3(qmle_par_rep|dist_gg,"UNIFORM",1,0,0);

 model ="EACD";
 {fpar_eacd3,f_eacd3,hpar_eacd3,hf_eacd3,fhatn_eacd3,b_eacd3,xe3} = DTHTPRE3(qmle_par_rep,"GAMMA",0,0,usemean);
  model ="WACD";
 {fpar_wacd3,f_wacd3,hpar_wacd3,hf_wacd3,fhatn_wacd3,b_wacd3,xw3} = DTHTPRE3(qmle_par_rep|dist_weibull,"GAMMA",0,0,usemean);
  model ="BACD";
 {fpar_bacd3,f_bacd3,hpar_bacd3,hf_bacd3,fhatn_bacd3,b_bacd3,xb3} = DTHTPRE3(qmle_par_rep|dist_burr,"GAMMA",0,0,usemean);
  model ="GGACD";
 {fpar_ggacd3,f_ggacd3,hpar_ggacd3,hf_ggacd3,fhatn_ggacd3,b_ggacd3,xg3} = DTHTPRE3(qmle_par_rep|dist_gg,"GAMMA",0,0,usemean);

/* Exponential */
{DS0000expon1, HS0000expon1, DS0501expon1, HS0501expon1, DS0505expon1, HS0505expon1,
 DS0510expon1, HS0510expon1, DS0520expon1, HS0520expon1, DS2001expon1, HS2001expon1,
 DS2020expon1, HS2020expon1, DS2501expon1, HS2501expon1, DS3001expon1, HS3001expon1}
 =trimit(fpar_eacd1,f_eacd1,hpar_eacd1,hf_eacd1,fhatn_eacd1,b_eacd1,"UNIFORM",xe1,1);

{DS0000expon2, HS0000expon2, DS0501expon2, HS0501expon2, DS0505expon2, HS0505expon2,
 DS0510expon2, HS0510expon2, DS0520expon2, HS0520expon2, DS2001expon2, HS2001expon2,
 DS2020expon2, HS2020expon2, DS2501expon2, HS2501expon2, DS3001expon2, HS3001expon2}
 =trimit(fpar_eacd2,f_eacd2,hpar_eacd2,hf_eacd2,fhatn_eacd2,b_eacd2,"UNIFORM",xe2,1);


{DS0000expon3, HS0000expon3, DS0501expon3, HS0501expon3, DS0505expon3, HS0505expon3,
 DS0510expon3, HS0510expon3, DS0520expon3, HS0520expon3, DS2001expon3, HS2001expon3,
 DS2020expon3, HS2020expon3, DS2501expon3, HS2501expon3, DS3001expon3, HS3001expon3}
 =trimit(fpar_eacd3,f_eacd3,hpar_eacd3,hf_eacd3,fhatn_eacd3,b_eacd3,"GAMMA",xe3,1);

/*Weibull */
{DS0000weibull1, HS0000weibull1, DS0501weibull1, HS0501weibull1, DS0505weibull1, HS0505weibull1,
 DS0510weibull1, HS0510weibull1, DS0520weibull1, HS0520weibull1, DS2001weibull1, HS2001weibull1,
 DS2020weibull1, HS2020weibull1, DS2501weibull1, HS2501weibull1, DS3001weibull1, HS3001weibull1}
 =trimit(fpar_wacd1,f_wacd1,hpar_wacd1,hf_wacd1,fhatn_wacd1,b_wacd1,"UNIFORM",xw1,1);

{DS0000weibull2, HS0000weibull2, DS0501weibull2, HS0501weibull2, DS0505weibull2, HS0505weibull2,
 DS0510weibull2, HS0510weibull2, DS0520weibull2, HS0520weibull2, DS2001weibull2, HS2001weibull2,
 DS2020weibull2, HS2020weibull2, DS2501weibull2, HS2501weibull2, DS3001weibull2, HS3001weibull2}
 =trimit(fpar_wacd2,f_wacd2,hpar_wacd2,hf_wacd2,fhatn_wacd2,b_wacd2,"UNIFORM",xw2,1);

{DS0000weibull3, HS0000weibull3, DS0501weibull3, HS0501weibull3, DS0505weibull3, HS0505weibull3,
 DS0510weibull3, HS0510weibull3, DS0520weibull3, HS0520weibull3, DS2001weibull3, HS2001weibull3,
 DS2020weibull3, HS2020weibull3, DS2501weibull3, HS2501weibull3, DS3001weibull3, HS3001weibull3}
 =trimit(fpar_wacd3,f_wacd3,hpar_wacd3,hf_wacd3,fhatn_wacd3,b_wacd3,"GAMMA",xw3,1);

/* Burr */
{DS0000burr1, HS0000burr1, DS0501burr1, HS0501burr1, DS0505burr1, HS0505burr1,
 DS0510burr1, HS0510burr1, DS0520burr1, HS0520burr1, DS2001burr1, HS2001burr1,
 DS2020burr1, HS2020burr1, DS2501burr1, HS2501burr1, DS3001burr1, HS3001burr1}
 =trimit(fpar_bacd1,f_bacd1,hpar_bacd1,hf_bacd1,fhatn_bacd1,b_bacd1,"UNIFORM",xb1,1);

{DS0000burr2, HS0000burr2, DS0501burr2, HS0501burr2, DS0505burr2, HS0505burr2,
 DS0510burr2, HS0510burr2, DS0520burr2, HS0520burr2, DS2001burr2, HS2001burr2,
 DS2020burr2, HS2020burr2, DS2501burr2, HS2501burr2, DS3001burr2, HS3001burr2}
 =trimit(fpar_bacd2,f_bacd2,hpar_bacd2,hf_bacd2,fhatn_bacd2,b_bacd2,"UNIFORM",xb2,1);

{DS0000burr3, HS0000burr3, DS0501burr3, HS0501burr3, DS0505burr3, HS0505burr3,
 DS0510burr3, HS0510burr3, DS0520burr3, HS0520burr3, DS2001burr3, HS2001burr3,
 DS2020burr3, HS2020burr3, DS2501burr3, HS2501burr3, DS3001burr3, HS3001burr3}
 =trimit(fpar_bacd3,f_bacd3,hpar_bacd3,hf_bacd3,fhatn_bacd3,b_bacd3,"GAMMA",xb3,1);

/* Gen. Gamma */
{DS0000gg1, HS0000gg1, DS0501gg1, HS0501gg1, DS0505gg1, HS0505gg1,
 DS0510gg1, HS0510gg1, DS0520gg1, HS0520gg1, DS2001gg1, HS2001gg1,
 DS2020gg1, HS2020gg1, DS2501gg1, HS2501gg1, DS3001gg1, HS3001gg1}
 =trimit(fpar_ggacd1,f_ggacd1,hpar_ggacd1,hf_ggacd1,fhatn_ggacd1,b_ggacd1,"UNIFORM",xg1,1);

{DS0000gg2, HS0000gg2, DS0501gg2, HS0501gg2, DS0505gg2, HS0505gg2,
 DS0510gg2, HS0510gg2, DS0520gg2, HS0520gg2, DS2001gg2, HS2001gg2,
 DS2020gg2, HS2020gg2, DS2501gg2, HS2501gg2, DS3001gg2, HS3001gg2}
 =trimit(fpar_ggacd2,f_ggacd2,hpar_ggacd2,hf_ggacd2,fhatn_ggacd2,b_ggacd2,"UNIFORM",xg2,1);

{DS0000gg3, HS0000gg3, DS0501gg3, HS0501gg3, DS0505gg3, HS0505gg3,
 DS0510gg3, HS0510gg3, DS0520gg3, HS0520gg3, DS2001gg3, HS2001gg3,
 DS2020gg3, HS2020gg3, DS2501gg3, HS2501gg3, DS3001gg3, HS3001gg3}
 =trimit(fpar_ggacd3,f_ggacd3,hpar_ggacd3,hf_ggacd3,fhatn_ggacd3,b_ggacd3,"GAMMA",xg3,1);

/* Overdispersion */

/* D test uniform */
DS0000E1=DS0000expon1[2]~1|zeros(num_boot,2);
DS0501E1=DS0501expon1[2]~1|zeros(num_boot,2);
DS2001E1=DS2001expon1[2]~1|zeros(num_boot,2);
DS2501E1=DS2501expon1[2]~1|zeros(num_boot,2);
DS3001E1=DS3001expon1[2]~1|zeros(num_boot,2);

DS0000W1=DS0000weibull1[2]~1|zeros(num_boot,2);
DS0501W1=DS0501weibull1[2]~1|zeros(num_boot,2);
DS2001W1=DS2001weibull1[2]~1|zeros(num_boot,2);
DS2501W1=DS2501weibull1[2]~1|zeros(num_boot,2);
DS3001W1=DS3001weibull1[2]~1|zeros(num_boot,2);

DS0000B1=DS0000burr1[2]~1|zeros(num_boot,2);
DS0501B1=DS0501burr1[2]~1|zeros(num_boot,2);
DS2001B1=DS2001burr1[2]~1|zeros(num_boot,2);
DS2501B1=DS2501burr1[2]~1|zeros(num_boot,2);
DS3001B1=DS3001burr1[2]~1|zeros(num_boot,2);

DS0000G1=DS0000gg1[2]~1|zeros(num_boot,2);
DS0501G1=DS0501gg1[2]~1|zeros(num_boot,2);
DS2001G1=DS2001gg1[2]~1|zeros(num_boot,2);
DS2501G1=DS2501gg1[2]~1|zeros(num_boot,2);
DS3001G1=DS3001gg1[2]~1|zeros(num_boot,2);

/*H test uniform */
HS0000E1=HS0000expon1[2]~1|zeros(num_boot,2);
HS0505E1=HS0505expon1[2]~1|zeros(num_boot,2);
HS0510E1=HS0510expon1[2]~1|zeros(num_boot,2);
HS0520E1=HS0520expon1[2]~1|zeros(num_boot,2);
HS2020E1=HS2020expon1[2]~1|zeros(num_boot,2);

HS0000W1=HS0000weibull1[2]~1|zeros(num_boot,2);
HS0505W1=HS0505weibull1[2]~1|zeros(num_boot,2);
HS0510W1=HS0510weibull1[2]~1|zeros(num_boot,2);
HS0520W1=HS0520weibull1[2]~1|zeros(num_boot,2);
HS2020W1=HS2020weibull1[2]~1|zeros(num_boot,2);

HS0000B1=HS0000burr1[2]~1|zeros(num_boot,2);
HS0505B1=HS0505burr1[2]~1|zeros(num_boot,2);
HS0510B1=HS0510burr1[2]~1|zeros(num_boot,2);
HS0520B1=HS0520burr1[2]~1|zeros(num_boot,2);
HS2020B1=HS2020burr1[2]~1|zeros(num_boot,2);

HS0000G1=HS0000gg1[2]~1|zeros(num_boot,2);
HS0505G1=HS0505gg1[2]~1|zeros(num_boot,2);
HS0510G1=HS0510gg1[2]~1|zeros(num_boot,2);
HS0520G1=HS0520gg1[2]~1|zeros(num_boot,2);
HS2020G1=HS2020gg1[2]~1|zeros(num_boot,2);

/* D test uniform log */
DS0000E2=DS0000expon2[2]~1|zeros(num_boot,2);
DS0501E2=DS0501expon2[2]~1|zeros(num_boot,2);
DS0505E2=DS0505expon2[2]~1|zeros(num_boot,2);

DS0000W2=DS0000weibull2[2]~1|zeros(num_boot,2);
DS0501W2=DS0501weibull2[2]~1|zeros(num_boot,2);
DS0505W2=DS0505weibull2[2]~1|zeros(num_boot,2);

DS0000B2=DS0000burr2[2]~1|zeros(num_boot,2);
DS0501B2=DS0501burr2[2]~1|zeros(num_boot,2);
DS0505B2=DS0505burr2[2]~1|zeros(num_boot,2);

DS0000G2=DS0000gg2[2]~1|zeros(num_boot,2);
DS0501G2=DS0501gg2[2]~1|zeros(num_boot,2);
DS0505G2=DS0505gg2[2]~1|zeros(num_boot,2);

/*D test gamma */
DS0000E3=DS0000expon3[2]~1|zeros(num_boot,2);
DS0505E3=DS0505expon3[2]~1|zeros(num_boot,2);
DS0510E3=DS0510expon3[2]~1|zeros(num_boot,2);
DS0520E3=DS0520expon3[2]~1|zeros(num_boot,2);
DS2020E3=DS2020expon3[2]~1|zeros(num_boot,2);

DS0000W3=DS0000weibull3[2]~1|zeros(num_boot,2);
DS0505W3=DS0505weibull3[2]~1|zeros(num_boot,2);
DS0510W3=DS0510weibull3[2]~1|zeros(num_boot,2);
DS0520W3=DS0520weibull3[2]~1|zeros(num_boot,2);
DS2020W3=DS2020weibull3[2]~1|zeros(num_boot,2);

DS0000B3=DS0000burr3[2]~1|zeros(num_boot,2);
DS0505B3=DS0505burr3[2]~1|zeros(num_boot,2);
DS0510B3=DS0510burr3[2]~1|zeros(num_boot,2);
DS0520B3=DS0520burr3[2]~1|zeros(num_boot,2);
DS2020B3=DS2020burr3[2]~1|zeros(num_boot,2);

DS0000G3=DS0000gg3[2]~1|zeros(num_boot,2);
DS0505G3=DS0505gg3[2]~1|zeros(num_boot,2);
DS0510G3=DS0510gg3[2]~1|zeros(num_boot,2);
DS0520G3=DS0520gg3[2]~1|zeros(num_boot,2);
DS2020G3=DS2020gg3[2]~1|zeros(num_boot,2);

/*H test gamma */
HS0000E3=HS0000expon3[2]~1|zeros(num_boot,2);
HS0505E3=HS0505expon3[2]~1|zeros(num_boot,2);
HS0510E3=HS0510expon3[2]~1|zeros(num_boot,2);
HS0520E3=HS0520expon3[2]~1|zeros(num_boot,2);
HS2020E3=HS2020expon3[2]~1|zeros(num_boot,2);

HS0000W3=HS0000weibull3[2]~1|zeros(num_boot,2);
HS0505W3=HS0505weibull3[2]~1|zeros(num_boot,2);
HS0510W3=HS0510weibull3[2]~1|zeros(num_boot,2);
HS0520W3=HS0520weibull3[2]~1|zeros(num_boot,2);
HS2020W3=HS2020weibull3[2]~1|zeros(num_boot,2);

HS0000B3=HS0000burr3[2]~1|zeros(num_boot,2);
HS0505B3=HS0505burr3[2]~1|zeros(num_boot,2);
HS0510B3=HS0510burr3[2]~1|zeros(num_boot,2);
HS0520B3=HS0520burr3[2]~1|zeros(num_boot,2);
HS2020B3=HS2020burr3[2]~1|zeros(num_boot,2);

HS0000G3=HS0000gg3[2]~1|zeros(num_boot,2);
HS0505G3=HS0505gg3[2]~1|zeros(num_boot,2);
HS0510G3=HS0510gg3[2]~1|zeros(num_boot,2);
HS0520G3=HS0520gg3[2]~1|zeros(num_boot,2);
HS2020G3=HS2020gg3[2]~1|zeros(num_boot,2);

BOOT=1;
do while BOOT le num_boot;
"...entered bootstrap loop Exponential";;"Rep";;rep;;"Boot";;boot;
ret_dist=1;
ret_qmle=1;
bad_data=1;
do while (ret_dist eq 1 or ret_qmle eq 1);
 do while bad_data gt 0;
  data_boot = simulate2("EXPON",1,1,qmle_par_rep[2],qmle_par_rep[3],qmle_par_rep[1],void,zuege);
  bad_data1=ismiss(data_boot);
  bad_data2=sumc(imag(data_boot).gt 0);
  bad_data=((bad_data1+bad_data2) gt 0);
  "Bad data?";;bad_data;
 endo;
 xi_prep(data_boot);
 distrib="EXPON";
 model="EACD";
 PARREST_qmle;
 {qmle_par,void,void,ret_qmle} = ACD_QML_twostep(acd_start,-999,1);
 "ret_qmle";;ret_qmle;;"par";;qmle_par';
if ret_qmle==1;
  bad_data=1;
else;
 {dist_pars,DS0000_1, HS0000_1, DS0501_1, HS0501_1, DS0505_1, HS0505_1,
 DS0510_1, HS0510_1, DS0520_1, HS0520_1, DS2001_1, HS2001_1,
 DS2020_1, HS2020_1, DS2501_1, HS2501_1, DS3001_1, HS3001_1,
 DS0000_2, HS0000_2, DS0501_2, HS0501_2, DS0505_2, HS0505_2,
 DS0510_2, HS0510_2, DS0520_2, HS0520_2, DS2001_2, HS2001_2,
 DS2020_2, HS2020_2, DS2501_2, HS2501_2, DS3001_2, HS3001_2,
 DS0000_3, HS0000_3, DS0501_3, HS0501_3, DS0505_3, HS0505_3,
 DS0510_3, HS0510_3, DS0520_3, HS0520_3, DS2001_3, HS2001_3,
 DS2020_3, HS2020_3, DS2501_3, HS2501_3, DS3001_3, HS3001_3,ret_dist}=
 test_boot("EXPON",qmle_par,void,usemean);
 "Ret_dist";;ret_dist;;"Parameter";;dist_pars';
 if ret_dist==1;
  bad_data=1;
 else;
  bad_data=0;
 endif;
endif;
endo;

overdis_expo_boot[BOOT+1,1]=overdis(0,0,0);

DS0000E1[BOOT+1,1]=DS0000_1;
DS0501E1[BOOT+1,1]=DS0501_1;
DS2001E1[BOOT+1,1]=DS2001_1;
DS2501E1[BOOT+1,1]=DS2501_1;
DS3001E1[BOOT+1,1]=DS3001_1;

HS0000E1[BOOT+1,1]=HS0000_1;
HS0505E1[BOOT+1,1]=HS0505_1;
HS0510E1[BOOT+1,1]=HS0510_1;
HS0520E1[BOOT+1,1]=HS0520_1;
HS2020E1[BOOT+1,1]=HS2020_1;

DS0000E2[BOOT+1,1]=DS0000_2;
DS0501E2[BOOT+1,1]=DS0501_2;
DS0505E2[BOOT+1,1]=DS0505_2;

DS0000E3[BOOT+1,1]=DS0000_3;
DS0505E3[BOOT+1,1]=DS0505_3;
DS0510E3[BOOT+1,1]=DS0510_3;
DS0520E3[BOOT+1,1]=DS0520_3;
DS2020E3[BOOT+1,1]=DS2020_3;

HS0000E3[BOOT+1,1]=HS0000_3;
HS0505E3[BOOT+1,1]=HS0505_3;
HS0510E3[BOOT+1,1]=HS0510_3;
HS0520E3[BOOT+1,1]=HS0520_3;
HS2020E3[BOOT+1,1]=HS2020_3;


"...entered bootstrap loop Weibull";;"Rep";;rep;;"Boot";;boot;
ret_dist=1;
ret_qmle=1;
bad_data=1;
do while (ret_dist eq 1 or ret_qmle eq 1);
 do while bad_data gt 0;
  data_boot = simulate2("WEIB",1,1,qmle_par_rep[2],qmle_par_rep[3],qmle_par_rep[1],dist_weibull,zuege);
  bad_data1=ismiss(data_boot);
  bad_data2=sumc(imag(data_boot).gt 0);
  bad_data=((bad_data1+bad_data2) gt 0);
  "Bad data?";;bad_data;
 endo;
 xi_prep(data_boot);
 distrib="EXPON";
 model="EACD";
 PARREST_qmle;
 {qmle_par,void,void,ret_qmle} = ACD_QML_twostep(acd_start,-999,1);
 "ret_qmle";;ret_qmle;;"par";;qmle_par';
 if ret_qmle==1;
  bad_data=1;
 else;
  model ="WACD";
 {dist_pars,DS0000_1, HS0000_1, DS0501_1, HS0501_1, DS0505_1, HS0505_1,
 DS0510_1, HS0510_1, DS0520_1, HS0520_1, DS2001_1, HS2001_1,
 DS2020_1, HS2020_1, DS2501_1, HS2501_1, DS3001_1, HS3001_1,
 DS0000_2, HS0000_2, DS0501_2, HS0501_2, DS0505_2, HS0505_2,
 DS0510_2, HS0510_2, DS0520_2, HS0520_2, DS2001_2, HS2001_2,
 DS2020_2, HS2020_2, DS2501_2, HS2501_2, DS3001_2, HS3001_2,
 DS0000_3, HS0000_3, DS0501_3, HS0501_3, DS0505_3, HS0505_3,
 DS0510_3, HS0510_3, DS0520_3, HS0520_3, DS2001_3, HS2001_3,
 DS2020_3, HS2020_3, DS2501_3, HS2501_3, DS3001_3, HS3001_3,ret_dist}=
 test_boot("WEIBULL",qmle_par,dist_weibull,usemean);
 "Ret_dist";;ret_dist;;"Parameter";;dist_pars';
 if ret_dist==1;
  bad_data=1;
 else;
  bad_data=0;
 endif;
endif;
endo;

overdis_wbll_boot[BOOT+1,1]=overdis(dist_pars,1,0);

DS0000W1[BOOT+1,1]=DS0000_1;
DS0501W1[BOOT+1,1]=DS0501_1;
DS2001W1[BOOT+1,1]=DS2001_1;
DS2501W1[BOOT+1,1]=DS2501_1;
DS3001W1[BOOT+1,1]=DS3001_1;

HS0000W1[BOOT+1,1]=HS0000_1;
HS0505W1[BOOT+1,1]=HS0505_1;
HS0510W1[BOOT+1,1]=HS0510_1;
HS0520W1[BOOT+1,1]=HS0520_1;
HS2020W1[BOOT+1,1]=HS2020_1;

DS0000W2[BOOT+1,1]=DS0000_2;
DS0501W2[BOOT+1,1]=DS0501_2;
DS0505W2[BOOT+1,1]=DS0505_2;

DS0000W3[BOOT+1,1]=DS0000_3;
DS0505W3[BOOT+1,1]=DS0505_3;
DS0510W3[BOOT+1,1]=DS0510_3;
DS0520W3[BOOT+1,1]=DS0520_3;
DS2020W3[BOOT+1,1]=DS2020_3;

HS0000W3[BOOT+1,1]=HS0000_3;
HS0505W3[BOOT+1,1]=HS0505_3;
HS0510W3[BOOT+1,1]=HS0510_3;
HS0520W3[BOOT+1,1]=HS0520_3;
HS2020W3[BOOT+1,1]=HS2020_3;

"...entered bootstrap loop Burr";;"Rep";;rep;;"Boot";;boot;
ret_dist=1;
ret_qmle=1;
bad_data=1;
do while (ret_dist eq 1 or ret_qmle eq 1);
 do while bad_data gt 0;
  data_boot = simulate2("BURR",1,1,qmle_par_rep[2],qmle_par_rep[3],qmle_par_rep[1],dist_burr,zuege);
  bad_data1=ismiss(data_boot);
  bad_data2=sumc(imag(data_boot).gt 0);
  bad_data=((bad_data1+bad_data2) gt 0);
  "Bad data?";;bad_data;
 endo;

 xi_prep(data_boot);
 distrib="EXPON";
 model="EACD";
 PARREST_qmle;
 {qmle_par,void,void, ret_qmle} = ACD_QML_twostep(acd_start,-999,1);
 if ret_qmle==1;
  bad_data=1;
 else;
"ret_qmle";;ret_qmle;;"par";;qmle_par';
 model ="BACD";
{dist_pars,DS0000_1, HS0000_1, DS0501_1, HS0501_1, DS0505_1, HS0505_1,
 DS0510_1, HS0510_1, DS0520_1, HS0520_1, DS2001_1, HS2001_1,
 DS2020_1, HS2020_1, DS2501_1, HS2501_1, DS3001_1, HS3001_1,
 DS0000_2, HS0000_2, DS0501_2, HS0501_2, DS0505_2, HS0505_2,
 DS0510_2, HS0510_2, DS0520_2, HS0520_2, DS2001_2, HS2001_2,
 DS2020_2, HS2020_2, DS2501_2, HS2501_2, DS3001_2, HS3001_2,
 DS0000_3, HS0000_3, DS0501_3, HS0501_3, DS0505_3, HS0505_3,
 DS0510_3, HS0510_3, DS0520_3, HS0520_3, DS2001_3, HS2001_3,
 DS2020_3, HS2020_3, DS2501_3, HS2501_3, DS3001_3, HS3001_3,ret_dist}=
 test_boot("BURR",qmle_par,dist_burr,usemean);
 "Ret_dist";;ret_dist;;"Parameter";;dist_pars';
 if ret_dist==1;
  bad_data=1;
 else;
  bad_data=0;
 endif;
endif;
endo;

DS0000B1[BOOT+1,1]=DS0000_1;
DS0501B1[BOOT+1,1]=DS0501_1;
DS2001B1[BOOT+1,1]=DS2001_1;
DS2501B1[BOOT+1,1]=DS2501_1;
DS3001B1[BOOT+1,1]=DS3001_1;

HS0000B1[BOOT+1,1]=HS0000_1;
HS0505B1[BOOT+1,1]=HS0505_1;
HS0510B1[BOOT+1,1]=HS0510_1;
HS0520B1[BOOT+1,1]=HS0520_1;
HS2020B1[BOOT+1,1]=HS2020_1;

DS0000B2[BOOT+1,1]=DS0000_2;
DS0501B2[BOOT+1,1]=DS0501_2;
DS0505B2[BOOT+1,1]=DS0505_2;

DS0000B3[BOOT+1,1]=DS0000_3;
DS0505B3[BOOT+1,1]=DS0505_3;
DS0510B3[BOOT+1,1]=DS0510_3;
DS0520B3[BOOT+1,1]=DS0520_3;
DS2020B3[BOOT+1,1]=DS2020_3;

HS0000B3[BOOT+1,1]=HS0000_3;
HS0505B3[BOOT+1,1]=HS0505_3;
HS0510B3[BOOT+1,1]=HS0510_3;
HS0520B3[BOOT+1,1]=HS0520_3;
HS2020B3[BOOT+1,1]=HS2020_3;

"...entered bootstrap loop Gen Gamma";;"Rep";;rep;;"Boot";;boot;

ret_dist=1;
ret_qmle=1;
bad_data=1;

do while (ret_dist eq 1 or ret_qmle eq 1);

 do while bad_data gt 0;
  data_boot = simulate2("GGAMMA",1,1,qmle_par_rep[2],qmle_par_rep[3],qmle_par_rep[1],dist_gg,zuege);
  bad_data1=ismiss(data_boot);
  bad_data2=sumc(imag(data_boot).gt 0);
  bad_data=((bad_data1+bad_data2) gt 0);
  "Bad data?";;bad_data;
 endo;

 xi_prep(data_boot);
 distrib="EXPON";
 model="EACD";
 PARREST_qmle;
 {qmle_par,void,void,ret_qmle} = ACD_QML_twostep(acd_start,-999,1);
 if ret_qmle==1;
  bad_data=1;
 else;
 "ret_qmle";;ret_qmle;;"par";;qmle_par';
 model ="GGACD";
 {dist_pars,DS0000_1, HS0000_1, DS0501_1, HS0501_1, DS0505_1, HS0505_1,
 DS0510_1, HS0510_1, DS0520_1, HS0520_1, DS2001_1, HS2001_1,
 DS2020_1, HS2020_1, DS2501_1, HS2501_1, DS3001_1, HS3001_1,
 DS0000_2, HS0000_2, DS0501_2, HS0501_2, DS0505_2, HS0505_2,
 DS0510_2, HS0510_2, DS0520_2, HS0520_2, DS2001_2, HS2001_2,
 DS2020_2, HS2020_2, DS2501_2, HS2501_2, DS3001_2, HS3001_2,
 DS0000_3, HS0000_3, DS0501_3, HS0501_3, DS0505_3, HS0505_3,
 DS0510_3, HS0510_3, DS0520_3, HS0520_3, DS2001_3, HS2001_3,
 DS2020_3, HS2020_3, DS2501_3, HS2501_3, DS3001_3, HS3001_3,ret_dist}=
 test_boot("GENGAM",qmle_par,dist_gg,usemean);
 "Ret_dist";;ret_dist;;"Parameter";;dist_pars';
 if ret_dist==1;
  bad_data=1;
 else;
  bad_data=0;
 endif;
endif;
endo;

DS0000G1[BOOT+1,1]=DS0000_1;
DS0501G1[BOOT+1,1]=DS0501_1;
DS2001G1[BOOT+1,1]=DS2001_1;
DS2501G1[BOOT+1,1]=DS2501_1;
DS3001G1[BOOT+1,1]=DS3001_1;

HS0000G1[BOOT+1,1]=HS0000_1;
HS0505G1[BOOT+1,1]=HS0505_1;
HS0510G1[BOOT+1,1]=HS0510_1;
HS0520G1[BOOT+1,1]=HS0520_1;
HS2020G1[BOOT+1,1]=HS2020_1;

DS0000G2[BOOT+1,1]=DS0000_2;
DS0501G2[BOOT+1,1]=DS0501_2;
DS0505G2[BOOT+1,1]=DS0505_2;

DS0000G3[BOOT+1,1]=DS0000_3;
DS0505G3[BOOT+1,1]=DS0505_3;
DS0510G3[BOOT+1,1]=DS0510_3;
DS0520G3[BOOT+1,1]=DS0520_3;
DS2020G3[BOOT+1,1]=DS2020_3;

HS0000G3[BOOT+1,1]=HS0000_3;
HS0505G3[BOOT+1,1]=HS0505_3;
HS0510G3[BOOT+1,1]=HS0510_3;
HS0520G3[BOOT+1,1]=HS0520_3;
HS2020G3[BOOT+1,1]=HS2020_3;
boot = boot+1;
endo;

overdis_expo[rep,.]=rep~seed_buf~seed~overdis_expo_rep[1]~pv_boot(overdis_expo_boot);
overdis_wbll[rep,.]=rep~seed_buf~seed~overdis_wbll_rep[1]~pv_boot(overdis_wbll_boot);

D0000E1[rep,.]=rep~seed_buf~seed~DS0000expon1[1]~pv_boot(DS0000E1);
D0501E1[rep,.]=rep~seed_buf~seed~DS0501expon1[1]~pv_boot(DS0501E1);
D2001E1[rep,.]=rep~seed_buf~seed~DS2001expon1[1]~pv_boot(DS2001E1);
D2501E1[rep,.]=rep~seed_buf~seed~DS2501expon1[1]~pv_boot(DS2501E1);
D3001E1[rep,.]=rep~seed_buf~seed~DS3001expon1[1]~pv_boot(DS3001E1);

D0000W1[rep,.]=rep~seed_buf~seed~DS0000weibull1[1]~pv_boot(DS0000W1);
D0501W1[rep,.]=rep~seed_buf~seed~DS0501weibull1[1]~pv_boot(DS0501W1);
D2001W1[rep,.]=rep~seed_buf~seed~DS2001weibull1[1]~pv_boot(DS2001W1);
D2501W1[rep,.]=rep~seed_buf~seed~DS2501weibull1[1]~pv_boot(DS2501W1);
D3001W1[rep,.]=rep~seed_buf~seed~DS3001weibull1[1]~pv_boot(DS3001W1);

D0000B1[rep,.]=rep~seed_buf~seed~DS0000burr1[1]~pv_boot(DS0000B1);
D0501B1[rep,.]=rep~seed_buf~seed~DS0501burr1[1]~pv_boot(DS0501B1);
D2001B1[rep,.]=rep~seed_buf~seed~DS2001burr1[1]~pv_boot(DS2001B1);
D2501B1[rep,.]=rep~seed_buf~seed~DS2501burr1[1]~pv_boot(DS2501B1);
D3001B1[rep,.]=rep~seed_buf~seed~DS3001burr1[1]~pv_boot(DS3001B1);

D0000G1[rep,.]=rep~seed_buf~seed~DS0000gg1[1]~pv_boot(DS0000G1);
D0501G1[rep,.]=rep~seed_buf~seed~DS0501gg1[1]~pv_boot(DS0501G1);
D2001G1[rep,.]=rep~seed_buf~seed~DS2001gg1[1]~pv_boot(DS2001G1);
D2501G1[rep,.]=rep~seed_buf~seed~DS2501gg1[1]~pv_boot(DS2501G1);
D3001G1[rep,.]=rep~seed_buf~seed~DS3001gg1[1]~pv_boot(DS3001G1);

/*H test uniform */
H0000E1[rep,.]=rep~seed_buf~seed~HS0000expon1[1]~pv_boot(HS0000E1);
H0505E1[rep,.]=rep~seed_buf~seed~HS0505expon1[1]~pv_boot(HS0505E1);
H0510E1[rep,.]=rep~seed_buf~seed~HS0510expon1[1]~pv_boot(HS0510E1);
H0520E1[rep,.]=rep~seed_buf~seed~HS0520expon1[1]~pv_boot(HS0520E1);
H2020E1[rep,.]=rep~seed_buf~seed~HS2020expon1[1]~pv_boot(HS2020E1);

H0000W1[rep,.]=rep~seed_buf~seed~HS0000weibull1[1]~pv_boot(HS0000W1);
H0505W1[rep,.]=rep~seed_buf~seed~HS0505weibull1[1]~pv_boot(HS0505W1);
H0510W1[rep,.]=rep~seed_buf~seed~HS0510weibull1[1]~pv_boot(HS0510W1);
H0520W1[rep,.]=rep~seed_buf~seed~HS0520weibull1[1]~pv_boot(HS0520W1);
H2020W1[rep,.]=rep~seed_buf~seed~HS2020weibull1[1]~pv_boot(HS2020W1);

H0000B1[rep,.]=rep~seed_buf~seed~HS0000burr1[1]~pv_boot(HS0000B1);
H0505B1[rep,.]=rep~seed_buf~seed~HS0505burr1[1]~pv_boot(HS0505B1);
H0510B1[rep,.]=rep~seed_buf~seed~HS0510burr1[1]~pv_boot(HS0510B1);
H0520B1[rep,.]=rep~seed_buf~seed~HS0520burr1[1]~pv_boot(HS0520B1);
H2020B1[rep,.]=rep~seed_buf~seed~HS2020burr1[1]~pv_boot(HS2020B1);

H0000G1[rep,.]=rep~seed_buf~seed~HS0000gg1[1]~pv_boot(HS0000G1);
H0505G1[rep,.]=rep~seed_buf~seed~HS0505gg1[1]~pv_boot(HS0505G1);
H0510G1[rep,.]=rep~seed_buf~seed~HS0510gg1[1]~pv_boot(HS0510G1);
H0520G1[rep,.]=rep~seed_buf~seed~HS0520gg1[1]~pv_boot(HS0520G1);
H2020G1[rep,.]=rep~seed_buf~seed~HS2020gg1[1]~pv_boot(HS2020G1);

/* D test uniform log */
D0000E2[rep,.]=rep~seed_buf~seed~DS0000expon2[1]~pv_boot(DS0000E2);
D0501E2[rep,.]=rep~seed_buf~seed~DS0501expon2[1]~pv_boot(DS0501E2);
D0505E2[rep,.]=rep~seed_buf~seed~DS0505expon2[1]~pv_boot(DS0505E2);

D0000W2[rep,.]=rep~seed_buf~seed~DS0000weibull2[1]~pv_boot(DS0000W2);
D0501W2[rep,.]=rep~seed_buf~seed~DS0501weibull2[1]~pv_boot(DS0501W2);
D0505W2[rep,.]=rep~seed_buf~seed~DS0505weibull2[1]~pv_boot(DS0505W2);

D0000B2[rep,.]=rep~seed_buf~seed~DS0000burr2[1]~pv_boot(DS0000B2);
D0501B2[rep,.]=rep~seed_buf~seed~DS0501burr2[1]~pv_boot(DS0501B2);
D0505B2[rep,.]=rep~seed_buf~seed~DS0505burr2[1]~pv_boot(DS0505B2);

D0000G2[rep,.]=rep~seed_buf~seed~DS0000gg2[1]~pv_boot(DS0000G2);
D0501G2[rep,.]=rep~seed_buf~seed~DS0501gg2[1]~pv_boot(DS0501G2);
D0505G2[rep,.]=rep~seed_buf~seed~DS0505gg2[1]~pv_boot(DS0505G2);

/*D test gamma */
D0000E3[rep,.]=rep~seed_buf~seed~DS0000expon3[1]~pv_boot(DS0000E3);
D0505E3[rep,.]=rep~seed_buf~seed~DS0505expon3[1]~pv_boot(DS0505E3);
D0510E3[rep,.]=rep~seed_buf~seed~DS0510expon3[1]~pv_boot(DS0510E3);
D0520E3[rep,.]=rep~seed_buf~seed~DS0520expon3[1]~pv_boot(DS0520E3);
D2020E3[rep,.]=rep~seed_buf~seed~DS2020expon3[1]~pv_boot(DS2020E3);

D0000W3[rep,.]=rep~seed_buf~seed~DS0000weibull3[1]~pv_boot(DS0000W3);
D0505W3[rep,.]=rep~seed_buf~seed~DS0505weibull3[1]~pv_boot(DS0505W3);
D0510W3[rep,.]=rep~seed_buf~seed~DS0510weibull3[1]~pv_boot(DS0510W3);
D0520W3[rep,.]=rep~seed_buf~seed~DS0520weibull3[1]~pv_boot(DS0520W3);
D2020W3[rep,.]=rep~seed_buf~seed~DS2020weibull3[1]~pv_boot(DS2020W3);

D0000B3[rep,.]=rep~seed_buf~seed~DS0000burr3[1]~pv_boot(DS0000B3);
D0505B3[rep,.]=rep~seed_buf~seed~DS0505burr3[1]~pv_boot(DS0505B3);
D0510B3[rep,.]=rep~seed_buf~seed~DS0510burr3[1]~pv_boot(DS0510B3);
D0520B3[rep,.]=rep~seed_buf~seed~DS0520burr3[1]~pv_boot(DS0520B3);
D2020B3[rep,.]=rep~seed_buf~seed~DS2020burr3[1]~pv_boot(DS2020B3);

D0000G3[rep,.]=rep~seed_buf~seed~DS0000gg3[1]~pv_boot(DS0000G3);
D0505G3[rep,.]=rep~seed_buf~seed~DS0505gg3[1]~pv_boot(DS0505G3);
D0510G3[rep,.]=rep~seed_buf~seed~DS0510gg3[1]~pv_boot(DS0510G3);
D0520G3[rep,.]=rep~seed_buf~seed~DS0520gg3[1]~pv_boot(DS0520G3);
D2020G3[rep,.]=rep~seed_buf~seed~DS2020gg3[1]~pv_boot(DS2020G3);

/*H test gamma */
H0000E3[rep,.]=rep~seed_buf~seed~HS0000expon3[1]~pv_boot(HS0000E3);
H0505E3[rep,.]=rep~seed_buf~seed~HS0505expon3[1]~pv_boot(HS0505E3);
H0510E3[rep,.]=rep~seed_buf~seed~HS0510expon3[1]~pv_boot(HS0510E3);
H0520E3[rep,.]=rep~seed_buf~seed~HS0520expon3[1]~pv_boot(HS0520E3);
H2020E3[rep,.]=rep~seed_buf~seed~HS2020expon3[1]~pv_boot(HS2020E3);

H0000W3[rep,.]=rep~seed_buf~seed~HS0000weibull3[1]~pv_boot(HS0000W3);
H0505W3[rep,.]=rep~seed_buf~seed~HS0505weibull3[1]~pv_boot(HS0505W3);
H0510W3[rep,.]=rep~seed_buf~seed~HS0510weibull3[1]~pv_boot(HS0510W3);
H0520W3[rep,.]=rep~seed_buf~seed~HS0520weibull3[1]~pv_boot(HS0520W3);
H2020W3[rep,.]=rep~seed_buf~seed~HS2020weibull3[1]~pv_boot(HS2020W3);

H0000B3[rep,.]=rep~seed_buf~seed~HS0000burr3[1]~pv_boot(HS0000B3);
H0505B3[rep,.]=rep~seed_buf~seed~HS0505burr3[1]~pv_boot(HS0505B3);
H0510B3[rep,.]=rep~seed_buf~seed~HS0510burr3[1]~pv_boot(HS0510B3);
H0520B3[rep,.]=rep~seed_buf~seed~HS0520burr3[1]~pv_boot(HS0520B3);
H2020B3[rep,.]=rep~seed_buf~seed~HS2020burr3[1]~pv_boot(HS2020B3);

H0000G3[rep,.]=rep~seed_buf~seed~HS0000gg3[1]~pv_boot(HS0000G3);
H0505G3[rep,.]=rep~seed_buf~seed~HS0505gg3[1]~pv_boot(HS0505G3);
H0510G3[rep,.]=rep~seed_buf~seed~HS0510gg3[1]~pv_boot(HS0510G3);
H0520G3[rep,.]=rep~seed_buf~seed~HS0520gg3[1]~pv_boot(HS0520G3);
H2020G3[rep,.]=rep~seed_buf~seed~HS2020gg3[1]~pv_boot(HS2020G3);

save overdis_expo;
save overdis_wbll;

save D0000E1;
save D0501E1;
save D2001E1;
save D2501E1;
save D3001E1;

save D0000W1;
save D0501W1;
save D2001W1;
save D2501W1;
save D3001W1;

save D0000B1;
save D0501B1;
save D2001B1;
save D2501B1;
save D3001B1;

save D0000G1;
save D0501G1;
save D2001G1;
save D2501G1;
save D3001G1;

/*H test uniform */
save H0000E1;
save H0505E1;
save H0510E1;
save H0520E1;
save H2020E1;

save H0000W1;
save H0505W1;
save H0510W1;
save H0520W1;
save H2020W1;

save H0000B1;
save H0505B1;
save H0510B1;
save H0520B1;
save H2020B1;

save H0000G1;
save H0505G1;
save H0510G1;
save H0520G1;
save H2020G1;

/* D test uniform log */
save D0000E2;
save D0501E2;
save D0505E2;

save D0000W2;
save D0501W2;
save D0505W2;

save D0000B2;
save D0501B2;
save D0505B2;

save D0000G2;
save D0501G2;
save D0505G2;

/*D test gamma */
save D0000E3;
save D0505E3;
save D0510E3;
save D0520E3;
save D2020E3;

save D0000W3;
save D0505W3;
save D0510W3;
save D0520W3;
save D2020W3;

save D0000B3;
save D0505B3;
save D0510B3;
save D0520B3;
save D2020B3;

save D0000G3;
save D0505G3;
save D0510G3;
save D0520G3;
save D2020G3;

/*H test gamma */
save H0000E3;
save H0505E3;
save H0510E3;
save H0520E3;
save H2020E3;

save H0000W3;
save H0505W3;
save H0510W3;
save H0520W3;
save H2020W3;

save H0000B3;
save H0505B3;
save H0510B3;
save H0520B3;
save H2020B3;

save H0000G3;
save H0505G3;
save H0510G3;
save H0520G3;
save H2020G3;

rep = rep + 1;

ENDO;

