/* IBM EXACD
*/


library cml, co, pgraph;
#include cml.ext;
#include co.ext
#include pgraph.ext;
CMLset;
coset;
graphset;
#include highfreq.dec;
#include highfreq.ext;
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
globalpsi = {};

#include dtyfcacd.src;


@============@
@ The following GLOBALS must be identical for all models tested to ensure comparability @

let number_of_bins = 20;                 /*number of bins for histogram plot of z changed from binwidth: j.g. 9.11.99 */
let lagorder = 50;                       /*Lags for autocorrelation plot:                      */
let conf_interval = 0.9;                 /*90 % confidence interval for histogram plot         */

@ end common section @
@============@

/*******************   TO BE ADAPTED FOR EACH DATA SET    *******************/

loadm datamatrix = xonqv25;
OUTPUT file      = evexacdb;
output reset; output on; screen on;
" ";
"Estimation first two third, evaluation first two third";

/****************************************************************************/

 ALLCASES = rows(datamatrix);

 P     =1;                                 /* lag length for lagged psi in ACD model (used as GLOBAL) */
 Q     =1;                                 /* lag length for lagged XI in  ACD model (used as GLOBAL) */

@
  This selects the last third of the data for forecasting purposes
  and also tests on the data
@

 XI    = datamatrix[1:round(allcases*(2/3))-1,9];
 FXI   = xi;

/* Globals needed for Forecasting j.g. November 4, 1999 */

                                           /* This uses the last third of durations for evaluation (XI is used as a GLOBAL)*/
 FCASES =rows(FXI);                        /* CASES is used as a GLOBAL in diebold_z                  */
 FMXI   =generate_lagged_xi(FXI,q,fcases); /* Generates a matrix of lagged durations (used as GLOBAL) */


/* Globals for Estimation  j.g. November 4, 1999 */

 CASES =rows(XI);                         /* CASES used for estimation                                            */
 MXI   =generate_lagged_xi(XI,q,cases);   /* Generates a matrix of lagged durations for estimation(used as GLOBAL) */
 MIND_P=genindx_with_cases(2,p,1,cases);  /* Generates an index vector that is only needed if analytical gradients
                                             are supplied for EACD, WACD and BACD, then used as global
                                          */

 EXO    = zeros(rows(xi),1);                             /* 0 = no exogenous regressors in PSI equation: estimation period */
 FEXO   = 0;                             /* same for forecasting period                                    */
 NOEXOG = 0;                             /* signifies number of exogenour regressors */
 data_input = {};                        /* I dont use this matrix to transfer data, I use Glokols (xi, mxi,)
                                            it may be needed, however for other models...*/
 let model_specifics = {};               /* I don't need any, you may.... */

model            = "BAACD";
sub_aacd         = "EXACD";
loadm model_parameters = evlogacdb_par;
model_parameters = model_parameters|0;

_cml_algorithm   = 3;         /* CML settings */
_cml_linesearch  = 1;
/*_cml_gradstep  = 0.01;*/
_cml_gradmethod  = 1;
_use_cml         = 1;
_cml_covpar      = 2;
_cml_gradmethod  = 1;
/*
_uu_ = { -1e250 1e250 };
_cml_Bounds = ones(rows(model_parameters),2).*_uu_;
_cml_bounds[1,1] = -1000;
*/
_cml_maxiters = 100;
_cml_covpar   = 2;
_cml_maxtry = 100000;
_cml_Dirtol = 1e-4;

_cml_maxiters = 100000;

{evexacdb_par, evexacdb_f0 , g, evexacdb_varcov, evexacdb_retcode} = cmlprt(CML(XI, 0, &li_aacd, model_parameters));
save evexacdb_par;
save evexacdb_f0;
evexacdb_se = sqrt(diag(evexacdb_varcov));
save evexacdb_se;
save evexacdb_retcode;
save evexacdb_varcov;
save evexacdb_se;
save evexacdb_retcode;
"Log-Likelihood";
 evexacdb_f0*cases;
"BIC";
-2*evexacdb_f0*cases+ln(cases)*rows(evexacdb_par);
"Parameter estimates and standard errors";
evexacdb_par~evexacdb_se;
