/* IBM price power acd burr
*/


library cml, co, pgraph;
#include cml.ext;
#include co.ext
#include pgraph.ext;
CMLset;
coset;
graphset;
#include highfreq.dec;
#include highfreq.ext;
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
globalpsi = {};

#include dtyfcacd.src;


@============@
@ The following GLOBALS must be identical for all models tested to ensure comparability @

let number_of_bins = 20;                 /*number of bins for histogram plot of z changed from binwidth: j.g. 9.11.99 */
let lagorder = 50;                       /*Lags for autocorrelation plot:                      */
let conf_interval = 0.9;                 /*90 % confidence interval for histogram plot         */

@ end common section @
@============@

/*******************   TO BE ADAPTED FOR EACH DATA SET    *******************/

loadm datamatrix = ibmqp18;
OUTPUT file      = ipapacdb;
output reset; output on; screen on;
" ";
"Estimation first two third, evaluation first two third";

/****************************************************************************/

 ALLCASES = rows(datamatrix);

 P     =1;                                 /* lag length for lagged psi in ACD model (used as GLOBAL) */
 Q     =1;                                 /* lag length for lagged XI in  ACD model (used as GLOBAL) */

@
  This selects the last third of the data for forecasting purposes
  and also tests on the data
@

 XI    = datamatrix[1:round(allcases*(2/3))-1,9];
 FXI   = xi;

/* Globals needed for Forecasting j.g. November 4, 1999 */

                                           /* This uses the last third of durations for evaluation (XI is used as a GLOBAL)*/
 FCASES =rows(FXI);                        /* CASES is used as a GLOBAL in diebold_z                  */
 FMXI   =generate_lagged_xi(FXI,q,fcases); /* Generates a matrix of lagged durations (used as GLOBAL) */


/* Globals for Estimation  j.g. November 4, 1999 */

 CASES =rows(XI);                         /* CASES used for estimation                                            */
 MXI   =generate_lagged_xi(XI,q,cases);   /* Generates a matrix of lagged durations for estimation(used as GLOBAL) */
 MIND_P=genindx_with_cases(2,p,1,cases);  /* Generates an index vector that is only needed if analytical gradients
                                             are supplied for EACD, WACD and BACD, then used as global
                                          */

 EXO    = 0;                             /* 0 = no exogenous regressors in PSI equation: estimation period */
 FEXO   = 0;                             /* same for forecasting period                                    */
 NOEXOG = 0;                             /* signifies number of exogenour regressors */
 data_input = {};                        /* I dont use this matrix to transfer data, I use Glokols (xi, mxi,)
                                            it may be needed, however for other models...*/
 let model_specifics = {};               /* I don't need any, you may.... */

 model            = "EACD";
 _cml_algorithm   = 3;
 _cml_linesearch  = 3;
 _cml_covpar      = 3;
 loadm model_parameters = ba_t_beta_eacd_o.fmt;
{parameter_input, f0 , g, varcov1, retcode} = CML(XI, 0, &li_ACD, model_parameters);

sub_aacd         = "APACD";
model            = "BAACD";
eacd_start       = parameter_input;
kappa            = 1.3;
sigma2           = 0.2;
/*b                = 0;
c                = 0;*/
lambda           = 1;
/*upsilon          = 1;*/

model_parameters   = model_parameters|kappa|sigma2|1|0.01|0;

loadm model_parameters = ipacdb_par;
model_parameters = model_parameters|0.01|0;


let model_parameters = 0.03779501 0.12696156 0.84677087
  1.2978673 0.46845286 0.25730297 0.041057754 -0.23255295;

_cml_algorithm   = 3;         /* CML settings */
_cml_linesearch  = 3;
/*_cml_gradstep  = 0.01;*/
_use_cml         = 1;
_cml_covpar      = 2;
_cml_gradmethod  = 1;

_uu_ = { 1e-06 1e250 };
_cml_Bounds = ones(rows(model_parameters),2).*_uu_;
_cml_bounds[1,1] = -50;
_cml_bounds[2,1] = -50;
_cml_bounds[8,1]= -0.9999;
_cml_bounds[8,2]= 0.9999;
_cml_maxtry = 100000;

/*loadm model_parameters = ipapacdb_par;*/
_cml_maxiters = 0;
_cml_covpar   = 2;
loadm model_parameters = iasacdb_par;
model_parameters = model_parameters[1]|
                   model_parameters[2]|
                   model_parameters[3]-model_parameters[2]*model_parameters[7]|
                   model_parameters[4]|
                   model_parameters[5]|
                   1|
                   model_parameters[6]|
                   model_parameters[7]/model_parameters[2];

_cml_maxtry = 100000;
{iapacdb_par, iapacdb_f0 , g, iapacdb_varcov, iapacdb_retcode} = CML(XI, 0, &li_aacd, model_parameters);
save iapacdb_par;
save iapacdb_f0;
iapacdb_se = sqrt(diag(iapacdb_varcov));
save iapacdb_se;
save iapacdb_retcode;
