/* Exxon Volume power acd burr
*/


library cml, co, pgraph;
#include cml.ext;
#include co.ext
#include pgraph.ext;
CMLset;
coset;
graphset;
#include highfreq.dec;
#include highfreq.ext;
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
globalpsi = {};

#include dtyfcacd.src;


@============@
@ The following GLOBALS must be identical for all models tested to ensure comparability @

let number_of_bins = 20;                 /*number of bins for histogram plot of z changed from binwidth: j.g. 9.11.99 */
let lagorder = 50;                       /*Lags for autocorrelation plot:                      */
let conf_interval = 0.9;                 /*90 % confidence interval for histogram plot         */

@ end common section @
@============@

/*******************   TO BE ADAPTED FOR EACH DATA SET    *******************/

loadm datamatrix = ibmqv25;
OUTPUT file      = ivlnacd1b;
output reset; output on; screen on;
" ";
"Estimation first two third, etaluation first two third";

/****************************************************************************/

 ALLCASES = rows(datamatrix);

 P     =1;                                 /* lag length for lagged psi in ACD model (used as GLOBAL) */
 Q     =1;                                 /* lag length for lagged XI in  ACD model (used as GLOBAL) */

@
  This selects the last third of the data for forecasting purposes
  and also tests on the data
@

 XI    = datamatrix[1:round(allcases*(2/3))-1,9];
 FXI   = xi;

/* Globals needed for Forecasting j.g. November 4, 1999 */

                                           /* This uses the last third of durations for etaluation (XI is used as a GLOBAL)*/
 FCASES =rows(FXI);                        /* CASES is used as a GLOBAL in diebold_z                  */
 FMXI   =generate_lagged_xi(FXI,q,fcases); /* Generates a matrix of lagged durations (used as GLOBAL) */


/* Globals for Estimation  j.g. November 4, 1999 */

 CASES =rows(XI);                         /* CASES used for estimation                                            */
 MXI   =generate_lagged_xi(XI,q,cases);   /* Generates a matrix of lagged durations for estimation(used as GLOBAL) */
 MIND_P=genindx_with_cases(2,p,1,cases);  /* Generates an index vector that is only needed if analytical gradients
                                             are supplied for EACD, WACD and BACD, then used as global
                                          */

 EXO    = zeros(rows(xi),1);                             /* 0 = no exogenous regressors in PSI equation: estimation period */
 FEXO   = 0;                             /* same for forecasting period                                    */
 NOEXOG = 0;                             /* signifies number of exogenour regressors */
 data_input = {};                        /* I dont use this matrix to transfer data, I use Glokols (xi, mxi,)
                                            it may be needed, howeter for other models...*/
 let model_specifics = {};               /* I don't need any, you may.... */

model            = "BAACD";
sub_aacd         = "LNACD1";
_cml_algorithm   = 3;         /* CML settings */
_cml_linesearch  = 3;
_cml_gradmethod  = 1;
_use_cml         = 1;
_cml_covpar      = 2;
_cml_gradmethod  = 1;
loadm model_parameters = evlinacdb_par;
_cml_maxtry = 100000;
{ivlacd1b_par, ivlacd1b_f0 , g, ivlacd1b_varcov, ivlacd1b_retcode} = CML(XI, 0, &li_aacd, model_parameters);
save ivlacd1b_par;
save ivlacd1b_f0;
ivlacd1b_se = sqrt(diag(ivlacd1b_varcov));
save ivlacd1b_se;
save ivlacd1b_retcode;

"Log-Likelihood";
 ivlacd1b_f0*cases;
"BIC";
-2*ivlacd1b_f0*cases+ln(cases)*rows(ivlacd1b_par);
"Parameter estimates and standard errors";
ivlacd1b_par~ivlacd1b_se;
