/* TwoPassGMM_All_JFQA.prg
   ============================
   Frontend for estimation of CDRM and other models by two-pass regressions
   using 2-pass-regression/GMM a'la Cochrane produces results in paper 
   "Creative destruction and asset prices" Results are printed on screen
/***********************************************************************/
// 1. Initialisation of globals for GMM_NCB_Collection_JFQA.src and #including the source code */
//Gauss initializations
cls;
library  pgraph;
graphset;
#include GMM_NCB_Collection_JFQA_v2.src; //include procedures file

/***********************************************************************/
//1. Set here the analysis that you want !!!!
model=3;      /* relevant choice are:
                 1=CAPM
                 2=Fama French model
                 3=CDRM (referred to as PAG in the code)
                 4=MP-CDRM with excess return of mimicking portfolio supplied in raw data
                  (used for 45 degree plots and covariances of excess returns with patenting growth 
                   proper GMM inference in this context is with model=6)
                 5=GMM inference for mimicking portfolio estimation
                   Wald test for joint significance of mimicking portfolio weights
                   Also performs regresssions
                   on SMB and HML to test the significance of intercepts taking into
                   account that the portfolio weights are estimated
                 6=MP-CDRM three-pass regression using GMM results, including Lewellen/Wald test
		 8=orthogonalized extended CDRM (orthogonolized HML und SMB w.r.t patenting growth)
		 10=CDH portfolio model*/
/*Note: model=4 uses a pre-estimated mimicking portfolio while 6 estimates it, and provides proper 
inference. The estimates are numerically identical. use model=4 to produce the goodness-of
fit plots (not produced when model=6). */

testassets=1; //1= 25sb,value-weighted (VW); 2= 25sb, equally-weighted (EW); 3= 25sb~ind17ew, vw  4= HML and SMB
              //5=10 size single sorted (VW); 6= 10 B/M single sorted (VW)  

freq=1;     //1 = annual, 2 = quarterly 

/* Main text reports results on
   model-test assets-frequency
   1-1-1 (CAPM, value-weighted, annual)
   2-1-1 (Fama-French, value-weighted, annual)
   3-1-1 (CDRM, value-weighted,annual)
   3-1-2 (CDRM, value-weighted,quarterly)
   4-1-1 (MP-CDRM-value-weighted-annual (just for plots))
   model four (mimicking pf estimatd upfront, now replaced by model= 6...)
   but we use model=4 to produce the 45 degree line plots!
   5-void-1 (HML and SMB as test assets, with MP-CDRM)
   6-1-1 MP-CDRM, value-weighted, annual 
   6-2-1 MP-CDRM, value-weighted, quarterly
   6-4-1 MP-CDRM with SMB and HML as test assets 
   online appendix has also results for equally weighted portfolios*/

excel=0;    // do not change
nlsys_dummy=0; // do not change
run_boot=0; // do not change

if freq==2 and testassets==3;
    "****************************************************";
    "not implemented";
    "****************************************************";
    stop;
endif;
if model==4 and freq==2;
    "****************************************************";
    "not implemented";
    "****************************************************";
    stop;
endif;

"****************************************************";
"Analysis for model: ";;model;"frequency: ";;freq;"testassets: ";;testassets;

/***********************************************************************/
//2. manage data input

#include data_input_GMM_all.run; //data input

format /rd 4,3;
//Descriptives
 "****************************************************";
"Mean/Stdc/rho(1)x100 patenting growth (pg)";
 "****************************************************";
meanc(pag)*100~stdc(pag)*100~acf(pag,1,0)*100;
 "****************************************************";
"Mean/Stdc/AC(1)x100 SMB";
 "****************************************************";
meanc(smb)*100~stdc(smb)*100~acf(smb,1,0)*100;
 "****************************************************";
"Mean/Stdc/AC(1)x100 HML";
 "****************************************************";
meanc(hml)*100~stdc(hml)*100~acf(hml,1,0)*100;
 "****************************************************";
"Mean/Stdc/AC(1)x100 r^W";
 "****************************************************";
meanc(mkt)*100~stdc(mkt)*100~acf(mkt,1,0)*100;
 "****************************************************";

if freq == 1;
    "Mean/Stdc/AC(1)x100 Mimicking Portfolio excess return";
    meanc(pagm)*100~stdc(pagm)*100~acf(pagm,1,0)*100;
    "****************************************************";
    "correlation matrix risk factors x 100";
     "****************************************************";
    "r^W,SMB,HML,patenting growth,mimicking portfolio";;
    corrx(mkt~smb~hml~pag~pagm)*100;
     "****************************************************";
elseif freq ==2;
    "correlation matrix risk factors x 100";
     "****************************************************";
    "r^W,SMB,HML,patenting growth";;
   corrx(mkt~smb~hml~pag)*100;
endif;


/***********************************************************************/
// 3. run the two-pass regression/GMM for CAPM, Fama-French or CDRM or MP-CDRM)

if model .le 4 or model==8 or model==10; /*not for the mimicking pf, but the three base models
                  not to be changed, universal, all models 1-4 use this */
  
  #include Two_Pass_Regression_GMM_JFQA.run; // run block 

/***********************************************************************/
// Postprocessing of estimation results for model 1-4
/* The .run file does not prepare the betas and their standard errors
   in a convenient way, i.e. in a way they are reported in the paper
   this is done now
   beta estimates come as a N*K vector (after the N alpha
   estimates, the betas for each asset are stacked
   and need to be reshaped to have them separate for each factor for reporting*/
    N=cols(excess_returns); /*Define for convenience */
    K=cols(factors);
    // t-stats for estimates have not yet been computed we do it here ...
    t=param_est_ols./param_se_OLS;
    betas=param_est_ols[cols(excess_returns)+1:cols(excess_returns)*(cols(factors)+1)];
    betas_se=param_se_ols[cols(excess_returns)+1:cols(excess_returns)*(cols(factors)+1)];
    betas_t=t[cols(excess_returns)+1:cols(excess_returns)*(cols(factors)+1)];
    /* The N*K vectors are reshaped as KxN matrices: the first colum has then
    the first column has the betas for the first asset, and so forth,
    the first row holds the beta values belonging to the first factor
    the second row for the second and so on: this is the lower right
    corner of the a_t matrix */
    betas_mat=reshape(betas,cols(excess_returns),cols(factors));
    betas_se_mat=reshape(betas_se,cols(excess_returns),cols(factors))';
    betas_t_mat=reshape(betas_t,cols(excess_returns),cols(factors))';
    //lambdas
    lambdas_mat=param_est_ols[cols(excess_returns)*(cols(factors)+1)+1:rows(param_est_ols)];
    lambdas_se_mat=param_se_ols[cols(excess_returns)*(cols(factors)+1)+1:rows(param_est_ols)];
    lambdas_t_mat=t[cols(excess_returns)*(cols(factors)+1)+1:rows(param_est_ols)];
    format /rd 4,3;
    "****************************************************";
    "Estimated lambdas (in paper)";;
    lambdas_mat;
    "Lambdas t-stats (in paper)";;
    lambdas_t_mat;
    "Lambdas p-values in % (in paper) ";;
    (1-cdfn(abs(lambdas_t_mat)))*100*2;
    "****************************************************";

    // J-Test results from the .run file results, we have the test statistic, the d.f. and the pvalue
    J_GRS_results=(J_last_N~(cols(excess_returns)-cols(factors))~p_value_J_last_N);

    // R-squared along the lines of Maio Santa-Clara 2012
    mexret_fit = model_implied_expected_return;
    mexret = meanc(excess_returns);
    alpha_hat=mexret-mexret_fit;
    alpha_hat_demeaned=alpha_hat-meanc(alpha_hat);
    mexret_demeaned=mexret-meanc(mexret);
    rsq=1-((sumc(alpha_hat_demeaned.^2))/(sumc(mexret_demeaned.^2))); //that's it 
    rsq_uncentered=1-((sumc(alpha_hat.^2))/(sumc(mexret.^2))); //uncentered R^2
    MAE=meanc(abs(alpha_hat));

    "****************************************************";
    "Cross Sectional R-squared (Eqn (15)) (in paper) :  ";rsq*100;
    "****************************************************";
    "****************************************************";
    "Uncentred Cross Sectional R-squared  % (not reported):   ";rsq_uncentered*100;
    "****************************************************";
    "****************************************************";
    "Mean absolute pricing error (Eqn (14)) (in paper):  ";MAE*100;
    "****************************************************";

/*******************************************************************/
    if model==3 or model==4; //For model CDRM 3 or MP-CDRM 4
    // now reshape the beta estimates, s.e. and t in 5 by 5 matrice as reported in the paper 
        if testassets==1 or testassets==2;
            CDR_annual_FF_beta_mkt=reshape(betas_mat[.,1],5,5);
            CDR_annual_FF_beta_PAG=reshape(betas_mat[.,2],5,5);
            "Invention Betas (in paper)";
            CDR_annual_FF_beta_PAG;
            CDR_annual_FF_beta_mkt_se=reshape(betas_se_mat[.,1],5,5);
            CDR_annual_FF_beta_PAG_se=reshape(betas_se_mat[.,2],5,5);
            CDR_annual_FF_beta_mkt_t=reshape(betas_t_mat[1,.],5,5);
            CDR_annual_FF_beta_PAG_t=reshape(betas_t_mat[2,.],5,5);
            "Invention Betas t-stats";
            CDR_annual_FF_beta_PAG_t;
            "Invention Betas p-values (in %) (interpreted in paper for CDRM)";
            (1-cdfn(abs(CDR_annual_FF_beta_PAG_t)))*100*2;
            /*Beta*lamdas, they come directyl out of the .run file*/
            CDR_annual_FF_betalambda_mkt=beta_lambda_mat_factor_1;
            CDR_annual_FF_betalambda_PAG=beta_lambda_mat_factor_2;
            CDR_annual_FF_betalambda_mkt_se=se_beta_lambda_mat_factor_1;
            CDR_annual_FF_betalambda_PAG_se=se_beta_lambda_mat_factor_2;
            CDR_annual_FF_betalambda_mkt_t=t_beta_lambda_mat_factor_1;
            CDR_annual_FF_betalambda_PAG_t=t_beta_lambda_mat_factor_2;
        else; //other testassets
            "not implemented for testassets other than 25 B/M sorted portfolios";
        endif;
    else; // not CDRM and MP-CDRM
        "not implemented";
    endif; // models 3 or 4
    format /rd 4,3;
    {r_sq_mat}=r_squared(param);
    "******************************************************";
    "Time Series R-squared (in paper)";;
    r_sq_mat;
    "******************************************************";        

    if model ==2 or model==3 or model==4 or model==8 or model==9 or model==10; // ICAPM consistency based on beta-representation
        "Plausibility of the implied risk aversion coefficients of the ICAPM (see Maio and Santa Clara 2012)";
        gamma_vec=invpd(1/rows(factors)*(factors'*factors)-meanc(factors)*(meanc(factors))')*lambdas_mat; 
        // compare eqn 12 in CDRM paper
        vc_lambda=par_var[rows(par_var)-cols(factors)+1:rows(par_var),rows(par_var)-cols(factors)+1:rows(par_var)];
        vc_gamma=invpd(1/rows(factors)*(factors'*factors)-meanc(factors)*(meanc(factors))')*
        (vc_lambda/(rows(factors)))*invpd(1/rows(factors)*(factors'*factors)-meanc(factors)*(meanc(factors))');
        se_gamma=sqrt(diag(vc_gamma));
        "******************************************************";
        "implied gamma estimates and t-statistics (see Eqn (12)) (in paper)";
        gamma_vec~gamma_vec./se_gamma;
        "******************************************************";
        "implied rra estimate:  ";; gamma_vec[1];
         "with s.e.: ";; se_gamma[1];;" and  t-stat.: ";; gamma_vec[1]/se_gamma[1];
        if model==3 or model==4;
            "implied gamma_N estimate: ";; gamma_vec[2];
            "with s.e.:  ";;se_gamma[2];;" and  t-stat: ";;gamma_vec[2]/se_gamma[2];
            if model==4;
                "Warning, inference on RRA and gamma_n does not take into account that mimicking portfolio weights
                are estimated";
            endif;
        endif; // model 3 or 4
    endif; //model 2,3 or 4
    if model==3 or model==4; //covariances of test asset excess returns with pg
        if model==3;
            DataMat=pag~excess_returns;
        endif;
        if model==4;
            DataMat=pagM~excess_returns;
        endif;
        vcmatrix=1/rows(excess_returns)*DataMat'*DataMat-meanc(DataMat)*meanc(DataMat)';
        interesting_covs=vcmatrix[2:rows(vcmatrix),1];
        if testassets==1 or testassets==2;//only for B/M sorted portfolios
            covmat_25=reshape(interesting_covs,5,5);
            "******************************************************";
            "Covariances of patent growth (model=3) or mimicking portfolio excess return (model=4)";
            "with excess returns arranged in usual 5x5 form (*100) (in paper):";
            covmat_25*100;
            "******************************************************";
        else;
            "not implemented for other test assets that 25 B/M sorts";
        endif;
    endif;
    
// Postprocessing estimation results for model 6
elseif model==6; // mimicking portfolio CDRM with GMM
    analysis=7; // required in the generic GMM procedures! 
    GLS=0;
    c_fac=cols(factors)+cols(mim_proj_var);
    {startvals}=get_params; // Estimates by OLS mimicking weights, betas, and lambdas separately 
    if nlsys_dummy==1;
      "not implemented, set nlsys_dummy=0, program stops";stop;
    elseif nlsys_dummy==0;
       param=startvals;
    endif;
    betas=param[cols(excess_returns)+1:cols(excess_returns)*(c_fac+1)];
    betas_mat=reshape(betas,cols(excess_returns),c_fac);
    // Report estimates and t-stats as required for the paper
    betas_market=betas_mat[.,1];
    betas_pagm=betas_mat[.,2];
    if testassets==1 or testassets==2; //only for 25 B/M sorted test assests
        betas_market_mat=reshape(betas_market,5,5);
        betas_pagm_mat=reshape(betas_pagm,5,5);
    else;
        "not implemented for other test assets";
    endif;
    {S_est}=S_estimate(param);
    {Avar_g_T,Avar_param}=var_GMM(param);

     "Check whether a_T g_T=0:";
    "***************************************************";
    (a_T(param)*g_T(param))';

    "***************************************************";
    "Parameters and t-stats:";
    "first alphas and betas, then lambdas (CS and TS) then mimicking:";
    "****************************************************";
    t_stat=param./sqrt(diag(Avar_param)/rows(mim_proj_var));
    seqa(1,1,rows(param))~param~t_stat;
    "****************************************************";

    t_stat=param./sqrt(diag(Avar_param)/rows(mim_proj_var));
    t_stat_betas=t_stat[cols(excess_returns)+1:cols(excess_returns)*(c_fac+1)];
    t_stat_mat=reshape(t_stat_betas,cols(excess_returns),c_fac);
    t_stat_market=t_stat_mat[.,1];
    t_stat_pagm=t_stat_mat[.,2];
    if testassets==1 or testassets==2;
        t_stat_market_mat=reshape(t_stat_market,5,5);
        t_stat_pagm_mat=reshape(t_stat_pagm,5,5);
    else;
        "not implemented for test assets other than 25 B/M";
    endif;
    rsq_vec=zeros(cols(excess_returns),1);
    i=1;
    do while i le cols(excess_returns);
    //Computes the time-series R-squared*
        mimportfolio=mim_base_assets*param[cols(excess_returns)*(c_fac+1)+2*c_fac+cols(mim_proj_var)+1:cols(excess_returns)*(c_fac+1)+2*c_fac+cols(mim_proj_var)+cols(mim_base_assets)];
        {vnam,m,b,stb,vc,stderr,sigma,cx,rsq,resid,dwstat } = ols(0,excess_returns[.,i],mimportfolio~factors);
        rsq_vec[i]=rsq;
        i=i+1;
    endo;
    // Shape time series r-squared as required for paper table
    if testassets==1 or testassets==2;
        rsq_mat=reshape(rsq_vec,5,5);
        "***************************************************";
        "Time Series R-squared (in paper)";;
        rsq_mat;
        "***************************************************";
    else;
       "not implemented for testassets other than 25 B/M sorted portfolios";
    endif;
    lambda_cs_market=param[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+1:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+1];
    lambda_cs_pagm=param[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+2:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+2];
    lambda_ts_market=param[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+3:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+3];
    lambda_ts_pagm=param[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+4:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+4];
    lambda_cs_market_tstat=t_stat[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+1:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+1];
    lambda_cs_pagm_tstat=t_stat[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+2:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+2];
    lambda_ts_market_tstat=t_stat[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+3:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+3];
    lambda_ts_pagm_tstat=t_stat[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+4:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+4];
    // Test for identity of lambdas 
    R1=zeros(rows(param),1);
    R2=zeros(rows(param),1);
    R1[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+1,1]=1;
    R1[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+3,1]=-1;
    R2[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+2,1]=1;
    R2[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+4,1]=-1;
    R1=R1';
    R2=R2';
    Wald_market=(R1*param)'*inv(R1*avar_param/rows(mim_base_assets)*R1')*(R1*param);
    Wald_pagm=(R2*param)'*inv(R2*avar_param/rows(mim_base_assets)*R2')*(R2*param);
    pval_market=cdfchic(Wald_market,1);
    pval_pagm=cdfchic(Wald_pagm,1);

    "Market lambda estimate ";;lambda_cs_market;
    "and t-stat: ";;lambda_cs_market_tstat; 
    "cross-sectional estimate of lambda_N (in paper): ";;lambda_cs_pagm;;
    " and t-stat: ";;lambda_cs_pagm_tstat;;
    " p-value in %: ";; (1-cdfn(abs(lambda_cs_pagm_tstat)))*100*2;
    "time series estimate of lamdba_N (in paper): ";;lambda_ts_pagm;;
    " and t-stat: ";;lambda_ts_pagm_tstat;; "p-value in %: ";; (1-cdfn(abs(lambda_ts_pagm_tstat)))*100*2;

    "******************************************************";
    "Wald-statistic to test identity of two estimates (Eqn (13)), p-value in % (in paper): ";;pval_pagm*100;
    "******************************************************";
    
     {g_T_var,par_var}=var_GMM(param);
     {betalambda}=beta_lambda(param);
     betalambda_market=betalambda[1,.];
     betalambda_pagm=betalambda[2,.];
     {beta_lambda_vec_vc,se_beta_lambda}=beta_lambda_vc(param,par_var);
     se_market=se_beta_lambda[1,.];
     se_pagm=se_beta_lambda[2,.];
     betalambda_tstat_market=betalambda_market./se_market;   
     betalambda_tstat_pagm=betalambda_pagm./se_pagm;
    
    "gamma estimates implied by lambda estimates (in paper) (see Eqn (12))";
     //extract lambda_W and lambda_~N from parameter vector, call it lambdas_mat
     lambdas_mat=param[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+1:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+2];
     //extract the mimicking portfolio parameters 
     mim_par=param[cols(excess_returns)*(c_fac+1)+2*c_fac+cols(mim_proj_var)+1:cols(excess_returns)*(c_fac+1)+2*c_fac+cols(mim_proj_var)+cols(mim_base_assets)];
     //construct the vector of factors: market return and mimicking portfolio, call it factors
     mim_pag=mim_base_assets*mim_par;
     factors_mat=factors~mim_pag;
     //extract the variance covariance sub-matrix of the lambdas, check it
      vc_lambda=par_var[cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+1:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+2, cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+1:cols(excess_returns)*(1+cols(factors)+cols(mim_proj_var))+2];
     //compute implied gamma representation parameters
      gamma_vec=invpd(1/rows(factors_mat)*(factors_mat'*factors_mat)-meanc(factors_mat)*(meanc(factors_mat))')*lambdas_mat; 
     //VC matrix as described in Appendix A.1
      vc_gamma=invpd(1/rows(factors_mat)*(factors_mat'*factors_mat)-meanc(factors_mat)*(meanc(factors_mat))')*
     (vc_lambda/(rows(factors_mat)))*invpd(1/rows(factors_mat)*(factors_mat'*factors_mat)-meanc(factors_mat)*(meanc(factors_mat))');
     //standard errors of recovered parameters
     se_gamma=sqrt(diag(vc_gamma));
     "******************************************************";
     "implied gamma estimates and t-statistics (see Eqn (12)) (in paper):";
     gamma_vec~gamma_vec./se_gamma;
      "******************************************************";
    
    if testassets==1 or testassets==2;    
    // Next, for testassets 1 and 2 (VW and EW), output for beta*lambda table is generated 
    // ! This is specific for the 25 portfolios, it would not work for industry portfolios
    
    /* Test the signficance of a beta*lambda difference of two stocks
         of the last three arguments the first is the row that identifies
        the factor (differences can only be tested holding the factor 
        constant, the remaining two are the assets. the big growth
        portfolio is number 21, the small value portfolio is 5, we
        pick the second row, that is the PAG factor 
        NOTE THAT for THE CDR MODEL, PG MUST BE THE SECOND FACTOR !!
     */
        "Difference in expected returns analysis for MP-CDRM (in paper)";
        let asset_1=5;  // first asset to be compared (small value)
        let asset_2=21; // second asset (big growth)
        {beta_lambda_diff_r,beta_lambda_se,beta_lambda_pval}=beta_lambda_diff(betalambda,beta_lambda_vec_vc,2,asset_1,asset_2);
        format /rd 4,0;
        "Reported in paper:";
        "Assets ";; Asset_1;;"-";;Asset_2;
        "diff.  " "s.e. ";;"t     ";;"p-val.% ";format /rd 4,3;
        beta_lambda_diff_r~beta_lambda_se~(beta_lambda_diff_r./beta_lambda_se)~beta_lambda_pval*100;
        "Analysis for asset 5, small value, against 21, big growth";
        "****************************************************";
        
        // now reshape into matrices
        betalambda_market=reshape(betalambda_market,5,5);
        betalambda_pagm=reshape(betalambda_pagm,5,5);
        betalambda_tstat_market=reshape(betalambda_tstat_market,5,5);
        betalambda_tstat_pagm=reshape(betalambda_tstat_pagm,5,5);

        "****************************************************";
        "Beta*Lambda for MP-CDRM "; "horizontal: Book-to-Market vertical: size (in paper):";
        betalambda_pagm;
        "****************************************************";
        "t-stats beta_N*lambda_N for MP-CDRM (in paper): ";
        betalambda_tstat_pagm;
        "";
        "****************************************************";
        "Reported in paper for large-growth and small-value (corners)";
        "p-value (%) beta_N*lambda_N for MP-CDRM:";;(1-cdfn(abs(betalambda_tstat_pagm)))*100*2;
        "****************************************************";
        if freq==2;
            "annualized compensation (((beta_N x lambda_N + 1)^4)-1)*100";
            (((betalambda_pagm+1)^4)-1)*100;
            "annualized beta_N x lambda_N x 4 x 100;";
              betalambda_pagm*4*100;
        endif;
    else; // not for B/M sorted portfolios (industry)
       "not implemented for testassets other than 25 B/M sorted porfolios";
    endif;

    //Compute mean realized excess returns and avg. predicted excess returns for model-fit-graph 
    mexret=meanc(excess_returns);
    model_implied_expected_return=sumc(betalambda);

    // Maio and Santa Clara type R^2: reported in the paper
    mexret_fit = model_implied_expected_return;
    mexret = meanc(excess_returns);
    alpha_hat=mexret-mexret_fit;
    alpha_hat_demeaned=alpha_hat-meanc(alpha_hat);
    mexret_demeaned=mexret-meanc(mexret);
    rsq=1-((sumc(alpha_hat_demeaned.^2))/(sumc(mexret_demeaned.^2)));
    "****************************************************";
    "Cross-sectional R-squared (Eqn (15)) (in paper): ";;rsq*100;
    "****************************************************";
    MAE=meanc(abs(alpha_hat));
    "****************************************************";
    "Mean absolute pricing error (Eqn (14)) (in paper):  ";MAE*100;
    "****************************************************";
    /*The 45 degreee plot*/
    FONTS("simplex");
    __output = 1;
    _ptek = "plot.tkf";
    _pstype = { 7 }; //defining global
    _pgrid = { 2, 2 }; //defining global
    _plctrl = { -1 }; //defining global
    _pstype = { 7 }; //defining global
    _pdate = 0; /*excluding date*/
    title("predicted vs. model-implied pricing errors"); //setting TITLE
    xlabel("predicted excess returns"); //setting Y label
    ylabel("observed excess returns"); //setting X label
    xtics(0,0.2,0.05,0);
    ytics(0,0.2,0.05,0);
    _pline={1 6 -0.01 -0.01 0.5 0.5 1 0 1};
    _pmcolor={0, 0,0, 0, 0,0,0,0,15};
    _pcolor={1};
    //activate the line for 45-degree plot
    if freq==2;
      xtics(0,0.05,0.01,0);
      ytics(0,0.05,0.01,0);
    elseif freq ==1;
      xtics(0,0.2,0.05,0);
      ytics(0,0.2,0.05,0);
    endif;
    xy(model_implied_expected_return,mexret);
    ret=tkf2eps("plot.tkf", "fortyfive.eps");
    // Compute a J-statistic for the validity of the asset pricing model (Eqn (16))
     {J_last_N, p_value_J_last_N,g_T_last_N,t_stat_last_N,corr_g_T,var_g_T}=Jstat_GRS(param);
    "J-statistic (Eqn (16)) (in paper): ";;J_last_N;
    "p-value in %:  ";;p_value_J_last_N*100;
    "****************************************************";
    "Avg. pricing errors (g_T)and t-stats: ";
    g_T_last_N~t_stat_last_N;
   endif; // end model distinction
   "****************************************************";
